/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.story;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.media.UploadParameters;
import com.github.instagram4j.instagram4j.models.media.reel.item.ReelMetadataItem;
import com.github.instagram4j.instagram4j.requests.feed.FeedReelsTrayRequest;
import com.github.instagram4j.instagram4j.requests.feed.FeedUserStoryRequest;
import com.github.instagram4j.instagram4j.requests.media.MediaConfigureToStoryRequest;
import com.github.instagram4j.instagram4j.responses.feed.FeedReelsTrayResponse;
import com.github.instagram4j.instagram4j.responses.feed.FeedUserStoryResponse;
import com.github.instagram4j.instagram4j.responses.media.MediaResponse;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class StoryAction {
    @NonNull
    private IGClient client;

    public CompletableFuture<MediaResponse.MediaConfigureToStoryResponse> uploadPhoto(byte[] data, List<ReelMetadataItem> metadata) {
        String upload_id = String.valueOf(System.currentTimeMillis());
        return this.client.actions().upload().photo(data, upload_id).thenCompose(response -> new MediaConfigureToStoryRequest(response.getUpload_id(), metadata).execute(this.client));
    }

    public CompletableFuture<MediaResponse.MediaConfigureToStoryResponse> uploadVideo(byte[] video, byte[] cover, List<ReelMetadataItem> metadata) {
        String upload_id = String.valueOf(System.currentTimeMillis());
        return this.client.actions().upload().videoWithCover(video, cover, UploadParameters.forAlbumVideo(upload_id)).thenCompose(Response2 -> new MediaConfigureToStoryRequest(upload_id, metadata).execute(this.client));
    }

    public CompletableFuture<MediaResponse.MediaConfigureToStoryResponse> uploadPhoto(File file, List<ReelMetadataItem> metadata) {
        try {
            return this.uploadPhoto(Files.readAllBytes(file.toPath()), metadata);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public CompletableFuture<MediaResponse.MediaConfigureToStoryResponse> uploadPhoto(File file) {
        return this.uploadPhoto(file, Collections.emptyList());
    }

    public CompletableFuture<MediaResponse.MediaConfigureToStoryResponse> uploadVideo(File videoFile, File coverFile, List<ReelMetadataItem> metadata) {
        try {
            return this.uploadVideo(Files.readAllBytes(videoFile.toPath()), Files.readAllBytes(coverFile.toPath()), metadata);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public CompletableFuture<MediaResponse.MediaConfigureToStoryResponse> uploadVideo(File videoFile, File coverFile) {
        return this.uploadVideo(videoFile, coverFile, Collections.emptyList());
    }

    public CompletableFuture<FeedReelsTrayResponse> tray() {
        return new FeedReelsTrayRequest().execute(this.client);
    }

    public CompletableFuture<FeedUserStoryResponse> userStory(long pk) {
        return new FeedUserStoryRequest(pk).execute(this.client);
    }

    public StoryAction(@NonNull IGClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }
}

