/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.search;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.fbsearch.FbsearchPlacesRequest;
import com.github.instagram4j.instagram4j.requests.tags.TagsSearchRequest;
import com.github.instagram4j.instagram4j.requests.users.UsersSearchRequest;
import com.github.instagram4j.instagram4j.responses.fbsearch.FbsearchPlacesResponse;
import com.github.instagram4j.instagram4j.responses.tags.TagsSearchResponse;
import com.github.instagram4j.instagram4j.responses.users.UsersSearchResponse;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class SearchAction {
    @NonNull
    private IGClient client;

    public CompletableFuture<FbsearchPlacesResponse> searchPlace(String location) {
        return this.getFbsearchPlacesRequest(location, null, null, null, null).execute(this.client);
    }

    public CompletableFuture<FbsearchPlacesResponse> searchPlace(String location, double lat, double lon) {
        return this.getFbsearchPlacesRequest(location, lat, lon, null, null).execute(this.client);
    }

    public CompletableFuture<TagsSearchResponse> searchTag(String tag) {
        return this.getSearchTagRequest(tag, null, null, null, null).execute(this.client);
    }

    public CompletableFuture<TagsSearchResponse> searchTag(String tag, double lat, double lon) {
        return this.getSearchTagRequest(tag, lat, lon, null, null).execute(this.client);
    }

    public CompletableFuture<FbsearchPlacesResponse> searchPlace(String location, double lat, double lon, String page_token, String rank_token) {
        return this.getFbsearchPlacesRequest(location, lat, lon, page_token, rank_token).execute(this.client);
    }

    public CompletableFuture<TagsSearchResponse> searchTag(String location, double lat, double lon, String page_token, String rank_token) {
        return this.getSearchTagRequest(location, lat, lon, page_token, rank_token).execute(this.client);
    }

    public CompletableFuture<UsersSearchResponse> searchUser(String query) {
        return new UsersSearchRequest(query).execute(this.client);
    }

    private TagsSearchRequest getSearchTagRequest(String tag, Double lat, Double lon, String page_token, String rank_token) {
        return new TagsSearchRequest(tag, lat, lon, page_token, rank_token);
    }

    private FbsearchPlacesRequest getFbsearchPlacesRequest(String user, Double lat, Double lon, String page_token, String rank_token) {
        return new FbsearchPlacesRequest(user, lat, lon, page_token, rank_token);
    }

    public SearchAction(@NonNull IGClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }
}

