/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.media;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.actions.feed.FeedIterable;
import com.github.instagram4j.instagram4j.requests.media.MediaActionRequest;
import com.github.instagram4j.instagram4j.requests.media.MediaCommentRequest;
import com.github.instagram4j.instagram4j.requests.media.MediaConfigureSidecarRequest;
import com.github.instagram4j.instagram4j.requests.media.MediaConfigureTimelineRequest;
import com.github.instagram4j.instagram4j.requests.media.MediaConfigureToIgtvRequest;
import com.github.instagram4j.instagram4j.requests.media.MediaEditRequest;
import com.github.instagram4j.instagram4j.requests.media.MediaGetCommentsRequest;
import com.github.instagram4j.instagram4j.requests.media.MediaInfoRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.responses.media.MediaCommentResponse;
import com.github.instagram4j.instagram4j.responses.media.MediaGetCommentsResponse;
import com.github.instagram4j.instagram4j.responses.media.MediaInfoResponse;
import com.github.instagram4j.instagram4j.responses.media.MediaResponse;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class MediaAction {
    @NonNull
    private IGClient client;
    @NonNull
    private String media_id;

    public CompletableFuture<MediaCommentResponse> comment(String comment) {
        return new MediaCommentRequest(this.media_id, comment).execute(this.client);
    }

    public CompletableFuture<MediaResponse> editCaption(String caption) {
        return new MediaEditRequest(this.media_id, caption).execute(this.client);
    }

    public CompletableFuture<MediaInfoResponse> info() {
        return new MediaInfoRequest(this.media_id).execute(this.client);
    }

    public FeedIterable<MediaGetCommentsRequest, MediaGetCommentsResponse> comments() {
        return new FeedIterable<MediaGetCommentsRequest, MediaGetCommentsResponse>(this.client, () -> new MediaGetCommentsRequest(this.media_id));
    }

    public CompletableFuture<IGResponse> action(MediaActionRequest.MediaAction action) {
        return new MediaActionRequest(this.media_id, action).execute(this.client);
    }

    public static MediaAction of(IGClient client, String media_id) {
        return new MediaAction(client, media_id);
    }

    public static CompletableFuture<MediaResponse.MediaConfigureTimelineResponse> configureMediaToTimeline(IGClient client, String upload_id, MediaConfigureTimelineRequest.MediaConfigurePayload payload) {
        return new MediaConfigureTimelineRequest(payload.upload_id(upload_id)).execute(client);
    }

    public static CompletableFuture<MediaResponse.MediaConfigureSidecarResponse> configureAlbumToTimeline(IGClient client, MediaConfigureSidecarRequest.MediaConfigureSidecarPayload payload) {
        return new MediaConfigureSidecarRequest(payload).execute(client);
    }

    public static CompletableFuture<MediaResponse.MediaConfigureToIgtvResponse> configureToIgtv(IGClient client, String upload_id, String title, String caption, boolean postToFeed) {
        return new MediaConfigureToIgtvRequest(upload_id, title, caption, postToFeed).execute(client);
    }

    public MediaAction(@NonNull IGClient client, @NonNull String media_id) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (media_id == null) {
            throw new NullPointerException("media_id is marked non-null but is null");
        }
        this.client = client;
        this.media_id = media_id;
    }
}

