/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.igtv;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.actions.async.AsyncAction;
import com.github.instagram4j.instagram4j.actions.feed.FeedIterable;
import com.github.instagram4j.instagram4j.actions.media.MediaAction;
import com.github.instagram4j.instagram4j.exceptions.IGResponseException;
import com.github.instagram4j.instagram4j.requests.igtv.IgtvBrowseFeedRequest;
import com.github.instagram4j.instagram4j.requests.igtv.IgtvChannelRequest;
import com.github.instagram4j.instagram4j.requests.igtv.IgtvSearchRequest;
import com.github.instagram4j.instagram4j.requests.igtv.IgtvSeriesAddEpisodeRequest;
import com.github.instagram4j.instagram4j.requests.igtv.IgtvSeriesCreateRequest;
import com.github.instagram4j.instagram4j.responses.igtv.IgtvBrowseFeedResponse;
import com.github.instagram4j.instagram4j.responses.igtv.IgtvChannelResponse;
import com.github.instagram4j.instagram4j.responses.igtv.IgtvSearchResponse;
import com.github.instagram4j.instagram4j.responses.igtv.IgtvSeriesResponse;
import com.github.instagram4j.instagram4j.responses.media.MediaResponse;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgtvAction {
    private static final Logger log = LoggerFactory.getLogger(IgtvAction.class);
    @NonNull
    private IGClient client;

    public CompletableFuture<MediaResponse.MediaConfigureToIgtvResponse> upload(byte[] data, byte[] cover, String title, String caption, boolean postToFeed) {
        String upload_id = String.valueOf(System.currentTimeMillis());
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.client.actions().upload().chunkedVideoWithCover(data, cover, 10000000, upload_id).thenCompose(res -> MediaAction.configureToIgtv(this.client, upload_id, title, caption, postToFeed))).thenApply(CompletableFuture::completedFuture)).exceptionally(tr -> {
            if (IGResponseException.IGFailedResponse.of(tr.getCause()).getStatusCode() != 202) {
                throw new CompletionException(tr.getCause());
            }
            log.info("{} Transcode not finished. Retrying up to three times.", (Object)upload_id);
            return AsyncAction.retry(() -> MediaAction.configureToIgtv(this.client, upload_id, title, caption, postToFeed), tr, 3, 10L, TimeUnit.SECONDS);
        })).thenCompose(Function.identity());
    }

    public CompletableFuture<MediaResponse.MediaConfigureToIgtvResponse> upload(File videoFile, File coverFile, String title, String caption, boolean postToFeed) {
        try {
            return this.upload(Files.readAllBytes(videoFile.toPath()), Files.readAllBytes(coverFile.toPath()), title, caption, postToFeed);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public CompletableFuture<MediaResponse.MediaConfigureToIgtvResponse> upload(File videoFile, File coverFile, String title, String caption) {
        return this.upload(videoFile, coverFile, title, caption, false);
    }

    public CompletableFuture<IgtvSeriesResponse> createSeries(String title, String description) {
        return new IgtvSeriesCreateRequest(title, description).execute(this.client);
    }

    public CompletableFuture<IgtvSeriesResponse> addEpisode(String series_id, long pk) {
        return new IgtvSeriesAddEpisodeRequest(series_id, pk).execute(this.client);
    }

    public CompletableFuture<IgtvChannelResponse> getChannel(long pk) {
        return new IgtvChannelRequest("user_" + pk).execute(this.client);
    }

    public CompletableFuture<IgtvChannelResponse> getChannel(String userId) {
        return new IgtvChannelRequest(userId).execute(this.client);
    }

    public CompletableFuture<IgtvSearchResponse> search(String query) {
        return new IgtvSearchRequest(query).execute(this.client);
    }

    public FeedIterable<IgtvBrowseFeedRequest, IgtvBrowseFeedResponse> feed() {
        return new FeedIterable<IgtvBrowseFeedRequest, IgtvBrowseFeedResponse>(this.client, IgtvBrowseFeedRequest::new);
    }

    public IgtvAction(@NonNull IGClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }
}

