/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.feed;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.actions.feed.PageRankTokenIterator;
import com.github.instagram4j.instagram4j.requests.IGRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;

public class PageRankIterable<T extends IGRequest<R>, R extends IGResponse>
implements Iterable<R> {
    @NonNull
    private IGClient client;
    @NonNull
    private Supplier<T> requestSupplier;

    @Override
    public Iterator<R> iterator() {
        return new PageRankTokenIterator(this.client, (IGRequest)this.requestSupplier.get());
    }

    @Override
    public Spliterator<R> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 1024);
    }

    public Stream<R> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public static <T extends IGRequest<R>, R extends IGResponse> PageRankIterable<T, R> of(IGClient client, T t) {
        return new PageRankIterable<IGRequest, R>(client, () -> t);
    }

    public PageRankIterable(@NonNull IGClient client, @NonNull Supplier<T> requestSupplier) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (requestSupplier == null) {
            throw new NullPointerException("requestSupplier is marked non-null but is null");
        }
        this.client = client;
        this.requestSupplier = requestSupplier;
    }
}

