/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.feed;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.IGRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.NonNull;

public class CursorIterator<T extends IGRequest<R>, R extends IGResponse>
implements Iterator<R> {
    @NonNull
    private IGClient client;
    @NonNull
    private T request;
    @NonNull
    private BiConsumer<T, String> set_cursor;
    @NonNull
    private Function<R, String> get_next_cursor;
    @NonNull
    private Function<R, Boolean> has_next;
    protected R response = null;

    @Override
    public boolean hasNext() {
        return this.response == null || ((IGResponse)this.response).getStatusCode() == 200 && this.has_next.apply(this.response) != false;
    }

    @Override
    public R next() {
        this.response = (IGResponse)this.client.sendRequest(this.request).join();
        String next_cursor = this.get_next_cursor.apply(this.response);
        this.set_cursor.accept(this.request, next_cursor);
        return this.response;
    }

    public CursorIterator(@NonNull IGClient client, @NonNull T request, @NonNull BiConsumer<T, String> set_cursor, @NonNull Function<R, String> get_next_cursor, @NonNull Function<R, Boolean> has_next) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (set_cursor == null) {
            throw new NullPointerException("set_cursor is marked non-null but is null");
        }
        if (get_next_cursor == null) {
            throw new NullPointerException("get_next_cursor is marked non-null but is null");
        }
        if (has_next == null) {
            throw new NullPointerException("has_next is marked non-null but is null");
        }
        this.client = client;
        this.request = request;
        this.set_cursor = set_cursor;
        this.get_next_cursor = get_next_cursor;
        this.has_next = has_next;
    }
}

