/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.account;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.accounts.AccountsActionRequest;
import com.github.instagram4j.instagram4j.requests.accounts.AccountsChangeProfilePictureRequest;
import com.github.instagram4j.instagram4j.requests.accounts.AccountsCurrentUserRequest;
import com.github.instagram4j.instagram4j.requests.accounts.AccountsSetBiographyRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.responses.accounts.AccountsUserResponse;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class AccountAction {
    @NonNull
    private IGClient client;

    public CompletableFuture<AccountsUserResponse> setProfilePicture(byte[] photo) {
        return this.client.actions().upload().photo(photo, String.valueOf(System.currentTimeMillis())).thenCompose(res -> new AccountsChangeProfilePictureRequest(res.getUpload_id()).execute(this.client));
    }

    public CompletableFuture<AccountsUserResponse> setProfilePicture(File file) {
        try {
            return this.setProfilePicture(Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public CompletableFuture<IGResponse> setBio(String bio) {
        return new AccountsSetBiographyRequest(bio).execute(this.client);
    }

    public CompletableFuture<AccountsUserResponse> action(AccountsActionRequest.AccountsAction action) {
        return new AccountsActionRequest(action).execute(this.client);
    }

    public CompletableFuture<AccountsUserResponse> currentUser() {
        return new AccountsCurrentUserRequest().execute(this.client);
    }

    public AccountAction(@NonNull IGClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }
}

