/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j;

import com.github.instagram4j.instagram4j.IGAndroidDevice;
import com.github.instagram4j.instagram4j.IGDevice;
import com.github.instagram4j.instagram4j.actions.IGClientActions;
import com.github.instagram4j.instagram4j.exceptions.ExceptionallyHandler;
import com.github.instagram4j.instagram4j.exceptions.IGLoginException;
import com.github.instagram4j.instagram4j.exceptions.IGResponseException;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.models.user.Profile;
import com.github.instagram4j.instagram4j.requests.IGRequest;
import com.github.instagram4j.instagram4j.requests.accounts.AccountsLoginRequest;
import com.github.instagram4j.instagram4j.requests.accounts.AccountsTwoFactorLoginRequest;
import com.github.instagram4j.instagram4j.requests.qe.QeSyncRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.responses.accounts.LoginResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import com.github.instagram4j.instagram4j.utils.SerializableCookieJar;
import com.github.instagram4j.instagram4j.utils.SerializeUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Pair;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGClient
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(IGClient.class);
    private static final long serialVersionUID = -893265874836L;
    private final String $username;
    private final String $password;
    private transient String encryptionId;
    private transient String encryptionKey;
    private transient String authorization;
    private transient OkHttpClient httpClient;
    private transient String sessionId;
    private transient IGClientActions actions;
    private transient ExceptionallyHandler exceptionallyHandler;
    private String deviceId;
    private String guid;
    private String phoneId;
    private boolean loggedIn = false;
    private Profile selfProfile;
    private IGDevice device = IGAndroidDevice.GOOD_DEVICES[0];

    public IGClient(String username, String password) {
        this(username, password, IGUtils.defaultHttpClientBuilder().build());
    }

    public IGClient(String username, String password, OkHttpClient client) {
        this.$username = username;
        this.$password = password;
        this.guid = IGUtils.randomUuid();
        this.phoneId = IGUtils.randomUuid();
        this.deviceId = IGUtils.generateDeviceId(username, password);
        this.httpClient = client;
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.sessionId = IGUtils.randomUuid();
        this.actions = new IGClientActions(this);
        this.exceptionallyHandler = new ExceptionallyHandler(){

            @Override
            public <T> T handle(Throwable throwable, Class<T> type) {
                throw new CompletionException(throwable.getCause());
            }
        };
    }

    public IGClientActions actions() {
        return this.actions;
    }

    public CompletableFuture<LoginResponse> sendLoginRequest() {
        return ((CompletableFuture)new QeSyncRequest().execute(this).thenCompose(res -> new AccountsLoginRequest(this.$username, IGUtils.encryptPassword(this.$password, this.encryptionId, this.encryptionKey)).execute(this))).thenApply(res -> {
            this.setLoggedInState((LoginResponse)res);
            return res;
        });
    }

    public CompletableFuture<LoginResponse> sendLoginRequest(String code, String identifier) {
        return ((CompletableFuture)new QeSyncRequest().execute(this).thenCompose(res -> new AccountsTwoFactorLoginRequest(this.$username, IGUtils.encryptPassword(this.$password, this.encryptionId, this.encryptionKey), code, identifier).execute(this))).thenApply(res -> {
            this.setLoggedInState((LoginResponse)res);
            return res;
        });
    }

    public <T extends IGResponse> CompletableFuture<T> sendRequest(@NonNull IGRequest<T> req) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        final CompletableFuture responseFuture = new CompletableFuture();
        log.info("Sending request : {}", (Object)req.formUrl(this).toString());
        this.httpClient.newCall(req.formRequest(this)).enqueue(new Callback(){

            public void onFailure(Call call, IOException exception) {
                responseFuture.completeExceptionally(exception);
            }

            public void onResponse(Call call, Response res) throws IOException {
                log.info("Response for {} : {}", (Object)call.request().url().toString(), (Object)res.code());
                try (ResponseBody body = res.body();){
                    responseFuture.complete(new Pair((Object)res, (Object)body.string()));
                }
            }
        });
        return ((CompletableFuture)responseFuture.thenApply(res -> {
            this.setFromResponseHeaders((Response)res.getFirst());
            log.info("Response for {} with body (truncated) : {}", (Object)((Response)res.getFirst()).request().url(), (Object)IGUtils.truncate((String)res.getSecond()));
            return req.parseResponse((Pair<Response, String>)res);
        })).exceptionally(tr -> (IGResponse)this.exceptionallyHandler.handle((Throwable)tr, req.getResponseType()));
    }

    private void setLoggedInState(LoginResponse state) {
        if (!state.getStatus().equals("ok")) {
            return;
        }
        this.loggedIn = true;
        this.selfProfile = state.getLogged_in_user();
        log.info("Logged into {} ({})", (Object)this.selfProfile.getUsername(), (Object)this.selfProfile.getPk());
    }

    public String getCsrfToken() {
        return IGUtils.getCookieValue(this.getHttpClient().cookieJar(), "csrftoken").orElse("missing");
    }

    public void setFromResponseHeaders(Response res) {
        Optional.ofNullable(res.header("ig-set-password-encryption-key-id")).ifPresent(s -> {
            this.encryptionId = s;
        });
        Optional.ofNullable(res.header("ig-set-password-encryption-pub-key")).ifPresent(s -> {
            this.encryptionKey = s;
        });
        Optional.ofNullable(res.header("ig-set-authorization")).ifPresent(s -> {
            this.authorization = s;
        });
    }

    public IGPayload setIGPayloadDefaults(IGPayload load) {
        load.set_csrftoken(this.getCsrfToken());
        load.setDevice_id(this.deviceId);
        if (this.selfProfile != null) {
            load.set_uid(this.selfProfile.getPk().toString());
            load.set_uuid(this.guid);
        } else {
            load.setId(this.guid);
        }
        load.setGuid(this.guid);
        load.setPhone_id(this.phoneId);
        return load;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static IGClient deserialize(File clientFile, File cookieFile) throws ClassNotFoundException, IOException {
        return IGClient.deserialize(clientFile, cookieFile, IGUtils.defaultHttpClientBuilder());
    }

    public static IGClient deserialize(File clientFile, File cookieFile, OkHttpClient.Builder clientBuilder) throws ClassNotFoundException, IOException {
        IGClient client = SerializeUtil.deserialize(clientFile, IGClient.class);
        CookieJar jar = SerializeUtil.deserialize(cookieFile, SerializableCookieJar.class);
        client.httpClient = clientBuilder.cookieJar(jar).build();
        return client;
    }

    public void serialize(File clientFile, File cookieFile) throws IOException {
        SerializeUtil.serialize(this, clientFile);
        SerializeUtil.serialize(this.httpClient.cookieJar(), cookieFile);
    }

    private Object readResolve() throws ObjectStreamException {
        this.initializeDefaults();
        if (this.loggedIn) {
            log.info("Logged into {} ({})", (Object)this.selfProfile.getUsername(), (Object)this.selfProfile.getPk());
        }
        return this;
    }

    public String getEncryptionId() {
        return this.encryptionId;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public IGClientActions getActions() {
        return this.actions;
    }

    public ExceptionallyHandler getExceptionallyHandler() {
        return this.exceptionallyHandler;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getPhoneId() {
        return this.phoneId;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public Profile getSelfProfile() {
        return this.selfProfile;
    }

    public IGDevice getDevice() {
        return this.device;
    }

    public void setEncryptionId(String encryptionId) {
        this.encryptionId = encryptionId;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public IGClient setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setActions(IGClientActions actions) {
        this.actions = actions;
    }

    public IGClient setExceptionallyHandler(ExceptionallyHandler exceptionallyHandler) {
        this.exceptionallyHandler = exceptionallyHandler;
        return this;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public void setPhoneId(String phoneId) {
        this.phoneId = phoneId;
    }

    public IGClient setDevice(IGDevice device) {
        this.device = device;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IGClient)) {
            return false;
        }
        IGClient other = (IGClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$guid = this.getGuid();
        String other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) {
            return false;
        }
        String this$phoneId = this.getPhoneId();
        String other$phoneId = other.getPhoneId();
        if (this$phoneId == null ? other$phoneId != null : !this$phoneId.equals(other$phoneId)) {
            return false;
        }
        if (this.isLoggedIn() != other.isLoggedIn()) {
            return false;
        }
        Profile this$selfProfile = this.getSelfProfile();
        Profile other$selfProfile = other.getSelfProfile();
        if (this$selfProfile == null ? other$selfProfile != null : !((Object)this$selfProfile).equals(other$selfProfile)) {
            return false;
        }
        IGDevice this$device = this.getDevice();
        IGDevice other$device = other.getDevice();
        return !(this$device == null ? other$device != null : !((Object)this$device).equals(other$device));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IGClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $guid = this.getGuid();
        result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
        String $phoneId = this.getPhoneId();
        result = result * 59 + ($phoneId == null ? 43 : $phoneId.hashCode());
        result = result * 59 + (this.isLoggedIn() ? 79 : 97);
        Profile $selfProfile = this.getSelfProfile();
        result = result * 59 + ($selfProfile == null ? 43 : ((Object)$selfProfile).hashCode());
        IGDevice $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : ((Object)$device).hashCode());
        return result;
    }

    public String toString() {
        return "IGClient(encryptionId=" + this.getEncryptionId() + ", encryptionKey=" + this.getEncryptionKey() + ", authorization=" + this.getAuthorization() + ", httpClient=" + this.getHttpClient() + ", sessionId=" + this.getSessionId() + ", actions=" + this.getActions() + ", exceptionallyHandler=" + this.getExceptionallyHandler() + ", deviceId=" + this.getDeviceId() + ", guid=" + this.getGuid() + ", phoneId=" + this.getPhoneId() + ", loggedIn=" + this.isLoggedIn() + ", selfProfile=" + this.getSelfProfile() + ", device=" + this.getDevice() + ")";
    }

    private void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    private void setSelfProfile(Profile selfProfile) {
        this.selfProfile = selfProfile;
    }

    public static class Builder {
        private String username;
        private String password;
        private OkHttpClient client;
        private IGDevice device = IGAndroidDevice.GOOD_DEVICES[0];
        private LoginHandler onChallenge;
        private LoginHandler onTwoFactor;
        private BiConsumer<IGClient, LoginResponse> onLogin;

        public IGClient build() {
            return new IGClient(this.username, this.password, Optional.ofNullable(this.client).orElseGet(() -> IGUtils.defaultHttpClientBuilder().build())).setDevice(this.device);
        }

        public IGClient simulatedLogin(Consumer<List<CompletableFuture<?>>> postLoginResponses) throws IGLoginException {
            IGClient client = this.build();
            client.actions.simulate().preLoginFlow().forEach(CompletableFuture::join);
            this.onLogin.accept(client, this.performLogin(client));
            postLoginResponses.accept(client.actions.simulate().postLoginFlow());
            return client;
        }

        public IGClient simulatedLogin() throws IGLoginException {
            return this.simulatedLogin(res -> {});
        }

        public IGClient login() throws IGLoginException {
            IGClient client = this.build();
            this.onLogin.accept(client, this.performLogin(client));
            return client;
        }

        private LoginResponse performLogin(IGClient client) throws IGLoginException {
            LoginResponse response = (LoginResponse)((CompletableFuture)client.sendLoginRequest().exceptionally(tr -> {
                LoginResponse loginResponse = IGResponseException.IGFailedResponse.of(tr.getCause(), LoginResponse.class);
                if (loginResponse.getTwo_factor_info() != null && this.onTwoFactor != null) {
                    loginResponse = this.onTwoFactor.accept(client, loginResponse);
                }
                if (loginResponse.getChallenge() != null && this.onChallenge != null) {
                    loginResponse = this.onChallenge.accept(client, loginResponse);
                    client.setLoggedInState(loginResponse);
                }
                return loginResponse;
            })).join();
            if (!client.isLoggedIn()) {
                throw new IGLoginException(client, response);
            }
            return response;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder device(IGDevice device) {
            this.device = device;
            return this;
        }

        public Builder onChallenge(LoginHandler onChallenge) {
            this.onChallenge = onChallenge;
            return this;
        }

        public Builder onTwoFactor(LoginHandler onTwoFactor) {
            this.onTwoFactor = onTwoFactor;
            return this;
        }

        public Builder onLogin(BiConsumer<IGClient, LoginResponse> onLogin) {
            this.onLogin = onLogin;
            return this;
        }

        public Builder(String username, String password, OkHttpClient client2, IGDevice device, LoginHandler onChallenge, LoginHandler onTwoFactor, BiConsumer<IGClient, LoginResponse> onLogin) {
            this.onLogin = (client, login) -> {};
            this.username = username;
            this.password = password;
            this.client = client2;
            this.device = device;
            this.onChallenge = onChallenge;
            this.onTwoFactor = onTwoFactor;
            this.onLogin = onLogin;
        }

        public Builder() {
            this.onLogin = (client, login) -> {};
        }

        @FunctionalInterface
        public static interface LoginHandler {
            public LoginResponse accept(IGClient var1, LoginResponse var2);
        }
    }
}

