/*
 * Decompiled with CFR 0.152.
 */
package org.spin.lve.at.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_Order;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEListLine;
import org.erpya.lve.model.MLVEListVersion;
import org.erpya.lve.model.MLVEWithholdingTax;
import org.spin.lve.at.util.LVEAdditionalTaxSetting;
import org.spin.model.MWHSetting;
import org.spin.model.MWHWithholding;
import org.spin.util.AbstractWithholdingSetting;

public class TBTT_Withholding
extends AbstractWithholdingSetting {
    private Optional<PO> maybedocument = null;
    private MBPartner businessPartner;
    private HashMap<MLVEList, LVEAdditionalTaxSetting> conceptsToApply = null;
    int curPrecision = 0;
    private boolean isManual = false;
    private BigDecimal A_BaseAmt = Env.ZERO;
    private int C_Currency_ID = 0;
    private BigDecimal conversionRate = Env.ONE;
    private Timestamp dateAcct = null;

    public TBTT_Withholding(MWHSetting setting) {
        super(setting);
    }

    public boolean isValid() {
        AtomicReference<Boolean> isValid = new AtomicReference<Boolean>(true);
        if (this.getDocument().get_Table_ID() != I_C_Invoice.Table_ID && this.getDocument().get_Table_ID() != I_C_Order.Table_ID && this.getDocument().get_Table_ID() != MPayment.Table_ID) {
            this.addLog("@C_Invoice_ID@ / @C_Order_ID@ / @C_Payment_ID@ @NotFound@");
            isValid.set(false);
            this.log.warning("Invalid Entity");
        }
        this.log.fine("Valid Entity");
        Optional.ofNullable(this.getDocument()).ifPresent(document -> {
            if (document.get_Table_ID() == MPayment.Table_ID) {
                MPayment payment = (MPayment)document;
                if (payment.getC_Invoice_ID() > 0 && "X".equals(payment.getTenderType()) && MOrgInfo.get((Properties)this.getContext(), (int)payment.getAD_Org_ID(), (String)payment.get_TrxName()).get_ValueAsInt("LVE_FiscalCurrency_ID") != payment.getC_Currency_ID()) {
                    this.setDocument((PO)((MInvoice)payment.getC_Invoice()));
                    this.setParameter("A_Base_Amount", payment.getPayAmt());
                    this.setParameter("C_Currency_ID", new BigDecimal(payment.getC_Currency_ID()));
                    this.setParameter("DateAcct", payment.getDateAcct());
                } else {
                    isValid.set(false);
                }
            }
        });
        if (!isValid.get().booleanValue()) {
            this.log.warning("Invalid Document");
            return isValid.get();
        }
        this.log.fine("Document Valid");
        this.maybedocument = Optional.ofNullable(this.getDocument());
        this.dateAcct = Optional.ofNullable((Timestamp)this.getParameter("DateAcct")).orElse((Timestamp)this.getDocument().get_Value("DateAcct"));
        this.maybedocument.ifPresent(document -> {
            Optional.ofNullable(this.getParameterAsBigDecimal("C_Currency_ID")).ifPresent(currency -> {
                this.C_Currency_ID = currency.intValue();
            });
            if (this.C_Currency_ID == 0) {
                this.C_Currency_ID = document.get_ValueAsInt("C_Currency_ID");
            }
            if (this.C_Currency_ID != document.get_ValueAsInt("C_Currency_ID")) {
                Optional<BigDecimal> maybeConversionRate = Optional.ofNullable(MConversionRate.getRate((int)document.get_ValueAsInt("C_Currency_ID"), (int)this.C_Currency_ID, (Timestamp)this.dateAcct, (int)document.get_ValueAsInt("C_ConversionType_ID"), (int)document.getAD_Client_ID(), (int)document.getAD_Org_ID()));
                this.conversionRate = maybeConversionRate.orElseGet(() -> {
                    this.addLog("@C_ConversionRate_ID@ @NotFound@ -> ".concat(MCurrency.getISO_Code((Properties)this.getContext(), (int)document.get_ValueAsInt("C_Currency_ID"))).concat(" <-> ").concat(MCurrency.getISO_Code((Properties)this.getContext(), (int)this.C_Currency_ID)));
                    isValid.set(false);
                    return Env.ONE;
                });
            }
            this.curPrecision = MCurrency.getStdPrecision((Properties)this.getContext(), (int)this.C_Currency_ID);
        });
        this.log.fine("Currency Precision is get");
        Optional<MLVEWithholdingTax> maybeCurrentWHTax = Optional.ofNullable(MLVEWithholdingTax.getFromClient((Properties)this.getContext(), (int)this.getDocument().getAD_Org_ID(), (String)"AT"));
        maybeCurrentWHTax.orElseGet(() -> {
            this.addLog("@LVE_WithholdingTax_ID@ @NotFound@");
            isValid.set(false);
            this.log.warning("Not Found Withholding Tax");
            return null;
        });
        maybeCurrentWHTax.ifPresent(currentWHTax -> {
            if (currentWHTax.isClientExcluded()) {
                this.addLog("@IsClientExcluded@ " + currentWHTax.getName());
                isValid.set(false);
            }
        });
        maybeCurrentWHTax.ifPresent(currentWHTax -> this.maybedocument.ifPresent(document -> {
            MDocType documentType;
            if (this.isReversal((PO)document)) {
                isValid.set(false);
            }
            if ((documentType = MDocType.get((Properties)this.getContext(), (int)document.get_ValueAsInt("C_DocTypeTarget_ID"))) == null) {
                this.addLog("@C_DocType_ID@ @NotFound@");
                isValid.set(false);
            }
            Optional.ofNullable(document).ifPresent(documentToApply -> {
                if (documentToApply.get_ValueAsBoolean("IsSOTrx")) {
                    Optional.ofNullable(MOrgInfo.get((Properties)this.getContext(), (int)documentToApply.getAD_Org_ID(), (String)documentToApply.get_TrxName())).ifPresent(orgInfo -> {
                        this.businessPartner = MBPartner.get((Properties)this.getContext(), (int)orgInfo.get_ValueAsInt("WH_BPartner_ID"));
                    });
                } else {
                    this.businessPartner = MBPartner.get((Properties)this.getContext(), (int)documentToApply.get_ValueAsInt("C_BPartner_ID"));
                }
            });
            if (document instanceof MInvoice) {
                this.setReturnValue("SourceInvoice_ID", document.get_ID());
            }
            if (document instanceof MOrder) {
                this.setReturnValue("SourceOrder_ID", document.get_ID());
            }
            this.setReturnValue("AD_Org_ID", document.getAD_Org_ID());
            boolean bl = this.isManual = !document.get_ValueAsBoolean("IsSOTrx");
            if (this.businessPartner == null) {
                this.addLog("@C_BPartner_ID@ @NotFound@");
                isValid.set(false);
            } else {
                Optional.ofNullable(this.businessPartner.get_ValueAsString("TaxpayerType")).ifPresent(taxPayerType -> {
                    if (!taxPayerType.equals("TPFO")) {
                        this.addLog("@C_BPartner_ID@ @Invalid@ @TaxpayerType@");
                        isValid.set(false);
                    }
                });
                this.conceptsToApply = new HashMap();
                this.A_BaseAmt = Optional.ofNullable((BigDecimal)this.getParameter("A_Base_Amount")).orElse((BigDecimal)document.get_Value("GrandTotal"));
                if (this.A_BaseAmt.multiply(this.conversionRate).compareTo((BigDecimal)document.get_Value("GrandTotal")) > 0) {
                    isValid.set(false);
                    this.addLog("@A_Base_Amount@ (" + this.A_BaseAmt.multiply(this.conversionRate) + ") > @TotalLines@ (" + (BigDecimal)document.get_Value("GrandTotal") + ")");
                }
                this.conceptsToApply.put((MLVEList)currentWHTax.getDefaultWithholdingRate(), new LVEAdditionalTaxSetting((PO)document, this.A_BaseAmt));
                if (this.conceptsToApply.size() == 0) {
                    isValid.set(false);
                    this.addLog("@NotFound@ @WithholdingRate@");
                }
                if (this.isGenerated()) {
                    isValid.set(false);
                }
                if (((Boolean)isValid.get()).booleanValue()) {
                    Optional.ofNullable(this.setRates()).ifPresent(msgResult -> {
                        if (!msgResult.isEmpty()) {
                            this.addLog((String)msgResult);
                            isValid.set(false);
                            this.log.warning(msgResult);
                        }
                    });
                }
            }
        }));
        return isValid.get();
    }

    public String run() {
        this.conceptsToApply.entrySet().stream().forEach(rateToApply -> {
            LVEAdditionalTaxSetting conceptSetting = (LVEAdditionalTaxSetting)rateToApply.getValue();
            BigDecimal rate = conceptSetting.getRate();
            if (rate == null) {
                rate = Env.ZERO;
            }
            if (rate.compareTo(Env.ZERO) != 0) {
                this.setWithholdingRate(rate);
                rate = this.getWithholdingRate(true);
                this.addBaseAmount(conceptSetting.getAmtBase());
                if (conceptSetting.isValid()) {
                    this.addWithholdingAmount(conceptSetting.getAmtBase().multiply(rate, MathContext.DECIMAL128));
                } else {
                    this.addWithholdingAmount(Env.ZERO);
                }
                this.addDescription(((MLVEList)rateToApply.getKey()).getName());
                this.setReturnValue("IsManual", this.isManual);
                this.setReturnValue("C_Currency_ID", this.C_Currency_ID);
                int conversionTypeId = MConversionType.getDefault((int)this.getDocument().getAD_Client_ID());
                if (conversionTypeId > 0) {
                    this.setReturnValue("C_ConversionType_ID", conversionTypeId);
                }
                this.setReturnValue("ECA40_IsFBTT", true);
                this.setReturnValue("DateAcct", this.dateAcct);
                this.setTagLine();
                this.saveResult();
            }
        });
        this.conceptsToApply.clear();
        this.A_BaseAmt = Env.ZERO;
        this.conversionRate = Env.ZERO;
        this.curPrecision = 0;
        this.C_Currency_ID = 0;
        return null;
    }

    private String setRates() {
        AtomicReference<String> resultMessage = new AtomicReference<String>();
        resultMessage.set("");
        this.maybedocument.ifPresent(document -> this.conceptsToApply.forEach((whConcept, LVEAdditionalTaxSetting2) -> {
            MLVEListVersion rateToApply = whConcept.getValidVersionInstance(this.getDocumentDate((PO)document), "IsActive", "Y");
            MLVEListLine varRateToApply = null;
            if (rateToApply != null) {
                List varRate = rateToApply.getListLine();
                varRate.stream().filter(listLine -> this.A_BaseAmt.compareTo(listLine.getMinValue()) >= 0 && (this.A_BaseAmt.compareTo(listLine.getMaxValue()) < 0 || listLine.getMaxValue().compareTo(Env.ZERO) == 0)).forEach(listLine -> {
                    LVEAdditionalTaxSetting2.setRateToApply(rateToApply);
                    LVEAdditionalTaxSetting2.setVarRateToApply(varRateToApply);
                    LVEAdditionalTaxSetting2.setRate(listLine.getCol_1());
                });
            } else {
                resultMessage.set((String)resultMessage.get() + "- @NotFound@ @WithholdingRentalRate_ID@");
            }
        }));
        return (String)resultMessage.get();
    }

    private boolean isGenerated() {
        AtomicReference<Boolean> result = new AtomicReference<Boolean>(false);
        this.maybedocument.ifPresent(document -> {
            String whereClause = "";
            if (document instanceof MInvoice) {
                whereClause = "SourceInvoice_ID = ? ";
            }
            if (document instanceof MOrder) {
                whereClause = "SourceOrder_ID = ? ";
            }
            whereClause = whereClause + "AND EXISTS (SELECT 1 FROM WH_Setting ws WHERE ws.WH_Setting_ID = WH_Withholding.WH_Setting_ID AND ws.WH_Type_ID = ?) AND Processed = 'Y' AND IsSimulation='N' AND C_Currency_ID= ? AND DocStatus IN (?,?)";
            Optional<MWHWithholding> maybeWithholding = Optional.ofNullable((MWHWithholding)new Query(this.getContext(), "WH_Withholding", whereClause, this.getTransactionName()).setParameters(new Object[]{document.get_ID(), this.getDefinition().getWH_Type_ID(), this.C_Currency_ID, "CO", "CL"}).first());
            maybeWithholding.ifPresent(withholding -> {
                if (withholding.getC_Invoice_ID() > 0 && withholding.getC_Invoice().getDocStatus().equals("CO")) {
                    result.set(true);
                } else {
                    withholding.processIt("VO");
                    withholding.save();
                    result.set(false);
                }
            });
        });
        return result.get();
    }

    private boolean isReversal(PO document) {
        if (document == null) {
            return false;
        }
        return document.get_ValueAsInt("Reversal_ID") > 0;
    }

    private Timestamp getDocumentDate(PO document) {
        return Optional.ofNullable((Timestamp)document.get_Value("DateInvoiced")).orElse((Timestamp)document.get_Value("DateOrdered"));
    }

    private void setTagLine() {
        this.maybedocument.ifPresent(document -> {
            MInvoice invoice;
            if (document instanceof MInvoice && (invoice = (MInvoice)document).isSOTrx() && invoice.get_ValueAsBoolean("IsFiscalDocument")) {
                String isoCode = MCurrency.getISO_Code((Properties)this.getContext(), (int)this.C_Currency_ID);
                Object[] params = new Object[]{this.getWithholdingRate(), isoCode, this.getBaseAmount(), isoCode, this.getWithholdingAmount()};
                String tagLine = Msg.getMsg((Properties)this.getContext(), (String)"LVE_AdditionalTax_IGTF", (Object[])params);
                invoice.setDescription(tagLine);
                invoice.saveEx();
            }
        });
    }
}

