/*
 * Decompiled with CFR 0.152.
 */
package org.spin.lve.at.util;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.lve.at.util.POSCollectIGTFBase;
import org.spin.model.MCPaymentMethod;
import org.spin.model.MWHSetting;

public class POSCollectIGTFChange
extends POSCollectIGTFBase {
    public POSCollectIGTFChange(MWHSetting setting) {
        super(setting);
    }

    @Override
    public boolean isValid() {
        boolean isValid = super.isValid();
        if (!isValid) {
            return isValid;
        }
        int fiscalCurrencyId = this.getOrganizationInfo().get_ValueAsInt("LVE_FiscalCurrency_ID");
        if (!this.getPayment().isReceipt() || this.getPayment().getPayAmt().compareTo(Env.ZERO) <= 0 || this.getPayment().getC_Currency_ID() == fiscalCurrencyId) {
            return false;
        }
        if (!this.fillRate(this.getPayment().getDateAcct(), this.getPayment().getPayAmt())) {
            return false;
        }
        BigDecimal paymentBaseAmount = this.getPaymentBaseAmount();
        this.setBaseAmount(paymentBaseAmount);
        MTable posPaymentType = MTable.get((Properties)this.getContext(), (String)"C_POSPaymentTypeAllocation");
        if (posPaymentType != null) {
            PO paymentTypeAllocation = this.getDefaultPaymentMethodAllocated();
            if (Util.isEmpty((String)paymentTypeAllocation.get_ValueAsString("Name"))) {
                MCPaymentMethod paymentMethod = MCPaymentMethod.getById((Properties)this.getContext(), (int)paymentTypeAllocation.get_ValueAsInt("C_PaymentMethod_ID"), (String)this.getTransactionName());
                if (!Util.isEmpty((String)paymentMethod.getDescription())) {
                    this.addDescription(paymentMethod.getDescription() + " @of@ " + DisplayType.getNumberFormat((int)12).format(paymentBaseAmount));
                }
            } else {
                this.addDescription(paymentTypeAllocation.get_ValueAsString("Name") + " @of@ " + DisplayType.getNumberFormat((int)12).format(paymentBaseAmount));
            }
        }
        return true;
    }

    public String run() {
        this.setReturnValue("IsSimulation", true);
        this.setWithholdingAmount(this.getBaseAmount().multiply(this.getWithholdingRate(true)));
        this.savePaymentReference(true);
        return null;
    }
}

