/*
 * Decompiled with CFR 0.152.
 */
package org.spin.lve.at.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.I_C_Payment;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEListLine;
import org.erpya.lve.model.MLVEListVersion;
import org.erpya.lve.model.MLVEWithholdingTax;
import org.spin.model.MWHSetting;
import org.spin.util.AbstractWithholdingSetting;

public abstract class POSCollectIGTFBase
extends AbstractWithholdingSetting {
    private MOrder order;
    private MPayment payment;
    private MOrgInfo organizationInfo;
    private MBPartner businessPartner;
    private MLVEList rateDefinitionToApply;
    BigDecimal withholdingRate = Env.ZERO;
    private PO defaultPaymentMethodallocated;
    private String event;

    public POSCollectIGTFBase(MWHSetting setting) {
        super(setting);
    }

    public MOrder getOrder() {
        return this.order;
    }

    public MPayment getPayment() {
        return this.payment;
    }

    public MOrgInfo getOrganizationInfo() {
        return this.organizationInfo;
    }

    public MLVEList getRateDefinitionToApply() {
        return this.rateDefinitionToApply;
    }

    public String getEvent() {
        return this.event;
    }

    public PO getDefaultPaymentMethodAllocated() {
        if (this.defaultPaymentMethodallocated != null) {
            return this.defaultPaymentMethodallocated;
        }
        this.defaultPaymentMethodallocated = new Query(this.getContext(), "C_POSPaymentTypeAllocation", "C_POS_ID = ? AND IsPaymentReference = 'Y' AND EXISTS(SELECT 1 FROM C_PaymentMethod pm WHERE pm.C_PaymentMethod_ID = C_POSPaymentTypeAllocation.C_PaymentMethod_ID AND pm.TenderType = ? AND pm.IsWithholdingExempt = 'N' AND pm.WH_Type_ID = ?)", this.getTransactionName()).setParameters(new Object[]{this.payment.getC_POS_ID(), "M", this.getSetting().getWH_Type_ID()}).setOnlyActiveRecords(true).first();
        return this.defaultPaymentMethodallocated;
    }

    public void setDefaultPaymentMethodAllocated(PO defaultPaymentMethodallocated) {
        this.defaultPaymentMethodallocated = defaultPaymentMethodallocated;
    }

    public boolean fillRate(Timestamp dateAcct, BigDecimal amount) {
        MLVEListVersion rateToApply = this.getRateDefinitionToApply().getValidVersionInstance(dateAcct);
        if (rateToApply != null) {
            List rateFinder = rateToApply.getListLine();
            Optional<MLVEListLine> rateDefinition = rateFinder.stream().filter(listLine -> amount.compareTo(listLine.getMinValue()) >= 0 && (amount.compareTo(listLine.getMaxValue()) < 0 || listLine.getMaxValue().compareTo(Env.ZERO) == 0)).findFirst();
            if (!rateDefinition.isPresent()) {
                this.addLog("@NotFound@ @WithholdingRentalRate_ID@");
                return false;
            }
            this.setWithholdingRate(rateDefinition.get().getCol_1());
            return true;
        }
        return false;
    }

    public boolean isValid() {
        PO paymentMethod;
        boolean isValid = true;
        this.event = this.getSetting().getEventModelValidator();
        if (Util.isEmpty((String)this.event)) {
            return false;
        }
        if (this.getDocument().get_Table_ID() != I_C_Payment.Table_ID) {
            return false;
        }
        this.payment = (MPayment)this.getDocument();
        if (this.payment == null || this.payment.getC_Order_ID() <= 0 || this.payment.getC_POS_ID() <= 0) {
            return false;
        }
        if (this.payment.isProcessed()) {
            return false;
        }
        this.order = (MOrder)this.payment.getC_Order();
        this.organizationInfo = MOrgInfo.get((Properties)this.getContext(), (int)this.payment.getAD_Org_ID(), (String)this.payment.get_TrxName());
        this.businessPartner = this.order.get_ValueAsBoolean("IsSOTrx") ? MBPartner.get((Properties)this.getContext(), (int)this.organizationInfo.get_ValueAsInt("WH_BPartner_ID")) : MBPartner.get((Properties)this.getContext(), (int)this.order.get_ValueAsInt("C_BPartner_ID"));
        if (this.businessPartner == null || !this.businessPartner.get_ValueAsBoolean("IsTaxpayer")) {
            return false;
        }
        MLVEWithholdingTax currentWHTax = MLVEWithholdingTax.getFromClient((Properties)this.getContext(), (int)this.getDocument().getAD_Org_ID(), (String)"AT");
        if (currentWHTax == null) {
            this.log.warning("Not Found Withholding Tax");
            return false;
        }
        if (currentWHTax.isClientExcluded()) {
            this.log.warning("Client Excluded " + currentWHTax.getName());
            return false;
        }
        this.rateDefinitionToApply = (MLVEList)currentWHTax.getDefaultWithholdingRate();
        if (this.rateDefinitionToApply == null) {
            return false;
        }
        this.setReturnValue("SourceOrder_ID", this.order.getC_Order_ID());
        this.setReturnValue("AD_Org_ID", this.order.getAD_Org_ID());
        this.setReturnValue("ECA40_IsFBTT", true);
        String taxpayerType = this.businessPartner.get_ValueAsString("TaxpayerType");
        if (Util.isEmpty((String)taxpayerType)) {
            return false;
        }
        if (this.order.get_ValueAsBoolean("IsWithholdingTaxExempt")) {
            return false;
        }
        if (this.businessPartner.get_ValueAsBoolean("IsWithholdingTaxExempt")) {
            return false;
        }
        if (this.getDefaultPaymentMethodAllocated() == null) {
            return false;
        }
        if (this.payment.get_ValueAsInt("C_PaymentMethod_ID") > 0 && ((paymentMethod = MTable.get((Properties)this.getContext(), (String)"C_PaymentMethod").getPO(this.payment.get_ValueAsInt("C_PaymentMethod_ID"), this.getTransactionName())) == null || paymentMethod.get_ValueAsBoolean("IsWithholdingExempt"))) {
            return false;
        }
        return isValid;
    }

    private int getPaymentCurrencyId() {
        return this.payment.getC_Currency_ID();
    }

    private BigDecimal getPaidAmound(int currencyToConvertId) {
        Optional paidAmount = MPayment.getOfOrder((MOrder)this.order).stream().filter(payment -> payment.getC_Currency_ID() == currencyToConvertId).map(payment -> {
            MInvoice creditMemo;
            BigDecimal paymentAmount = payment.getPayAmt();
            if (paymentAmount.compareTo(Env.ZERO) == 0 && payment.getTenderType().equals("M") && (creditMemo = (MInvoice)new Query(payment.getCtx(), "C_Invoice", "C_Payment_ID = ?", payment.get_TrxName()).setParameters(new Object[]{payment.getC_Payment_ID()}).first()) != null) {
                paymentAmount = creditMemo.getGrandTotal();
            }
            if (!payment.isReceipt()) {
                paymentAmount = payment.getPayAmt().negate();
            }
            return this.getConvetedAmount((MPayment)payment, paymentAmount, currencyToConvertId);
        }).collect(Collectors.reducing(BigDecimal::add));
        if (paidAmount.isPresent()) {
            return (BigDecimal)paidAmount.get();
        }
        return Env.ZERO;
    }

    private BigDecimal getOpenOpenAmount(int currencyToConvertId) {
        Optional paidAmount = MPayment.getOfOrder((MOrder)this.order).stream().map(payment -> {
            MInvoice creditMemo;
            BigDecimal paymentAmount = payment.getPayAmt();
            if (paymentAmount.compareTo(Env.ZERO) == 0 && payment.getTenderType().equals("M") && (creditMemo = (MInvoice)new Query(payment.getCtx(), "C_Invoice", "C_Payment_ID = ?", payment.get_TrxName()).setParameters(new Object[]{payment.getC_Payment_ID()}).first()) != null) {
                paymentAmount = creditMemo.getGrandTotal();
            }
            if (!payment.isReceipt()) {
                paymentAmount = payment.getPayAmt().negate();
            }
            return this.getConvetedAmount((MPayment)payment, paymentAmount, this.getPaymentCurrencyId());
        }).collect(Collectors.reducing(BigDecimal::add));
        List<PO> paymentReferencesList = POSCollectIGTFBase.getPaymentReferencesList(this.order);
        Optional paymentReferenceAmount = paymentReferencesList.stream().map(paymentReference -> {
            BigDecimal amount = (BigDecimal)paymentReference.get_Value("Amount");
            if (paymentReference.get_ValueAsBoolean("IsReceipt")) {
                amount = amount.negate();
            }
            return this.getConvetedAmount((PO)paymentReference, amount, this.getPaymentCurrencyId());
        }).collect(Collectors.reducing(BigDecimal::add));
        BigDecimal grandTotal = this.getConvetedAmount((PO)this.order, this.order.getGrandTotal(), this.getPaymentCurrencyId());
        BigDecimal paymentAmount = Env.ZERO;
        if (paidAmount.isPresent()) {
            paymentAmount = (BigDecimal)paidAmount.get();
        }
        BigDecimal totalPaymentAmount = paymentAmount;
        if (paymentReferenceAmount.isPresent()) {
            totalPaymentAmount = totalPaymentAmount.subtract((BigDecimal)paymentReferenceAmount.get());
        }
        return grandTotal.subtract(totalPaymentAmount);
    }

    public BigDecimal getPaymentBaseAmount() {
        BigDecimal paidAmount = this.getPaidAmound(this.getPaymentCurrencyId());
        BigDecimal openAmount = this.getOpenOpenAmount(this.getPaymentCurrencyId());
        if (openAmount.compareTo(Env.ZERO) < 0) {
            return paidAmount.add(openAmount);
        }
        return paidAmount;
    }

    private static List<PO> getPaymentReferencesList(MOrder order) {
        return POSCollectIGTFBase.getPaymentReferences(order).stream().filter(paymentReference -> !paymentReference.get_ValueAsBoolean("Processed") && !paymentReference.get_ValueAsBoolean("IsPaid") || paymentReference.get_ValueAsBoolean("IsKeepReferenceAfterProcess")).collect(Collectors.toList());
    }

    private static List<PO> getPaymentReferences(MOrder order) {
        if (MTable.get((Properties)Env.getCtx(), (String)"C_POSPaymentReference") == null) {
            return new ArrayList<PO>();
        }
        return new Query(order.getCtx(), "C_POSPaymentReference", "C_Order_ID = ?", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).list();
    }

    public BigDecimal getConvetedAmount(PO paymentReference, BigDecimal amount, int currencyToId) {
        if (paymentReference.get_ValueAsInt("C_Currency_ID") == currencyToId || amount == null || amount.compareTo(Env.ZERO) == 0) {
            return amount;
        }
        BigDecimal convertedAmount = MConversionRate.convert((Properties)paymentReference.getCtx(), (BigDecimal)amount, (int)paymentReference.get_ValueAsInt("C_Currency_ID"), (int)currencyToId, (Timestamp)this.order.getDateAcct(), (int)paymentReference.get_ValueAsInt("C_ConversionType_ID"), (int)paymentReference.getAD_Client_ID(), (int)paymentReference.getAD_Org_ID());
        return Optional.ofNullable(convertedAmount).orElse(Env.ZERO);
    }

    private BigDecimal getConvetedAmount(MPayment sourcePayment, BigDecimal amount, int currencyToId) {
        if (sourcePayment.getC_Currency_ID() == currencyToId || amount == null || amount.compareTo(Env.ZERO) == 0) {
            return amount;
        }
        BigDecimal convertedAmount = MConversionRate.convert((Properties)sourcePayment.getCtx(), (BigDecimal)amount, (int)sourcePayment.getC_Currency_ID(), (int)currencyToId, (Timestamp)sourcePayment.getDateAcct(), (int)sourcePayment.getC_ConversionType_ID(), (int)sourcePayment.getAD_Client_ID(), (int)sourcePayment.getAD_Org_ID());
        return Optional.ofNullable(convertedAmount).orElse(Env.ZERO);
    }

    protected void savePaymentReference(boolean createIfNotExists) {
        if (Optional.ofNullable(this.getWithholdingAmount()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0) {
            MTable paymentReferenceDefinition = MTable.get((Properties)this.getContext(), (String)"C_POSPaymentReference");
            if (paymentReferenceDefinition != null) {
                PO paymentReferenceToCreate = new Query(this.getContext(), "C_POSPaymentReference", "C_Order_ID = ? AND C_Currency_ID = ? AND TenderType = ? AND C_PaymentMethod_ID = ? AND Processed = 'N'", this.getTransactionName()).setParameters(new Object[]{this.order.getC_Order_ID(), this.payment.getC_Currency_ID(), "M", this.getDefaultPaymentMethodAllocated().get_ValueAsInt("C_PaymentMethod_ID")}).setClient_ID().first();
                if (createIfNotExists && (paymentReferenceToCreate == null || paymentReferenceToCreate.get_ID() <= 0)) {
                    paymentReferenceToCreate = paymentReferenceDefinition.getPO(0, this.getTransactionName());
                }
                if (paymentReferenceToCreate != null) {
                    paymentReferenceToCreate.set_ValueOfColumn("Amount", (Object)this.getWithholdingAmount());
                    paymentReferenceToCreate.set_ValueOfColumn("AmtSource", (Object)this.getWithholdingAmount());
                    paymentReferenceToCreate.set_ValueOfColumn("Base", (Object)this.getPaymentBaseAmount());
                    paymentReferenceToCreate.set_ValueOfColumn("Rate", (Object)this.getWithholdingRate());
                    paymentReferenceToCreate.set_ValueOfColumn("C_BPartner_ID", (Object)this.payment.getC_BPartner_ID());
                    paymentReferenceToCreate.set_ValueOfColumn("C_ConversionType_ID", (Object)this.payment.getC_ConversionType_ID());
                    paymentReferenceToCreate.set_ValueOfColumn("C_Currency_ID", (Object)this.payment.getC_Currency_ID());
                    paymentReferenceToCreate.set_ValueOfColumn("C_Order_ID", (Object)this.payment.getC_Order_ID());
                    paymentReferenceToCreate.set_ValueOfColumn("C_POS_ID", (Object)this.payment.getC_POS_ID());
                    if (this.payment.get_ValueAsInt("CollectingAgent_ID") > 0) {
                        paymentReferenceToCreate.set_ValueOfColumn("SalesRep_ID", (Object)this.payment.get_ValueAsInt("CollectingAgent_ID"));
                    }
                    if (this.payment.get_ValueAsInt("C_PaymentMethod_ID") > 0) {
                        paymentReferenceToCreate.set_ValueOfColumn("POS_SourcePaymentMethod_ID", (Object)this.payment.get_ValueAsInt("C_PaymentMethod_ID"));
                    }
                    paymentReferenceToCreate.set_ValueOfColumn("C_PaymentMethod_ID", (Object)this.getDefaultPaymentMethodAllocated().get_ValueAsInt("C_PaymentMethod_ID"));
                    paymentReferenceToCreate.set_ValueOfColumn("IsReceipt", (Object)false);
                    paymentReferenceToCreate.set_ValueOfColumn("TenderType", (Object)"M");
                    paymentReferenceToCreate.set_ValueOfColumn("PayDate", (Object)this.payment.getDateTrx());
                    paymentReferenceToCreate.set_ValueOfColumn("IsAutoCreatedReference", (Object)true);
                    paymentReferenceToCreate.set_ValueOfColumn("IsKeepReferenceAfterProcess", (Object)true);
                    paymentReferenceToCreate.set_ValueOfColumn("Description", (Object)Msg.parseTranslation((Properties)this.getContext(), (String)this.getProcessDescription()));
                    paymentReferenceToCreate.saveEx();
                }
            }
        } else {
            PO paymentReferenceToDelete;
            MTable paymentReferenceDefinition = MTable.get((Properties)this.getContext(), (String)"C_POSPaymentReference");
            if (paymentReferenceDefinition != null && (paymentReferenceToDelete = new Query(this.getContext(), "C_POSPaymentReference", "C_Order_ID = ? AND C_Currency_ID = ? AND TenderType = ? AND C_PaymentMethod_ID = ?", this.getTransactionName()).setParameters(new Object[]{this.order.getC_Order_ID(), this.payment.getC_Currency_ID(), "M", this.getDefaultPaymentMethodAllocated().get_ValueAsInt("C_PaymentMethod_ID")}).setClient_ID().first()) != null) {
                paymentReferenceToDelete.deleteEx(true);
            }
        }
        this.setWithholdingRate(Env.ZERO);
        this.setBaseAmount(Env.ZERO);
        this.setWithholdingAmount(Env.ZERO);
        this.setDefaultPaymentMethodAllocated(null);
    }
}

