/*
 * Decompiled with CFR 0.152.
 */
package org.spin.lve.at.setup;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MTaxCategory;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEListLine;
import org.erpya.lve.model.MLVEListType;
import org.erpya.lve.model.MLVEListVersion;
import org.erpya.lve.model.MLVEWithholdingTax;
import org.spin.lve.at.util.TBTT_Withholding;
import org.spin.lve.at.util.TBTT_WithholdingUtil;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHDefinitionLine;
import org.spin.model.MWHSetting;
import org.spin.model.MWHType;
import org.spin.util.ISetupDefinition;

public class TTBT_WithholdingSetup
implements ISetupDefinition {
    private static final String DESCRIPTION = "(*Created from Setup Automatically*)";
    private static final String UUID = "(*AutomaticSetup*)";
    private Properties context = null;
    private String transactionName = null;
    private int chargeId = 0;

    private Properties getCtx() {
        return this.context;
    }

    private String getTrx_Name() {
        return this.transactionName;
    }

    public String doIt(Properties context, String transactionName) {
        this.context = context;
        this.transactionName = transactionName;
        this.setupWithholding();
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void setupWithholding() {
        String whereClause = "EXISTS (SELECT 1 FROM WH_Setting s WHERE WH_Type.WH_Type_ID = s.WH_Type_ID AND ".concat("WithholdingClassName").concat(" = ?)");
        MWHType withHolgingType = (MWHType)new Query(this.getCtx(), "WH_Type", whereClause, this.getTrx_Name()).setParameters(new Object[]{TBTT_Withholding.class.getName()}).setClient_ID().first();
        if (withHolgingType != null && withHolgingType.get_ID() > 0) {
            return;
        }
        this.chargeId = this.getCharge();
        this.createSetting();
        this.createLVEList();
    }

    private void createSetting() {
        int withholdingDebitCxPId = this.getDocumentType("Impuesto IGTF (D\u00e9bito CxP)", "API");
        int withholdingCreditCxPId = this.getDocumentType("Impuesto IGTF (Cr\u00e9dito CxP)", "APC");
        int declarationDebitCxPId = this.getDocumentType("Declaraci\u00f3n de Impuesto IGTF (D\u00e9bito CxP)", "API");
        int declarationCreditCxPId = this.getDocumentType("Declaraci\u00f3n de Impuesto IGTF (Cr\u00e9dito CxP)", "APC");
        int withholdingDebitCxCId = this.getDocumentType("Impuesto IGTF (D\u00e9bito CxC)", "ARI");
        int withholdingCreditCxCId = this.getDocumentType("Impuesto IGTF (Cr\u00e9dito CxC)", "ARC");
        int declarationDebitCxCId = this.getDocumentType("Declaraci\u00f3n de Impuesto IGTF (D\u00e9bito CxC)", "ARI");
        int declarationCreditCxCId = this.getDocumentType("Declaraci\u00f3n de Impuesto IGTF (Cr\u00e9dito CxC)", "ARC");
        MWHType withholdingType = new MWHType(this.getCtx(), 0, this.getTrx_Name());
        withholdingType.setValue("Impuesto IGTF");
        withholdingType.setName("Impuesto IGTF");
        withholdingType.setWithholdingDebitDocType_ID(withholdingDebitCxPId);
        withholdingType.setWithholdingCreditDocType_ID(withholdingCreditCxPId);
        withholdingType.setDeclarationDebitDocType_ID(declarationDebitCxPId);
        withholdingType.setDeclarationCreditDocType_ID(declarationCreditCxPId);
        withholdingType.setDescription(DESCRIPTION);
        withholdingType.setIsDirectLoad(true);
        withholdingType.setUUID(UUID);
        withholdingType.saveEx();
        this.createWithholdingSetting(withholdingType);
        this.createWithholdingDefinition(withholdingType, "Impuesto IGTF (CxP)", withholdingDebitCxPId, withholdingCreditCxPId, declarationDebitCxPId, declarationCreditCxPId, false);
        this.createWithholdingDefinition(withholdingType, "Impuesto IGTF (CxC)", withholdingDebitCxCId, withholdingCreditCxCId, declarationDebitCxCId, declarationCreditCxCId, true);
    }

    private void createWithholdingDefinition(MWHType withholdingType, String name, int withholdingDebitDocType_ID, int withholdingCreditDocType_ID, int declarationDebitDocType_ID, int declarationCreditDocType_ID, boolean IsSOTrx) {
        MWHDefinition withholdingDefinition = new MWHDefinition(this.getCtx(), 0, this.getTrx_Name());
        withholdingDefinition.setName(name);
        withholdingDefinition.setWH_Type_ID(withholdingType.get_ID());
        withholdingDefinition.setC_Charge_ID(this.chargeId);
        withholdingDefinition.setDescription(DESCRIPTION);
        withholdingDefinition.setWithholdingDebitDocType_ID(withholdingDebitDocType_ID);
        withholdingDefinition.setWithholdingCreditDocType_ID(withholdingCreditDocType_ID);
        withholdingDefinition.setDeclarationDebitDocType_ID(declarationDebitDocType_ID);
        withholdingDefinition.setDeclarationCreditDocType_ID(declarationCreditDocType_ID);
        withholdingDefinition.setUUID(UUID);
        withholdingDefinition.setIsDirectLoad(true);
        withholdingDefinition.saveEx();
        String whereClause = "";
        whereClause = !IsSOTrx ? "DocBaseType = 'APP'" : "DocBaseType = 'ARR'";
        new Query(this.getCtx(), "C_DocType", whereClause, this.getTrx_Name()).setOnlyActiveRecords(true).list().forEach(docType -> {
            MWHDefinitionLine withholdingDefinitionLine = new MWHDefinitionLine(this.getCtx(), 0, this.getTrx_Name());
            withholdingDefinitionLine.setWH_Definition_ID(withholdingDefinition.get_ID());
            withholdingDefinitionLine.setC_DocType_ID(docType.get_ID());
            withholdingDefinitionLine.setUUID(UUID);
            withholdingDefinitionLine.setIsDirectLoad(true);
            withholdingDefinitionLine.saveEx();
        });
        whereClause = !IsSOTrx ? "(IsFiscalDocument = 'Y' AND DocBaseType IN ('".concat("API").concat("', '").concat("APC").concat("')) OR ").concat("(IsSOTrx='N' AND DocBaseType = '").concat("POO").concat("' AND ").concat("DocSubTypeSO NOT IN ('").concat("ON").concat("', '").concat("OB").concat("', '").concat("RM").concat("'))") : "(IsFiscalDocument = 'Y' AND DocBaseType IN ('".concat("ARI").concat("', '").concat("ARC").concat("')) OR ").concat("(IsSOTrx='Y' AND DocBaseType = '").concat("SOO").concat("' AND ").concat("DocSubTypeSO NOT IN ('").concat("ON").concat("', '").concat("OB").concat("', '").concat("RM").concat("'))");
        new Query(this.getCtx(), "C_DocType", whereClause, this.getTrx_Name()).setOnlyActiveRecords(true).list().forEach(docType -> {
            MWHDefinitionLine withholdingDefinitionLine = new MWHDefinitionLine(this.getCtx(), 0, this.getTrx_Name());
            withholdingDefinitionLine.setWH_Definition_ID(withholdingDefinition.get_ID());
            withholdingDefinitionLine.setC_DocType_ID(docType.get_ID());
            withholdingDefinitionLine.setUUID(UUID);
            withholdingDefinitionLine.setIsDirectLoad(true);
            withholdingDefinitionLine.saveEx();
        });
    }

    private void createWithholdingSetting(MWHType withholdingType) {
        MWHSetting withholdingSettingProcess = new MWHSetting(this.getCtx(), 0, this.getTrx_Name());
        withholdingSettingProcess.setWH_Type_ID(withholdingType.get_ID());
        withholdingSettingProcess.setValue(withholdingType.getValue());
        withholdingSettingProcess.setName(withholdingType.getName());
        withholdingSettingProcess.setSeqNo(10);
        withholdingSettingProcess.setEventType("P");
        withholdingSettingProcess.setDescription(DESCRIPTION);
        withholdingSettingProcess.setWithholdingClassName(TBTT_Withholding.class.getName());
        withholdingSettingProcess.setC_Charge_ID(this.chargeId);
        withholdingSettingProcess.setUUID(UUID);
        withholdingSettingProcess.setIsDirectLoad(true);
        withholdingSettingProcess.saveEx();
        MWHSetting withholdingSettingInvoice = new MWHSetting(this.getCtx(), 0, this.getTrx_Name());
        withholdingSettingInvoice.setWH_Type_ID(withholdingType.get_ID());
        withholdingSettingInvoice.setValue(withholdingType.getValue());
        withholdingSettingInvoice.setName(withholdingType.getName());
        withholdingSettingInvoice.setSeqNo(20);
        withholdingSettingInvoice.setEventType("E");
        withholdingSettingInvoice.setAD_Table_ID(MPayment.Table_ID);
        withholdingSettingInvoice.setEventModelValidator("DACO");
        withholdingSettingInvoice.setDescription(DESCRIPTION);
        withholdingSettingInvoice.setWithholdingClassName(TBTT_Withholding.class.getName());
        withholdingSettingInvoice.setC_Charge_ID(this.chargeId);
        withholdingSettingInvoice.setUUID(UUID);
        withholdingSettingInvoice.setIsDirectLoad(true);
        withholdingSettingInvoice.saveEx();
        MWHSetting withholdingSettingOrder = new MWHSetting(this.getCtx(), 0, this.getTrx_Name());
        withholdingSettingOrder.setWH_Type_ID(withholdingType.get_ID());
        withholdingSettingOrder.setValue(withholdingType.getValue());
        withholdingSettingOrder.setName(withholdingType.getName());
        withholdingSettingOrder.setSeqNo(30);
        withholdingSettingOrder.setEventType("E");
        withholdingSettingOrder.setAD_Table_ID(MOrder.Table_ID);
        withholdingSettingOrder.setEventModelValidator("DACO");
        withholdingSettingOrder.setDescription(DESCRIPTION);
        withholdingSettingOrder.setWithholdingClassName(TBTT_Withholding.class.getName());
        withholdingSettingOrder.setC_Charge_ID(this.chargeId);
        withholdingSettingOrder.setUUID(UUID);
        withholdingSettingOrder.setIsDirectLoad(true);
        withholdingSettingOrder.saveEx();
    }

    private int getDocumentType(String documentTypeName, String docBaseType) {
        MDocType docType = new MDocType(this.getCtx(), 0, this.getTrx_Name());
        docType.setName(documentTypeName);
        docType.setPrintName(documentTypeName);
        docType.setDocBaseType(docBaseType);
        docType.setGL_Category_ID();
        docType.set_ValueOfColumn("IsAllocateInvoice", (Object)true);
        docType.setUUID(UUID);
        docType.saveEx();
        return docType.get_ID();
    }

    private int getCharge() {
        String whereClause = "EXISTS (SELECT 1 FROM C_Tax t WHERE t.IsActive = 'Y' AND t.Rate = 0 AND t.C_TaxCategory_ID = C_TaxCategory.C_TaxCategory_ID)";
        MTaxCategory taxCategory = (MTaxCategory)new Query(this.getCtx(), "C_TaxCategory", whereClause, this.getTrx_Name()).setClient_ID().setOnlyActiveRecords(true).setOrderBy("IsDefault DESC").first();
        if (taxCategory == null || taxCategory != null && taxCategory.get_ID() == 0) {
            throw new AdempiereException("@NotFound@ @C_Tax_ID@ @Excempt@");
        }
        MCharge charge = new MCharge(this.getCtx(), 0, this.getTrx_Name());
        charge.setName("Impuesto IGTF");
        charge.setDescription(DESCRIPTION);
        charge.setChargeAmt(Env.ZERO);
        charge.setC_TaxCategory_ID(taxCategory.get_ID());
        charge.setUUID(UUID);
        charge.saveEx();
        return charge.get_ID();
    }

    private void createLVEList() {
        MLVEListType listType = new MLVEListType(this.getCtx(), 0, this.getTrx_Name());
        listType.setValue("AT");
        listType.setName("Impuesto a Grandes Transacciones Financieras");
        listType.setDescription(DESCRIPTION);
        listType.setUUID(UUID);
        listType.setIsDirectLoad(true);
        listType.saveEx();
        MLVEList list = new MLVEList(this.getCtx(), 0, this.getTrx_Name());
        list.setLVE_ListType_ID(listType.get_ID());
        list.setValue(listType.getValue());
        list.setName(listType.getName());
        list.setDescription(DESCRIPTION);
        list.setUUID(UUID);
        list.setIsDirectLoad(true);
        list.saveEx();
        MLVEListVersion listVersion = new MLVEListVersion(this.getCtx(), 0, this.getTrx_Name());
        listVersion.setLVE_List_ID(list.get_ID());
        listVersion.setName("Impuesto a Grandes Transacciones Financieras");
        listVersion.setValidFrom(TBTT_WithholdingUtil.TAX_ForeignPayment_ValidFrom);
        listVersion.setDescription(DESCRIPTION);
        listVersion.setUUID(UUID);
        listVersion.setIsDirectLoad(true);
        listVersion.saveEx();
        MLVEListLine listLine = new MLVEListLine(this.getCtx(), 0, this.getTrx_Name());
        listLine.setLVE_ListVersion_ID(listVersion.get_ID());
        listLine.setName(DESCRIPTION);
        listLine.setMinValue(Env.ZERO);
        listLine.setMaxValue(Env.ZERO);
        listLine.setCol_1(TBTT_WithholdingUtil.TAX_ForeignPayment_Rate);
        listLine.setUUID(UUID);
        listLine.setIsDirectLoad(true);
        listLine.saveEx();
        MLVEWithholdingTax withholdingTax = new MLVEWithholdingTax(this.getCtx(), 0, this.getTrx_Name());
        withholdingTax.setName("Impuesto a Grandes Transacciones Financieras");
        withholdingTax.setDescription(DESCRIPTION);
        withholdingTax.setWithholdingRateType_ID(listType.get_ID());
        withholdingTax.setDefaultWithholdingRate_ID(list.get_ID());
        withholdingTax.setIsClientExcluded(false);
        withholdingTax.setType("AT");
        withholdingTax.setUUID(UUID);
        withholdingTax.setIsDirectLoad(true);
        withholdingTax.saveEx();
    }
}

