/*
 * Decompiled with CFR 0.152.
 */
package org.spin.lve.at.setup;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_C_Payment;
import org.compiere.model.MCharge;
import org.compiere.model.MPOS;
import org.compiere.model.MTable;
import org.compiere.model.MTaxCategory;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.spin.lve.at.util.POSCollectIGTFChange;
import org.spin.lve.at.util.POSOrderIGTFProcess;
import org.spin.lve.at.util.TBTT_Withholding;
import org.spin.model.MWHSetting;
import org.spin.model.MWHType;
import org.spin.util.ISetupDefinition;

public class TTBT_WithholdingPOSSetup
implements ISetupDefinition {
    private static final String DESCRIPTION = "(*Created from Setup Automatically*)";
    private static final String UUID = "(*AutomaticSetup*)";
    private Properties context = null;
    private String transactionName = null;
    private int chargeId = 0;

    private Properties getCtx() {
        return this.context;
    }

    private String getTrx_Name() {
        return this.transactionName;
    }

    public String doIt(Properties context, String transactionName) {
        this.context = context;
        this.transactionName = transactionName;
        this.setupWithholding();
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void setupWithholding() {
        String whereClause = "EXISTS (SELECT 1 FROM WH_Setting s WHERE WH_Type.WH_Type_ID = s.WH_Type_ID AND ".concat("WithholdingClassName").concat(" = ?)");
        MWHType withHolgingType = (MWHType)new Query(this.getCtx(), "WH_Type", whereClause, this.getTrx_Name()).setParameters(new Object[]{TBTT_Withholding.class.getName()}).setClient_ID().first();
        if (withHolgingType == null || withHolgingType.getWH_Type_ID() <= 0) {
            return;
        }
        this.chargeId = this.getCharge();
        int maxSequence = DB.getSQLValue((String)this.getTrx_Name(), (String)"SELECT MAX(SeqNo) FROM WH_Setting WHERE WH_Type_ID = ?", (int)withHolgingType.getWH_Type_ID());
        maxSequence = maxSequence < 0 ? 10 : (maxSequence += 10);
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSCollectIGTFChange.class.getName(), "TAN", I_C_Payment.Table_ID, "IGTF-Pago-Crear", "Impuesto IGTF Despu\u00e9s de Crear Pago", maxSequence)) {
            maxSequence += 10;
        }
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSCollectIGTFChange.class.getName(), "TAC", I_C_Payment.Table_ID, "IGTF-Pago-Modificar", "Impuesto IGTF Despu\u00e9s de Modificar Pago", maxSequence)) {
            maxSequence += 10;
        }
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSCollectIGTFChange.class.getName(), "TAD", I_C_Payment.Table_ID, "IGTF-Pago-Eliminar", "Impuesto IGTF Despu\u00e9s de Eliminar el Pago", maxSequence)) {
            maxSequence += 10;
        }
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSOrderIGTFProcess.class.getName(), "DACO", I_C_Order.Table_ID, "IGTF-Orden-Procesar", "Impuesto IGTF Despu\u00e9s de Procesar Orden de Venta", maxSequence)) {
            maxSequence += 10;
        }
        this.createPaymentMethod(withHolgingType.getWH_Type_ID());
    }

    private void createPaymentMethod(int withholdingTypeId) {
        PO payPaymentMethod;
        PO paymentMethod = new Query(this.getCtx(), "C_PaymentMethod", "TenderType = 'M' AND Value = ?", this.getTrx_Name()).setParameters(new Object[]{"IGTF"}).first();
        if (paymentMethod == null || paymentMethod.get_ID() <= 0) {
            paymentMethod = MTable.get((Properties)this.context, (String)"C_PaymentMethod").getPO(0, this.getTrx_Name());
            paymentMethod.set_ValueOfColumn("TenderType", (Object)"M");
            paymentMethod.set_ValueOfColumn("Value", (Object)"IGTF");
            paymentMethod.set_ValueOfColumn("Name", (Object)"IGTF");
            paymentMethod.set_ValueOfColumn("Description", (Object)"IGTF sobre");
            paymentMethod.set_ValueOfColumn("WH_Type_ID", (Object)withholdingTypeId);
            paymentMethod.setAD_Org_ID(0);
            paymentMethod.saveEx();
        }
        if ((payPaymentMethod = new Query(this.getCtx(), "C_PaymentMethod", "TenderType = 'X' AND Value = ?", this.getTrx_Name()).setParameters(new Object[]{"Pago-IGTF"}).first()) == null || payPaymentMethod.get_ID() <= 0) {
            payPaymentMethod = MTable.get((Properties)this.context, (String)"C_PaymentMethod").getPO(0, this.getTrx_Name());
            payPaymentMethod.set_ValueOfColumn("TenderType", (Object)"X");
            payPaymentMethod.set_ValueOfColumn("Value", (Object)"Pago-IGTF");
            payPaymentMethod.set_ValueOfColumn("Name", (Object)"Pago de IGTF");
            payPaymentMethod.set_ValueOfColumn("Description", (Object)"Pago de IGTF");
            payPaymentMethod.set_ValueOfColumn("WH_Type_ID", (Object)withholdingTypeId);
            payPaymentMethod.set_ValueOfColumn("IsWithholdingExempt", (Object)true);
            payPaymentMethod.setAD_Org_ID(0);
            payPaymentMethod.saveEx();
        }
        if (MTable.getTable_ID((String)"C_POSPaymentTypeAllocation") <= 0) {
            return;
        }
        int paymentMethodId = paymentMethod.get_ID();
        int payPaymentMethodId = payPaymentMethod.get_ID();
        new Query(this.getCtx(), "C_POS", null, this.getTrx_Name()).setOnlyActiveRecords(true).setClient_ID().getIDsAsList().forEach(posId -> {
            PO allocatedPayPaymentMethod;
            MPOS pos = MPOS.get((Properties)this.getCtx(), (int)posId);
            PO allocatedPaymentMethod = new Query(this.getCtx(), "C_POSPaymentTypeAllocation", "C_POS_ID = ? AND C_PaymentMethod_ID = ?", this.getTrx_Name()).setParameters(new Object[]{posId, paymentMethodId}).first();
            if (allocatedPaymentMethod == null || allocatedPaymentMethod.get_ID() <= 0) {
                allocatedPaymentMethod = MTable.get((Properties)this.getCtx(), (String)"C_POSPaymentTypeAllocation").getPO(0, this.getTrx_Name());
                allocatedPaymentMethod.setAD_Org_ID(pos.getAD_Org_ID());
                allocatedPaymentMethod.set_ValueOfColumn("C_POS_ID", posId);
                allocatedPaymentMethod.set_ValueOfColumn("C_PaymentMethod_ID", (Object)paymentMethodId);
                allocatedPaymentMethod.set_ValueOfColumn("IsPaymentReference", (Object)true);
                allocatedPaymentMethod.set_ValueOfColumn("IsDisplayedFromCollection", (Object)false);
                allocatedPaymentMethod.set_ValueOfColumn("SeqNo", (Object)999);
                allocatedPaymentMethod.saveEx();
            }
            if ((allocatedPayPaymentMethod = new Query(this.getCtx(), "C_POSPaymentTypeAllocation", "C_POS_ID = ? AND C_PaymentMethod_ID = ?", this.getTrx_Name()).setParameters(new Object[]{posId, payPaymentMethodId}).first()) == null || allocatedPayPaymentMethod.get_ID() <= 0) {
                allocatedPayPaymentMethod = MTable.get((Properties)this.getCtx(), (String)"C_POSPaymentTypeAllocation").getPO(0, this.getTrx_Name());
                allocatedPayPaymentMethod.setAD_Org_ID(pos.getAD_Org_ID());
                allocatedPayPaymentMethod.set_ValueOfColumn("C_POS_ID", posId);
                allocatedPayPaymentMethod.set_ValueOfColumn("C_PaymentMethod_ID", (Object)payPaymentMethodId);
                allocatedPayPaymentMethod.set_ValueOfColumn("IsPaymentReference", (Object)false);
                allocatedPayPaymentMethod.set_ValueOfColumn("IsDisplayedFromCollection", (Object)true);
                allocatedPayPaymentMethod.set_ValueOfColumn("SeqNo", (Object)999);
                allocatedPayPaymentMethod.saveEx();
            }
        });
    }

    private boolean createSettingWithEvent(int withholdingTypeId, String className, String eventType, int tableId, String value, String name, int sequence) {
        MWHSetting setting = (MWHSetting)new Query(this.getCtx(), "WH_Setting", "EventType = 'E' AND WH_Type_ID = ? AND EventModelValidator = ? AND WithholdingClassName = ? AND AD_Table_ID = ?", this.getTrx_Name()).setParameters(new Object[]{withholdingTypeId, eventType, className, tableId}).first();
        if (setting != null) {
            return false;
        }
        setting = new MWHSetting(this.getCtx(), 0, this.getTrx_Name());
        setting.setWH_Type_ID(withholdingTypeId);
        setting.setValue(value);
        setting.setName(name);
        setting.setSeqNo(sequence);
        setting.setEventType("E");
        setting.setAD_Table_ID(tableId);
        setting.setEventModelValidator(eventType);
        setting.setDescription(DESCRIPTION);
        setting.setWithholdingClassName(className);
        setting.setC_Charge_ID(this.chargeId);
        setting.setUUID(UUID);
        setting.setIsDirectLoad(true);
        setting.saveEx();
        return true;
    }

    private int getCharge() {
        String whereClause = "EXISTS (SELECT 1 FROM C_Tax t WHERE t.IsActive = 'Y' AND t.Rate = 0 AND t.C_TaxCategory_ID = C_TaxCategory.C_TaxCategory_ID)";
        MTaxCategory taxCategory = (MTaxCategory)new Query(this.getCtx(), "C_TaxCategory", whereClause, this.getTrx_Name()).setClient_ID().setOnlyActiveRecords(true).setOrderBy("IsDefault DESC").first();
        if (taxCategory == null || taxCategory != null && taxCategory.getC_TaxCategory_ID() == 0) {
            throw new AdempiereException("@NotFound@ @C_Tax_ID@ @Excempt@");
        }
        MCharge charge = (MCharge)new Query(this.getCtx(), "C_Charge", "Name = ?", this.getTrx_Name()).setParameters(new Object[]{"Impuesto IGTF"}).setClient_ID().first();
        if (charge == null || charge.getC_Charge_ID() <= 0) {
            charge = new MCharge(this.getCtx(), 0, this.getTrx_Name());
            charge.setName("Impuesto IGTF");
            charge.setDescription(DESCRIPTION);
            charge.setChargeAmt(Env.ZERO);
            charge.setC_TaxCategory_ID(taxCategory.getC_TaxCategory_ID());
            charge.setUUID(UUID);
            charge.saveEx();
        }
        return charge.getC_Charge_ID();
    }
}

