/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.extensions;

import java.net.URL;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import net.sf.jasperreports.extensions.SpringExtensionsRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringExtensionsRegistryFactory
implements ExtensionsRegistryFactory {
    private static final Log log = LogFactory.getLog(SpringExtensionsRegistryFactory.class);
    public static final String EXCEPTION_MESSAGE_KEY_NO_SPRING_RESOURCE_SET = "extensions.no.spring.resource.set";
    public static final String EXCEPTION_MESSAGE_KEY_SPRING_RESOURCE_NOT_FOUND = "extensions.spring.resource.not.found";
    public static final String PROPERTY_SUFFIX_SPRING_BEANS_RESOURCE = ".spring.beans.resource";

    @Override
    public ExtensionsRegistry createRegistry(String registryId, JRPropertiesMap properties) {
        ListableBeanFactory beanFactory = this.getBeanFactory(registryId, properties);
        return new SpringExtensionsRegistry(beanFactory);
    }

    protected ListableBeanFactory getBeanFactory(String registryId, JRPropertiesMap properties) {
        String resourceProp = "net.sf.jasperreports.extension." + registryId + PROPERTY_SUFFIX_SPRING_BEANS_RESOURCE;
        String resource = properties.getProperty(resourceProp);
        if (resource == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_SPRING_RESOURCE_SET, (Object[])null);
        }
        URL resourceLocation = JRLoader.getResource(resource);
        if (resourceLocation == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_SPRING_RESOURCE_NOT_FOUND, new Object[]{resource, registryId});
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Spring beans factory for extensions registry " + registryId + " using " + resourceLocation));
        }
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        reader.loadBeanDefinitions((Resource)new UrlResource(resourceLocation));
        return beanFactory;
    }
}

