/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRCommonImage;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageAlignment;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.fill.JRTemplateGraphicElement;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRTemplateImage
extends JRTemplateGraphicElement
implements JRImageAlignment,
JRCommonImage {
    private static final long serialVersionUID = 10200L;
    private ScaleImageEnum scaleImageValue;
    private Boolean isUsingCache = Boolean.TRUE;
    private HorizontalImageAlignEnum horizontalImageAlign;
    private VerticalImageAlignEnum verticalImageAlign;
    protected boolean isLazy;
    protected OnErrorTypeEnum onErrorTypeValue = OnErrorTypeEnum.ERROR;
    private String linkType;
    private String linkTarget;
    private JRLineBox lineBox;
    private int PSEUDO_SERIAL_VERSION_UID = 60002;
    private Byte horizontalAlignment;
    private Byte verticalAlignment;
    private HorizontalAlignEnum horizontalAlignmentValue;
    private VerticalAlignEnum verticalAlignmentValue;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private Byte scaleImage;
    private byte onErrorType;

    protected JRTemplateImage(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRImage image) {
        super(origin, defaultStyleProvider);
        this.setImage(image);
    }

    protected JRTemplateImage(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRChart chart) {
        super(origin, defaultStyleProvider);
        this.setChart(chart);
    }

    public JRTemplateImage(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
        this.lineBox = new JRBaseLineBox(this);
        this.linePen = new JRBasePen(this);
    }

    protected void setImage(JRImage image) {
        super.setGraphicElement(image);
        this.lineBox = image.getLineBox().clone(this);
        this.setScaleImage(image.getScaleImageValue());
        this.setUsingCache(image.getUsingCache());
        this.setHorizontalImageAlign(image.getHorizontalImageAlign());
        this.setVerticalImageAlign(image.getVerticalImageAlign());
        this.setLazy(image.isLazy());
        this.setOnErrorType(image.getOnErrorTypeValue());
        this.setLinkType(image.getLinkType());
        this.setLinkTarget(image.getLinkTarget());
    }

    protected void setChart(JRChart chart) {
        super.setElement(chart);
        this.linePen = new JRBasePen(this);
        this.getLinePen().setLineWidth(Float.valueOf(0.0f));
        this.setFill(FillEnum.SOLID);
        this.copyLineBox(chart.getLineBox());
        this.setLinkType(chart.getLinkType());
        this.setLinkTarget(chart.getLinkTarget());
    }

    public void copyLineBox(JRLineBox box) {
        this.lineBox = box.clone(this);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public ModeEnum getModeValue() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public ScaleImageEnum getScaleImageValue() {
        return this.getStyleResolver().getScaleImageValue(this);
    }

    @Override
    public ScaleImageEnum getOwnScaleImageValue() {
        return this.scaleImageValue;
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImageValue) {
        this.scaleImageValue = scaleImageValue;
    }

    public boolean isUsingCache() {
        return this.isUsingCache == null ? true : this.isUsingCache;
    }

    public void setUsingCache(boolean isUsingCache) {
        this.isUsingCache = isUsingCache;
    }

    public void setUsingCache(Boolean isUsingCache) {
        this.isUsingCache = isUsingCache;
    }

    @Override
    public HorizontalImageAlignEnum getHorizontalImageAlign() {
        return this.getStyleResolver().getHorizontalImageAlign(this);
    }

    @Override
    public HorizontalImageAlignEnum getOwnHorizontalImageAlign() {
        return this.horizontalImageAlign;
    }

    @Override
    public void setHorizontalImageAlign(HorizontalImageAlignEnum horizontalImageAlign) {
        this.horizontalImageAlign = horizontalImageAlign;
    }

    @Override
    public VerticalImageAlignEnum getVerticalImageAlign() {
        return this.getStyleResolver().getVerticalImageAlign(this);
    }

    @Override
    public VerticalImageAlignEnum getOwnVerticalImageAlign() {
        return this.verticalImageAlign;
    }

    @Override
    public void setVerticalImageAlign(VerticalImageAlignEnum verticalImageAlign) {
        this.verticalImageAlign = verticalImageAlign;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public void setLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public OnErrorTypeEnum getOnErrorTypeValue() {
        return this.onErrorTypeValue;
    }

    public void setOnErrorType(OnErrorTypeEnum onErrorTypeValue) {
        this.onErrorTypeValue = onErrorTypeValue;
    }

    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this.getLinkType());
    }

    protected void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public HyperlinkTargetEnum getHyperlinkTargetValue() {
        return JRHyperlinkHelper.getHyperlinkTargetValue(this.getLinkTarget());
    }

    protected void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.horizontalAlignmentValue = HorizontalAlignEnum.getByValue(this.horizontalAlignment);
            this.verticalAlignmentValue = VerticalAlignEnum.getByValue(this.verticalAlignment);
            this.scaleImageValue = ScaleImageEnum.getByValue(this.scaleImage);
            this.onErrorTypeValue = OnErrorTypeEnum.getByValue(this.onErrorType);
            this.horizontalAlignment = null;
            this.verticalAlignment = null;
            this.scaleImage = null;
        }
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 60002) {
            this.horizontalImageAlign = HorizontalAlignEnum.getHorizontalImageAlignEnum(this.horizontalAlignmentValue);
            this.verticalImageAlign = VerticalAlignEnum.getVerticalImageAlignEnum(this.verticalAlignmentValue);
            this.horizontalAlignmentValue = null;
            this.verticalAlignmentValue = null;
        }
    }

    @Override
    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        this.addGraphicHash(hash);
        hash.add(this.scaleImageValue);
        hash.add(this.isUsingCache);
        hash.add(this.horizontalImageAlign);
        hash.add(this.verticalImageAlign);
        hash.add(this.isLazy);
        hash.add(this.onErrorTypeValue);
        hash.add(this.linkType);
        hash.add(this.linkTarget);
        hash.addIdentical(this.lineBox);
        return hash.getHashCode();
    }

    @Override
    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRTemplateImage)) {
            return false;
        }
        JRTemplateImage template = (JRTemplateImage)object;
        return this.graphicIdentical(template) && ObjectUtils.equals(this.scaleImageValue, template.scaleImageValue) && ObjectUtils.equals(this.isUsingCache, template.isUsingCache) && ObjectUtils.equals(this.horizontalImageAlign, template.horizontalImageAlign) && ObjectUtils.equals(this.verticalImageAlign, template.verticalImageAlign) && ObjectUtils.equals(this.isLazy, template.isLazy) && ObjectUtils.equals(this.onErrorTypeValue, template.onErrorTypeValue) && ObjectUtils.equals(this.linkType, template.linkType) && ObjectUtils.equals(this.linkTarget, template.linkTarget) && ObjectUtils.identical(this.lineBox, template.lineBox);
    }
}

