/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.oasis.DocumentBuilder;
import net.sf.jasperreports.engine.export.oasis.InternalImageProcessorResult;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;

public class InternalImageProcessor {
    private final JRPrintImage imageElement;
    private final RenderersCache imageRenderersCache;
    private final JRExporterGridCell cell;
    private final int availableImageWidth;
    private final int availableImageHeight;
    private final DocumentBuilder documentBuilder;
    private final JasperReportsContext jasperReportsContext;

    public InternalImageProcessor(JRPrintImage imageElement, JRExporterGridCell cell, int availableImageWidth, int availableImageHeight, DocumentBuilder documentBuilder, JasperReportsContext jasperReportsContext) {
        this.imageElement = imageElement;
        this.imageRenderersCache = imageElement.isUsingCache() ? documentBuilder.getRenderersCache() : new RenderersCache(jasperReportsContext);
        this.cell = cell;
        this.availableImageWidth = availableImageWidth;
        this.availableImageHeight = availableImageHeight;
        this.documentBuilder = documentBuilder;
        this.jasperReportsContext = jasperReportsContext;
    }

    public InternalImageProcessorResult process(Renderable renderer) throws JRException {
        boolean isLazy = RendererUtil.isLazy(renderer);
        if (!isLazy && renderer instanceof ResourceRenderer) {
            renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
        }
        int width = this.availableImageWidth;
        int height = this.availableImageHeight;
        int xoffset = 0;
        int yoffset = 0;
        double cropTop = 0.0;
        double cropLeft = 0.0;
        double cropBottom = 0.0;
        double cropRight = 0.0;
        switch (this.imageElement.getScaleImageValue()) {
            case FILL_FRAME: {
                width = this.availableImageWidth;
                height = this.availableImageHeight;
                break;
            }
            case CLIP: {
                Dimension2D dimension;
                double normalWidth = this.availableImageWidth;
                double normalHeight = this.availableImageHeight;
                DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable(renderer);
                Dimension2D dimension2D = dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(this.jasperReportsContext);
                if (dimension != null) {
                    normalWidth = dimension.getWidth();
                    normalHeight = dimension.getHeight();
                }
                if (normalWidth > (double)this.availableImageWidth) {
                    switch (this.imageElement.getHorizontalImageAlign()) {
                        case RIGHT: {
                            cropLeft = normalWidth - (double)this.availableImageWidth;
                            cropRight = 0.0;
                            break;
                        }
                        case CENTER: {
                            cropRight = cropLeft = (normalWidth - (double)this.availableImageWidth) / 2.0;
                            break;
                        }
                        default: {
                            cropLeft = 0.0;
                            cropRight = normalWidth - (double)this.availableImageWidth;
                        }
                    }
                    width = (int)normalWidth - (int)cropLeft - (int)cropRight;
                } else {
                    width = (int)normalWidth;
                }
                if (normalHeight > (double)this.availableImageHeight) {
                    switch (this.imageElement.getVerticalImageAlign()) {
                        case TOP: {
                            cropTop = 0.0;
                            cropBottom = normalHeight - (double)this.availableImageHeight;
                            break;
                        }
                        case MIDDLE: {
                            cropBottom = cropTop = (normalHeight - (double)this.availableImageHeight) / 2.0;
                            break;
                        }
                        default: {
                            cropTop = normalHeight - (double)this.availableImageHeight;
                            cropBottom = 0.0;
                        }
                    }
                    height = (int)normalHeight - (int)cropTop - (int)cropBottom;
                    break;
                }
                height = (int)normalHeight;
                break;
            }
            default: {
                double ratio;
                double normalWidth = this.availableImageWidth;
                double normalHeight = this.availableImageHeight;
                if (!isLazy) {
                    Dimension2D dimension;
                    DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable(renderer);
                    Dimension2D dimension2D = dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(this.jasperReportsContext);
                    if (dimension != null) {
                        normalWidth = dimension.getWidth();
                        normalHeight = dimension.getHeight();
                    }
                }
                if ((ratio = normalWidth / normalHeight) > (double)this.availableImageWidth / (double)this.availableImageHeight) {
                    width = this.availableImageWidth;
                    height = (int)((double)width / ratio);
                    break;
                }
                height = this.availableImageHeight;
                width = (int)(ratio * (double)height);
            }
        }
        String imagePath = this.documentBuilder.getImagePath(renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null, this.cell, isLazy, this.imageRenderersCache);
        return new InternalImageProcessorResult(imagePath, width, height, xoffset, yoffset, cropTop, cropLeft, cropBottom, cropRight);
    }
}

