/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.ParameterContributor;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.ParameterContributorFactory;
import net.sf.jasperreports.repo.DataAdapterResource;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.ResourceInfo;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DataAdapterParameterContributorFactory
implements ParameterContributorFactory {
    private static final Log log = LogFactory.getLog(DataAdapterParameterContributorFactory.class);
    public static final String PROPERTY_DATA_ADAPTER_LOCATION = "net.sf.jasperreports.data.adapter";
    private static final DataAdapterParameterContributorFactory INSTANCE = new DataAdapterParameterContributorFactory();

    private DataAdapterParameterContributorFactory() {
    }

    public static DataAdapterParameterContributorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public List<ParameterContributor> getContributors(ParameterContributorContext context) throws JRException {
        ArrayList<ParameterContributor> contributors = new ArrayList<ParameterContributor>();
        String dataAdapterUri = JRPropertiesUtil.getInstance(context.getJasperReportsContext()).getProperty(context.getDataset(), PROPERTY_DATA_ADAPTER_LOCATION);
        if (dataAdapterUri != null) {
            RepositoryUtil repository = RepositoryUtil.getInstance(context.getRepositoryContext());
            ResourceInfo resourceInfo = repository.getResourceInfo(dataAdapterUri);
            String resourceLocation = dataAdapterUri;
            String contextLocation = null;
            if (resourceInfo != null) {
                resourceLocation = resourceInfo.getRepositoryResourceLocation();
                contextLocation = resourceInfo.getRepositoryContextLocation();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("data adapter " + dataAdapterUri + " resolved to " + resourceLocation + ", context " + contextLocation));
                }
            }
            DataAdapterResource dataAdapterResource = repository.getResourceFromLocation(resourceLocation, DataAdapterResource.class);
            RepositoryResourceContext currentContext = context.getRepositoryContext().getResourceContext();
            SimpleRepositoryResourceContext adapterResourceContext = SimpleRepositoryResourceContext.of(contextLocation, currentContext == null ? null : currentContext.getDerivedContextFallback());
            SimpleRepositoryContext adapterRepositoryContext = SimpleRepositoryContext.of(context.getJasperReportsContext(), adapterResourceContext);
            ParameterContributorContext adapterContext = context.withRepositoryContext(adapterRepositoryContext);
            DataAdapterService dataAdapterService = DataAdapterServiceUtil.getInstance(adapterContext).getService(dataAdapterResource.getDataAdapter());
            return Collections.singletonList(dataAdapterService);
        }
        return contributors;
    }
}

