/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHSetting;
import org.spin.model.MWHType;
import org.spin.model.X_WH_Setting;
import org.spin.util.AbstractWithholdingSetting;

public class WithholdingEngine {
    private static WithholdingEngine settingEngine = null;
    private HashMap<String, Object> returnValues;
    private StringBuffer errorMessage = new StringBuffer();
    private HashMap<String, String> processLog;

    private WithholdingEngine() {
    }

    public static synchronized WithholdingEngine get() {
        if (settingEngine == null) {
            settingEngine = new WithholdingEngine();
        }
        return settingEngine;
    }

    public HashMap<String, Object> getReturnValues() {
        return this.returnValues;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }

    public String fireDocValidate(PO document, int documentTiming, int documentTypeId) {
        if (document == null || documentTypeId <= 0) {
            return null;
        }
        MDocType documentType = MDocType.get((Properties)document.getCtx(), (int)documentTypeId);
        if (documentType == null) {
            return null;
        }
        this.returnValues = new HashMap();
        this.processLog = new HashMap();
        this.errorMessage = new StringBuffer();
        MWHDefinition.getFromDocumentType(Env.getCtx(), documentTypeId, document.getAD_Org_ID()).forEach(withholding -> this.processWithholding((MWHDefinition)withholding, document, ModelValidator.documentEventValidators[documentTiming]));
        return this.errorMessage.toString();
    }

    public String fireDocValidate(PO document, int documentTiming) {
        if (document == null) {
            return null;
        }
        int documentTypeId = document.get_ValueAsInt("C_DocTypeTarget_ID");
        if (documentTypeId <= 0) {
            documentTypeId = document.get_ValueAsInt("C_DocType_ID");
        }
        return this.fireDocValidate(document, documentTiming, documentTypeId);
    }

    public String fireModelChange(PO document, int changeType, int documentTypeId) {
        this.returnValues = new HashMap();
        this.processLog = new HashMap();
        this.errorMessage = new StringBuffer();
        if (DocAction.class.isAssignableFrom(document.getClass()) || documentTypeId > 0) {
            MDocType documentType = MDocType.get((Properties)document.getCtx(), (int)documentTypeId);
            if (documentType == null) {
                return null;
            }
            MWHDefinition.getFromDocumentType(Env.getCtx(), documentTypeId, document.getAD_Org_ID()).forEach(withholding -> this.processWithholding((MWHDefinition)withholding, document, ModelValidator.tableEventValidators[changeType]));
        } else {
            MWHDefinition.getFromTable(Env.getCtx(), document.get_TableName()).forEach(withholding -> this.processWithholding((MWHDefinition)withholding, document, ModelValidator.tableEventValidators[changeType]));
        }
        return this.errorMessage.toString();
    }

    private void processWithholding(MWHDefinition withholdingDefinition, PO document, String eventModelValidator) {
        this.processWithholding(withholdingDefinition, document, eventModelValidator, null, false);
    }

    private void processWithholding(MWHDefinition withholdingDefinition, PO document, String eventModelValidator, HashMap<String, Object> parameters, boolean eventProcess) {
        if (!eventProcess) {
            withholdingDefinition.getSettingList(document.get_TableName(), eventModelValidator).stream().sorted(Comparator.comparing(X_WH_Setting::getSeqNo)).forEach(setting -> this.processWithholding((MWHSetting)setting, withholdingDefinition, document, eventModelValidator));
        } else {
            withholdingDefinition.getSettingList(eventModelValidator).stream().sorted(Comparator.comparing(X_WH_Setting::getSeqNo)).forEach(setting -> this.processWithholding((MWHSetting)setting, withholdingDefinition, document, eventModelValidator, parameters));
        }
    }

    private void processWithholding(MWHSetting setting, MWHDefinition withholdingDefinition, PO document, String eventModelValidator) {
        this.processWithholding(setting, withholdingDefinition, document, eventModelValidator, null);
    }

    private void processWithholding(MWHSetting setting, MWHDefinition withholdingDefinition, PO document, String eventModelValidator, HashMap<String, Object> parameters) {
        try {
            AbstractWithholdingSetting settingRunningImplementation = setting.getSettingInstance();
            if (settingRunningImplementation == null) {
                throw new AdempiereException("@WH_Setting_ID@ @WithholdingClassName@ @NotFound@");
            }
            if (parameters != null) {
                settingRunningImplementation.setParameters(parameters);
            }
            settingRunningImplementation.setWithholdingDefinition(withholdingDefinition);
            settingRunningImplementation.setDocument(document);
            if (settingRunningImplementation.isValid()) {
                String runMessage = settingRunningImplementation.run();
                if (!Util.isEmpty((String)runMessage)) {
                    if (this.errorMessage.length() > 0) {
                        this.errorMessage.append(Env.NL);
                    }
                    this.errorMessage.append(runMessage);
                }
                for (Map.Entry<String, Object> entry : settingRunningImplementation.getReturnValues().entrySet()) {
                    this.returnValues.put(entry.getKey(), entry.getValue());
                }
                settingRunningImplementation.saveResult();
            }
            if (!Util.isEmpty((String)settingRunningImplementation.getProcessLog())) {
                this.processLog.put(setting.getWH_Setting_ID() + "|" + document.get_ID(), settingRunningImplementation.getProcessLog());
                settingRunningImplementation.saveResult();
            }
        }
        catch (Exception e) {
            this.errorMessage.append(e);
        }
    }

    public String fireProcess(PO document, HashMap<String, Object> parameters) {
        return this.fireProcess(document, null, null, null, parameters);
    }

    public String fireProcess(PO document, MWHType type, HashMap<String, Object> parameters) {
        return this.fireProcess(document, type, null, null, parameters);
    }

    public String fireProcess(PO document, MWHType type, MWHSetting setting, HashMap<String, Object> parameters) {
        return this.fireProcess(document, type, setting, null, parameters);
    }

    public String fireProcess(PO document, MWHType type, MWHSetting setting, MWHDefinition definition, HashMap<String, Object> parameters) {
        if (document == null) {
            return "";
        }
        int documentTypeId = document.get_ValueAsInt("C_DocTypeTarget_ID");
        if (documentTypeId <= 0) {
            documentTypeId = document.get_ValueAsInt("C_DocType_ID");
        }
        this.returnValues = new HashMap();
        this.processLog = new HashMap();
        this.errorMessage = new StringBuffer();
        MWHDefinition.getFromDocumentType(Env.getCtx(), documentTypeId, document.getAD_Org_ID()).stream().filter(whDef -> (type != null && type.get_ID() == whDef.getWH_Type_ID() || type == null) && (definition != null && definition.get_ID() == whDef.get_ID() || definition == null)).forEach(whDef -> {
            if (setting != null && setting.getWH_Type_ID() == whDef.getWH_Type_ID() && setting.getEventType().equals("P")) {
                this.processWithholding(setting, (MWHDefinition)whDef, document, "P", parameters);
            } else if (setting == null) {
                this.processWithholding((MWHDefinition)whDef, document, "P", parameters, true);
            }
        });
        return this.errorMessage.toString();
    }
}

