/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MMailText;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.process.WithholdingSendAbstract;

public class WithholdingSend
extends WithholdingSendAbstract {
    private AtomicInteger sends = new AtomicInteger();

    protected String doIt() throws Exception {
        if (this.getMailTextId() == 0) {
            throw new AdempiereException("@Invalid@ @R_MailTex_ID@");
        }
        if (!this.isSelection()) {
            ArrayList<Object> params = new ArrayList<Object>();
            String whereClause = "DocStatus IN (?,?) ";
            params.add("CO");
            params.add("CL");
            whereClause = whereClause + "AND EXISTS(SELECT 1 FROM WH_Withholding wh INNER JOIN WH_Setting whs ON (wh.WH_Setting_ID = whs.WH_Setting_ID) WHERE wh.C_Invoice_ID = C_Invoice.C_Invoice_ID ";
            if (this.getTypeId() != 0) {
                whereClause = whereClause + "AND whs.WH_Type_ID = ? ";
                params.add(this.getTypeId());
            }
            whereClause = whereClause + ") ";
            if (this.getBPartnerId() != 0) {
                whereClause = whereClause + "AND C_BPartner_ID = ? ";
                params.add(this.getBPartnerId());
            }
            if (!this.getIsSOTrx().equals("")) {
                whereClause = whereClause + "AND IsSOTrx = ? ";
                params.add(this.getIsSOTrx());
            }
            whereClause = whereClause + "AND DateInvoiced >= ? ";
            if (this.getDateDoc() != null) {
                params.add(this.getDateDoc());
            } else {
                params.add(Env.getContextAsDate((Properties)this.getCtx(), (String)"@#Date@"));
            }
            whereClause = whereClause + "AND DateInvoiced <= ? ";
            if (this.getDateDocTo() != null) {
                params.add(this.getDateDocTo());
            } else {
                params.add(Env.getContextAsDate((Properties)this.getCtx(), (String)"@#Date@"));
            }
            new Query(this.getCtx(), "C_Invoice", whereClause, this.get_TrxName()).setParameters(params).list().forEach(invoice -> this.sendInvoiceEmail(invoice.get_ID(), this.getMailTextId()));
        } else {
            this.getSelectionKeys().forEach(invoiceID -> this.sendInvoiceEmail((int)invoiceID, this.getMailTextId()));
        }
        return "@EMail@ @Sent@ " + this.sends.get();
    }

    private void sendInvoiceEmail(int recordId, int mailTextId) {
        MInvoice invoice = new MInvoice(this.getCtx(), recordId, this.get_TrxName());
        AtomicReference<MUser> to = new AtomicReference<MUser>();
        MUser from = MUser.get((Properties)this.getCtx(), (int)this.getAD_User_ID());
        if (invoice.getAD_User_ID() > 0) {
            to.set((MUser)invoice.getAD_User());
        }
        if (to.get() == null) {
            Optional<MUser> maybeUser = Arrays.asList(MUser.getOfBPartner((Properties)this.getCtx(), (int)invoice.getC_BPartner_ID(), (String)this.get_TrxName())).stream().filter(user -> !Util.isEmpty((String)user.getNotificationType()) && (user.getNotificationType().equals("E") || user.getNotificationType().equals("B"))).filter(user -> !Util.isEmpty((String)user.getEMail()) && user.getC_BPartner_Location_ID() == invoice.getC_BPartner_Location_ID()).findFirst();
            if (maybeUser.isPresent()) {
                to.set(maybeUser.get());
            } else {
                maybeUser = Arrays.asList(MUser.getOfBPartner((Properties)this.getCtx(), (int)invoice.getC_BPartner_ID(), (String)this.get_TrxName())).stream().filter(user -> !Util.isEmpty((String)user.getNotificationType()) && (user.getNotificationType().equals("E") || user.getNotificationType().equals("B"))).filter(user -> !Util.isEmpty((String)user.getEMail())).findFirst();
                if (maybeUser.isPresent()) {
                    to.set(maybeUser.get());
                }
            }
        }
        Optional.ofNullable(to.get()).ifPresent(toUser -> {
            ReportEngine re = ReportEngine.get((Properties)this.getCtx(), (int)2, (int)invoice.get_ID());
            File attachment = re.getPDF();
            MClient client = MClient.get((Properties)this.getCtx(), (int)this.getAD_Client_ID());
            MMailText template = new MMailText(this.getCtx(), mailTextId, this.get_TrxName());
            template.setPO((PO)invoice);
            template.setUser(this.getAD_User_ID());
            template.setBPartner(invoice.getC_BPartner_ID());
            if (client.sendEMail(from, (MUser)to.get(), template.getMailHeader(), template.getMailText(true), attachment, template.isHtml())) {
                this.addLog("@EMail@ @Sent@ @to@ " + ((MUser)to.get()).getName());
                this.sends.incrementAndGet();
            }
        });
        if (!Optional.ofNullable(to.get()).isPresent()) {
            this.addLog("@NotFound@ @AD_User_ID@ -> @C_BPartner_ID@ " + invoice.getC_BPartner().getName() + " @DocumentNo@ " + invoice.getDocumentNo());
        }
    }
}

