/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPriceList;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHSetting;
import org.spin.model.MWHWithholding;
import org.spin.process.Withholding;
import org.spin.process.WithholdingGenerateAbstract;

public class WithholdingGenerate
extends WithholdingGenerateAbstract {
    private static final String COLUMN_C_Currency_ID = "WH_C_Currency_ID";
    private static final String COLUMN_C_Currency_ID_To = "CTO_C_Currency_ID_To";
    private static final String COLUMN_Converted_WithholdingAmt = "WH_Converted_WithholdingAmt";
    private ArrayList<Withholding> withholdingDocList = new ArrayList();

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.isSelection()) {
            this.getSelectionValues().entrySet().stream().forEach(list -> {
                MWHWithholding withholding = new MWHWithholding(this.getCtx(), (Integer)list.getKey(), this.get_TrxName());
                BigDecimal manualWithholdingAmt = Env.ZERO;
                this.setCurrencyId(Optional.ofNullable((Integer)((LinkedHashMap)list.getValue()).get(COLUMN_C_Currency_ID)).orElse(Env.ZERO.intValue()));
                this.setCurrencyToId(Optional.ofNullable((Integer)((LinkedHashMap)list.getValue()).get(COLUMN_C_Currency_ID_To)).orElse(Env.ZERO.intValue()));
                if (withholding.isManual()) {
                    manualWithholdingAmt = Optional.ofNullable((BigDecimal)((LinkedHashMap)list.getValue()).get(COLUMN_Converted_WithholdingAmt)).orElse(Env.ZERO);
                }
                this.generateWHDoc(withholding, manualWithholdingAmt);
            });
            this.processWHDoc();
        } else {
            StringBuffer whereClause = new StringBuffer();
            ArrayList<Object> params = new ArrayList<Object>();
            whereClause.append("AD_Client_ID = ? ");
            params.add(this.getAD_Client_ID());
            whereClause.append("AND DocStatus IN (?,?) ");
            params.add("CO");
            params.add("CL");
            if (this.getOrgId() > 0) {
                whereClause.append(" AND AD_Org_ID = ? ");
                params.add(this.getOrgId());
            }
            if (this.getBPartnerId() > 0) {
                whereClause.append(" AND C_BPartner_ID = ? ");
                params.add(this.getBPartnerId());
            }
            if (this.getInvoiceId() > 0) {
                whereClause.append(" AND SourceInvoice_ID = ? ");
                params.add(this.getInvoiceId());
            }
            if (this.getTypeId() > 0) {
                whereClause.append(" AND EXISTS (SELECT 1 FROM WH_Definition whd WHERE whd.WH_Definition_ID = WH_Withholding.WH_Definition_ID AND whd.WH_Type_ID = ?) ");
                params.add(this.getTypeId());
            }
            if (this.getCurrencyId() > 0) {
                whereClause.append(" AND EXISTS (SELECT 1 FROM C_Invoice i WHERE i.C_Invoice_ID = WH_Withholding.SourceInvoice_ID AND i.C_Currency_ID = ?) ");
                params.add(this.getCurrencyId());
            }
            new Query(this.getCtx(), "WH_Withholding", whereClause.toString(), this.get_TrxName()).setParameters(params).list().forEach(withholding -> this.generateWHDoc((MWHWithholding)withholding, Env.ZERO));
            this.processWHDoc();
        }
        return "@OK@";
    }

    private void generateWHDoc(MWHWithholding withholding, BigDecimal manualWithholdingAmt) {
        MInvoice whDoc;
        if (!withholding.isProcessed() || withholding.isSimulation()) {
            return;
        }
        if (this.getCurrencyId() == 0) {
            throw new AdempiereException("@NotFound@ @C_Currency_ID@");
        }
        if (this.getCurrencyToId() == 0) {
            throw new AdempiereException("@NotFound@ @C_Currency_ID_To@");
        }
        if (this.isManual()) {
            if (this.getBPartnerId() == 0) {
                throw new AdempiereException("@NotFound@ @C_BPartner_ID@");
            }
            if (Util.isEmpty((String)this.getDocumentNo())) {
                throw new AdempiereException("@IsEmpty@ @DocumentNo@");
            }
        }
        if (withholding.getC_Invoice_ID() > 0 && (whDoc = MInvoice.get((Properties)this.getCtx(), (int)withholding.getC_Invoice_ID())) != null && (whDoc.getDocStatus().equals("CO") || whDoc.getDocStatus().equals("CL") || whDoc.getDocStatus().equals("IP") || whDoc.getDocStatus().equals("IN"))) {
            this.addLog("@DocumentNo@ : " + whDoc.getDocumentNo() + " | @IsGenerated@ | @DocStatus@ : " + whDoc.getDocStatusName());
            return;
        }
        AtomicReference invoiceTo = new AtomicReference();
        AtomicReference invoiceLineTo = new AtomicReference();
        AtomicReference<Integer> Curr_WH_Definition_ID = new AtomicReference<Integer>();
        AtomicReference<Integer> Curr_WH_Setting_ID = new AtomicReference<Integer>();
        AtomicReference<Integer> Curr_C_BPartner_ID = new AtomicReference<Integer>();
        AtomicReference<Integer> Curr_C_DocType_ID = new AtomicReference<Integer>();
        AtomicReference<Integer> Curr_C_ConversionType_ID = new AtomicReference<Integer>();
        if (withholding.get_ID() > 0) {
            Curr_WH_Definition_ID.set(withholding.getWH_Definition_ID());
            Curr_WH_Setting_ID.set(withholding.getWH_Setting_ID());
            Curr_C_BPartner_ID.set(withholding.getC_BPartner_ID());
            Curr_C_DocType_ID.set(withholding.getWHDocType());
            Curr_C_ConversionType_ID.set(withholding.getC_ConversionType_ID());
            invoiceTo.set(Optional.empty());
            invoiceLineTo.set(Optional.empty());
            MWHDefinition whDefinition = (MWHDefinition)withholding.getWH_Definition();
            MWHSetting whSetting = (MWHSetting)withholding.getWH_Setting();
            MInvoice invoiceFrom = MInvoice.get((Properties)this.getCtx(), (int)withholding.getSourceInvoice_ID());
            Optional<Object> withholldingDoc = Optional.empty();
            withholldingDoc = this.withholdingDocList.stream().filter(wh -> wh.getC_BPartner_ID() == ((Integer)Curr_C_BPartner_ID.get()).intValue() && wh.getWH_Definition_ID() == ((Integer)Curr_WH_Definition_ID.get()).intValue() && wh.getWH_Setting_ID() == ((Integer)Curr_WH_Setting_ID.get()).intValue() && wh.getC_DocType_ID() == ((Integer)Curr_C_DocType_ID.get()).intValue() && wh.getC_ConversionType_ID() == ((Integer)Curr_C_ConversionType_ID.get()).intValue()).findFirst();
            if (!withholldingDoc.isPresent()) {
                withholldingDoc = Optional.ofNullable(new Withholding(withholding.getWH_Definition_ID(), withholding.getWH_Setting_ID(), withholding.getC_BPartner_ID(), withholding.getWHDocType(), withholding.getC_ConversionType_ID(), this));
            }
            withholldingDoc.ifPresent(whDocument -> {
                if (!whDocument.getInvoice().isPresent()) {
                    MInvoice invoice2 = new MInvoice(this.getCtx(), 0, this.get_TrxName());
                    invoiceTo.set(Optional.ofNullable(invoice2));
                    whDocument.setInvoice(invoice2);
                } else {
                    invoiceTo.set(whDocument.getInvoice());
                }
                ((Optional)invoiceTo.get()).ifPresent(invoice -> {
                    AtomicReference<BigDecimal> withholdingAmt = new AtomicReference<BigDecimal>(Env.ZERO);
                    if (invoice.get_ID() == 0) {
                        if (withholding.isManual()) {
                            invoice.setDocumentNo(this.getDocumentNo());
                        }
                        invoice.setAD_Org_ID(withholding.getAD_Org_ID());
                        invoice.setC_BPartner_ID(withholding.getC_BPartner_ID());
                        invoice.setC_BPartner_Location_ID(withholding.getC_BPartner_Location_ID());
                        invoice.setIsSOTrx(withholding.isSOTrx());
                        invoice.setDateInvoiced(this.getDateDoc());
                        invoice.setDateAcct(this.getDateDoc());
                        invoice.setC_ConversionType_ID(withholding.getC_ConversionType_ID());
                        invoice.setM_PriceList_ID(invoiceFrom.getM_PriceList_ID());
                        Optional<MPriceList> maybePriceList = Optional.ofNullable(MPriceList.getDefault((Properties)this.getCtx(), (boolean)invoice.isSOTrx(), (String)MCurrency.get((Properties)this.getCtx(), (int)this.getCurrencyToId()).getISO_Code()));
                        maybePriceList.ifPresent(priceList -> invoice.setM_PriceList_ID(priceList.getM_PriceList_ID()));
                        int C_DocType_ID = (Integer)Curr_C_DocType_ID.get();
                        if (C_DocType_ID <= 0) {
                            throw new AdempiereException("@NotFound@ @WithholdingDebitDocType_ID@");
                        }
                        invoice.setC_DocTypeTarget_ID(C_DocType_ID);
                        invoice.setC_DocType_ID(invoice.getC_DocTypeTarget_ID());
                        invoice.saveEx();
                    }
                    if (withholding.isManual() && Optional.ofNullable(manualWithholdingAmt).orElse(Env.ZERO).compareTo(Env.ZERO) != 0) {
                        withholdingAmt.set(manualWithholdingAmt);
                    } else if (this.getCurrencyId() != this.getCurrencyToId()) {
                        withholdingAmt.set(Optional.ofNullable(MConversionRate.convert((Properties)invoice.getCtx(), (BigDecimal)Optional.ofNullable(withholding.getWithholdingAmt()).orElse(Env.ZERO), (int)this.getCurrencyId(), (int)this.getCurrencyToId(), (Timestamp)withholding.getDateAcct(), (int)withholding.getC_ConversionType_ID(), (int)withholding.getAD_Client_ID(), (int)withholding.getAD_Org_ID())).orElse(Env.ZERO));
                    } else {
                        withholdingAmt.set(withholding.getWithholdingAmt());
                    }
                    invoiceLineTo.set(Optional.ofNullable(new MInvoiceLine(invoice)));
                    ((Optional)invoiceLineTo.get()).ifPresent(invoiceLine -> {
                        if (whSetting.getC_Charge_ID() > 0) {
                            invoiceLine.setC_Charge_ID(whSetting.getC_Charge_ID());
                        } else if (whDefinition.getC_Charge_ID() > 0) {
                            invoiceLine.setC_Charge_ID(whDefinition.getC_Charge_ID());
                        } else {
                            new AdempiereException("@NotFound@ @C_Charge_ID@");
                        }
                        invoiceLine.setQty(Env.ONE);
                        invoiceLine.setPrice(Optional.ofNullable(withholdingAmt.get()).orElse(Env.ZERO));
                        invoiceLine.saveEx();
                        withholding.setC_Invoice_ID(invoiceLine.getC_Invoice_ID());
                        withholding.setC_InvoiceLine_ID(invoiceLine.getC_InvoiceLine_ID());
                        withholding.saveEx();
                    });
                    if (whDocument.getInvoice() == null) {
                        whDocument.setInvoice((MInvoice)invoice);
                    }
                    whDocument.addWithHolding(withholding);
                });
                this.withholdingDocList.add((Withholding)whDocument);
            });
        }
    }

    private void processWHDoc() {
        this.withholdingDocList.stream().forEach(withholding -> withholding.process());
    }
}

