/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MInvoice;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHType;
import org.spin.model.MWHWithholding;
import org.spin.process.Declaration;
import org.spin.process.WithholdingDeclarationAbstract;

public class WithholdingDeclaration
extends WithholdingDeclarationAbstract {
    private ArrayList<Declaration> m_Declarations = new ArrayList();

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        String result;
        if (this.isSelection()) {
            this.getSelectionValues().entrySet().stream().forEach(list -> {
                MInvoice invoice = new MInvoice(this.getCtx(), ((Integer)list.getKey()).intValue(), this.get_TrxName());
                this.addWHDoc(invoice);
            });
            result = this.processWHDoc();
        } else {
            StringBuffer whereClause = new StringBuffer();
            ArrayList<Integer> params = new ArrayList<Integer>();
            whereClause.append("AD_Client_ID = ? ");
            params.add(this.getAD_Client_ID());
            if (this.getParameterAsInt("AD_Org_ID") > 0) {
                whereClause.append(" AND AD_Org_ID = ? ");
                params.add(this.getParameterAsInt("AD_Org_ID"));
            }
            if (this.getParameterAsInt("C_BPartner_ID") > 0) {
                whereClause.append(" AND C_BPartner_ID = ? ");
                params.add(this.getParameterAsInt("C_BPartner_ID"));
            }
            if (this.getParameterAsInt("C_Invoice_ID") > 0) {
                whereClause.append(" AND SourceInvoice_ID = ? ");
                params.add(this.getParameterAsInt("C_Invoice_ID"));
            }
            if (this.getParameterAsInt("WH_Type_ID") > 0) {
                whereClause.append(" AND WH_Type_ID = ? ");
                params.add(this.getParameterAsInt("WH_Type_ID"));
            }
            new Query(this.getCtx(), "C_Invoice", whereClause.toString(), this.get_TrxName()).setParameters(params).list().forEach(invoice -> this.addWHDoc((MInvoice)invoice));
            result = this.processWHDoc();
        }
        return result;
    }

    private void addWHDoc(MInvoice invoiceWH) {
        MWHWithholding withholding = (MWHWithholding)new Query(this.getCtx(), "WH_Withholding", "C_Invoice_ID = ? AND IsSimulation = 'N' AND IsDeclared = 'N'", this.get_TrxName()).setParameters(new Object[]{invoiceWH.getC_Invoice_ID()}).first();
        if (withholding != null && withholding.get_ID() > 0) {
            BigDecimal amt;
            Declaration declaration = this.m_Declarations.stream().filter(dec -> dec.getM_WHType_ID() == withholding.getWH_Setting().getWH_Type_ID()).findFirst().orElse(null);
            BigDecimal bigDecimal = amt = invoiceWH.getGrandTotal(true).compareTo(Env.ZERO) > 0 ? invoiceWH.getTotalLines() : invoiceWH.getTotalLines().negate();
            if (declaration == null) {
                declaration = new Declaration((MWHType)withholding.getWH_Setting().getWH_Type(), (MWHDefinition)withholding.getWH_Definition(), amt, this, invoiceWH.getC_Currency_ID());
                this.m_Declarations.add(declaration);
            } else {
                declaration.addAmt(amt);
            }
            declaration.addInvoice(invoiceWH);
        }
    }

    private String processWHDoc() {
        AtomicReference<String> result = new AtomicReference<String>();
        result.set("");
        this.m_Declarations.forEach(declaration -> {
            declaration.process();
            result.set((String)result.get() + "\n@DocumentNo@  : " + declaration.getDocumentNo());
        });
        return (String)result.get();
    }
}

