/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPriceList;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHType;

class Declaration {
    private MWHType m_WHType = null;
    private MWHDefinition m_WHDefinition = null;
    private BigDecimal m_Amt = Env.ZERO;
    private ArrayList<MInvoice> m_InvoicesWH = new ArrayList();
    private SvrProcess process = null;
    private MInvoice m_Declaration = null;
    private int C_Currency_ID = 0;

    public Declaration(MWHType m_WHType, MWHDefinition m_WHDefinition, BigDecimal m_Amt, SvrProcess process, int C_Currency_ID) {
        this.m_WHType = m_WHType;
        this.m_Amt = m_Amt;
        this.process = process;
        this.m_WHDefinition = m_WHDefinition;
        this.C_Currency_ID = C_Currency_ID;
    }

    public MWHType getM_WHType() {
        return this.m_WHType;
    }

    public int getM_WHType_ID() {
        if (this.m_WHType != null) {
            return this.m_WHType.get_ID();
        }
        return 0;
    }

    public BigDecimal getM_Amt() {
        return this.m_Amt;
    }

    public void addAmt(BigDecimal amt) {
        if (amt != null && this.m_Amt != null) {
            this.m_Amt = this.m_Amt.add(amt);
        }
    }

    public void addInvoice(MInvoice invoice) {
        this.m_InvoicesWH.add(invoice);
    }

    public void process() {
        if (this.m_Amt != null && this.m_InvoicesWH != null && this.m_InvoicesWH.size() > 0) {
            if (this.m_Amt.compareTo(Env.ZERO) < 0) {
                this.GenerateDeclaration(false);
            } else {
                this.GenerateDeclaration(true);
            }
            this.setDeclaration();
        }
    }

    private void GenerateDeclaration(boolean isCredit) {
        this.m_Declaration = new MInvoice(this.process.getCtx(), 0, this.process.get_TrxName());
        this.m_Declaration.setC_BPartner_ID(this.m_WHDefinition.getC_BPartner_ID());
        if (isCredit) {
            this.m_Declaration.setC_DocTypeTarget_ID(this.m_WHType.getDeclarationCreditDocType_ID());
        } else {
            this.m_Declaration.setC_DocTypeTarget_ID(this.m_WHType.getDeclarationDebitDocType_ID());
        }
        if (this.m_Declaration.getC_DocTypeTarget_ID() == 0) {
            throw new AdempiereException("@Invalid@ @" + (isCredit ? "DeclarationCreditDocType_ID" : "DeclarationDebitDocType_ID") + "@");
        }
        this.m_Declaration.setDateInvoiced(this.process.getParameterAsTimestamp("DateDoc"));
        this.m_Declaration.setDateAcct(this.process.getParameterAsTimestamp("DateDoc"));
        this.m_Declaration.setIsSOTrx(this.m_Declaration.getC_DocTypeTarget().isSOTrx());
        Optional.ofNullable(MPriceList.getDefault((Properties)this.process.getCtx(), (boolean)this.m_Declaration.isSOTrx(), (String)MCurrency.get((Properties)this.process.getCtx(), (int)this.C_Currency_ID).getISO_Code())).ifPresent(priceList -> this.m_Declaration.setM_PriceList_ID(priceList.getM_PriceList_ID()));
        this.m_Declaration.saveEx();
        MInvoiceLine declarationLine = new MInvoiceLine(this.m_Declaration);
        declarationLine.setC_Charge_ID(this.m_WHDefinition.getC_Charge_ID());
        declarationLine.setQty(Env.ONE);
        declarationLine.setPrice(this.m_Amt.abs());
        declarationLine.saveEx();
        this.m_Declaration.processIt("CO");
        this.m_Declaration.saveEx();
    }

    private void setDeclaration() {
        for (MInvoice mInvoice : this.m_InvoicesWH) {
            new Query(this.process.getCtx(), "WH_Withholding", "C_Invoice_ID = ? ", this.process.get_TrxName()).setParameters(new Object[]{mInvoice.getC_Invoice_ID()}).list().forEach(wh -> {
                wh.set_ValueOfColumn("WithholdingDeclaration_ID", (Object)this.m_Declaration.getC_Invoice_ID());
                wh.saveEx();
            });
        }
    }

    public String toString() {
        return "WHType = " + (this.m_WHType == null ? "" : this.m_WHType.toString()) + "\n Amount = " + this.m_Amt.toString() + "\n Invoice = " + this.m_InvoicesWH.toString();
    }

    public String getDocumentNo() {
        if (this.m_Declaration != null) {
            return this.m_Declaration.getDocumentNo();
        }
        return "";
    }
}

