/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MWHWithholding;
import org.spin.model.X_WH_Setting;
import org.spin.util.WithholdingEngine;

public class Withholding
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(Withholding.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        List settings = new Query(Env.getCtx(), "WH_Setting", "EventType = 'E' AND AD_Client_ID =? AND EXISTS(SELECT 1 FROM WH_Type wt WHERE wt.WH_Type_ID = WH_Setting.WH_Type_ID AND wt.IsActive = 'Y')", null).setOnlyActiveRecords(true).setParameters(new Object[]{this.clientId}).setOrderBy("SeqNo").list();
        settings.stream().filter(setting -> setting.getEventModelValidator().startsWith("T")).collect(Collectors.groupingBy(X_WH_Setting::getAD_Table_ID)).entrySet().forEach(tableSet -> {
            String tableName = MTable.getTableName((Properties)Env.getCtx(), (int)((Integer)tableSet.getKey()));
            engine.addModelChange(tableName, (ModelValidator)this);
        });
        settings.stream().filter(setting -> setting.getEventModelValidator().startsWith("D")).collect(Collectors.groupingBy(X_WH_Setting::getAD_Table_ID)).entrySet().forEach(tableSet -> {
            String tableName = MTable.getTableName((Properties)Env.getCtx(), (int)((Integer)tableSet.getKey()));
            engine.addDocValidate(tableName, (ModelValidator)this);
        });
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String docValidate(PO entity, int timing) {
        String error = WithholdingEngine.get().fireDocValidate(entity, timing);
        if (!Util.isEmpty((String)error)) {
            throw new AdempiereException(error);
        }
        if (entity.get_TableName().equals("C_Invoice")) {
            MInvoice invoice = (MInvoice)entity;
            if (timing == 5 || timing == 6 || timing == 2) {
                List withholdingList;
                StringBuffer errorMessage;
                if (!invoice.isReversal()) {
                    errorMessage = new StringBuffer();
                    withholdingList = MWHWithholding.getWithholdingFromInvoice(invoice.getCtx(), invoice.getC_Invoice_ID(), invoice.get_TrxName());
                    withholdingList.stream().filter(withholding -> withholding.getDocStatus().equals("CO") && withholding.getC_Invoice_ID() != 0).forEach(withholding -> {
                        if (errorMessage.length() > 0) {
                            errorMessage.append(Env.NL);
                        }
                        errorMessage.append("@WH_Withholding_ID@ ").append(withholding.getDocumentNo()).append(" @C_Invoice_ID@ ").append(withholding.getC_Invoice().getDocumentNo());
                    });
                    if (errorMessage.length() > 0) {
                        throw new AdempiereException("@WithholdingReferenceError@: " + errorMessage);
                    }
                    withholdingList.stream().filter(withholding -> withholding.getDocStatus().equals("CO")).forEach(withholding -> {
                        if (!withholding.processIt("VO")) {
                            throw new AdempiereException(withholding.getProcessMsg());
                        }
                        withholding.saveEx();
                    });
                }
                errorMessage = new StringBuffer();
                withholdingList = new Query(Env.getCtx(), "WH_Withholding", "C_Invoice_ID = ? AND WithholdingDeclaration_ID > 0", null).setOnlyActiveRecords(true).setParameters(new Object[]{invoice.getC_Invoice_ID()}).list();
                withholdingList.stream().forEach(withholding -> {
                    MInvoice withholdingDeclaration = MInvoice.get((Properties)Env.getCtx(), (int)withholding.getWithholdingDeclaration_ID());
                    if (errorMessage.length() > 0) {
                        errorMessage.append(Env.NL);
                    }
                    if (withholdingDeclaration.getDocStatus().equals("CO") || withholdingDeclaration.getDocStatus().equals("CL") || withholdingDeclaration.getDocStatus().equals("DR")) {
                        errorMessage.append("@WH_Withholding_ID@ ").append(withholding.getDocumentNo()).append(" @C_Invoice_ID@ ").append(withholdingDeclaration.getDocumentNo());
                    }
                });
                if (errorMessage.length() > 0) {
                    throw new AdempiereException("@WithholdingReferenceError@: " + errorMessage);
                }
            }
        }
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        String error;
        int documentTypeId = entity.get_ValueAsInt("C_DocTypeTarget_ID");
        if (documentTypeId <= 0) {
            documentTypeId = entity.get_ValueAsInt("C_DocType_ID");
        }
        if (!Util.isEmpty((String)(error = WithholdingEngine.get().fireModelChange(entity, type, documentTypeId)))) {
            throw new AdempiereException(error);
        }
        return null;
    }
}

