/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.X_WH_Setting;
import org.spin.util.AbstractWithholdingSetting;
import org.spin.util.GenericWithholdingSetting;

public class MWHSetting
extends X_WH_Setting {
    private static final long serialVersionUID = -7050562622116465459L;
    private static CCache<Integer, MWHSetting> settingCacheIds = new CCache("WH_Setting", 30);
    private static CCache<String, MWHSetting> settingCacheValues = new CCache("WH_Setting", 30);
    private AbstractWithholdingSetting functionalSetting = null;

    public MWHSetting(Properties ctx, int WH_Setting_ID, String trxName) {
        super(ctx, WH_Setting_ID, trxName);
    }

    public MWHSetting(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MWHSetting getById(Properties ctx, int settingId, String trxName) {
        if (settingId <= 0) {
            return null;
        }
        MWHSetting setting = (MWHSetting)settingCacheIds.get((Object)settingId);
        if (setting != null && setting.get_ID() > 0) {
            return setting;
        }
        setting = (MWHSetting)new Query(ctx, "WH_Setting", "WH_Setting_ID=?", trxName).setClient_ID().setParameters(new Object[]{settingId}).first();
        if (setting != null && setting.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + setting.getValue();
            settingCacheValues.put((Object)key, (Object)setting);
            settingCacheIds.put((Object)setting.get_ID(), (Object)setting);
        }
        return setting;
    }

    public static MWHSetting getByValue(Properties ctx, String settingValue, String trxName) {
        int clientId;
        String key;
        MWHSetting setting;
        if (settingValue == null) {
            return null;
        }
        if (settingCacheValues.size() == 0) {
            MWHSetting.getAll(ctx, true, trxName);
        }
        if ((setting = (MWHSetting)settingCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + settingValue))) != null && setting.get_ID() > 0) {
            return setting;
        }
        setting = (MWHSetting)new Query(ctx, "WH_Setting", "Value=?", trxName).setClient_ID().setParameters(new Object[]{settingValue}).first();
        if (setting != null && setting.get_ID() > 0) {
            settingCacheValues.put((Object)key, (Object)setting);
            settingCacheIds.put((Object)setting.get_ID(), (Object)setting);
        }
        return setting;
    }

    public static List<MWHSetting> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || settingCacheIds.size() > 0) {
            List settingList = new Query(Env.getCtx(), "WH_Setting", null, trxName).setClient_ID().setOrderBy("Name").list();
            settingList.stream().forEach(setting -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + setting.getValue();
                settingCacheIds.put((Object)setting.getWH_Setting_ID(), setting);
                settingCacheValues.put((Object)key, setting);
            });
            return settingList;
        }
        List<MWHSetting> settingList = settingCacheIds.entrySet().stream().map(setting -> (MWHSetting)setting.getValue()).collect(Collectors.toList());
        return settingList;
    }

    private Class<?> getHandlerClass() {
        String className = this.getWithholdingClassName();
        if (Util.isEmpty((String)className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != AbstractWithholdingSetting.class) continue;
                this.log.fine("Use: " + className);
                return clazz;
            }
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
        }
        this.log.finest("Not found: " + className);
        return null;
    }

    private void loadClass() throws Exception {
        if (this.functionalSetting != null) {
            return;
        }
        Class<?> clazz = this.getHandlerClass();
        if (clazz == null) {
            this.log.log(Level.INFO, "Using Standard Functional Setting");
            this.functionalSetting = new GenericWithholdingSetting(this);
            return;
        }
        Constructor<?> constructor = clazz.getDeclaredConstructor(MWHSetting.class);
        this.functionalSetting = (AbstractWithholdingSetting)constructor.newInstance(this);
    }

    public AbstractWithholdingSetting getSettingInstance() throws Exception {
        this.loadClass();
        return this.functionalSetting;
    }

    @Override
    public String toString() {
        return "MWHSetting [getAD_Table_ID()=" + this.getAD_Table_ID() + ", getEventModelValidator()=" + this.getEventModelValidator() + ", getEventType()=" + this.getEventType() + ", getName()=" + this.getName() + ", getSeqNo()=" + this.getSeqNo() + ", getValue()=" + this.getValue() + ", getWH_Setting_ID()=" + this.getWH_Setting_ID() + "]";
    }
}

