/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.events.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.events.v1.EventList;
import io.fabric8.kubernetes.api.model.events.v1.EventListFluent;
import io.fabric8.kubernetes.api.model.events.v1.EventListFluentImpl;
import java.util.Objects;

public class EventListBuilder
extends EventListFluentImpl<EventListBuilder>
implements VisitableBuilder<EventList, EventListBuilder> {
    EventListFluent<?> fluent;
    Boolean validationEnabled;

    public EventListBuilder() {
        this(false);
    }

    public EventListBuilder(Boolean validationEnabled) {
        this(new EventList(), validationEnabled);
    }

    public EventListBuilder(EventListFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public EventListBuilder(EventListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EventList(), validationEnabled);
    }

    public EventListBuilder(EventListFluent<?> fluent, EventList instance) {
        this(fluent, instance, false);
    }

    public EventListBuilder(EventListFluent<?> fluent, EventList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public EventListBuilder(EventList instance) {
        this(instance, (Boolean)false);
    }

    public EventListBuilder(EventList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public EventList build() {
        EventList buildable = new EventList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventListBuilder that = (EventListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

