/*
 * Decompiled with CFR 0.152.
 */
package org.spin.amtinwords.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRScriptletException;
import org.spin.amtinwords.util.AmtInWords;

public class JasperAmountInWords
extends JRDefaultScriptlet {
    private static final String RESOURCE = "org.spin.amtinwords.util.AmtInWords";
    private static final DecimalFormat FORMAT = new DecimalFormat("#######################################.00");

    public String getAmountInWords(BigDecimal amount, String language) {
        if (language == null) {
            language = "en";
        }
        if (amount == null) {
            amount = new BigDecimal(0.0);
        }
        try {
            AmtInWords handler = (AmtInWords)Class.forName("org.spin.amtinwords.util.AmtInWords_" + language.toUpperCase()).newInstance();
            return handler.getAmtInWords(FORMAT.format(amount));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getAmountInWords(String amount, String language) {
        if (language == null) {
            language = "en";
        }
        if (amount == null) {
            return null;
        }
        try {
            AmtInWords handler = (AmtInWords)Class.forName("org.spin.amtinwords.util.AmtInWords_" + language.toUpperCase()).newInstance();
            return handler.getAmtInWords(amount);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getAmountInWords(int amount, String language) {
        if (language == null) {
            language = "en";
        }
        try {
            AmtInWords handler = (AmtInWords)Class.forName("org.spin.amtinwords.util.AmtInWords_" + language.toUpperCase()).newInstance();
            return handler.getAmtInWords(String.valueOf(amount));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getAmountInWordsFromVariable(String valiableName, String language) {
        if (language == null) {
            language = "en";
        }
        if (valiableName == null) {
            System.err.println("Variable Name is null");
            return "Variable Name is null";
        }
        Object variable = null;
        try {
            variable = this.getVariableValue(valiableName);
        }
        catch (JRScriptletException e) {
            e.printStackTrace();
        }
        if (variable == null) {
            System.err.println("Variable not found");
            return "Variable not found";
        }
        if (variable.getClass().isAssignableFrom(BigDecimal.class)) {
            BigDecimal amount = (BigDecimal)variable;
            return this.getAmountInWords(amount, language);
        }
        System.err.println("Variable is not a BigDecimal: " + variable.getClass().getName());
        return "Variable is not a BigDecimal";
    }

    public String getAmountInWordsFromField(String fieldName, String language) {
        if (language == null) {
            language = "en";
        }
        if (fieldName == null) {
            System.err.println("Field Name is null");
            return null;
        }
        Object variable = null;
        try {
            variable = this.getFieldValue(fieldName);
        }
        catch (JRScriptletException e) {
            e.printStackTrace();
        }
        if (variable == null) {
            System.err.println("Field not found");
            return null;
        }
        if (variable.getClass().isAssignableFrom(BigDecimal.class)) {
            BigDecimal amount = (BigDecimal)variable;
            return this.getAmountInWords(amount, language);
        }
        System.err.println("Field is not a BigDecimal: " + variable.getClass().getName());
        return null;
    }
}

