/*
 * Decompiled with CFR 0.152.
 */
package org.spin.amtinwords.util;

import org.spin.amtinwords.util.AmtInWords;

public class AmtInWords_PL
implements AmtInWords {
    private static final String[][] majorNames = new String[][]{{"", "", ""}, {"tysi\u0105c", "tysi\u0105ce", "tysi\u0119cy"}, {"milion", "miliony", "milion\u00f3w"}, {"miliard", "miliardy", "miliard\u00f3w"}, {"bilion", "biliony", "bilion\u00f3w"}, {"trylion", "tryliony", "trylion\u00f3w"}, {"quadrylion", "quadryliony", "quadrylion\u00f3w"}};
    private static final String[] tensNames = new String[]{"", "dziesi\u0119\u0107", "dwadzie\u015bcia", "trzydzie\u015bci", "czterdzie\u015bci", "pi\u0119\u0107dziesi\u0105t", "sze\u015b\u0107dziesi\u0105t", "siedemdziesi\u0105t", "osiemdziesi\u0105t", "dziewi\u0119\u0107dziesi\u0105t"};
    private static final String[] hundredNames = new String[]{"", "sto", "dwie\u015bcie", "trzysta", "czterysta", "pi\u0119\u0107set", "sze\u015b\u0107set", "siedemset", "osiemset", "dziewi\u0119\u0107set"};
    private static final String[] numNames = new String[]{"", "jeden", "dwa", "trzy", "cztery", "pi\u0119\u0107", "sze\u015b\u0107", "siedem", "osiem", "dzieiwi\u0119\u0107", "dziesi\u0119\u0107", "jedena\u015bcie", "dwana\u015bcie", "trzyna\u015bcie", "czterna\u015bcie", "pietna\u015bcie", "szescna\u015bcie", "siedemna\u015bcie", "osiemna\u015bcie", "dziewi\u0119tna\u015bcie"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + " " + soFar;
            number /= 10;
        }
        soFar = hundredNames[number % 10] + " " + soFar;
        number /= 10;
        return soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "zero";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "minus ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                int pos = number % 10L == 1L ? 0 : (number % 10L < 5L ? 1 : 2);
                if (number > 9L && number < 20L) {
                    pos = 2;
                }
                soFar = s + " " + majorNames[place][pos] + " " + soFar;
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        long dollars = Long.parseLong(amount.substring(0, newpos));
        sb.append(this.convert(dollars));
        for (int i = 0; i < oldamt.length(); ++i) {
            if (pos != i) continue;
            String cents = oldamt.substring(i + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_PL aiw = new AmtInWords_PL();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12.345");
        aiw.print("123.45");
        aiw.print("1234.56");
        aiw.print("12345.78");
        aiw.print("10345.78");
        aiw.print("123457.89");
        aiw.print("323457.89");
        aiw.print("23457.89");
        aiw.print("1,234,578.90");
    }
}

