/*
 * Decompiled with CFR 0.152.
 */
package org.spin.amtinwords.util;

import org.spin.amtinwords.util.AmtInWords;

public class AmtInWords_EN
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", "Thousand-", "Million-", "Billion-", "Trillion-", "Quadrillion-", "Quintillion-"};
    private static final String[] tensNames = new String[]{"", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"};
    private static final String[] numNames = new String[]{"", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return numNames[number] + "Hundred-" + soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "Zero";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "Negative ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                soFar = s + majorNames[place] + soFar;
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        int newpos = (amount = amount.replaceAll(",", "")).lastIndexOf(46);
        if (newpos <= 0) {
            newpos = amount.length();
        }
        long dollars = Long.parseLong(amount.substring(0, newpos));
        sb.append(this.convert(dollars));
        for (int i = 0; i < oldamt.length(); ++i) {
            if (pos != i) continue;
            String cents = oldamt.substring(i + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_EN aiw = new AmtInWords_EN();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12.345");
        aiw.print("123.45");
        aiw.print("1234.56");
        aiw.print("12345.78");
        aiw.print("123457.89");
        aiw.print("1,234,578.90");
    }
}

