/*
 * Decompiled with CFR 0.152.
 */
package org.spin.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.spin.base.setup.SetupLoader;
import org.spin.base.util.Services;
import org.spin.grpc.service.AccessServiceImplementation;
import org.spin.grpc.service.BusinessDataServiceImplementation;
import org.spin.grpc.service.CoreFunctionalityImplementation;
import org.spin.grpc.service.DashboardingServiceImplementation;
import org.spin.grpc.service.DictionaryServiceImplementation;
import org.spin.grpc.service.EnrollmentServiceImplementation;
import org.spin.grpc.service.LogsServiceImplementation;
import org.spin.grpc.service.PointOfSalesServiceImplementation;
import org.spin.grpc.service.UpdateImplementation;
import org.spin.grpc.service.UserInterfaceServiceImplementation;
import org.spin.grpc.service.WebStoreServiceImplementation;
import org.spin.grpc.service.WorkflowServiceImplementation;

public class AllInOneServices {
    private static final Logger logger = Logger.getLogger(AllInOneServices.class.getName());
    private Server server;

    private SslContextBuilder getSslContextBuilder() {
        SslContextBuilder sslClientContextBuilder = SslContextBuilder.forServer((File)new File(SetupLoader.getInstance().getServer().getCertificate_chain_file()), (File)new File(SetupLoader.getInstance().getServer().getPrivate_key_file()));
        if (SetupLoader.getInstance().getServer().getTrust_certificate_collection_file() != null) {
            sslClientContextBuilder.trustManager(new File(SetupLoader.getInstance().getServer().getTrust_certificate_collection_file()));
            sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
        }
        return GrpcSslContexts.configure((SslContextBuilder)sslClientContextBuilder);
    }

    private void start() throws IOException {
        NettyServerBuilder serverBuilder = NettyServerBuilder.forPort((int)SetupLoader.getInstance().getServer().getPort());
        if (SetupLoader.getInstance().getServer().isValidService(Services.ACCESS.getServiceName())) {
            serverBuilder.addService((BindableService)new AccessServiceImplementation());
            logger.info("Service " + Services.ACCESS.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.ENROLLMENT.getServiceName())) {
            serverBuilder.addService((BindableService)new EnrollmentServiceImplementation());
            logger.info("Service " + Services.ENROLLMENT.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.DICTIONARY.getServiceName())) {
            serverBuilder.addService((BindableService)new DictionaryServiceImplementation());
            logger.info("Service " + Services.DICTIONARY.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.BUSINESS.getServiceName())) {
            serverBuilder.addService((BindableService)new BusinessDataServiceImplementation());
            logger.info("Service " + Services.BUSINESS.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.CORE.getServiceName())) {
            serverBuilder.addService((BindableService)new CoreFunctionalityImplementation());
            logger.info("Service " + Services.CORE.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.UI.getServiceName())) {
            serverBuilder.addService((BindableService)new UserInterfaceServiceImplementation());
            logger.info("Service " + Services.UI.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.DASHBOARDING.getServiceName())) {
            serverBuilder.addService((BindableService)new DashboardingServiceImplementation());
            logger.info("Service " + Services.DASHBOARDING.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.WORKFLOW.getServiceName())) {
            serverBuilder.addService((BindableService)new WorkflowServiceImplementation());
            logger.info("Service " + Services.WORKFLOW.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.LOG.getServiceName())) {
            serverBuilder.addService((BindableService)new LogsServiceImplementation());
            logger.info("Service " + Services.LOG.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.STORE.getServiceName())) {
            serverBuilder.addService((BindableService)new WebStoreServiceImplementation());
            logger.info("Service " + Services.STORE.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.POS.getServiceName())) {
            serverBuilder.addService((BindableService)new PointOfSalesServiceImplementation());
            logger.info("Service " + Services.POS.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        if (SetupLoader.getInstance().getServer().isValidService(Services.UPDATER.getServiceName())) {
            serverBuilder.addService((BindableService)new UpdateImplementation());
            logger.info("Service " + Services.UPDATER.getServiceName() + " added on " + SetupLoader.getInstance().getServer().getPort());
        }
        this.server = SetupLoader.getInstance().getServer().isTlsEnabled() ? serverBuilder.sslContext(this.getSslContextBuilder().build()).build().start() : serverBuilder.build().start();
        logger.info("Server started, listening on " + SetupLoader.getInstance().getServer().getPort());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("*** shutting down gRPC server since JVM is shutting down");
                AllInOneServices.this.stop();
                logger.info("*** server shut down");
            }
        });
    }

    private void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args == null) {
            throw new Exception("Arguments Not Found");
        }
        if (args == null || args.length == 0) {
            throw new Exception("Arguments Must Be: [property file name]");
        }
        String setupFileName = args[0];
        if (setupFileName == null || setupFileName.trim().length() == 0) {
            throw new Exception("Setup File not found");
        }
        SetupLoader.loadSetup(setupFileName);
        SetupLoader.getInstance().validateLoad();
        AllInOneServices server = new AllInOneServices();
        server.start();
        server.blockUntilShutdown();
    }
}

