/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWorkflow;
import org.spin.base.util.ContextManager;
import org.spin.base.util.ConvertUtil;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ValueUtil;
import org.spin.base.util.WorkflowUtil;
import org.spin.grpc.util.DocumentStatus;
import org.spin.grpc.util.ListDocumentActionsRequest;
import org.spin.grpc.util.ListDocumentActionsResponse;
import org.spin.grpc.util.ListDocumentStatusesRequest;
import org.spin.grpc.util.ListDocumentStatusesResponse;
import org.spin.grpc.util.ListWorkflowActivitiesRequest;
import org.spin.grpc.util.ListWorkflowActivitiesResponse;
import org.spin.grpc.util.ListWorkflowsRequest;
import org.spin.grpc.util.ListWorkflowsResponse;
import org.spin.grpc.util.WorkflowActivity;
import org.spin.grpc.util.WorkflowDefinition;
import org.spin.grpc.util.WorkflowGrpc;

public class WorkflowServiceImplementation
extends WorkflowGrpc.WorkflowImplBase {
    private CLogger log = CLogger.getCLogger(WorkflowServiceImplementation.class);

    @Override
    public void listWorkflows(ListWorkflowsRequest request, StreamObserver<ListWorkflowsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Workflow Logs Requested is Null");
            }
            this.log.fine("Object List Requested = " + request);
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListWorkflowsResponse.Builder entityValueList = this.convertWorkflows(context, request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listDocumentActions(ListDocumentActionsRequest request, StreamObserver<ListDocumentActionsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Document Actions is Null");
            }
            this.log.fine("Object List Requested = " + request);
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListDocumentActionsResponse.Builder entityValueList = this.convertDocumentActions(context, request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listDocumentStatuses(ListDocumentStatusesRequest request, StreamObserver<ListDocumentStatusesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Document Statuses is Null");
            }
            this.log.fine("Object List Requested = " + request);
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListDocumentStatusesResponse.Builder entityValueList = this.convertDocumentStatuses(context, request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listWorkflowActivities(ListWorkflowActivitiesRequest request, StreamObserver<ListWorkflowActivitiesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Request is Null");
            }
            this.log.fine("Object List Requested = " + request);
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListWorkflowActivitiesResponse.Builder activitiesList = this.convertWorkflowActivities(context, request);
            responseObserver.onNext((Object)activitiesList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private ListWorkflowActivitiesResponse.Builder convertWorkflowActivities(Properties context, ListWorkflowActivitiesRequest request) {
        if (Util.isEmpty((String)request.getUserUuid())) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        int userId = RecordUtil.getIdFromUuid("AD_User", request.getUserUuid(), null);
        String whereClause = "AD_WF_Activity.Processed='N' AND AD_WF_Activity.WFState='OS' AND ( AD_WF_Activity.AD_User_ID=? \t\t\t\tOR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE AD_WF_Activity.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND COALESCE(r.AD_User_ID,0)=0 AND COALESCE(r.AD_Role_ID,0)=0 AND (AD_WF_Activity.AD_User_ID=? \t\t\t\tOR AD_WF_Activity.AD_User_ID IS NULL)) \t\t\t\tOR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE AD_WF_Activity.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.AD_User_ID=?) \t\t\t\tOR EXISTS (SELECT * FROM AD_WF_Responsible r INNER JOIN AD_User_Roles ur ON (r.AD_Role_ID=ur.AD_Role_ID) WHERE AD_WF_Activity.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND ur.AD_User_ID=?))";
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        Query query = new Query(context, "AD_WF_Activity", whereClause, null).setParameters(new Object[]{userId, userId, userId, userId});
        int count = query.count();
        List workflowActivitiesList = query.setLimit(limit, offset).setOrderBy("Priority DESC, Created").list();
        ListWorkflowActivitiesResponse.Builder builder = ListWorkflowActivitiesResponse.newBuilder();
        for (MWFActivity workflowActivity : workflowActivitiesList) {
            WorkflowActivity.Builder valueObject = WorkflowUtil.convertWorkflowActivity(workflowActivity);
            builder.addActivities(valueObject.build());
        }
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListDocumentStatusesResponse.Builder convertDocumentStatuses(Properties context, ListDocumentStatusesRequest request) {
        ArrayList<String> statusesList = new ArrayList<String>();
        String documentStatus = null;
        String documentAction = null;
        String orderType = "--";
        String isSOTrx = "Y";
        String isProcessing = "N";
        int documentTypeId = 0;
        statusesList.add("DR");
        MTable table = MTable.get((Properties)context, (String)request.getTableName());
        int recordId = 0;
        PO entity = RecordUtil.getEntity(context, request.getTableName(), request.getUuid(), request.getId(), null);
        if (entity != null) {
            MDocType documentType;
            documentStatus = entity.get_ValueAsString("DocStatus");
            documentAction = entity.get_ValueAsString("DocAction");
            isProcessing = entity.get_ValueAsBoolean("Processing") ? "Y" : "N";
            documentTypeId = entity.get_ValueAsInt("C_DocTypeTarget_ID");
            if (documentTypeId == 0) {
                documentTypeId = entity.get_ValueAsInt("C_DocType_ID");
            }
            if (documentTypeId != 0 && (documentType = MDocType.get((Properties)context, (int)documentTypeId)) != null && !Util.isEmpty((String)documentType.getDocBaseType())) {
                orderType = documentType.getDocBaseType();
            }
            isSOTrx = entity.get_ValueAsBoolean("IsSOTrx") ? "Y" : "N";
            recordId = entity.get_ID();
        }
        if (documentStatus == null) {
            documentStatus = "DR";
        }
        if (documentAction == null) {
            documentAction = "PR";
        }
        if (documentStatus.equals("CO") || documentStatus.equals("VO") || documentStatus.equals("RE") || documentStatus.equals("??") || documentStatus.equals("CL")) {
            statusesList.add("IP");
            statusesList.add("AP");
            if (orderType.equals("PR")) {
                statusesList.add("WP");
                statusesList.add("WC");
            }
        }
        statusesList.add(documentStatus);
        ArrayList<String> valueList = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> descriptionList = new ArrayList<String>();
        this.readDocumentStatusList(valueList, nameList, descriptionList);
        ListDocumentStatusesResponse.Builder builder = ListDocumentStatusesResponse.newBuilder();
        statusesList.stream().filter(status -> status != null).forEach(status -> {
            for (int i = 0; i < valueList.size(); ++i) {
                if (!status.equals(valueList.get(i))) continue;
                DocumentStatus.Builder documentStatusBuilder = DocumentStatus.newBuilder();
                documentStatusBuilder.setValue(ValueUtil.validateNull((String)valueList.get(i)));
                documentStatusBuilder.setName(ValueUtil.validateNull((String)nameList.get(i)));
                documentStatusBuilder.setDescription(ValueUtil.validateNull((String)descriptionList.get(i)));
                builder.addDocumentStatuses(documentStatusBuilder);
            }
        });
        this.log.fine("DocStatus=" + documentStatus + ", DocAction=" + documentAction + ", OrderType=" + orderType + ", IsSOTrx=" + isSOTrx + ", Processing=" + isProcessing + ", AD_Table_ID=" + table.getAD_Table_ID() + ", Record_ID=" + recordId);
        String[] options = new String[valueList.size()];
        int index = 0;
        String[] docActionHolder = new String[]{documentAction};
        index = DocumentEngine.getValidActions((String)documentStatus, (Object)isProcessing, (String)orderType, (String)isSOTrx, (int)table.getAD_Table_ID(), (String[])docActionHolder, (String[])options);
        if (entity != null && entity instanceof DocOptions) {
            index = ((DocOptions)entity).customizeValidActions(documentStatus, (Object)isProcessing, orderType, isSOTrx, entity.get_Table_ID(), docActionHolder, options, index);
        }
        this.log.fine("get doctype: " + documentTypeId);
        if (documentTypeId != 0) {
            index = DocumentEngine.checkActionAccess((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Role_ID((Properties)Env.getCtx()), (int)documentTypeId, (String[])options, (int)index);
        }
        documentAction = docActionHolder[0];
        Arrays.asList(options).stream().filter(option -> option != null).forEach(option -> {
            for (int i = 0; i < valueList.size(); ++i) {
                if (!option.equals(valueList.get(i))) continue;
                DocumentStatus.Builder documentActionBuilder = DocumentStatus.newBuilder();
                documentActionBuilder.setValue(ValueUtil.validateNull((String)valueList.get(i)));
                documentActionBuilder.setName(ValueUtil.validateNull((String)nameList.get(i)));
                documentActionBuilder.setDescription(ValueUtil.validateNull((String)descriptionList.get(i)));
                builder.addDocumentStatuses(documentActionBuilder);
            }
        });
        builder.setRecordCount(builder.getDocumentStatusesCount());
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDocumentStatusList(ArrayList<String> v_value, ArrayList<String> v_name, ArrayList<String> v_description) {
        if (v_value == null) {
            throw new IllegalArgumentException("v_value parameter is null");
        }
        if (v_name == null) {
            throw new IllegalArgumentException("v_name parameter is null");
        }
        if (v_description == null) {
            throw new IllegalArgumentException("v_description parameter is null");
        }
        String sql = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Ref_List") ? "SELECT Value, Name, Description FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Name" : "SELECT l.Value, t.Name, t.Description FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "' AND l.AD_Reference_ID=? ORDER BY t.Name";
        CPreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = DB.prepareStatement((String)sql, null);
            preparedStatement.setInt(1, 131);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String value = resultSet.getString(1);
                String name = resultSet.getString(2);
                String description = resultSet.getString(3);
                if (description == null) {
                    description = "";
                }
                v_value.add(value);
                v_name.add(name);
                v_description.add(description);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, (Statement)preparedStatement);
                resultSet = null;
                preparedStatement = null;
                throw throwable;
            }
            DB.close((ResultSet)resultSet, (Statement)preparedStatement);
            resultSet = null;
            preparedStatement = null;
        }
        DB.close((ResultSet)resultSet, (Statement)preparedStatement);
        resultSet = null;
        preparedStatement = null;
    }

    private ListWorkflowsResponse.Builder convertWorkflows(Properties context, ListWorkflowsRequest request) {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        if (Util.isEmpty((String)request.getTableName())) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        MTable table = MTable.get((Properties)context, (String)request.getTableName());
        if (table == null || table.getAD_Table_ID() == 0) {
            throw new AdempiereException("@AD_Table_ID@ @Invalid@");
        }
        whereClause.append("AD_Table_ID").append(" = ?");
        parameters.add(table.getAD_Table_ID());
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        Query query = new Query(context, "AD_Workflow", whereClause.toString(), null).setParameters(parameters);
        int count = query.count();
        List workflowList = query.setLimit(limit, offset).list();
        ListWorkflowsResponse.Builder builder = ListWorkflowsResponse.newBuilder();
        for (MWorkflow workflowDefinition : workflowList) {
            WorkflowDefinition.Builder valueObject = WorkflowUtil.convertWorkflowDefinition(workflowDefinition);
            builder.addWorkflows(valueObject.build());
        }
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListDocumentActionsResponse.Builder convertDocumentActions(Properties context, ListDocumentActionsRequest request) {
        String isSOTrx;
        MDocType documentType;
        PO entity = RecordUtil.getEntity(context, request.getTableName(), request.getUuid(), request.getId(), null);
        String documentStatus = entity.get_ValueAsString("DocStatus");
        String documentAction = entity.get_ValueAsString("DocAction");
        String isProcessing = entity.get_ValueAsBoolean("Processing") ? "Y" : "N";
        String orderType = "--";
        int documentTypeId = entity.get_ValueAsInt("C_DocTypeTarget_ID");
        if (documentTypeId == 0) {
            documentTypeId = entity.get_ValueAsInt("C_DocType_ID");
        }
        if (documentTypeId != 0 && (documentType = MDocType.get((Properties)context, (int)documentTypeId)) != null && !Util.isEmpty((String)documentType.getDocBaseType())) {
            orderType = documentType.getDocBaseType();
        }
        String string = isSOTrx = entity.get_ValueAsBoolean("IsSOTrx") ? "Y" : "N";
        if (documentStatus == null) {
            throw new AdempiereException("@DocStatus@ @NotFound@");
        }
        ArrayList valueList = new ArrayList();
        ArrayList nameList = new ArrayList();
        ArrayList descriptionList = new ArrayList();
        DocumentEngine.readReferenceList(valueList, nameList, descriptionList);
        this.log.fine("DocStatus=" + documentStatus + ", DocAction=" + documentAction + ", OrderType=" + orderType + ", IsSOTrx=" + isSOTrx + ", Processing=" + isProcessing + ", AD_Table_ID=" + entity.get_Table_ID() + ", Record_ID=" + entity.get_ID());
        String[] options = new String[valueList.size()];
        int index = 0;
        String workflowStatus = MWFActivity.getActiveInfo((Properties)Env.getCtx(), (int)entity.get_Table_ID(), (int)entity.get_ID());
        if (workflowStatus != null) {
            throw new AdempiereException("@WFActiveForRecord@");
        }
        String[] docActionHolder = new String[]{documentAction};
        index = DocumentEngine.getValidActions((String)documentStatus, (Object)isProcessing, (String)orderType, (String)isSOTrx, (int)entity.get_Table_ID(), (String[])docActionHolder, (String[])options);
        if (entity instanceof DocOptions) {
            index = ((DocOptions)entity).customizeValidActions(documentStatus, (Object)isProcessing, orderType, isSOTrx, entity.get_Table_ID(), docActionHolder, options, index);
        }
        this.log.fine("get doctype: " + documentTypeId);
        if (documentTypeId != 0) {
            index = DocumentEngine.checkActionAccess((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Role_ID((Properties)Env.getCtx()), (int)documentTypeId, (String[])options, (int)index);
        }
        documentAction = docActionHolder[0];
        ListDocumentActionsResponse.Builder builder = ListDocumentActionsResponse.newBuilder();
        Arrays.asList(options).stream().filter(option -> option != null).forEach(option -> {
            for (int i = 0; i < valueList.size(); ++i) {
                if (!option.equals(valueList.get(i))) continue;
                builder.addDocumentActions(ConvertUtil.convertDocumentAction((String)valueList.get(i), (String)nameList.get(i), (String)descriptionList.get(i)));
            }
        });
        if (documentAction.equals("--")) {
            documentAction = "CL";
        }
        String defaultValue = "";
        String defaultName = "";
        String defaultDescription = "";
        for (int i = 0; i < valueList.size() && defaultName.equals(""); ++i) {
            if (!documentAction.equals(valueList.get(i))) continue;
            defaultValue = (String)valueList.get(i);
            defaultName = (String)nameList.get(i);
            defaultDescription = (String)descriptionList.get(i);
        }
        if (!defaultName.equals("")) {
            builder.setDefaultDocumentAction(ConvertUtil.convertDocumentAction(defaultValue, defaultName, defaultDescription));
        }
        builder.setRecordCount(builder.getDocumentActionsCount());
        return builder;
    }
}

