/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_M_Shipper;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCharge;
import org.compiere.model.MCity;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFreightCategory;
import org.compiere.model.MInvoice;
import org.compiere.model.MLocation;
import org.compiere.model.MMailText;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPayment;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRefList;
import org.compiere.model.MRegion;
import org.compiere.model.MShipper;
import org.compiere.model.MStorage;
import org.compiere.model.MStore;
import org.compiere.model.MTax;
import org.compiere.model.MUOM;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_W_Basket;
import org.compiere.model.X_W_BasketLine;
import org.compiere.process.DocAction;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eevolution.engine.freight.FreightEngine;
import org.eevolution.engine.freight.FreightEngineFactory;
import org.eevolution.engine.freight.FreightInfo;
import org.spin.base.util.ContextManager;
import org.spin.base.util.DocumentUtil;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.store.Address;
import org.spin.grpc.store.AddressRequest;
import org.spin.grpc.store.Attribute;
import org.spin.grpc.store.Cart;
import org.spin.grpc.store.CartItem;
import org.spin.grpc.store.CartTotals;
import org.spin.grpc.store.ChangePasswordRequest;
import org.spin.grpc.store.ChangePasswordResponse;
import org.spin.grpc.store.City;
import org.spin.grpc.store.CreateCartRequest;
import org.spin.grpc.store.CreateCustomerRequest;
import org.spin.grpc.store.CreateOrderRequest;
import org.spin.grpc.store.Customer;
import org.spin.grpc.store.DeleteCartItemRequest;
import org.spin.grpc.store.Empty;
import org.spin.grpc.store.FormattedPrice;
import org.spin.grpc.store.GetCartRequest;
import org.spin.grpc.store.GetCartTotalsRequest;
import org.spin.grpc.store.GetCustomerRequest;
import org.spin.grpc.store.GetResourceRequest;
import org.spin.grpc.store.GetShippingInformationRequest;
import org.spin.grpc.store.GetStockRequest;
import org.spin.grpc.store.ListOrdersRequest;
import org.spin.grpc.store.ListOrdersResponse;
import org.spin.grpc.store.ListPaymentMethodsRequest;
import org.spin.grpc.store.ListPaymentMethodsResponse;
import org.spin.grpc.store.ListProductsRequest;
import org.spin.grpc.store.ListProductsResponse;
import org.spin.grpc.store.ListRenderProductsRequest;
import org.spin.grpc.store.ListRenderProductsResponse;
import org.spin.grpc.store.ListShippingMethodsRequest;
import org.spin.grpc.store.ListShippingMethodsResponse;
import org.spin.grpc.store.ListStocksRequest;
import org.spin.grpc.store.ListStocksResponse;
import org.spin.grpc.store.Order;
import org.spin.grpc.store.OrderLine;
import org.spin.grpc.store.PaymentMethod;
import org.spin.grpc.store.PaymentRequest;
import org.spin.grpc.store.PriceInfo;
import org.spin.grpc.store.Product;
import org.spin.grpc.store.ProductOrderLine;
import org.spin.grpc.store.Region;
import org.spin.grpc.store.RenderProduct;
import org.spin.grpc.store.ResetPasswordRequest;
import org.spin.grpc.store.ResetPasswordResponse;
import org.spin.grpc.store.Resource;
import org.spin.grpc.store.ShippingInformation;
import org.spin.grpc.store.ShippingMethod;
import org.spin.grpc.store.Stock;
import org.spin.grpc.store.TaxAdjustment;
import org.spin.grpc.store.TotalSegment;
import org.spin.grpc.store.UpdateCartRequest;
import org.spin.grpc.store.UpdateCustomerRequest;
import org.spin.grpc.store.WebStoreGrpc;
import org.spin.model.MADAttachmentReference;
import org.spin.model.MADToken;
import org.spin.model.MCPaymentMethod;
import org.spin.model.MWDeliveryViaRuleAllocation;
import org.spin.util.AttachmentUtil;
import org.spin.util.TokenGeneratorHandler;
import org.spin.util.VueStoreFrontUtil;

public class WebStoreServiceImplementation
extends WebStoreGrpc.WebStoreImplBase {
    private CLogger log = CLogger.getCLogger(WebStoreServiceImplementation.class);
    private final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private SimpleDateFormat dateConverter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static CCache<String, MProduct> productCache = new CCache("M_Product", 30, 0);

    @Override
    public void createCustomer(CreateCustomerRequest request, StreamObserver<Customer> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getEmail());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Customer.Builder customer = this.createCustomer(request);
            responseObserver.onNext((Object)customer.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void resetPassword(ResetPasswordRequest request, StreamObserver<ResetPasswordResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getEmail());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ResetPasswordResponse.Builder resetPasswordResponse = this.resetPassword(request);
            responseObserver.onNext((Object)resetPasswordResponse.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void changePassword(ChangePasswordRequest request, StreamObserver<ChangePasswordResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ChangePasswordResponse.Builder changePasswordResponse = this.changePassword(request);
            responseObserver.onNext((Object)changePasswordResponse.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getCustomer(GetCustomerRequest request, StreamObserver<Customer> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Customer.Builder customer = this.getCustomerInfo(request);
            responseObserver.onNext((Object)customer.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getStock(GetStockRequest request, StreamObserver<Stock> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Stock.Builder stock = this.getStockFromSku(request);
            responseObserver.onNext((Object)stock.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listStocks(ListStocksRequest request, StreamObserver<ListStocksResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListStocksResponse.Builder stocks = this.listStocks(request);
            responseObserver.onNext((Object)stocks.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listProducts(ListProductsRequest request, StreamObserver<ListProductsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListProductsResponse.Builder products = this.listProducts(request);
            responseObserver.onNext((Object)products.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listRenderProducts(ListRenderProductsRequest request, StreamObserver<ListRenderProductsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListRenderProductsResponse.Builder products = this.listRenderProducts(request);
            responseObserver.onNext((Object)products.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createCart(CreateCartRequest request, StreamObserver<Cart> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            Trx.run(transactionName -> {
                Cart.Builder cart = this.convertCart(this.createCart(request.getIsGuest(), transactionName), transactionName);
                responseObserver.onNext((Object)cart.build());
                responseObserver.onCompleted();
            });
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getCart(GetCartRequest request, StreamObserver<Cart> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Trx.run(transactionName -> {
                Cart.Builder cart = this.convertCart(this.getCart(request.getCartId(), request.getCartUuid(), request.getIsGuest(), 0, transactionName), transactionName);
                responseObserver.onNext((Object)cart.build());
                responseObserver.onCompleted();
            });
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void updateCart(UpdateCartRequest request, StreamObserver<CartItem> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            CartItem.Builder cartItem = this.convertCartItem(this.updateCart(request));
            responseObserver.onNext((Object)cartItem.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listPaymentMethods(ListPaymentMethodsRequest request, StreamObserver<ListPaymentMethodsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListPaymentMethodsResponse.Builder products = this.listPaymentMethods(request);
            responseObserver.onNext((Object)products.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listShippingMethods(ListShippingMethodsRequest request, StreamObserver<ListShippingMethodsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListShippingMethodsResponse.Builder freughtRules = this.listShippingMethods(request);
            responseObserver.onNext((Object)freughtRules.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getShippingInformation(GetShippingInformationRequest request, StreamObserver<ShippingInformation> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ShippingInformation.Builder shippingInformation = this.getShippingInformation(request);
            responseObserver.onNext((Object)shippingInformation.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getCartTotals(GetCartTotalsRequest request, StreamObserver<CartTotals> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            CartTotals.Builder cartInformation = this.getCartTotals(request);
            responseObserver.onNext((Object)cartInformation.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void deleteCartItem(DeleteCartItemRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder deleteConfirmation = this.deleteCartItem(request);
            responseObserver.onNext((Object)deleteConfirmation.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void updateCustomer(UpdateCustomerRequest request, StreamObserver<Customer> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getEmail());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Customer.Builder customer = this.updateCustomer(request);
            responseObserver.onNext((Object)customer.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getResource(GetResourceRequest request, StreamObserver<Resource> responseObserver) {
        try {
            if (request == null || Util.isEmpty((String)request.getResourceUuid()) && Util.isEmpty((String)request.getResourceName())) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Download Requested = " + request.getResourceUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            this.getResource(request.getResourceUuid(), request.getResourceName(), responseObserver);
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createOrder(CreateOrderRequest request, StreamObserver<Order> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            Trx.run(transactionName -> {
                Order.Builder orderBuilder = this.createOrder(request, transactionName);
                responseObserver.onNext((Object)orderBuilder.build());
                responseObserver.onCompleted();
            });
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listOrders(ListOrdersRequest request, StreamObserver<ListOrdersResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getClientRequest().getSessionUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListOrdersResponse.Builder orders = this.listOrders(request);
            responseObserver.onNext((Object)orders.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private Order.Builder createOrder(CreateOrderRequest request, String transactionName) {
        if (request.getCartId() == 0 && Util.isEmpty((String)request.getCartUuid())) {
            throw new AdempiereException("@W_Basket_ID@ @IsMandatory@");
        }
        MStore store = VueStoreFrontUtil.getDefaultStore((int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        if (store == null) {
            throw new AdempiereException("@W_Store_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)request.getShippingAddress().getCountryCode()) && Util.isEmpty((String)request.getShippingAddress().getRegionName()) && Util.isEmpty((String)request.getShippingAddress().getCityName())) {
            throw new AdempiereException("@IsShipTo@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getBillingAddress().getCountryCode()) && Util.isEmpty((String)request.getBillingAddress().getRegionName()) && Util.isEmpty((String)request.getBillingAddress().getCityName())) {
            throw new AdempiereException("@IsBillTo@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getPaymentMethodCode())) {
            throw new AdempiereException("@PaymentRule@ @IsMandatory@");
        }
        X_W_Basket basket = this.getCart(request.getCartId(), request.getCartUuid(), !Util.isEmpty((String)request.getCartUuid()), request.getUserId(), transactionName);
        if (basket == null) {
            throw new AdempiereException("@W_Basket_ID@ @IsMandatory@");
        }
        MBPartner businessPartner = null;
        if (request.getCustomerId() > 0) {
            businessPartner = new MBPartner(Env.getCtx(), request.getCustomerId(), transactionName);
            if (request.getCustomerId() != basket.getC_BPartner_ID()) {
                basket.setC_BPartner_ID(request.getCustomerId());
                basket.saveEx(transactionName);
            }
        } else if (basket.getC_BPartner_ID() <= 0) {
            businessPartner = VueStoreFrontUtil.getTemplate((Properties)Env.getCtx(), (int)store.get_ValueAsInt("C_TemplateBPartner_ID"), (String)transactionName);
            businessPartner.setName(request.getBillingAddress().getFirstName());
            businessPartner.setName2(request.getBillingAddress().getLastName());
            businessPartner.saveEx(transactionName);
        } else {
            businessPartner = (MBPartner)basket.getC_BPartner();
        }
        businessPartner.set_TrxName(transactionName);
        int shippingLocationId = this.findAddress(businessPartner, request.getShippingAddress(), false, transactionName);
        int billingLocationId = this.findAddress(businessPartner, request.getBillingAddress(), true, transactionName);
        MOrder salesOrder = new MOrder(Env.getCtx(), 0, transactionName);
        salesOrder.setDateOrdered(this.getDate());
        salesOrder.setDateAcct(this.getDate());
        salesOrder.setDatePromised(this.getDate());
        salesOrder.setIsSOTrx(true);
        salesOrder.setAD_Org_ID(store.getAD_Org_ID());
        if (store.getSalesRep_ID() > 0) {
            salesOrder.setSalesRep_ID(store.getSalesRep_ID());
        }
        salesOrder.setBPartner(businessPartner);
        salesOrder.setBill_Location_ID(billingLocationId);
        salesOrder.setC_BPartner_Location_ID(shippingLocationId);
        salesOrder.set_ValueOfColumn("W_Store_ID", (Object)store.getW_Store_ID());
        salesOrder.set_ValueOfColumn("W_Basket_ID", (Object)basket.getW_Basket_ID());
        salesOrder.setM_Warehouse_ID(store.getM_Warehouse_ID());
        salesOrder.setM_PriceList_ID(store.getM_PriceList_ID());
        int documeDocTypeId = store.get_ValueAsInt("C_DocType_ID");
        if (documeDocTypeId <= 0) {
            documeDocTypeId = MDocType.getDocTypeBaseOnSubType((int)store.getAD_Org_ID(), (String)"SOO", (String)"IO");
        }
        if (documeDocTypeId <= 0) {
            throw new AdempiereException("@C_DocType_ID@ @IsMandatory@");
        }
        salesOrder.setC_DocTypeTarget_ID(documeDocTypeId);
        MWDeliveryViaRuleAllocation deliveryViaRuleAllocation = MWDeliveryViaRuleAllocation.getFromUuid((Properties)Env.getCtx(), (String)request.getMethodCode(), (String)transactionName);
        if (!Util.isEmpty((String)deliveryViaRuleAllocation.getDeliveryViaRule())) {
            salesOrder.setDeliveryViaRule(deliveryViaRuleAllocation.getDeliveryViaRule());
        }
        if (deliveryViaRuleAllocation.getM_Shipper_ID() > 0) {
            salesOrder.setM_Shipper_ID(deliveryViaRuleAllocation.getM_Shipper_ID());
        }
        if (!Util.isEmpty((String)deliveryViaRuleAllocation.getFreightCostRule())) {
            salesOrder.setFreightCostRule(deliveryViaRuleAllocation.getFreightCostRule());
        }
        if (deliveryViaRuleAllocation.getM_FreightCategory_ID() > 0) {
            salesOrder.setM_FreightCategory_ID(deliveryViaRuleAllocation.getM_FreightCategory_ID());
        }
        if (!Util.isEmpty((String)deliveryViaRuleAllocation.getNote())) {
            salesOrder.addDescription(deliveryViaRuleAllocation.getNote());
        }
        if (Util.isEmpty((String)request.getPaymentMethodCode())) {
            throw new AdempiereException("@TenderType@ @IsMandatory@");
        }
        MCPaymentMethod paymentMethod = MCPaymentMethod.getByValue((Properties)Env.getCtx(), (String)request.getPaymentMethodCode(), (String)transactionName);
        salesOrder.setDocStatus("DR");
        salesOrder.setDocAction("CO");
        salesOrder.set_ValueOfColumn("W_Store_ID", (Object)store.getW_Store_ID());
        salesOrder.saveEx();
        request.getProductsList().forEach(product -> this.addLinesToOrder(salesOrder, (ProductOrderLine)product, transactionName));
        if (!salesOrder.processIt("CO")) {
            throw new AdempiereException("@Error@ " + salesOrder.getProcessMsg());
        }
        if (request.getUserId() > 0) {
            salesOrder.setAD_User_ID(request.getUserId());
        }
        salesOrder.saveEx();
        basket.setIsActive(false);
        basket.saveEx(transactionName);
        this.processPayments(paymentMethod, salesOrder, request.getPaymentsList(), transactionName);
        return this.convertOrder(request, salesOrder, transactionName);
    }

    private void processPayments(MCPaymentMethod defaultPaymentMethod, MOrder salesOrder, List<PaymentRequest> paymentList, String transactionName) {
        AtomicReference<BigDecimal> paymentAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        paymentList.forEach(paymentRequest -> {
            MCurrency currency;
            MCPaymentMethod paymentMethod = MCPaymentMethod.getByValue((Properties)Env.getCtx(), (String)paymentRequest.getPaymentMethodCode(), (String)transactionName);
            int currencyId = salesOrder.getC_Currency_ID();
            if (!Util.isEmpty((String)paymentRequest.getCurrencyCode()) && (currency = MCurrency.get((Properties)Env.getCtx(), (String)paymentRequest.getCurrencyCode())) != null) {
                currencyId = currency.getC_Currency_ID();
            }
            this.processPayment(salesOrder, paymentMethod.getTenderType(), currencyId, new BigDecimal(paymentRequest.getAmount()), (PaymentRequest)paymentRequest, transactionName);
            paymentAmount.updateAndGet(amount -> amount.add(new BigDecimal(paymentRequest.getAmount())));
        });
        if (paymentAmount.get().compareTo(Env.ZERO) >= 0 && salesOrder.getGrandTotal().subtract(paymentAmount.get()).compareTo(Env.ZERO) > 0 && defaultPaymentMethod != null) {
            this.processPayment(salesOrder, defaultPaymentMethod.getTenderType(), salesOrder.getC_Currency_ID(), salesOrder.getGrandTotal().subtract(paymentAmount.get()), null, transactionName);
        }
    }

    private void processPayment(MOrder salesOrder, String tenderType, int currencyId, BigDecimal paymentAmount, PaymentRequest paymentRequest, String transactionName) {
        if (paymentRequest == null) {
            paymentRequest = PaymentRequest.newBuilder().build();
        }
        if (Util.isEmpty((String)tenderType)) {
            tenderType = "X";
        }
        MPayment payment = this.createPayment(salesOrder, tenderType, currencyId, paymentAmount, transactionName);
        switch (tenderType) {
            case "K": {
                payment.setCheckNo(paymentRequest.getReferenceNo());
                break;
            }
            case "D": {
                break;
            }
            case "C": {
                break;
            }
            default: {
                payment.setDescription(paymentRequest.getDescription());
            }
        }
        if (paymentRequest.getBankId() > 0) {
            payment.set_ValueOfColumn("C_Bank_ID", (Object)paymentRequest.getBankId());
        }
        if (!Util.isEmpty((String)paymentRequest.getReferenceNo())) {
            payment.addDescription(paymentRequest.getReferenceNo());
        }
        if (!Util.isEmpty((String)paymentRequest.getDescription())) {
            payment.addDescription(paymentRequest.getDescription());
        }
        payment.saveEx(transactionName);
        if (payment != null) {
            if (!payment.processIt("PR")) {
                throw new AdempiereException("@Error@: " + payment.getProcessMsg());
            }
            payment.saveEx(transactionName);
        }
    }

    private int getCashBankAccount(MOrder salesOrder) {
        MBankAccount bankAccount = MBankAccount.getDefault((Properties)Env.getCtx(), (int)salesOrder.getAD_Org_ID(), (String)"C");
        if (bankAccount != null) {
            return bankAccount.getC_BankAccount_ID();
        }
        return -1;
    }

    private MPayment createPayment(MOrder salesOrder, String tenderType, int currencyId, BigDecimal paymentAmount, String transactionName) {
        int cashAccountId = this.getCashBankAccount(salesOrder);
        if (cashAccountId <= 0) {
            throw new AdempiereException("@NoCashBook@");
        }
        MPayment payment = new MPayment(Env.getCtx(), 0, transactionName);
        payment.setC_BankAccount_ID(cashAccountId);
        payment.setC_DocType_ID(true);
        payment.setAD_Org_ID(salesOrder.getAD_Org_ID());
        String value = DB.getDocumentNo((int)payment.getC_DocType_ID(), (String)transactionName, (boolean)false, (PO)payment);
        payment.setDocumentNo(value);
        payment.setDateAcct(salesOrder.getDateAcct());
        payment.setDateTrx(salesOrder.getDateOrdered());
        payment.setTenderType("X");
        payment.setDescription(salesOrder.getDescription());
        payment.setC_BPartner_ID(salesOrder.getC_BPartner_ID());
        payment.setC_Currency_ID(salesOrder.getC_Currency_ID());
        payment.setPayAmt(paymentAmount);
        payment.setOverUnderAmt(Env.ZERO);
        payment.setC_Order_ID(salesOrder.getC_Order_ID());
        payment.setDocStatus("DR");
        payment.saveEx();
        int invoiceId = salesOrder.getC_Invoice_ID();
        if (invoiceId > 0) {
            payment.setC_Invoice_ID(invoiceId);
            MInvoice invoice = new MInvoice(Env.getCtx(), payment.getC_Invoice_ID(), transactionName);
            payment.setDescription(Msg.getMsg((Properties)Env.getCtx(), (String)"Invoice No ") + invoice.getDocumentNo());
        } else {
            payment.setDescription(Msg.getMsg((Properties)Env.getCtx(), (String)"Order No ") + salesOrder.getDocumentNo());
        }
        payment.saveEx(transactionName);
        return payment;
    }

    private Order.Builder convertOrder(CreateOrderRequest request, MOrder salesOrder, String transactionName) {
        Order.Builder builder = Order.newBuilder();
        builder.setId(salesOrder.getC_Order_ID()).setDocumentNo(ValueUtil.validateNull(salesOrder.getDocumentNo())).setCreated(this.dateConverter.format(salesOrder.getCreated())).setUpdated(this.dateConverter.format(salesOrder.getUpdated())).setTransmited(this.dateConverter.format(salesOrder.getUpdated())).setCarrierCode(request.getCarrierCode()).setMethodCode(request.getMethodCode()).setPaymentMethodCode(request.getPaymentMethodCode()).setShippingAddress(this.convertAddress(MUser.get((Properties)Env.getCtx(), (int)salesOrder.getAD_User_ID()), (MBPartnerLocation)salesOrder.getC_BPartner_Location(), transactionName)).setShippingAddress(this.convertAddress(MUser.get((Properties)Env.getCtx(), (int)salesOrder.getAD_User_ID()), (MBPartnerLocation)salesOrder.getBill_Location(), transactionName));
        Arrays.asList(salesOrder.getLines(true, null)).forEach(orderLine -> {
            MProduct product = MProduct.get((Properties)Env.getCtx(), (int)orderLine.getM_Product_ID());
            builder.addOrderLines(OrderLine.newBuilder().setSku(ValueUtil.validateNull(product.getSKU())).setName(ValueUtil.validateNull(product.getName())).setPrice(orderLine.getPriceActual().doubleValue()).setQuantity(orderLine.getQtyOrdered().doubleValue()));
        });
        return builder;
    }

    private Order.Builder convertOrder(MOrder salesOrder, String transactionName) {
        Order.Builder builder = Order.newBuilder();
        builder.setId(salesOrder.getC_Order_ID()).setDocumentNo(ValueUtil.validateNull(salesOrder.getDocumentNo())).setCreated(this.dateConverter.format(salesOrder.getCreated())).setUpdated(this.dateConverter.format(salesOrder.getUpdated())).setTransmited(this.dateConverter.format(salesOrder.getUpdated())).setShippingAddress(this.convertAddress(MUser.get((Properties)Env.getCtx(), (int)salesOrder.getAD_User_ID()), (MBPartnerLocation)salesOrder.getC_BPartner_Location(), transactionName)).setShippingAddress(this.convertAddress(MUser.get((Properties)Env.getCtx(), (int)salesOrder.getAD_User_ID()), (MBPartnerLocation)salesOrder.getBill_Location(), transactionName));
        Arrays.asList(salesOrder.getLines(true, null)).forEach(orderLine -> {
            MProduct product = MProduct.get((Properties)Env.getCtx(), (int)orderLine.getM_Product_ID());
            builder.addOrderLines(OrderLine.newBuilder().setSku(ValueUtil.validateNull(product.getSKU())).setName(ValueUtil.validateNull(product.getName())).setPrice(orderLine.getPriceActual().doubleValue()).setQuantity(orderLine.getQtyOrdered().doubleValue()));
        });
        return builder;
    }

    private void addLinesToOrder(MOrder salesOrder, ProductOrderLine product, String transactionName) {
        if (!DocumentUtil.isDrafted((DocAction)salesOrder)) {
            throw new AdempiereException("@C_Order_ID@ @IsDrafted@");
        }
        BigDecimal quantityToOrder = new BigDecimal(product.getQuantity());
        MOrderLine orderLine = new MOrderLine(salesOrder);
        orderLine.setProduct(MProduct.get((Properties)salesOrder.getCtx(), (int)product.getId()));
        orderLine.setQty(quantityToOrder);
        orderLine.setPrice();
        orderLine.saveEx(transactionName);
    }

    private int findAddress(MBPartner customer, AddressRequest address, boolean isBillto, String transactionName) {
        List<MBPartnerLocation> businessPartnerLocations = Arrays.asList(customer.getLocations(true));
        int businessPartnerLocationId = 0;
        if (address.getLocationId() > 0) {
            Optional<MBPartnerLocation> maybeLocation = businessPartnerLocations.stream().filter(bPLocation -> bPLocation.getC_Location_ID() == address.getLocationId()).findFirst();
            if (maybeLocation.isPresent()) {
                businessPartnerLocationId = maybeLocation.get().getC_BPartner_Location_ID();
            }
        } else {
            Optional<MBPartnerLocation> maybeLocation = businessPartnerLocations.stream().filter(bPLocation -> {
                MLocation location = MLocation.get((Properties)Env.getCtx(), (int)bPLocation.getC_Location_ID(), (String)transactionName);
                MCountry country = MCountry.get((Properties)Env.getCtx(), (int)location.getC_Country_ID());
                return !(bPLocation.isBillTo() != isBillto && bPLocation.isShipTo() != !isBillto || !Optional.ofNullable(country.getCountryCode()).orElse("").toUpperCase().trim().equals(Optional.ofNullable(address.getCountryCode()).orElse("").toUpperCase().trim()) || !Optional.ofNullable(location.getRegionName()).orElse("").toUpperCase().trim().equals(Optional.ofNullable(address.getRegionName()).orElse("").toUpperCase().trim()) && location.getC_Region_ID() != address.getRegionId() || !Optional.ofNullable(location.getCity()).orElse("").equals(Optional.ofNullable(address.getCityName()).orElse("")) || !Optional.ofNullable(location.getAddress1()).orElse("").toUpperCase().trim().equals(Optional.ofNullable(address.getAddress1()).orElse("").toUpperCase().trim()) || !Optional.ofNullable(location.getAddress2()).orElse("").toUpperCase().trim().equals(Optional.ofNullable(address.getAddress2()).orElse("").toUpperCase().trim()) || !Optional.ofNullable(location.getAddress3()).orElse("").toUpperCase().trim().equals(Optional.ofNullable(address.getAddress3()).orElse("").toUpperCase().trim()) || !Optional.ofNullable(location.getAddress4()).orElse("").toUpperCase().trim().equals(Optional.ofNullable(address.getAddress4()).orElse("").toUpperCase().trim()) || !Optional.ofNullable(location.getPostal()).orElse("").equals(Optional.ofNullable(address.getPostalCode()).orElse("")));
            }).findFirst();
            if (maybeLocation.isPresent()) {
                businessPartnerLocationId = maybeLocation.get().getC_BPartner_Location_ID();
            } else {
                MBPartnerLocation businessPartnerLocation = this.createBusinessPartnerLocation(customer, address, isBillto, transactionName);
                businessPartnerLocationId = businessPartnerLocation.getC_BPartner_Location_ID();
            }
        }
        return businessPartnerLocationId;
    }

    private MBPartnerLocation createBusinessPartnerLocation(MBPartner customer, AddressRequest address, boolean isBillTo, String transactionName) {
        Optional<MRegion> maybeRegion;
        int regionId;
        MCountry country;
        int countryId = 0;
        if (!Util.isEmpty((String)address.getCountryCode()) && Optional.ofNullable(country = MCountry.get((Properties)Env.getCtx(), (String)address.getCountryCode())).isPresent()) {
            countryId = country.getC_Country_ID();
        }
        if (countryId <= 0) {
            countryId = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#C_Country_ID");
        }
        if ((regionId = address.getRegionId()) <= 0 && !Util.isEmpty((String)address.getRegionName()) && (maybeRegion = Arrays.asList(MRegion.getDefault((Properties)Env.getCtx())).stream().filter(region -> region.getName().equals(address.getRegionName())).findFirst()).isPresent()) {
            regionId = maybeRegion.get().getC_Region_ID();
        }
        String cityName = null;
        int cityId = 0;
        if (!Util.isEmpty((String)address.getCityName())) {
            cityName = address.getCityName();
            MCity city = (MCity)new Query(Env.getCtx(), "C_City", "UPPER(Name) = ?", transactionName).setParameters(new Object[]{address.getCityName().toUpperCase()}).first();
            if (city != null && city.getC_City_ID() > 0) {
                cityId = city.getC_City_ID();
                if (regionId <= 0 && city.getC_Region_ID() > 0) {
                    regionId = city.getC_Region_ID();
                }
            }
        }
        if (regionId > 0) {
            MRegion region2 = MRegion.get((Properties)Env.getCtx(), (int)regionId);
            countryId = region2.getC_Country_ID();
        }
        MLocation location = new MLocation(Env.getCtx(), countryId, regionId, cityName, transactionName);
        if (cityId > 0) {
            location.setC_City_ID(cityId);
        }
        if (!Util.isEmpty((String)address.getPostalCode())) {
            location.setPostal(address.getPostalCode());
        }
        location.setAddress1(address.getAddress1());
        location.setAddress2(address.getAddress2());
        location.setAddress3(address.getAddress3());
        location.setAddress4(address.getAddress4());
        location.saveEx(transactionName);
        MBPartnerLocation businessPartnerLocation = new MBPartnerLocation(customer);
        businessPartnerLocation.setC_Location_ID(location.getC_Location_ID());
        if (!Util.isEmpty((String)address.getPhone())) {
            businessPartnerLocation.setPhone(address.getPhone());
        }
        businessPartnerLocation.setIsShipTo(true);
        businessPartnerLocation.setIsBillTo(isBillTo);
        businessPartnerLocation.set_ValueOfColumn("IsDefaultBilling", (Object)address.getIsDefaultBilling());
        businessPartnerLocation.set_ValueOfColumn("IsDefaultShipping", (Object)address.getIsDefaultShipping());
        businessPartnerLocation.saveEx(transactionName);
        return businessPartnerLocation;
    }

    private Timestamp getDate() {
        return TimeUtil.getDay((long)System.currentTimeMillis());
    }

    private void getResource(String resourceUuid, String resourceName, StreamObserver<Resource> responseObserver) throws Exception {
        int length;
        if (!AttachmentUtil.getInstance().isValidForClient(Env.getAD_Client_ID((Properties)Env.getCtx()))) {
            responseObserver.onCompleted();
            return;
        }
        if (!Util.isEmpty((String)resourceName)) {
            MClientInfo clientInfo = MClientInfo.get((Properties)Env.getCtx());
            MADAttachmentReference reference = (MADAttachmentReference)new Query(Env.getCtx(), "AD_AttachmentReference", "(UUID || '-' || FileName) = ? AND FileHandler_ID = ?", null).setOrderBy("AD_Attachment_ID DESC").setParameters(new Object[]{resourceName, clientInfo.getFileHandler_ID()}).first();
            if (reference == null || reference.getAD_AttachmentReference_ID() <= 0) {
                responseObserver.onCompleted();
                return;
            }
            resourceUuid = reference.getUUID();
        } else if (Util.isEmpty((String)resourceUuid)) {
            responseObserver.onCompleted();
            return;
        }
        byte[] data = AttachmentUtil.getInstance().withClientId(Env.getAD_Client_ID((Properties)Env.getCtx())).withAttachmentReferenceId(RecordUtil.getIdFromUuid("AD_AttachmentReference", resourceUuid, null)).getAttachment();
        if (data == null) {
            responseObserver.onCompleted();
            return;
        }
        int bufferSize = 262144;
        byte[] buffer = new byte[bufferSize];
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        while ((length = ((InputStream)is).read(buffer, 0, bufferSize)) != -1) {
            responseObserver.onNext((Object)Resource.newBuilder().setData(ByteString.copyFrom((byte[])buffer, (int)0, (int)length)).build());
        }
        responseObserver.onCompleted();
    }

    private Empty.Builder deleteCartItem(DeleteCartItemRequest request) {
        Empty.Builder builder = Empty.newBuilder();
        Trx.run(transactionName -> {
            MStore store = VueStoreFrontUtil.getDefaultStore((int)Env.getAD_Org_ID((Properties)Env.getCtx()));
            if (store == null) {
                throw new AdempiereException("@W_Store_ID@ @NotFound@");
            }
            MProduct product = this.getProductFromSku(request.getSku());
            if (product == null || product.getM_Product_ID() == 0) {
                throw new AdempiereException("@M_Product_ID@ @NotFound@");
            }
            X_W_Basket basket = this.getCart(request.getCartId(), request.getCartUuid(), !Util.isEmpty((String)request.getCartUuid()), 0, transactionName);
            List items = new Query(Env.getCtx(), "W_BasketLine", "W_Basket_ID = ? AND (M_Product_ID = ? OR EXISTS(SELECT 1 FROM M_Product p WHERE p.M_Product_ID = W_BasketLine.M_Product_ID AND p.SKU = ?))", transactionName).setParameters(new Object[]{basket.getW_Basket_ID(), request.getProductId(), request.getSku()}).list();
            if (items != null && items.size() > 0) {
                items.forEach(item -> item.deleteEx(true));
            }
        });
        return builder;
    }

    private CartTotals.Builder getCartTotals(GetCartTotalsRequest request) {
        CartTotals.Builder builder = CartTotals.newBuilder();
        Trx.run(transactionName -> {
            X_W_Basket basket = this.getCart(request.getCartId(), request.getCartUuid(), !Util.isEmpty((String)request.getCartUuid()), 0, transactionName);
            if (basket == null) {
                throw new AdempiereException("@W_Basket_ID@ @NotFound@");
            }
            Cart.Builder cart = this.convertCart(basket, transactionName);
            builder.setCart(cart);
            String subTotalLabel = Msg.getMsg((Properties)Env.getCtx(), (String)"store.SubTotal");
            String shippingLabel = Msg.getMsg((Properties)Env.getCtx(), (String)"store.Shipping");
            String discountLabel = Msg.getMsg((Properties)Env.getCtx(), (String)"store.Discount");
            String taxLabel = Msg.getMsg((Properties)Env.getCtx(), (String)"store.Tax");
            String grandTotalLabel = Msg.getMsg((Properties)Env.getCtx(), (String)"store.GrandTotal");
            builder.addTotalSegments(TotalSegment.newBuilder().setCode("subtotal").setName(subTotalLabel).setValue(cart.getSubtotal()));
            builder.addTotalSegments(TotalSegment.newBuilder().setCode("shipping").setName(shippingLabel).setValue(cart.getShippingAmount()));
            builder.addTotalSegments(TotalSegment.newBuilder().setCode("discount").setName(discountLabel).setValue(cart.getDiscountAmount()));
            TotalSegment.Builder taxSegment = TotalSegment.newBuilder().setCode("tax").setName(taxLabel).setArea("taxes").setValue(cart.getTaxAmount());
            builder.addTotalSegments(taxSegment);
            builder.addTotalSegments(TotalSegment.newBuilder().setCode("grand_total").setName(grandTotalLabel).setArea("footer").setValue(cart.getGrandTotal()));
        });
        return builder;
    }

    private ShippingInformation.Builder getShippingInformation(GetShippingInformationRequest request) {
        ShippingInformation.Builder builder = ShippingInformation.newBuilder();
        Trx.run(transactionName -> {
            X_W_Basket basket = this.getCart(request.getCartId(), request.getCartUuid(), !Util.isEmpty((String)request.getCartUuid()), 0, transactionName);
            if (basket == null) {
                throw new AdempiereException("@W_Basket_ID@ @NotFound@");
            }
            MStore store = VueStoreFrontUtil.getDefaultStore((int)Env.getAD_Org_ID((Properties)Env.getCtx()));
            if (store == null) {
                throw new AdempiereException("@W_Store_ID@ @NotFound@");
            }
            MCPaymentMethod.getOfStore((Properties)Env.getCtx(), (int)store.getW_Store_ID(), (String)transactionName).forEach(paymentMethod -> builder.addPaymentMethods(PaymentMethod.newBuilder().setCode(ValueUtil.validateNull(paymentMethod.getValue())).setName(ValueUtil.validateNull(paymentMethod.getName()))));
            this.reloadShippingCalculation(basket.getW_Basket_ID(), request.getMethodCode(), transactionName);
            Cart.Builder cart = this.convertCart(basket, transactionName);
            builder.setCart(cart);
            String subTotalLabel = Msg.getMsg((Properties)Env.getCtx(), (String)"store.SubTotal");
            String shippingLabel = Msg.getMsg((Properties)Env.getCtx(), (String)"store.Shipping");
            String discountLabel = Msg.getMsg((Properties)Env.getCtx(), (String)"store.Discount");
            String taxLabel = Msg.getMsg((Properties)Env.getCtx(), (String)"store.Tax");
            String grandTotalLabel = Msg.getMsg((Properties)Env.getCtx(), (String)"store.GrandTotal");
            builder.addTotalSegments(TotalSegment.newBuilder().setCode("subtotal").setName(subTotalLabel).setValue(cart.getSubtotal()));
            builder.addTotalSegments(TotalSegment.newBuilder().setCode("shipping").setName(shippingLabel).setValue(cart.getShippingAmount()));
            builder.addTotalSegments(TotalSegment.newBuilder().setCode("discount").setName(discountLabel).setValue(cart.getDiscountAmount()));
            TotalSegment.Builder taxSegment = TotalSegment.newBuilder().setCode("tax").setName(taxLabel).setArea("taxes").setValue(cart.getTaxAmount());
            builder.addTotalSegments(taxSegment);
            builder.addTotalSegments(TotalSegment.newBuilder().setCode("grand_total").setName(grandTotalLabel).setArea("footer").setValue(cart.getGrandTotal()));
        });
        return builder;
    }

    private void reloadShippingCalculation(int basketId, String methodCode, String transactionName) {
        List items;
        MWDeliveryViaRuleAllocation deliveryVia;
        if (!Util.isEmpty((String)methodCode) && (deliveryVia = MWDeliveryViaRuleAllocation.getFromUuid((Properties)Env.getCtx(), (String)methodCode, (String)transactionName)) != null && deliveryVia.getW_DeliveryViaRuleAllocation_ID() > 0 && (items = new Query(Env.getCtx(), "W_BasketLine", "W_Basket_ID = ?", transactionName).setParameters(new Object[]{basketId}).list()) != null && items.size() > 0) {
            items.forEach(basketLine -> {
                basketLine.set_ValueOfColumn("DeliveryViaRule", (Object)deliveryVia.get_ValueAsString("DeliveryViaRule"));
                if (!Util.isEmpty((String)deliveryVia.get_ValueAsString("FreightCostRule"))) {
                    basketLine.set_ValueOfColumn("FreightCostRule", (Object)deliveryVia.get_ValueAsString("FreightCostRule"));
                }
                if (deliveryVia.get_ValueAsInt("M_FreightCategory_ID") > 0) {
                    basketLine.set_ValueOfColumn("M_FreightCategory_ID", (Object)deliveryVia.get_ValueAsInt("M_FreightCategory_ID"));
                }
                if (deliveryVia.get_ValueAsInt("M_Shipper_ID") > 0) {
                    basketLine.set_ValueOfColumn("M_Shipper_ID", (Object)deliveryVia.get_ValueAsInt("M_Shipper_ID"));
                }
                basketLine.saveEx(transactionName);
            });
            VueStoreFrontUtil.createPackagesFromBasket((Properties)Env.getCtx(), (int)basketId, (String)transactionName);
        }
    }

    private ListOrdersResponse.Builder listOrders(ListOrdersRequest request) {
        ListOrdersResponse.Builder builder = ListOrdersResponse.newBuilder();
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        Query query = new Query(Env.getCtx(), "C_Order", "EXISTS(SELECT 1 FROM W_Basket b WHERE b.W_Basket_ID = C_Order.W_Basket_ID AND b.AD_User_ID = ?)", null).setParameters(new Object[]{Env.getAD_User_ID((Properties)Env.getCtx())}).setClient_ID().setOnlyActiveRecords(true).setOrderBy("DateOrdered DESC");
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(order -> builder.addOrders(this.convertOrder((MOrder)order, null)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListShippingMethodsResponse.Builder listShippingMethods(ListShippingMethodsRequest request) {
        ListShippingMethodsResponse.Builder builder = ListShippingMethodsResponse.newBuilder();
        if (request.getCartId() == 0 && Util.isEmpty((String)request.getCartUuid())) {
            throw new AdempiereException("@W_Basket_ID@ @IsMandatory@");
        }
        MStore store = VueStoreFrontUtil.getDefaultStore((int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        if (store == null) {
            throw new AdempiereException("@W_Store_ID@ @NotFound@");
        }
        int locationToId = this.getLocationToId(request, store);
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        StringBuffer whereClause = new StringBuffer("SKU IN(");
        whereClause.append(")");
        Query query = new Query(Env.getCtx(), "W_DeliveryViaRuleAllocation", "W_Store_ID = ?", null).setParameters(new Object[]{store.getW_Store_ID()}).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(shippmentMethod -> this.getShippingMethod((MWDeliveryViaRuleAllocation)shippmentMethod, locationToId).forEach(shippingMethod -> builder.addShippingMethods((ShippingMethod.Builder)shippingMethod)));
        builder.setRecordCount(count);
        if (count > offset && count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private int getLocationToId(ListShippingMethodsRequest request, MStore store) {
        if (request.getShippingAddress().getLocationId() > 0) {
            return request.getShippingAddress().getLocationId();
        }
        if (Util.isEmpty((String)request.getShippingAddress().getCountryCode()) || Util.isEmpty((String)request.getShippingAddress().getRegionName()) || Util.isEmpty((String)request.getShippingAddress().getCityName())) {
            int customerTemplateId = store.get_ValueAsInt("C_TemplateBPartner_ID");
            MBPartner defaultBPartner = null;
            defaultBPartner = customerTemplateId <= 0 ? MBPartner.getBPartnerCashTrx((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx())) : MBPartner.get((Properties)Env.getCtx(), (int)customerTemplateId);
            List<MBPartnerLocation> businessPartnerLocations = Arrays.asList(defaultBPartner.getLocations(false));
            Optional<MBPartnerLocation> maybeLocation = businessPartnerLocations.stream().filter(bPLocation -> bPLocation.isShipTo()).findFirst();
            if (maybeLocation.isPresent()) {
                return maybeLocation.get().getC_Location_ID();
            }
        }
        return 0;
    }

    private List<ShippingMethod.Builder> getShippingMethod(MWDeliveryViaRuleAllocation shippmentMethod, int locationToId) {
        ArrayList<ShippingMethod.Builder> shippingMethodList = new ArrayList<ShippingMethod.Builder>();
        Trx.run(transactionName -> {
            MStore store = VueStoreFrontUtil.getDefaultStore((int)Env.getAD_Org_ID((Properties)Env.getCtx()));
            if (store == null) {
                throw new AdempiereException("@W_Store_ID@ @NotFound@");
            }
            MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)store.getM_PriceList_ID(), (String)transactionName);
            MWarehouse warehouse = MWarehouse.get((Properties)Env.getCtx(), (int)store.getM_Warehouse_ID());
            Timestamp validFrom = new Timestamp(System.currentTimeMillis());
            FreightEngine freightEngine = FreightEngineFactory.getFreightEngine((int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            if (shippmentMethod.getDeliveryViaRule().equals("S") && shippmentMethod.isCalculatedFreight()) {
                if (shippmentMethod.getM_Shipper_ID() > 0) {
                    MShipper shipper2 = (MShipper)shippmentMethod.getM_Shipper();
                    FreightInfo freightInfo = freightEngine.getFreightRuleFactory((I_M_Shipper)shipper2, shippmentMethod.getFreightCostRule()).calculate(Env.getCtx(), shippmentMethod.getM_Shipper_ID(), warehouse.getC_Location_ID(), locationToId, shippmentMethod.getM_FreightCategory_ID(), priceList.getC_Currency_ID(), validFrom, Env.ZERO, Env.ZERO, transactionName, null);
                    MFreightCategory freightCategory = MFreightCategory.getById((Properties)Env.getCtx(), (int)shippmentMethod.getM_FreightCategory_ID(), (String)transactionName);
                    BigDecimal freightAmount = Env.ZERO;
                    BigDecimal taxRate = Env.ZERO;
                    if (freightInfo != null && freightInfo.getFreightId() > 0) {
                        freightAmount = freightInfo.getFreightAmount();
                        if (freightCategory.getM_Product_ID() > 0) {
                            MProduct product = MProduct.get((Properties)Env.getCtx(), (int)freightCategory.getM_Product_ID());
                            taxRate = VueStoreFrontUtil.getTaxRate((int)product.getC_TaxCategory_ID());
                        }
                    }
                    shippingMethodList.add(ShippingMethod.newBuilder().setCarrierCode(shipper2.getUUID()).setCarrierName(shipper2.getName()).setMethodCode(shippmentMethod.getUUID()).setMethodName(freightCategory.getName()).setAmount(freightAmount.doubleValue()).setTaxRate(taxRate.doubleValue()).setIsAvailable(true));
                } else {
                    MShipper.getShippersForFreightCategory((Properties)Env.getCtx(), (int)shippmentMethod.getM_FreightCategory_ID(), (String)transactionName).forEach(shipper -> {
                        FreightInfo freightInfo = freightEngine.getFreightRuleFactory((I_M_Shipper)shipper, shippmentMethod.getFreightCostRule()).calculate(Env.getCtx(), shipper.getM_Shipper_ID(), warehouse.getC_Location_ID(), 0, shippmentMethod.getM_FreightCategory_ID(), priceList.getC_Currency_ID(), validFrom, Env.ZERO, Env.ZERO, transactionName, null);
                        MFreightCategory freightCategory = MFreightCategory.getById((Properties)Env.getCtx(), (int)shippmentMethod.getM_FreightCategory_ID(), (String)transactionName);
                        BigDecimal freightAmount = Env.ZERO;
                        BigDecimal taxRate = Env.ZERO;
                        if (freightInfo != null && freightInfo.getFreightId() > 0) {
                            freightAmount = freightInfo.getFreightAmount();
                            if (freightCategory.getM_Product_ID() > 0) {
                                MProduct product = MProduct.get((Properties)Env.getCtx(), (int)freightCategory.getM_Product_ID());
                                taxRate = VueStoreFrontUtil.getTaxRate((int)product.getC_TaxCategory_ID());
                            }
                        }
                        shippingMethodList.add(ShippingMethod.newBuilder().setCarrierCode(shipper.getUUID()).setCarrierName(shipper.getName()).setMethodCode(shippmentMethod.getUUID()).setMethodName(freightCategory.getName()).setAmount(freightAmount.doubleValue()).setTaxRate(taxRate.doubleValue()).setIsAvailable(true));
                    });
                }
            } else {
                String methodName = MRefList.getListName((Properties)Env.getCtx(), (int)152, (String)shippmentMethod.getDeliveryViaRule());
                shippingMethodList.add(ShippingMethod.newBuilder().setCarrierCode(shippmentMethod.getUUID()).setCarrierName(store.getName()).setMethodCode(shippmentMethod.getUUID()).setMethodName(methodName).setAmount(0.0).setTaxRate(0.0).setIsAvailable(true));
            }
        });
        return shippingMethodList;
    }

    private ListPaymentMethodsResponse.Builder listPaymentMethods(ListPaymentMethodsRequest request) {
        ListPaymentMethodsResponse.Builder builder = ListPaymentMethodsResponse.newBuilder();
        if (request.getCartId() == 0 && Util.isEmpty((String)request.getCartUuid())) {
            throw new AdempiereException("@W_Basket_ID@ @IsMandatory@");
        }
        MStore store = VueStoreFrontUtil.getDefaultStore((int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        if (store == null) {
            throw new AdempiereException("@W_Store_ID@ @NotFound@");
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        Query query = new Query(Env.getCtx(), "C_PaymentMethod", "EXISTS(SELECT 1 FROM C_PaymentMethodAllocation a WHERE a.C_PaymentMethod_ID = C_PaymentMethod.C_PaymentMethod_ID AND a.W_Store_ID = ?)", null).setParameters(new Object[]{store.getW_Store_ID()}).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(paymentMethod -> builder.addPaymentMethods(PaymentMethod.newBuilder().setCode(ValueUtil.validateNull(paymentMethod.getValue())).setName(ValueUtil.validateNull(paymentMethod.getName()))));
        builder.setRecordCount(count);
        if (count > offset && count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private X_W_Basket getCart(int cartId, String cartUuid, boolean isGuest, int userId, String transactionName) {
        String whereClause = "W_Basket_ID = ? AND AD_User_ID = ?";
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (isGuest) {
            whereClause = "UUID = ?";
            parameters.add(cartUuid);
        } else {
            parameters.add(cartId);
            if (userId > 0) {
                parameters.add(userId);
            } else {
                parameters.add(Env.getAD_User_ID((Properties)Env.getCtx()));
            }
        }
        return (X_W_Basket)new Query(Env.getCtx(), "W_Basket", whereClause, null).setParameters(parameters).first();
    }

    private X_W_Basket createCart(boolean isGuest, String transactionName) {
        X_W_Basket basket = null;
        if (!isGuest) {
            basket = (X_W_Basket)new Query(Env.getCtx(), "W_Basket", "AD_User_ID = ?", transactionName).setParameters(new Object[]{Env.getAD_User_ID((Properties)Env.getCtx())}).setOnlyActiveRecords(true).first();
        }
        if (basket == null || basket.getW_Basket_ID() == 0) {
            MUser user;
            basket = new X_W_Basket(Env.getCtx(), 0, transactionName);
            MStore store = VueStoreFrontUtil.getDefaultStore((int)(isGuest ? 0 : Env.getAD_Org_ID((Properties)Env.getCtx())));
            if (store == null) {
                throw new AdempiereException("@W_Store_ID@ @NotFound@");
            }
            basket.setAD_Org_ID(store.getAD_Org_ID());
            basket.setAD_User_ID(isGuest ? store.getSalesRep_ID() : Env.getAD_User_ID((Properties)Env.getCtx()));
            basket.setM_PriceList_ID(store.getM_PriceList_ID());
            if (!isGuest && (user = MUser.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()))).getC_BPartner_ID() != 0) {
                basket.setC_BPartner_ID(user.getC_BPartner_ID());
            }
            basket.saveEx();
        }
        return basket;
    }

    private X_W_BasketLine updateCart(UpdateCartRequest request) {
        AtomicReference cartItem = new AtomicReference();
        Trx.run(transactionName -> {
            MStore store = VueStoreFrontUtil.getDefaultStore((int)(request.getIsGuest() ? 0 : Env.getAD_Org_ID((Properties)Env.getCtx())));
            if (store == null) {
                throw new AdempiereException("@W_Store_ID@ @NotFound@");
            }
            MProduct product = this.getProductFromSku(request.getSku());
            if (product == null || product.getM_Product_ID() == 0) {
                throw new AdempiereException("@M_Product_ID@ @NotFound@");
            }
            X_W_Basket basket = this.getCart(request.getCartId(), request.getCartUuid(), request.getIsGuest(), 0, transactionName);
            List items = new Query(Env.getCtx(), "W_BasketLine", "W_Basket_ID = ?", transactionName).setParameters(new Object[]{basket.getW_Basket_ID()}).list();
            Optional<X_W_BasketLine> basketLine = items.stream().filter(item -> MProduct.get((Properties)Env.getCtx(), (int)item.getM_Product_ID()).getSKU().equals(request.getSku())).findFirst();
            X_W_BasketLine item2 = null;
            if (basketLine.isPresent()) {
                item2 = basketLine.get();
            } else {
                item2 = new X_W_BasketLine(Env.getCtx(), 0, transactionName);
                item2.setW_Basket_ID(basket.getW_Basket_ID());
                item2.setM_Product_ID(product.getM_Product_ID());
                item2.setProduct(product.getName());
            }
            item2.setPrice(Env.ZERO);
            item2.setQty(new BigDecimal(request.getQuantity()));
            item2.setIsActive(true);
            item2.setDescription(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@Created@ @from@ @W_Store_ID@"));
            item2.setLine(items.size() * 10 + 10);
            item2.saveEx(transactionName);
            cartItem.set(item2);
        });
        return (X_W_BasketLine)cartItem.get();
    }

    private Cart.Builder convertCart(X_W_Basket basket, String transactionName) {
        Cart.Builder builder = Cart.newBuilder();
        if (basket == null) {
            return builder;
        }
        MStore store = VueStoreFrontUtil.getDefaultStore((int)basket.getAD_Org_ID());
        if (store == null) {
            throw new AdempiereException("@W_Store_ID@ @NotFound@");
        }
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)store.getM_PriceList_ID(), (String)transactionName);
        MCurrency currency = MCurrency.get((Properties)Env.getCtx(), (int)priceList.getC_Currency_ID());
        builder.setId(basket.getW_Basket_ID()).setUuid(ValueUtil.validateNull(basket.getUUID()));
        List items = new Query(Env.getCtx(), "W_BasketLine", "W_Basket_ID = ?", transactionName).setParameters(new Object[]{basket.getW_Basket_ID()}).list();
        if (items != null && items.size() > 0) {
            AtomicReference<BigDecimal> subtotal = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> subtotalWithDiscount = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> subtotalWithTax = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> discount = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> tax = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> shipping = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> shippingTax = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> grandTotal = new AtomicReference<BigDecimal>(Env.ZERO);
            items.forEach(item -> {
                MProduct product = MProduct.get((Properties)Env.getCtx(), (int)item.getM_Product_ID());
                MTax taxDefinition = MTax.get((Properties)Env.getCtx(), (int)item.get_ValueAsInt("C_Tax_ID"));
                BigDecimal lineListAmount = (BigDecimal)item.get_Value("LineListAmt");
                BigDecimal lineDiscount = (BigDecimal)item.get_Value("LineDiscount");
                BigDecimal lineDiscountRate = (BigDecimal)item.get_Value("LineDiscountAmt");
                BigDecimal lineNetAmount = (BigDecimal)item.get_Value("LineNetAmt");
                BigDecimal taxRate = taxDefinition.getRate();
                BigDecimal taxAmount = (BigDecimal)item.get_Value("TaxAmt");
                BigDecimal lineTotalAmount = (BigDecimal)item.get_Value("LineTotalAmt");
                CartItem.Builder cartItem = CartItem.newBuilder().setProductId(product.getM_Product_ID()).setSku(ValueUtil.validateNull(product.getSKU())).setName(ValueUtil.validateNull(product.getName())).setProductTypeValue(this.getProductTypeFromProduct(product).getNumber()).setQuantity(item.getQty().doubleValue()).setPrice(Optional.ofNullable(item.getPrice()).orElse(Env.ZERO).doubleValue()).setRowTotal(Optional.ofNullable(lineListAmount).orElse(Env.ZERO).doubleValue()).setRowTotalWithDiscount(Optional.ofNullable(lineNetAmount).orElse(Env.ZERO).doubleValue()).setRowTotalInclTax(Optional.ofNullable(lineTotalAmount).orElse(Env.ZERO).doubleValue()).setTaxAmount(Optional.ofNullable(taxAmount).orElse(Env.ZERO).doubleValue()).setTaxPercent(Optional.ofNullable(taxRate).orElse(Env.ZERO).doubleValue()).setDiscountAmount(Optional.ofNullable(lineDiscount).orElse(Env.ZERO).doubleValue()).setDiscountPercent(Optional.ofNullable(lineDiscountRate).orElse(Env.ZERO).doubleValue());
                builder.addItems(cartItem);
                subtotal.updateAndGet(value -> value.add(Optional.ofNullable(lineListAmount).orElse(Env.ZERO)));
                discount.updateAndGet(value -> value.add(Optional.ofNullable(lineDiscount).orElse(Env.ZERO)));
                tax.updateAndGet(value -> value.add(Optional.ofNullable(taxAmount).orElse(Env.ZERO)));
                grandTotal.updateAndGet(value -> value.add(Optional.ofNullable(lineTotalAmount).orElse(Env.ZERO)));
                subtotalWithDiscount.updateAndGet(value -> value.add(Optional.ofNullable(lineNetAmount).orElse(Env.ZERO)));
                subtotalWithTax.updateAndGet(value -> value.add(Optional.ofNullable(lineTotalAmount).orElse(Env.ZERO)));
            });
            List packages = VueStoreFrontUtil.getPackagesFromBasket((Properties)Env.getCtx(), (int)basket.getW_Basket_ID(), (String)transactionName);
            if (packages != null && packages.size() > 0) {
                packages.forEach(packageToCalculate -> {
                    MFreightCategory freightCategory;
                    if (packageToCalculate.getM_FreightCategory_ID() > 0 && (freightCategory = MFreightCategory.getById((Properties)Env.getCtx(), (int)packageToCalculate.getM_FreightCategory_ID(), (String)transactionName)).isInvoiced()) {
                        AtomicReference<BigDecimal> valueToCalulate = new AtomicReference<BigDecimal>(Env.ZERO);
                        if (Util.isEmpty((String)freightCategory.getFreightCalculationType()) || freightCategory.getFreightCalculationType().equals("W")) {
                            valueToCalulate.set(packageToCalculate.getWeight());
                        } else if (freightCategory.getFreightCalculationType().equals("V")) {
                            valueToCalulate.set(packageToCalculate.getVolume());
                        }
                        if (freightCategory.getM_Product_ID() > 0) {
                            MProduct product = MProduct.get((Properties)Env.getCtx(), (int)freightCategory.getM_Product_ID());
                            BigDecimal freightAmount = VueStoreFrontUtil.getPriceStd((MProduct)product, (int)store.getM_PriceList_ID());
                            BigDecimal taxRate = VueStoreFrontUtil.getTaxRate((int)product.getC_TaxCategory_ID());
                            shipping.updateAndGet(value -> value.add(Optional.ofNullable(valueToCalulate.get()).orElse(Env.ZERO).multiply(Optional.ofNullable(freightAmount).orElse(Env.ZERO))));
                            shippingTax.updateAndGet(value -> value.add(Optional.ofNullable(valueToCalulate.get()).orElse(Env.ZERO).multiply(Optional.ofNullable(taxRate).orElse(Env.ZERO))));
                        } else if (freightCategory.getC_Charge_ID() > 0) {
                            MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)freightCategory.getC_Charge_ID());
                            BigDecimal freightAmount = charge.getChargeAmt();
                            BigDecimal taxRate = VueStoreFrontUtil.getTaxRate((int)charge.getC_TaxCategory_ID());
                            shipping.updateAndGet(value -> value.add(Optional.ofNullable(freightAmount).orElse(Env.ZERO)));
                            shippingTax.updateAndGet(value -> value.add(Optional.ofNullable(taxRate).orElse(Env.ZERO)));
                        }
                    }
                });
            }
            builder.setItemsQuantity(items.size()).setBaseCurrencyCode(ValueUtil.validateNull(currency.getISO_Code())).setQuoteCurrencyCode(ValueUtil.validateNull(currency.getISO_Code())).setDiscountAmount(discount.get().doubleValue()).setTaxAmount(tax.get().doubleValue()).setSubtotal(subtotal.get().doubleValue()).setSubtotalInclTax(subtotalWithTax.get().doubleValue()).setSubtotalWithDiscount(subtotalWithDiscount.get().doubleValue()).setGrandTotal(grandTotal.get().doubleValue()).setShippingAmount(shipping.get().doubleValue()).setShippingInclTax(shipping.get().add(shippingTax.get()).doubleValue()).setShippingTaxAmount(shippingTax.get().doubleValue());
        }
        return builder;
    }

    private CartItem.Builder convertCartItem(X_W_BasketLine basketLine) {
        CartItem.Builder cartItem = CartItem.newBuilder();
        if (basketLine == null) {
            return cartItem;
        }
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)basketLine.getM_Product_ID());
        MTax taxDefinition = MTax.get((Properties)Env.getCtx(), (int)basketLine.get_ValueAsInt("C_Tax_ID"));
        BigDecimal lineListAmount = (BigDecimal)basketLine.get_Value("LineListAmt");
        BigDecimal lineDiscount = (BigDecimal)basketLine.get_Value("LineDiscount");
        BigDecimal lineDiscountRate = (BigDecimal)basketLine.get_Value("LineDiscountAmt");
        BigDecimal lineNetAmount = (BigDecimal)basketLine.get_Value("LineNetAmt");
        BigDecimal taxRate = taxDefinition.getRate();
        BigDecimal taxAmount = (BigDecimal)basketLine.get_Value("TaxAmt");
        BigDecimal lineTotalAmount = (BigDecimal)basketLine.get_Value("LineTotalAmt");
        return CartItem.newBuilder().setProductId(product.getM_Product_ID()).setSku(ValueUtil.validateNull(product.getSKU())).setName(ValueUtil.validateNull(product.getName())).setProductTypeValue(this.getProductTypeFromProduct(product).getNumber()).setQuantity(basketLine.getQty().doubleValue()).setPrice(Optional.ofNullable(basketLine.getPrice()).orElse(Env.ZERO).doubleValue()).setRowTotal(Optional.ofNullable(lineListAmount).orElse(Env.ZERO).doubleValue()).setRowTotalWithDiscount(Optional.ofNullable(lineNetAmount).orElse(Env.ZERO).doubleValue()).setRowTotalInclTax(Optional.ofNullable(lineTotalAmount).orElse(Env.ZERO).doubleValue()).setTaxAmount(Optional.ofNullable(taxAmount).orElse(Env.ZERO).doubleValue()).setTaxPercent(Optional.ofNullable(taxRate).orElse(Env.ZERO).doubleValue()).setDiscountAmount(Optional.ofNullable(lineDiscount).orElse(Env.ZERO).doubleValue()).setDiscountPercent(Optional.ofNullable(lineDiscountRate).orElse(Env.ZERO).doubleValue());
    }

    private Customer.Builder updateCustomer(UpdateCustomerRequest request) {
        AtomicReference<Customer.Builder> builder = new AtomicReference<Customer.Builder>(Customer.newBuilder());
        Trx.run(transactionName -> {
            if (Util.isEmpty((String)request.getEmail())) {
                throw new AdempiereException("@EMail@ @IsMandatory@");
            }
            if (Util.isEmpty((String)request.getFirstName())) {
                throw new AdempiereException("@Name@ @IsMandatory@");
            }
            MUser customer = (MUser)new Query(Env.getCtx(), "AD_User", "AD_User_ID = ?", transactionName).setParameters(new Object[]{request.getId()}).first();
            if (customer == null || customer.getAD_User_ID() <= 0) {
                throw new AdempiereException("@UserName@ / @EMail@ @NotFound@");
            }
            customer.setName(request.getFirstName());
            customer.set_ValueOfColumn("Name2", (Object)request.getLastName());
            customer.setEMail(request.getEmail());
            customer.setValue(request.getEmail());
            customer.saveEx(transactionName);
            request.getAddressesList().forEach(address -> {
                boolean isDefaultBilling;
                MRegion region;
                MBPartnerLocation businessPartnerLocation = new MBPartnerLocation(Env.getCtx(), address.getId(), transactionName);
                MCountry country = MCountry.get((Properties)Env.getCtx(), (String)address.getCountryCode());
                if (country == null || country.getC_Country_ID() <= 0) {
                    country = MCountry.getDefault((Properties)Env.getCtx());
                }
                if ((region = (MRegion)new Query(Env.getCtx(), "C_Region", "Name = ?", transactionName).setParameters(new Object[]{address.getRegionName()}).first()) == null || region.getC_Region_ID() <= 0) {
                    region = MRegion.getDefault((Properties)Env.getCtx());
                }
                MLocation location = businessPartnerLocation.getC_BPartner_ID() <= 0 ? new MLocation(country, region) : new MLocation(Env.getCtx(), businessPartnerLocation.getC_Location_ID(), transactionName);
                location.setAddress1(address.getAddress1());
                location.setAddress2(address.getAddress2());
                location.setAddress3(address.getAddress3());
                location.setAddress4(address.getAddress4());
                location.setPostal(address.getPostalCode());
                location.saveEx(transactionName);
                businessPartnerLocation.setName(ValueUtil.validateNull(address.getFirstName()));
                businessPartnerLocation.set_ValueOfColumn("Description", (Object)ValueUtil.validateNull(address.getLastName()));
                businessPartnerLocation.setC_Location_ID(location.getC_Location_ID());
                businessPartnerLocation.setPhone(address.getPhone());
                boolean isDefaultShipping = request.getDefaultShipping() == businessPartnerLocation.getC_BPartner_Location_ID();
                boolean bl = isDefaultBilling = request.getDefaultBilling() == businessPartnerLocation.getC_BPartner_Location_ID();
                if (isDefaultBilling) {
                    businessPartnerLocation.setIsBillTo(isDefaultBilling);
                }
                businessPartnerLocation.set_ValueOfColumn("IsDefaultShipping", (Object)isDefaultShipping);
                businessPartnerLocation.set_ValueOfColumn("IsDefaultBilling", (Object)isDefaultBilling);
                businessPartnerLocation.saveEx(transactionName);
            });
            builder.set(this.convertCustomer(customer));
        });
        return builder.get();
    }

    private Customer.Builder convertCustomer(MUser customer) {
        Customer.Builder builder = Customer.newBuilder();
        builder.setEmail(ValueUtil.validateNull(customer.getEMail())).setFirstName(ValueUtil.validateNull(customer.getName())).setLastName(ValueUtil.validateNull(customer.get_ValueAsString("Name2"))).setId(customer.getAD_User_ID()).setCreated(this.dateConverter.format(customer.getCreated())).setUpdated(this.dateConverter.format(customer.getUpdated())).setOrganizationName(ValueUtil.validateNull(MOrg.get((Properties)Env.getCtx(), (int)customer.getAD_Org_ID()).getName()));
        if (customer.getC_BPartner_ID() > 0) {
            Arrays.asList(((MBPartner)customer.getC_BPartner()).getLocations(true)).forEach(businessPartnerLocation -> builder.addAddresses(this.convertAddress(customer, (MBPartnerLocation)businessPartnerLocation, customer.get_TrxName())));
        }
        return builder;
    }

    private Customer.Builder createCustomer(CreateCustomerRequest request) {
        AtomicReference<Customer.Builder> builder = new AtomicReference<Customer.Builder>(Customer.newBuilder());
        Trx.run(transactionName -> {
            if (Util.isEmpty((String)request.getEmail())) {
                throw new AdempiereException("@EMail@ @IsMandatory@");
            }
            if (Util.isEmpty((String)request.getFirstName())) {
                throw new AdempiereException("@Name@ @IsMandatory@");
            }
            int userId = new Query(Env.getCtx(), "AD_User", "Value = ? OR EMail = ?", transactionName).setParameters(new Object[]{request.getEmail(), request.getEmail()}).firstId();
            if (userId > 0) {
                throw new AdempiereException("@UserName@ / @EMail@ @AlreadyExists@");
            }
            builder.set(this.convertCustomer(this.createUser(request.getFirstName(), request.getLastName(), request.getEmail(), request.getPassword(), transactionName)));
        });
        return builder.get();
    }

    private MUser createUser(String firtName, String lastName, String email, String password, String transactionName) {
        MUser newUser = new MUser(Env.getCtx(), 0, transactionName);
        newUser.setName(firtName);
        newUser.set_ValueOfColumn("Name2", (Object)lastName);
        newUser.setEMail(email);
        newUser.setValue(email);
        newUser.setIsLoginUser(true);
        newUser.setIsInternalUser(false);
        newUser.setIsWebstoreUser(true);
        newUser.saveEx(transactionName);
        if (!Util.isEmpty((String)password)) {
            newUser.setPassword(password);
            newUser.saveEx(transactionName);
        }
        return newUser;
    }

    private Customer.Builder getCustomerInfo(GetCustomerRequest request) {
        AtomicReference<Customer.Builder> builder = new AtomicReference<Customer.Builder>(Customer.newBuilder());
        if (Util.isEmpty((String)request.getClientRequest().getSessionUuid())) {
            throw new AdempiereException("@AD_Session_ID@ @IsMandatory@");
        }
        Trx.run(transactionName -> {
            MUser customer = MUser.get((Properties)Env.getCtx());
            customer.set_TrxName(transactionName);
            builder.set(this.convertCustomer(customer));
        });
        return builder.get();
    }

    private Address.Builder convertAddress(MUser contact, MBPartnerLocation businessPartnerLocation, String transactionName) {
        Address.Builder builder = Address.newBuilder();
        String phone = null;
        if (contact != null) {
            phone = contact.getPhone();
        }
        MLocation location = MLocation.get((Properties)Env.getCtx(), (int)businessPartnerLocation.getC_Location_ID(), (String)transactionName);
        builder.setId(businessPartnerLocation.getC_BPartner_Location_ID()).setCountryCode(MCountry.get((Properties)Env.getCtx(), (int)location.getC_Country_ID()).getCountryCode()).setPostalCode(ValueUtil.validateNull(location.getPostal())).setPhone(ValueUtil.validateNull(Optional.ofNullable(businessPartnerLocation.getPhone()).orElse(Optional.ofNullable(phone).orElse("")))).setFirstName(ValueUtil.validateNull(businessPartnerLocation.getName())).setLastName(ValueUtil.validateNull(businessPartnerLocation.get_ValueAsString("Description"))).setAddress1(ValueUtil.validateNull(location.getAddress1())).setAddress2(ValueUtil.validateNull(location.getAddress2())).setAddress3(ValueUtil.validateNull(location.getAddress3())).setAddress4(ValueUtil.validateNull(location.getAddress4())).setIsDefaultShipping(businessPartnerLocation.isShipTo() && businessPartnerLocation.get_ValueAsBoolean("IsDefaultShipping")).setIsDefaultShipping(businessPartnerLocation.isBillTo() && businessPartnerLocation.get_ValueAsBoolean("IsDefaultBilling"));
        if (location.getC_City_ID() > 0) {
            MCity city = MCity.get((Properties)Env.getCtx(), (int)location.getC_City_ID());
            builder.setCity(City.newBuilder().setId(city.getC_City_ID()).setName(ValueUtil.validateNull(city.getName())));
        } else {
            builder.setCity(City.newBuilder().setName(ValueUtil.validateNull(location.getCity())));
        }
        if (location.getC_Region_ID() > 0) {
            MRegion region = MRegion.get((Properties)Env.getCtx(), (int)location.getC_Region_ID());
            builder.setRegion(Region.newBuilder().setId(region.getC_Region_ID()).setName(ValueUtil.validateNull(region.getName())));
        } else {
            builder.setCity(City.newBuilder().setName(ValueUtil.validateNull(location.getCity())));
        }
        return builder;
    }

    private ResetPasswordResponse.Builder resetPassword(ResetPasswordRequest request) {
        if (Util.isEmpty((String)request.getUserName()) && Util.isEmpty((String)request.getEmail())) {
            throw new AdempiereException("@UserName@ / @EMail@ @IsMandatory@");
        }
        ResetPasswordResponse.Builder builder = ResetPasswordResponse.newBuilder();
        MUser user = (MUser)new Query(Env.getCtx(), "AD_User", "Value type filter text= ? OR EMail = ?", null).setParameters(new Object[]{request.getUserName(), request.getEmail()}).first();
        if (user == null || user.getAD_User_ID() <= 0) {
            builder.setResponseType(ResetPasswordResponse.ResponseType.USER_NOT_FOUND);
            throw new AdempiereException("@UserName@ / @EMail@ @NotFound@");
        }
        try {
            MADToken token = this.generateToken(user);
            this.sendEMail(user, token);
        }
        catch (Exception e) {
            builder.setResponseType(ResetPasswordResponse.ResponseType.ERROR);
            throw new AdempiereException(e.getMessage());
        }
        builder.setResponseType(ResetPasswordResponse.ResponseType.OK);
        return builder;
    }

    private ChangePasswordResponse.Builder changePassword(ChangePasswordRequest request) {
        if (Util.isEmpty((String)request.getClientRequest().getSessionUuid())) {
            throw new AdempiereException("@UserName@ / @EMail@ @IsMandatory@");
        }
        ChangePasswordResponse.Builder builder = ChangePasswordResponse.newBuilder();
        MUser user = MUser.get((Properties)Env.getCtx());
        if (user == null || user.getAD_User_ID() <= 0) {
            builder.setResponseType(ChangePasswordResponse.ResponseType.USER_NOT_FOUND);
            throw new AdempiereException("@UserName@ / @EMail@ @NotFound@");
        }
        Login loginTest = new Login(Env.getCtx());
        if (loginTest.getAuthenticatedUserId(user.getValue(), request.getCurrentPassword()) == -1) {
            builder.setResponseType(ChangePasswordResponse.ResponseType.USER_NOT_FOUND);
            throw new AdempiereException("@UserName@ / @EMail@ @NotFound@");
        }
        user.setPassword(request.getNewPassword());
        user.saveEx();
        builder.setResponseType(ChangePasswordResponse.ResponseType.OK);
        return builder;
    }

    private void sendEMail(MUser user, MADToken token) {
        MClient client = MClient.get((Properties)user.getCtx(), (int)user.getAD_Client_ID());
        MClientInfo clientInfo = client.getInfo();
        int mailTextId = clientInfo.getRestorePassword_MailText_ID();
        if (mailTextId <= 0) {
            throw new AdempiereException("@RestorePassword_MailText_ID@ @NotFound@");
        }
        MMailText text = new MMailText(Env.getCtx(), mailTextId, null);
        text.setPO((PO)token);
        text.setUser(user);
        EMail email = client.createEMail(user.getEMail(), null, null);
        String msg = null;
        if (!email.isValid()) {
            msg = "@RequestActionEMailError@ Invalid EMail: " + user;
            throw new AdempiereException("@RequestActionEMailError@ Invalid EMail: " + user);
        }
        String message = text.getMailText(true);
        email.setMessageHTML(text.getMailHeader(), message);
        msg = email.send();
        MUserMail userMail = new MUserMail(text, user.getAD_User_ID(), email);
        userMail.saveEx();
        if (!msg.equals("OK")) {
            throw new AdempiereException(user.getName() + " @RequestActionEMailError@ " + msg);
        }
    }

    private MADToken generateToken(MUser user) throws Exception {
        if (user == null) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)user.getEMail())) {
            throw new AdempiereException("@AD_User_ID@ - @Email@ @NotFound@");
        }
        TokenGeneratorHandler.getInstance().generateToken("URL", user.getAD_User_ID());
        return TokenGeneratorHandler.getInstance().getToken("URL");
    }

    private MProduct getProductFromSku(String sku) {
        if (Util.isEmpty((String)sku)) {
            throw new AdempiereException("@SKU@ @IsMandatory@");
        }
        MProduct product = null;
        String key = Env.getAD_Client_ID((Properties)Env.getCtx()) + "|";
        if (!Util.isEmpty((String)sku) && (product = (MProduct)productCache.get((Object)(key = key + "SKU|" + sku.trim()))) == null) {
            product = (MProduct)new Query(Env.getCtx(), "M_Product", "(UPPER(SKU) = UPPER(?))", null).setParameters(new Object[]{sku.trim()}).setClient_ID().setOnlyActiveRecords(true).first();
        }
        if (product == null) {
            throw new AdempiereException("@M_Product_ID@ @NotFound@");
        }
        productCache.put((Object)key, product);
        return product;
    }

    private Stock.Builder getStockFromSku(GetStockRequest request) {
        MProduct product = this.getProductFromSku(request.getSku());
        Stock.Builder builder = Stock.newBuilder();
        Optional<MStorage> maybeStorage = Arrays.asList(MStorage.getOfProduct((Properties)Env.getCtx(), (int)product.getM_Product_ID(), null)).stream().filter(storage -> storage.getQtyOnHand().signum() > 0).reduce(StockSummary::add);
        if (maybeStorage.isPresent()) {
            builder = this.convertStock(maybeStorage.get());
        }
        return builder;
    }

    private ListProductsResponse.Builder listProducts(ListProductsRequest request) {
        ListProductsResponse.Builder builder = ListProductsResponse.newBuilder();
        if (request.getSkusCount() == 0) {
            throw new AdempiereException("@SKU@ @IsMandatory@");
        }
        MStore store = VueStoreFrontUtil.getDefaultStore((int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        if (store == null) {
            throw new AdempiereException("@W_Store_ID@ @NotFound@");
        }
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)store.getM_PriceList_ID(), null);
        Timestamp validFrom = TimeUtil.getDay((long)System.currentTimeMillis());
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        StringBuffer whereClause = new StringBuffer("SKU IN(");
        AtomicBoolean first = new AtomicBoolean(true);
        ArrayList<Boolean> parameters = new ArrayList<Boolean>();
        request.getSkusList().forEach(sku -> {
            if (first.get()) {
                first.set(false);
            } else {
                whereClause.append(", ");
            }
            whereClause.append("?");
            parameters.add((Boolean)((Object)sku.trim()));
        });
        whereClause.append(")");
        whereClause.append(" AND ").append("IsWebStoreFeatured").append(" = ").append("?");
        parameters.add(true);
        Query query = new Query(Env.getCtx(), "M_Product", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(product -> builder.addProducts(this.convertProduct((MProduct)product, priceList, validFrom)));
        builder.setRecordCount(count);
        if (count > offset && count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListRenderProductsResponse.Builder listRenderProducts(ListRenderProductsRequest request) {
        ListRenderProductsResponse.Builder builder = ListRenderProductsResponse.newBuilder();
        if (request.getSkusCount() == 0) {
            throw new AdempiereException("@SKU@ @IsMandatory@");
        }
        MStore store = VueStoreFrontUtil.getDefaultStore((int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        if (store == null) {
            throw new AdempiereException("@W_Store_ID@ @NotFound@");
        }
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)store.getM_PriceList_ID(), null);
        Timestamp validFrom = TimeUtil.getDay((long)System.currentTimeMillis());
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        StringBuffer whereClause = new StringBuffer("SKU IN(");
        AtomicBoolean first = new AtomicBoolean(true);
        ArrayList parameters = new ArrayList();
        request.getSkusList().forEach(sku -> {
            if (first.get()) {
                first.set(false);
            } else {
                whereClause.append(", ");
            }
            whereClause.append("?");
            parameters.add(sku.trim());
        });
        whereClause.append(")");
        Query query = new Query(Env.getCtx(), "M_Product", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(product -> builder.addRenderProducts(this.convertRenderProduct((MProduct)product, priceList, validFrom)));
        builder.setRecordCount(count);
        if (count > offset && count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private RenderProduct.Builder convertRenderProduct(MProduct product, MPriceList productPriceList, Timestamp validFrom) {
        RenderProduct.Builder builder = RenderProduct.newBuilder();
        MProductPricing productPricing = new MProductPricing(product.getM_Product_ID(), 0, Env.ZERO, true, null);
        productPricing.setM_PriceList_ID(productPriceList.getM_PriceList_ID());
        productPricing.setPriceDate(validFrom);
        int taxCategoryId = product.getC_TaxCategory_ID();
        BigDecimal taxRate = Env.ZERO;
        Optional<MTax> optionalTax = Arrays.asList(MTax.getAll((Properties)Env.getCtx())).stream().filter(tax -> tax.getC_TaxCategory_ID() == taxCategoryId && (tax.isSalesTax() || !Util.isEmpty((String)tax.getSOPOType()) && (tax.getSOPOType().equals("B") || tax.getSOPOType().equals("S")))).findFirst();
        if (optionalTax.isPresent()) {
            taxRate = optionalTax.get().getRate();
        }
        taxRate = taxRate.divide(Env.ONEHUNDRED).add(Env.ONE);
        BigDecimal basePriceList = productPricing.getPriceList();
        BigDecimal priceList = productPricing.getPriceList();
        BigDecimal basePriceStd = productPricing.getPriceStd();
        BigDecimal priceStd = productPricing.getPriceStd();
        BigDecimal basePriceLimit = productPricing.getPriceLimit();
        BigDecimal priceLimit = productPricing.getPriceLimit();
        if (taxRate.signum() != 0) {
            if (productPriceList.isTaxIncluded()) {
                basePriceList = basePriceList.divide(taxRate, MathContext.DECIMAL128);
                basePriceStd = basePriceStd.divide(taxRate, MathContext.DECIMAL128);
                basePriceLimit = basePriceLimit.divide(taxRate, MathContext.DECIMAL128);
            } else {
                priceList = basePriceList.multiply(taxRate);
                priceStd = basePriceStd.multiply(taxRate);
                priceLimit = basePriceLimit.multiply(taxRate);
            }
        }
        MCurrency currency = MCurrency.get((Properties)Env.getCtx(), (int)productPriceList.getC_Currency_ID());
        return builder.setId(product.getM_Product_ID()).setName(ValueUtil.validateNull(product.getName())).setStoreId(Env.getAD_Org_ID((Properties)Env.getCtx())).setUrl(ValueUtil.validateNull(product.getDescriptionURL())).setProductType(this.getProductTypeFromProduct(product)).setPriceInfo(PriceInfo.newBuilder().setMaxPrice(priceList.setScale(productPricing.getPrecision(), 0).doubleValue()).setMaxRegularPrice(priceList.setScale(productPricing.getPrecision(), 0).doubleValue()).setFinalPrice(priceStd.setScale(productPricing.getPrecision(), 0).doubleValue()).setSpecialPrice(priceStd.setScale(productPricing.getPrecision(), 0).doubleValue()).setRegularPrice(priceStd.setScale(productPricing.getPrecision(), 0).doubleValue()).setMinimalRegularPrice(priceLimit.setScale(productPricing.getPrecision(), 0).doubleValue()).setMinimalPrice(priceLimit.setScale(productPricing.getPrecision(), 0).doubleValue()).setCurrencyCode(MCurrency.getISO_Code((Properties)Env.getCtx(), (int)productPriceList.getC_Currency_ID())).setFormattedPrice(FormattedPrice.newBuilder().setMaxPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(priceList) + "</span>").setMaxRegularPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(priceList) + "</span>").setFinalPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(priceStd) + "</span>").setSpecialPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(priceStd) + "</span>").setRegularPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(priceStd) + "</span>").setMinimalRegularPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(priceLimit) + "</span>").setMinimalPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(priceLimit) + "</span>")).setTaxAdjustment(TaxAdjustment.newBuilder().setMaxPrice(basePriceList.setScale(productPricing.getPrecision(), 0).doubleValue()).setMaxRegularPrice(basePriceList.setScale(productPricing.getPrecision(), 0).doubleValue()).setFinalPrice(basePriceStd.setScale(productPricing.getPrecision(), 0).doubleValue()).setSpecialPrice(basePriceStd.setScale(productPricing.getPrecision(), 0).doubleValue()).setRegularPrice(basePriceStd.setScale(productPricing.getPrecision(), 0).doubleValue()).setMinimalRegularPrice(basePriceLimit.setScale(productPricing.getPrecision(), 0).doubleValue()).setMinimalPrice(basePriceLimit.setScale(productPricing.getPrecision(), 0).doubleValue()).setFormattedPrice(FormattedPrice.newBuilder().setMaxPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(basePriceList) + "</span>").setMaxRegularPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(basePriceList) + "</span>").setFinalPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(basePriceStd) + "</span>").setSpecialPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(basePriceStd) + "</span>").setRegularPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(basePriceStd) + "</span>").setMinimalRegularPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(basePriceLimit) + "</span>").setMinimalPrice("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(basePriceLimit) + "</span>")).setWeeeAdjustment("<span class=\"price\">" + currency.getCurSymbol() + DisplayType.getNumberFormat((int)37).format(priceStd) + "</span>")));
    }

    private RenderProduct.ProductType getProductTypeFromProduct(MProduct product) {
        if (Util.isEmpty((String)product.getProductType())) {
            return RenderProduct.ProductType.SIMPLE;
        }
        if (product.getProductType().equals("I") && product.isStocked() && product.getM_AttributeSet_ID() > 0) {
            return RenderProduct.ProductType.CONFIGURABLE;
        }
        if (product.getProductType().equals("I") && product.isStocked() && product.isBOM()) {
            return RenderProduct.ProductType.GROUPED;
        }
        if (product.getProductType().equals("S")) {
            return RenderProduct.ProductType.CONFIGURABLE;
        }
        if (product.getProductType().equals("I") && !product.isStocked() && product.isBOM()) {
            return RenderProduct.ProductType.GROUPED;
        }
        if (product.getProductType().equals("S") && product.getM_Product_Category().getA_Asset_Group_ID() > 0) {
            return RenderProduct.ProductType.DOWNLOADABLE;
        }
        if ((product.getProductType().equals("I") || product.getProductType().equals("S")) && product.getR_MailText_ID() > 0) {
            return RenderProduct.ProductType.GIFT;
        }
        return RenderProduct.ProductType.SIMPLE;
    }

    private Product.Builder convertProduct(MProduct product, MPriceList priceList, Timestamp validFrom) {
        Product.Builder builder = Product.newBuilder();
        MProductPricing productPricing = new MProductPricing(product.getM_Product_ID(), 0, Env.ZERO, true, null);
        productPricing.setM_PriceList_ID(priceList.getM_PriceList_ID());
        productPricing.setPriceDate(validFrom);
        return builder.setId(product.getM_Product_ID()).setSku(ValueUtil.validateNull(product.getSKU())).setName(ValueUtil.validateNull(product.getName())).setStatus(Product.Status.ENABLED).setVisibility(Product.Visibility.BOTH).setProductGroupId(product.getM_Product_Group_ID()).setCreated(this.dateConverter.format(product.getCreated())).setUpdated(this.dateConverter.format(product.getUpdated())).setPrice(productPricing.getPriceStd().setScale(productPricing.getPrecision()).doubleValue()).addCustomAttributes(Attribute.newBuilder().setAttributeCode("description").setValue(ValueUtil.validateNull(product.getDescription())));
    }

    private ListStocksResponse.Builder listStocks(ListStocksRequest request) {
        MProduct product = this.getProductFromSku(request.getSku());
        ListStocksResponse.Builder builder = ListStocksResponse.newBuilder();
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        Query query = new Query(Env.getCtx(), "M_Storage", "M_Product_ID = ? AND QtyOnHand > 0", null).setParameters(new Object[]{product.getM_Product_ID()}).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(storage -> builder.addStocks(this.convertStock((MStorage)storage)));
        builder.setRecordCount(count);
        if (count > offset && count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private Stock.Builder convertStock(MStorage storage) {
        Stock.Builder builder = Stock.newBuilder();
        BigDecimal quantityOnHand = Env.ZERO;
        BigDecimal quantityReserved = Env.ZERO;
        if (storage == null) {
            return builder;
        }
        if (storage.getQtyOnHand() != null) {
            quantityOnHand = storage.getQtyOnHand();
        }
        if (storage.getQtyReserved() != null) {
            quantityReserved = storage.getQtyReserved();
        }
        builder.setIsInStock(quantityOnHand.signum() > 0);
        builder.setQuantity(quantityOnHand.doubleValue());
        if (quantityReserved.signum() < 0) {
            builder.setQuantity(quantityReserved.abs().doubleValue());
        }
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)storage.getM_Product_ID());
        MUOM unitOfMeasure = MUOM.get((Properties)Env.getCtx(), (int)product.getC_UOM_ID());
        builder.setIsDecimalQuantity(unitOfMeasure.getStdPrecision() != 0);
        builder.setProductId(storage.getM_Product_ID());
        MStore store = VueStoreFrontUtil.getDefaultStore((int)storage.getAD_Org_ID());
        if (store != null) {
            builder.setStoreId(store.getW_Store_ID());
        }
        builder.setIsManageStock(product.isStocked());
        return builder;
    }

    private static final class StockSummary {
        private StockSummary() {
        }

        public static MStorage add(MStorage previousValue, MStorage newValue) {
            previousValue.setQtyOnHand(previousValue.getQtyOnHand().add(newValue.getQtyOnHand()));
            previousValue.setQtyReserved(previousValue.getQtyReserved().add(newValue.getQtyReserved()));
            return previousValue;
        }
    }
}

