/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.MView;
import org.adempiere.model.MViewColumn;
import org.adempiere.model.MViewDefinition;
import org.adempiere.model.ZoomInfoFactory;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridTab;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MAttachment;
import org.compiere.model.MChangeLog;
import org.compiere.model.MChat;
import org.compiere.model.MChatEntry;
import org.compiere.model.MClientInfo;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MMessage;
import org.compiere.model.MPreference;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MQuery;
import org.compiere.model.MRecordAccess;
import org.compiere.model.MRefList;
import org.compiere.model.MReportView;
import org.compiere.model.MRole;
import org.compiere.model.MRule;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MWindow;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.MimeType;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.base.util.ContextManager;
import org.spin.base.util.ConvertUtil;
import org.spin.base.util.DictionaryUtil;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ReferenceUtil;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.Attachment;
import org.spin.grpc.util.Callout;
import org.spin.grpc.util.ChatEntry;
import org.spin.grpc.util.ContextInfoValue;
import org.spin.grpc.util.CreateChatEntryRequest;
import org.spin.grpc.util.Criteria;
import org.spin.grpc.util.DefaultValue;
import org.spin.grpc.util.DeletePreferenceRequest;
import org.spin.grpc.util.DrillTable;
import org.spin.grpc.util.Empty;
import org.spin.grpc.util.Entity;
import org.spin.grpc.util.GetAttachmentRequest;
import org.spin.grpc.util.GetContextInfoValueRequest;
import org.spin.grpc.util.GetDefaultValueRequest;
import org.spin.grpc.util.GetLookupItemRequest;
import org.spin.grpc.util.GetPrivateAccessRequest;
import org.spin.grpc.util.GetRecordAccessRequest;
import org.spin.grpc.util.GetReportOutputRequest;
import org.spin.grpc.util.GetResourceReferenceRequest;
import org.spin.grpc.util.GetResourceRequest;
import org.spin.grpc.util.KeyValue;
import org.spin.grpc.util.ListBrowserItemsRequest;
import org.spin.grpc.util.ListBrowserItemsResponse;
import org.spin.grpc.util.ListDrillTablesRequest;
import org.spin.grpc.util.ListDrillTablesResponse;
import org.spin.grpc.util.ListLookupItemsRequest;
import org.spin.grpc.util.ListLookupItemsResponse;
import org.spin.grpc.util.ListPrintFormatsRequest;
import org.spin.grpc.util.ListPrintFormatsResponse;
import org.spin.grpc.util.ListReferencesRequest;
import org.spin.grpc.util.ListReferencesResponse;
import org.spin.grpc.util.ListReportViewsRequest;
import org.spin.grpc.util.ListReportViewsResponse;
import org.spin.grpc.util.ListTabEntitiesRequest;
import org.spin.grpc.util.ListTabEntitiesResponse;
import org.spin.grpc.util.ListTranslationsRequest;
import org.spin.grpc.util.ListTranslationsResponse;
import org.spin.grpc.util.LockPrivateAccessRequest;
import org.spin.grpc.util.LookupItem;
import org.spin.grpc.util.Preference;
import org.spin.grpc.util.PrintFormat;
import org.spin.grpc.util.PrivateAccess;
import org.spin.grpc.util.RecordAccess;
import org.spin.grpc.util.RecordAccessRole;
import org.spin.grpc.util.RecordReferenceInfo;
import org.spin.grpc.util.ReportOutput;
import org.spin.grpc.util.ReportView;
import org.spin.grpc.util.Resource;
import org.spin.grpc.util.ResourceReference;
import org.spin.grpc.util.RollbackEntityRequest;
import org.spin.grpc.util.RunCalloutRequest;
import org.spin.grpc.util.SetPreferenceRequest;
import org.spin.grpc.util.SetRecordAccessRequest;
import org.spin.grpc.util.Translation;
import org.spin.grpc.util.UnlockPrivateAccessRequest;
import org.spin.grpc.util.UserInterfaceGrpc;
import org.spin.grpc.util.Value;
import org.spin.model.MADAttachmentReference;
import org.spin.model.MADContextInfo;
import org.spin.util.ASPUtil;
import org.spin.util.AbstractExportFormat;
import org.spin.util.AttachmentUtil;
import org.spin.util.ReportExportHandler;

public class UserInterfaceServiceImplementation
extends UserInterfaceGrpc.UserInterfaceImplBase {
    private CLogger log = CLogger.getCLogger(UserInterfaceServiceImplementation.class);
    private final String KEY_COLUMN_KEY = "KeyColumn";
    private final String DISPLAY_COLUMN_KEY = "DisplayColumn";
    private final String VALUE_COLUMN_KEY = "ValueColumn";
    private static CCache<String, MBrowse> browserRequested = new CCache("AD_Browse_UUID", 30, 0);
    private static CCache<String, MTab> tabRequested = new CCache("AD_Tab_UUID", 30, 0);
    private static CCache<String, String> referenceWhereClauseCache = new CCache("Reference_WhereClause", 30, 0);
    private AtomicInteger windowNoEmulation = new AtomicInteger(1);

    @Override
    public void rollbackEntity(RollbackEntityRequest request, StreamObserver<Entity> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Rollback Requested = " + request.getId());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Entity.Builder entityValue = this.rollbackLastEntityAction(request);
            responseObserver.onNext((Object)entityValue.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void runCallout(RunCalloutRequest request, StreamObserver<Callout> responseObserver) {
        try {
            if (request == null || Util.isEmpty((String)request.getCallout())) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Callout Requested = " + request.getCallout());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Callout.Builder calloutResponse = this.runcallout(request);
            responseObserver.onNext((Object)calloutResponse.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getLookupItem(GetLookupItemRequest request, StreamObserver<LookupItem> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Lookup Requested = " + request.getUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            LookupItem.Builder lookupValue = this.convertLookupItem(request);
            responseObserver.onNext((Object)lookupValue.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listLookupItems(ListLookupItemsRequest request, StreamObserver<ListLookupItemsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Lookup Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListLookupItemsResponse.Builder entityValueList = this.convertLookupItemsList(request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listBrowserItems(ListBrowserItemsRequest request, StreamObserver<ListBrowserItemsResponse> responseObserver) {
        try {
            if (request == null || Util.isEmpty((String)request.getUuid())) {
                throw new AdempiereException("Browser Requested is Null");
            }
            this.log.fine("Object List Requested = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListBrowserItemsResponse.Builder entityValueList = this.convertBrowserList(request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listReferences(ListReferencesRequest request, StreamObserver<ListReferencesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Process Activity Requested is Null");
            }
            this.log.fine("References Info Requested = " + request);
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListReferencesResponse.Builder entityValueList = this.convertRecordReferences(context, request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getDefaultValue(GetDefaultValueRequest request, StreamObserver<DefaultValue> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            DefaultValue.Builder defaultValue = this.getInfoFromDefaultValueRequest(request);
            responseObserver.onNext((Object)defaultValue.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void lockPrivateAccess(LockPrivateAccessRequest request, StreamObserver<PrivateAccess> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            int recordId = request.getId();
            if (recordId <= 0 && Util.isEmpty((String)request.getUuid())) {
                throw new AdempiereException("@Record_ID@ / @UUID@ @NotFound@");
            }
            if (recordId <= 0) {
                recordId = RecordUtil.getIdFromUuid(request.getTableName(), request.getUuid(), null);
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            MUser user = MUser.get((Properties)context);
            PrivateAccess.Builder privateaccess = this.lockUnlockPrivateAccess(context, request.getTableName(), recordId, user.getAD_User_ID(), true, null);
            responseObserver.onNext((Object)privateaccess.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void unlockPrivateAccess(UnlockPrivateAccessRequest request, StreamObserver<PrivateAccess> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            int recordId = request.getId();
            if (recordId <= 0 && Util.isEmpty((String)request.getUuid())) {
                throw new AdempiereException("@Record_ID@ / @UUID@ @NotFound@");
            }
            if (recordId <= 0) {
                recordId = RecordUtil.getIdFromUuid(request.getTableName(), request.getUuid(), null);
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            MUser user = MUser.get((Properties)context);
            PrivateAccess.Builder privateaccess = this.lockUnlockPrivateAccess(context, request.getTableName(), recordId, user.getAD_User_ID(), false, null);
            responseObserver.onNext((Object)privateaccess.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getPrivateAccess(GetPrivateAccessRequest request, StreamObserver<PrivateAccess> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            int recordId = request.getId();
            if (recordId <= 0 && Util.isEmpty((String)request.getUuid())) {
                throw new AdempiereException("@Record_ID@ / @UUID@ @NotFound@");
            }
            if (recordId <= 0) {
                recordId = RecordUtil.getIdFromUuid(request.getTableName(), request.getUuid(), null);
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            MUser user = MUser.get((Properties)context);
            MPrivateAccess privateAccess = this.getPrivateAccess(context, request.getTableName(), recordId, user.getAD_User_ID(), null);
            if (privateAccess == null || privateAccess.getAD_Table_ID() == 0) {
                MTable table = MTable.get((Properties)context, (String)request.getTableName());
                privateAccess = new MPrivateAccess(context, user.getAD_User_ID(), table.getAD_Table_ID(), recordId);
                privateAccess.setIsActive(false);
            }
            PrivateAccess.Builder privateaccess = this.convertPrivateAccess(context, privateAccess);
            responseObserver.onNext((Object)privateaccess.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getContextInfoValue(GetContextInfoValueRequest request, StreamObserver<ContextInfoValue> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ContextInfoValue.Builder contextInfoValue = this.convertContextInfoValue(context, request);
            responseObserver.onNext((Object)contextInfoValue.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listTranslations(ListTranslationsRequest request, StreamObserver<ListTranslationsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListTranslationsResponse.Builder translationsList = this.convertTranslationsList(context, request);
            responseObserver.onNext((Object)translationsList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listPrintFormats(ListPrintFormatsRequest request, StreamObserver<ListPrintFormatsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListPrintFormatsResponse.Builder printFormatsList = this.convertPrintFormatsList(context, request);
            responseObserver.onNext((Object)printFormatsList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listReportViews(ListReportViewsRequest request, StreamObserver<ListReportViewsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListReportViewsResponse.Builder reportViewsList = this.convertReportViewsList(context, request);
            responseObserver.onNext((Object)reportViewsList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listDrillTables(ListDrillTablesRequest request, StreamObserver<ListDrillTablesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListDrillTablesResponse.Builder drillTablesList = this.convertDrillTablesList(request);
            responseObserver.onNext((Object)drillTablesList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getReportOutput(GetReportOutputRequest request, StreamObserver<ReportOutput> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ReportOutput.Builder reportOutput = this.getReportOutput(request);
            responseObserver.onNext((Object)reportOutput.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createChatEntry(CreateChatEntryRequest request, StreamObserver<ChatEntry> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ChatEntry.Builder chatEntryValue = this.addChatEntry(context, request);
            responseObserver.onNext((Object)chatEntryValue.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getResource(GetResourceRequest request, StreamObserver<Resource> responseObserver) {
        try {
            if (request == null || Util.isEmpty((String)request.getResourceUuid()) && Util.isEmpty((String)request.getResourceName())) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Download Requested = " + request.getResourceUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            this.getResource(request.getResourceUuid(), request.getResourceName(), responseObserver);
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private void getResource(String resourceUuid, String resourceName, StreamObserver<Resource> responseObserver) throws Exception {
        int length;
        if (!AttachmentUtil.getInstance().isValidForClient(Env.getAD_Client_ID((Properties)Env.getCtx()))) {
            responseObserver.onError((Throwable)new AdempiereException("@NotFound@"));
            return;
        }
        if (!Util.isEmpty((String)resourceName)) {
            MClientInfo clientInfo = MClientInfo.get((Properties)Env.getCtx());
            MADAttachmentReference reference = (MADAttachmentReference)new Query(Env.getCtx(), "AD_AttachmentReference", "(UUID || '-' || FileName) = ? AND FileHandler_ID = ?", null).setOrderBy("AD_Attachment_ID DESC").setParameters(new Object[]{resourceName, clientInfo.getFileHandler_ID()}).first();
            if (reference == null || reference.getAD_AttachmentReference_ID() <= 0) {
                responseObserver.onError((Throwable)new AdempiereException("@NotFound@"));
                return;
            }
            resourceUuid = reference.getUUID();
        } else if (Util.isEmpty((String)resourceUuid)) {
            responseObserver.onError((Throwable)new AdempiereException("@NotFound@"));
            return;
        }
        byte[] data = AttachmentUtil.getInstance().withClientId(Env.getAD_Client_ID((Properties)Env.getCtx())).withAttachmentReferenceId(RecordUtil.getIdFromUuid("AD_AttachmentReference", resourceUuid, null)).getAttachment();
        if (data == null) {
            responseObserver.onError((Throwable)new AdempiereException("@NotFound@"));
            return;
        }
        int bufferSize = 262144;
        byte[] buffer = new byte[bufferSize];
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        while ((length = ((InputStream)is).read(buffer, 0, bufferSize)) != -1) {
            responseObserver.onNext((Object)Resource.newBuilder().setData(ByteString.copyFrom((byte[])buffer, (int)0, (int)length)).build());
        }
        responseObserver.onCompleted();
    }

    @Override
    public void getResourceReference(GetResourceReferenceRequest request, StreamObserver<ResourceReference> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ResourceReference.Builder resourceReference = this.getResourceReferenceFromImageId(request.getImageId());
            responseObserver.onNext((Object)resourceReference.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getAttachment(GetAttachmentRequest request, StreamObserver<Attachment> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Attachment.Builder attachment = this.getAttachmentFromEntity(request);
            responseObserver.onNext((Object)attachment.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void setPreference(SetPreferenceRequest request, StreamObserver<Preference> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            MPreference preference = this.getPreference(request.getTypeValue(), request.getColumnName(), request.getIsForCurrentClient(), request.getIsForCurrentOrganization(), request.getIsForCurrentUser(), request.getIsForCurrentContainer(), request.getContainerUuid());
            if (preference == null || preference.getAD_Preference_ID() <= 0) {
                preference = new MPreference(Env.getCtx(), 0, null);
            }
            Preference.Builder preferenceBuilder = this.savePreference(preference, request.getTypeValue(), request.getColumnName(), request.getIsForCurrentClient(), request.getIsForCurrentOrganization(), request.getIsForCurrentUser(), request.getIsForCurrentContainer(), request.getContainerUuid(), request.getValue());
            responseObserver.onNext((Object)preferenceBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void deletePreference(DeletePreferenceRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder empty = Empty.newBuilder();
            MPreference preference = this.getPreference(request.getTypeValue(), request.getColumnName(), request.getIsForCurrentClient(), request.getIsForCurrentOrganization(), request.getIsForCurrentUser(), request.getIsForCurrentContainer(), request.getContainerUuid());
            if (preference != null && preference.getAD_Preference_ID() > 0) {
                preference.deleteEx(true);
            }
            responseObserver.onNext((Object)empty.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getRecordAccess(GetRecordAccessRequest request, StreamObserver<RecordAccess> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            RecordAccess.Builder recordAccess = this.convertRecordAccess(request);
            responseObserver.onNext((Object)recordAccess.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void setRecordAccess(SetRecordAccessRequest request, StreamObserver<RecordAccess> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            RecordAccess.Builder recordAccess = this.saveRecordAccess(request);
            responseObserver.onNext((Object)recordAccess.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listTabEntities(ListTabEntitiesRequest request, StreamObserver<ListTabEntitiesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListTabEntitiesResponse.Builder entityValueList = this.convertEntitiesList(context, request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private ListTabEntitiesResponse.Builder convertEntitiesList(Properties context, ListTabEntitiesRequest request) {
        String referenceWhereClause;
        int tabId = RecordUtil.getIdFromUuid("AD_Tab", request.getTabUuid(), null);
        if (tabId <= 0) {
            throw new AdempiereException("@AD_Tab_ID@ @NotFound@");
        }
        MTab tab = MTab.get((Properties)context, (int)tabId);
        String tableName = MTable.getTableName((Properties)context, (int)tab.getAD_Table_ID());
        int windowNo = ThreadLocalRandom.current().nextInt(1, 8997);
        Env.clearWinContext((int)windowNo);
        Map<String, Object> attributes = ValueUtil.convertValuesToObjects(request.getContextAttributesList());
        attributes.entrySet().forEach(attribute -> {
            if (attribute.getValue() instanceof Integer) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (int)((Integer)attribute.getValue()));
            } else if (attribute.getValue() instanceof Timestamp) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (Timestamp)((Timestamp)attribute.getValue()));
            } else if (attribute.getValue() instanceof Boolean) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (boolean)((Boolean)attribute.getValue()));
            } else if (attribute.getValue() instanceof String) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (String)((String)attribute.getValue()));
            }
        });
        String where = Env.parseContext((Properties)context, (int)windowNo, (String)tab.getWhereClause(), (boolean)false);
        if (Util.isEmpty((String)where) && !Util.isEmpty((String)tab.getWhereClause())) {
            throw new AdempiereException("@AD_Tab_ID@ @WhereClause@ @Unparseable@");
        }
        Criteria criteria = request.getFilters();
        StringBuffer whereClause = new StringBuffer(where);
        ArrayList<Object> params = new ArrayList<Object>();
        String dynamicWhere = ValueUtil.getWhereClauseFromCriteria(criteria, tableName, params);
        if (!Util.isEmpty((String)dynamicWhere)) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append(dynamicWhere);
        }
        if (!Util.isEmpty((String)criteria.getReferenceUuid()) && !Util.isEmpty((String)(referenceWhereClause = (String)referenceWhereClauseCache.get((Object)criteria.getReferenceUuid())))) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(").append(referenceWhereClause).append(")");
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int count = 0;
        ListTabEntitiesResponse.Builder builder = ListTabEntitiesResponse.newBuilder();
        StringBuilder sql = new StringBuilder(DictionaryUtil.getQueryWithReferencesFromTab(tab));
        if (whereClause.length() > 0) {
            sql.append(" WHERE ").append(whereClause);
        }
        String parsedSQL = MRole.getDefault().addAccessSQL(sql.toString(), null, true, false);
        String orderByClause = criteria.getOrderByClause();
        orderByClause = Util.isEmpty((String)orderByClause) ? "" : " ORDER BY " + orderByClause;
        count = RecordUtil.countRecords(parsedSQL, tableName, params);
        parsedSQL = parsedSQL + " AND ROWNUM >= " + offset + " AND ROWNUM <= " + limit;
        parsedSQL = parsedSQL + orderByClause;
        builder = this.convertListEntitiesResult(MTable.get((Properties)context, (String)tableName), parsedSQL, params);
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListTabEntitiesResponse.Builder convertListEntitiesResult(MTable table, String sql, List<Object> params) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ListTabEntitiesResponse.Builder builder = ListTabEntitiesResponse.newBuilder();
        long recordCount = 0L;
        try {
            LinkedHashMap<String, MColumn> columnsMap = new LinkedHashMap<String, MColumn>();
            for (Object column : table.getColumnsAsList()) {
                columnsMap.put(column.getColumnName().toUpperCase(), (MColumn)column);
            }
            pstmt = DB.prepareStatement((String)sql, null);
            AtomicInteger parameterIndex = new AtomicInteger(1);
            for (Object e : params) {
                ValueUtil.setParameterFromObject((PreparedStatement)pstmt, e, parameterIndex.getAndIncrement());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Entity.Builder valueObjectBuilder = Entity.newBuilder();
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                for (int index = 1; index <= resultSetMetaData.getColumnCount(); ++index) {
                    try {
                        String columnName = resultSetMetaData.getColumnName(index);
                        MColumn field = (MColumn)columnsMap.get(columnName.toUpperCase());
                        Value.Builder valueBuilder = Value.newBuilder();
                        if (field == null) {
                            String value = rs.getString(index);
                            if (Util.isEmpty((String)value)) continue;
                            valueBuilder = ValueUtil.getValueFromString(value);
                            valueObjectBuilder.putValues(columnName, valueBuilder.build());
                            continue;
                        }
                        String fieldColumnName = field.getColumnName();
                        valueBuilder = ValueUtil.getValueFromReference(rs.getObject(index), field.getAD_Reference_ID());
                        if (valueBuilder.getValueType().equals((Object)Value.ValueType.UNRECOGNIZED)) continue;
                        valueObjectBuilder.putValues(fieldColumnName, valueBuilder.build());
                        continue;
                    }
                    catch (Exception e) {
                        this.log.severe(e.getLocalizedMessage());
                    }
                }
                builder.addRecords(valueObjectBuilder.build());
                ++recordCount;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
        finally {
            DB.close(rs, pstmt);
        }
        builder.setRecordCount(recordCount);
        return builder;
    }

    private RecordAccess.Builder convertRecordAccess(GetRecordAccessRequest request) {
        if (Util.isEmpty((String)request.getTableName())) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)request.getUuid()) && request.getId() <= 0) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
        int tableId = MTable.getTable_ID((String)request.getTableName());
        int recordId = request.getId();
        String uuid = request.getUuid();
        if (recordId <= 0) {
            recordId = RecordUtil.getIdFromUuid(request.getTableName(), request.getUuid(), null);
        }
        if (Util.isEmpty((String)uuid)) {
            uuid = RecordUtil.getUuidFromId(request.getTableName(), recordId);
        }
        RecordAccess.Builder builder = RecordAccess.newBuilder().setTableName(ValueUtil.validateNull(request.getTableName())).setUuid(ValueUtil.validateNull(uuid)).setId(recordId);
        this.getRecordAccess(tableId, recordId, null).forEach(recordAccess -> {
            MRole role = MRole.get((Properties)Env.getCtx(), (int)recordAccess.getAD_Role_ID());
            builder.addCurrentRoles(RecordAccessRole.newBuilder().setRoleId(role.getAD_Role_ID()).setRoleUuid(ValueUtil.validateNull(role.getUUID())).setRoleName(ValueUtil.validateNull(role.getName())).setIsActive(recordAccess.isActive()).setIsDependentEntities(recordAccess.isDependentEntities()).setIsExclude(recordAccess.isExclude()).setIsReadOnly(recordAccess.isReadOnly()));
        });
        this.getRolesList(null).forEach(role -> builder.addAvailableRoles(RecordAccessRole.newBuilder().setRoleId(role.getAD_Role_ID()).setRoleUuid(ValueUtil.validateNull(role.getUUID())).setRoleName(ValueUtil.validateNull(role.getName()))));
        return builder;
    }

    private List<MRecordAccess> getRecordAccess(int tableId, int recordId, String transactionName) {
        return new Query(Env.getCtx(), "AD_Record_Access", "AD_Table_ID = ? AND Record_ID = ? AND AD_Client_ID = ?", transactionName).setParameters(new Object[]{tableId, recordId, Env.getAD_Client_ID((Properties)Env.getCtx())}).list();
    }

    private List<MRole> getRolesList(String transactionName) {
        return new Query(Env.getCtx(), "AD_Role", null, transactionName).setClient_ID().setOnlyActiveRecords(true).list();
    }

    private RecordAccess.Builder saveRecordAccess(SetRecordAccessRequest request) {
        if (Util.isEmpty((String)request.getTableName())) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)request.getUuid()) && request.getId() <= 0) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
        RecordAccess.Builder builder = RecordAccess.newBuilder();
        Trx.run(transactionName -> {
            int tableId = MTable.getTable_ID((String)request.getTableName());
            AtomicInteger recordId = new AtomicInteger(request.getId());
            String uuid = request.getUuid();
            if (recordId.get() <= 0) {
                recordId.set(RecordUtil.getIdFromUuid(request.getTableName(), request.getUuid(), transactionName));
            }
            if (Util.isEmpty((String)uuid)) {
                uuid = RecordUtil.getUuidFromId(request.getTableName(), recordId.get(), transactionName);
            }
            builder.setTableName(ValueUtil.validateNull(request.getTableName())).setUuid(ValueUtil.validateNull(uuid)).setId(recordId.get());
            DB.executeUpdateEx((String)"DELETE FROM AD_Record_Access WHERE AD_Table_ID = ? AND Record_ID = ? AND AD_Client_ID = ?", (Object[])new Object[]{tableId, recordId.get(), Env.getAD_Client_ID((Properties)Env.getCtx())}, (String)transactionName);
            request.getRecordAccessesList().forEach(recordAccessToSet -> {
                int roleId = recordAccessToSet.getRoleId();
                if (roleId <= 0) {
                    roleId = RecordUtil.getIdFromUuid("AD_Role", recordAccessToSet.getRoleUuid(), transactionName);
                }
                if (roleId <= 0) {
                    throw new AdempiereException("@AD_Role_ID@ @NotFound@");
                }
                MRole role = MRole.get((Properties)Env.getCtx(), (int)roleId);
                MRecordAccess recordAccess = new MRecordAccess(Env.getCtx(), role.getAD_Role_ID(), tableId, recordId.get(), transactionName);
                recordAccess.setIsActive(recordAccessToSet.getIsActive());
                recordAccess.setIsExclude(recordAccessToSet.getIsExclude());
                recordAccess.setIsDependentEntities(recordAccessToSet.getIsDependentEntities());
                recordAccess.setIsReadOnly(recordAccessToSet.getIsReadOnly());
                recordAccess.saveEx();
                builder.addCurrentRoles(RecordAccessRole.newBuilder().setRoleId(role.getAD_Role_ID()).setRoleUuid(ValueUtil.validateNull(role.getUUID())).setRoleName(ValueUtil.validateNull(role.getName())).setIsActive(recordAccess.isActive()).setIsDependentEntities(recordAccess.isDependentEntities()).setIsExclude(recordAccess.isExclude()).setIsReadOnly(recordAccess.isReadOnly()));
            });
            this.getRolesList(transactionName).forEach(roleToGet -> builder.addAvailableRoles(RecordAccessRole.newBuilder().setRoleId(roleToGet.getAD_Role_ID()).setRoleUuid(ValueUtil.validateNull(roleToGet.getUUID()))));
        });
        return builder;
    }

    private Preference.Builder savePreference(MPreference preference, int preferenceType, String attribute, boolean isCurrentClient, boolean isCurrentOrganization, boolean isCurrentUser, boolean isCurrentContainer, String uuid, String value) {
        Preference.Builder builder = Preference.newBuilder();
        if (preferenceType == 0) {
            int windowId = RecordUtil.getIdFromUuid("AD_Window", uuid, null);
            int clientId = Env.getAD_Client_ID((Properties)Env.getCtx());
            int orgId = Env.getAD_Org_ID((Properties)Env.getCtx());
            int userId = Env.getAD_User_ID((Properties)Env.getCtx());
            if (!isCurrentClient) {
                clientId = 0;
            }
            if (!isCurrentOrganization) {
                orgId = 0;
            }
            if (!isCurrentUser) {
                userId = -1;
            }
            if (!isCurrentContainer) {
                windowId = -1;
            }
            preference.set_ValueOfColumn("AD_Client_ID", (Object)clientId);
            preference.setAD_Org_ID(orgId);
            preference.setAD_User_ID(userId);
            preference.setAD_Window_ID(windowId);
            preference.setAttribute(attribute);
            preference.setValue(value);
            preference.saveEx();
            builder.setClientUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("AD_Client", preference.getAD_Client_ID()))).setOrganizationUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("AD_Org", preference.getAD_Org_ID()))).setUserUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("AD_User", preference.getAD_User_ID()))).setContainerUuid(ValueUtil.validateNull(uuid)).setColumnName(ValueUtil.validateNull(preference.getAttribute())).setValue(preference.getValue());
        }
        return builder;
    }

    private MPreference getPreference(int preferenceType, String attribute, boolean isCurrentClient, boolean isCurrentOrganization, boolean isCurrentUser, boolean isCurrentContainer, String uuid) {
        if (preferenceType == 0) {
            int windowId = RecordUtil.getIdFromUuid("AD_Window", uuid, null);
            StringBuffer whereClause = new StringBuffer("Attribute = ?");
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(attribute);
            whereClause.append(" AND AD_Client_ID = ?");
            if (isCurrentClient) {
                parameters.add(Env.getAD_Client_ID((Properties)Env.getCtx()));
            } else {
                parameters.add(0);
            }
            whereClause.append(" AND AD_Org_ID = ?");
            if (isCurrentOrganization) {
                parameters.add(Env.getAD_Org_ID((Properties)Env.getCtx()));
            } else {
                parameters.add(0);
            }
            if (isCurrentUser) {
                parameters.add(Env.getAD_User_ID((Properties)Env.getCtx()));
                whereClause.append(" AND AD_User_ID = ?");
            } else {
                whereClause.append(" AND AD_User_ID IS NULL");
            }
            if (isCurrentContainer) {
                parameters.add(windowId);
                whereClause.append(" AND AD_Window_ID = ?");
            } else {
                whereClause.append(" AND AD_Window_ID IS NULL");
            }
            return (MPreference)new Query(Env.getCtx(), "AD_Preference", whereClause.toString(), null).setParameters(parameters).first();
        }
        return null;
    }

    private Attachment.Builder getAttachmentFromEntity(GetAttachmentRequest request) {
        int recordId;
        MTable table;
        int tableId = 0;
        if (!Util.isEmpty((String)request.getTableName()) && (table = MTable.get((Properties)Env.getCtx(), (String)request.getTableName())) != null && table.getAD_Table_ID() != 0) {
            tableId = table.getAD_Table_ID();
        }
        if ((recordId = request.getId()) <= 0) {
            recordId = RecordUtil.getIdFromUuid(request.getTableName(), request.getUuid(), null);
        }
        if (tableId != 0 && recordId != 0) {
            return ConvertUtil.convertAttachment(MAttachment.get((Properties)Env.getCtx(), (int)tableId, (int)recordId));
        }
        return Attachment.newBuilder();
    }

    private ResourceReference.Builder getResourceReferenceFromImageId(int imageId) {
        return ConvertUtil.convertResourceReference(RecordUtil.getResourceFromImageId(imageId));
    }

    private ReportOutput.Builder getReportOutput(GetReportOutputRequest request) throws FileNotFoundException, IOException {
        Criteria criteria = request.getCriteria();
        if (Util.isEmpty((String)criteria.getTableName())) {
            throw new AdempiereException("@TableName@ @NotFound@");
        }
        if (Util.isEmpty((String)request.getPrintFormatUuid())) {
            throw new AdempiereException("@AD_PrintFormat_ID@ @NotFound@");
        }
        MTable table = MTable.get((Properties)Env.getCtx(), (String)criteria.getTableName());
        if (!MRole.getDefault().isCanReport(table.getAD_Table_ID())) {
            throw new AdempiereException("@AccessCannotReport@");
        }
        ReportOutput.Builder builder = ReportOutput.newBuilder();
        MQuery query = this.getReportQueryFromCriteria(criteria);
        if (!Util.isEmpty((String)criteria.getWhereClause())) {
            query.addRestriction(criteria.getWhereClause());
        }
        PrintInfo printInformation = new PrintInfo(request.getReportName(), table.getAD_Table_ID(), 0, 0);
        MPrintFormat printFormat = null;
        MReportView reportView = null;
        if (!Util.isEmpty((String)request.getPrintFormatUuid())) {
            printFormat = (MPrintFormat)new Query(Env.getCtx(), "AD_PrintFormat", "UUID = ?", null).setParameters(new Object[]{request.getPrintFormatUuid()}).first();
        }
        if (!Util.isEmpty((String)request.getReportViewUuid())) {
            reportView = (MReportView)new Query(Env.getCtx(), "AD_ReportView", "UUID = ?", null).setParameters(new Object[]{request.getReportViewUuid()}).first();
        }
        if (printFormat == null) {
            int reportViewId = 0;
            if (reportView != null) {
                reportViewId = reportView.getAD_ReportView_ID();
            }
            printFormat = MPrintFormat.get((Properties)Env.getCtx(), (int)reportViewId, (int)table.getAD_Table_ID());
        }
        if (printFormat == null) {
            throw new AdempiereException("@AD_PrintGormat_ID@ @NotFound@");
        }
        if (table.getAD_Table_ID() != printFormat.getAD_Table_ID()) {
            table = MTable.get((Properties)Env.getCtx(), (int)printFormat.getAD_Table_ID());
        }
        ReportEngine reportEngine = new ReportEngine(Env.getCtx(), printFormat, query, printInformation);
        if (reportView != null) {
            reportEngine.setAD_ReportView_ID(reportView.getAD_ReportView_ID());
        } else {
            reportView = MReportView.get((Properties)Env.getCtx(), (int)reportEngine.getAD_ReportView_ID());
        }
        reportEngine.setSummary(request.getIsSummary());
        File reportFile = this.createOutput(reportEngine, request.getReportType());
        if (reportFile != null && reportFile.exists()) {
            String validFileName = this.getValidName(reportFile.getName());
            builder.setFileName(ValueUtil.validateNull(validFileName));
            builder.setName(ValueUtil.validateNull(reportEngine.getName()));
            builder.setMimeType(ValueUtil.validateNull(MimeType.getMimeType((String)validFileName)));
            String headerName = Msg.getMsg((Properties)Env.getCtx(), (String)"Report") + ": " + reportEngine.getName() + "  " + Env.getHeader((Properties)Env.getCtx(), (int)0);
            builder.setHeaderName(ValueUtil.validateNull(headerName));
            StringBuffer footerName = new StringBuffer();
            footerName.append(Msg.getMsg((Properties)Env.getCtx(), (String)"DataCols")).append("=").append(reportEngine.getColumnCount()).append(", ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"DataRows")).append("=").append(reportEngine.getRowCount());
            builder.setFooterName(ValueUtil.validateNull(footerName.toString()));
            builder.setReportType(request.getReportType());
            ByteString resultFile = ByteString.readFrom((InputStream)new FileInputStream(reportFile));
            if (request.getReportType().endsWith("html") || request.getReportType().endsWith("txt")) {
                builder.setOutputBytes(resultFile);
            }
            if (reportView != null) {
                builder.setReportViewUuid(ValueUtil.validateNull(reportView.getUUID()));
            }
            builder.setPrintFormatUuid(ValueUtil.validateNull(printFormat.getUUID()));
            builder.setTableName(ValueUtil.validateNull(table.getTableName()));
            builder.setOutputStream(resultFile);
        }
        return builder;
    }

    private File createOutput(ReportEngine reportEngine, String reportType) {
        File file = null;
        try {
            ReportExportHandler exportHandler = new ReportExportHandler(Env.getCtx(), reportEngine);
            AbstractExportFormat exporter = exportHandler.getExporterFromExtension(reportType);
            if (exporter != null) {
                file = File.createTempFile(reportEngine.getName() + "_" + System.currentTimeMillis(), "." + exporter.getExtension());
                exporter.exportTo(file);
            }
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }

    private MPrivateAccess getPrivateAccess(Properties context, String tableName, int recordId, int userId, String transactionName) {
        return (MPrivateAccess)new Query(context, "AD_Private_Access", "EXISTS(SELECT 1 FROM AD_Table t WHERE t.AD_Table_ID = AD_Private_Access.AD_Table_ID AND t.TableName = ?) AND Record_ID = ? AND AD_User_ID = ?", transactionName).setParameters(new Object[]{tableName, recordId, userId}).first();
    }

    private PrivateAccess.Builder lockUnlockPrivateAccess(Properties context, String tableName, int recordId, int userId, boolean lock, String transactionName) {
        MPrivateAccess privateAccess = this.getPrivateAccess(context, tableName, recordId, userId, transactionName);
        if (privateAccess == null || privateAccess.getAD_Table_ID() == 0) {
            MTable table = MTable.get((Properties)context, (String)tableName);
            privateAccess = new MPrivateAccess(context, userId, table.getAD_Table_ID(), recordId);
        }
        privateAccess.setIsActive(lock);
        privateAccess.saveEx(transactionName);
        return this.convertPrivateAccess(context, privateAccess);
    }

    private ListReferencesResponse.Builder convertRecordReferences(Properties context, ListReferencesRequest request) {
        MWindow window;
        ListReferencesResponse.Builder builder = ListReferencesResponse.newBuilder();
        if (request.getId() == 0 && Util.isEmpty((String)request.getUuid())) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)request.getTableName())) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        String tableName = request.getTableName();
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        if (!Util.isEmpty((String)request.getUuid())) {
            whereClause.append("UUID = ?");
            params.add(request.getUuid());
        } else if (request.getId() > 0) {
            whereClause.append(tableName + "_ID = ?");
            params.add(request.getId());
        } else {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
        PO entity = new Query(context, tableName, whereClause.toString(), null).setParameters(params).first();
        if (entity != null && entity.get_ID() >= 0 && (window = (MWindow)new Query(context, "AD_Window", "UUID = ?", null).setParameters(new Object[]{request.getWindowUuid()}).setOnlyActiveRecords(true).first()) != null && window.get_ID() > 0) {
            for (ZoomInfoFactory.ZoomInfo zoomInfo : ZoomInfoFactory.retrieveZoomInfos((PO)entity, (int)window.getAD_Window_ID())) {
                if (zoomInfo.query.getRecordCount() == 0) continue;
                MWindow referenceWindow = MWindow.get((Properties)context, (int)zoomInfo.windowId);
                String uuid = UUID.randomUUID().toString();
                RecordReferenceInfo.Builder recordReferenceBuilder = RecordReferenceInfo.newBuilder();
                recordReferenceBuilder.setDisplayName(zoomInfo.destinationDisplay + " (#" + zoomInfo.query.getRecordCount() + ")");
                recordReferenceBuilder.setRecordCount(zoomInfo.query.getRecordCount());
                recordReferenceBuilder.setWindowUuid(ValueUtil.validateNull(referenceWindow.get_UUID()));
                recordReferenceBuilder.setTableName(ValueUtil.validateNull(zoomInfo.query.getZoomTableName()));
                recordReferenceBuilder.setWhereClause(ValueUtil.validateNull(zoomInfo.query.getWhereClause()));
                recordReferenceBuilder.setUuid(uuid);
                referenceWhereClauseCache.put((Object)uuid, (Object)zoomInfo.query.getWhereClause());
                builder.addReferences(recordReferenceBuilder.build());
            }
        }
        return builder;
    }

    private ListTranslationsResponse.Builder convertTranslationsList(Properties context, ListTranslationsRequest request) {
        ListTranslationsResponse.Builder builder = ListTranslationsResponse.newBuilder();
        String tableName = request.getTableName();
        if (Util.isEmpty((String)tableName)) {
            throw new AdempiereException("@TableName@ @NotFound@");
        }
        Trx.run(transactionName -> {
            MTable table = MTable.get((Properties)context, (String)tableName);
            PO entity = RecordUtil.getEntity(context, tableName, request.getUuid(), request.getId(), transactionName);
            ArrayList<Object> parameters = new ArrayList<Object>();
            StringBuffer whereClause = new StringBuffer(entity.get_KeyColumns()[0] + " = ?");
            parameters.add(entity.get_ID());
            if (!Util.isEmpty((String)request.getLanguage())) {
                whereClause.append(" AND AD_Language = ?");
                parameters.add(request.getLanguage());
            }
            new Query(context, tableName + "_Trl", whereClause.toString(), transactionName).setParameters(parameters).list().forEach(translation -> {
                Translation.Builder translationBuilder = Translation.newBuilder();
                table.getColumnsAsList().stream().filter(column -> column.isTranslated()).forEach(column -> {
                    Object value = translation.get_Value(column.getColumnName());
                    if (value != null) {
                        Value.Builder builderValue = ValueUtil.getValueFromObject(value);
                        if (builderValue != null) {
                            translationBuilder.putValues(column.getColumnName(), builderValue.build());
                        }
                        if (Util.isEmpty((String)translationBuilder.getUuid())) {
                            translationBuilder.setUuid(ValueUtil.validateNull(translation.get_UUID()));
                        }
                        if (Util.isEmpty((String)translationBuilder.getLanguage())) {
                            translationBuilder.setLanguage(ValueUtil.validateNull(translation.get_ValueAsString("AD_Language")));
                        }
                    }
                });
                builder.addTranslations(translationBuilder);
            });
        });
        return builder;
    }

    private ListReportViewsResponse.Builder convertReportViewsList(Properties context, ListReportViewsRequest request) {
        ListReportViewsResponse.Builder builder = ListReportViewsResponse.newBuilder();
        if (Util.isEmpty((String)request.getTableName()) && Util.isEmpty((String)request.getProcessUuid())) {
            throw new AdempiereException("@TableName@ / @AD_Process_ID@ @NotFound@");
        }
        String whereClause = null;
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (!Util.isEmpty((String)request.getTableName())) {
            MTable table = MTable.get((Properties)context, (String)request.getTableName());
            if (table == null) {
                throw new AdempiereException("@TableName@ @NotFound@");
            }
            whereClause = "AD_Table_ID = ?";
            parameters.add(table.getAD_Table_ID());
        } else if (!Util.isEmpty((String)request.getProcessUuid())) {
            whereClause = "EXISTS(SELECT 1 FROM AD_Process p WHERE p.UUID = ? AND p.AD_ReportView_ID = AD_ReportView.AD_ReportView_ID)";
            parameters.add(request.getProcessUuid());
        }
        new Query(context, "AD_ReportView", whereClause, null).setParameters(parameters).setOrderBy("PrintName, Name").list().forEach(reportViewReference -> {
            ReportView.Builder reportViewBuilder = ReportView.newBuilder();
            String name = reportViewReference.getName();
            String description = reportViewReference.getDescription();
            if (!Env.isBaseLanguage((Properties)context, (String)"")) {
                String translation = reportViewReference.get_Translation("Name");
                if (!Util.isEmpty((String)translation)) {
                    name = translation;
                }
                if (!Util.isEmpty((String)(translation = reportViewReference.get_Translation("Description")))) {
                    description = translation;
                }
            }
            reportViewBuilder.setUuid(ValueUtil.validateNull(reportViewReference.getUUID()));
            reportViewBuilder.setName(ValueUtil.validateNull(name));
            reportViewBuilder.setDescription(ValueUtil.validateNull(description));
            MTable table = MTable.get((Properties)context, (int)reportViewReference.getAD_Table_ID());
            reportViewBuilder.setTableName(ValueUtil.validateNull(table.getTableName()));
            builder.addReportViews(reportViewBuilder);
        });
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListDrillTablesResponse.Builder convertDrillTablesList(ListDrillTablesRequest request) {
        ListDrillTablesResponse.Builder builder = ListDrillTablesResponse.newBuilder();
        if (Util.isEmpty((String)request.getTableName())) {
            throw new AdempiereException("@TableName@ @NotFound@");
        }
        MTable table = MTable.get((Properties)Env.getCtx(), (String)request.getTableName());
        String sql = "SELECT t.TableName, e.ColumnName, NULLIF(e.PO_PrintName,e.PrintName) FROM AD_Column c  INNER JOIN AD_Column used ON (c.ColumnName=used.ColumnName) INNER JOIN AD_Table t ON (used.AD_Table_ID=t.AD_Table_ID AND t.IsView='N' AND t.AD_Table_ID <> c.AD_Table_ID) INNER JOIN AD_Column cKey ON (t.AD_Table_ID=cKey.AD_Table_ID AND cKey.IsKey='Y') INNER JOIN AD_Element e ON (cKey.ColumnName=e.ColumnName) WHERE c.AD_Table_ID=? AND c.IsKey='Y' ORDER BY 3";
        CPreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, table.getAD_Table_ID());
            resultSet = pstmt.executeQuery();
            while (resultSet.next()) {
                String drillTableName = resultSet.getString("TableName");
                String columnName = resultSet.getString("ColumnName");
                M_Element element = M_Element.get((Properties)Env.getCtx(), (String)columnName);
                DrillTable.Builder drillTable = DrillTable.newBuilder();
                drillTable.setTableName(ValueUtil.validateNull(drillTableName));
                String name = element.getPrintName();
                String poName = element.getPO_PrintName();
                if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"")) {
                    String translation = element.get_Translation("PrintName");
                    if (!Util.isEmpty((String)translation)) {
                        name = translation;
                    }
                    if (!Util.isEmpty((String)(translation = element.get_Translation("PO_PrintName")))) {
                        poName = translation;
                    }
                }
                if (!Util.isEmpty((String)poName)) {
                    name = name + "/" + poName;
                }
                drillTable.setPrintName(ValueUtil.validateNull(name));
                builder.addDrillTables(drillTable);
            }
            resultSet.close();
            pstmt.close();
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)resultSet, (Statement)pstmt);
        }
        DB.close((ResultSet)resultSet, (Statement)pstmt);
        return builder;
    }

    private ListPrintFormatsResponse.Builder convertPrintFormatsList(Properties context, ListPrintFormatsRequest request) {
        ListPrintFormatsResponse.Builder builder = ListPrintFormatsResponse.newBuilder();
        if (Util.isEmpty((String)request.getTableName()) && Util.isEmpty((String)request.getProcessUuid()) && Util.isEmpty((String)request.getReportViewUuid())) {
            throw new AdempiereException("@TableName@ / @AD_Process_ID@ / @AD_ReportView_ID@ @NotFound@");
        }
        String whereClause = null;
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (!Util.isEmpty((String)request.getTableName())) {
            MTable table = MTable.get((Properties)context, (String)request.getTableName());
            whereClause = "AD_Table_ID = ?";
            parameters.add(table.getAD_Table_ID());
        } else if (!Util.isEmpty((String)request.getProcessUuid())) {
            whereClause = "EXISTS(SELECT 1 FROM AD_Process p WHERE p.UUID = ? AND (p.AD_PrintFormat_ID = AD_PrintFormat.AD_PrintFormat_ID OR p.AD_ReportView_ID = AD_PrintFormat.AD_ReportView_ID))";
            parameters.add(request.getProcessUuid());
        } else if (!Util.isEmpty((String)request.getReportViewUuid())) {
            MReportView reportView = (MReportView)new Query(context, "AD_ReportView", "UUID = ?", null).setParameters(new Object[]{request.getReportViewUuid()}).first();
            whereClause = "AD_ReportView_ID = ?";
            parameters.add(reportView.getUUID());
        }
        new Query(context, "AD_PrintFormat", whereClause, null).setParameters(parameters).setOrderBy("Name").setClient_ID().list().forEach(printFormatReference -> {
            PrintFormat.Builder printFormatBuilder = PrintFormat.newBuilder();
            printFormatBuilder.setUuid(ValueUtil.validateNull(printFormatReference.getUUID()));
            printFormatBuilder.setName(ValueUtil.validateNull(printFormatReference.getName()));
            printFormatBuilder.setDescription(ValueUtil.validateNull(printFormatReference.getDescription()));
            printFormatBuilder.setIsDefault(printFormatReference.isDefault());
            MTable table = MTable.get((Properties)context, (int)printFormatReference.getAD_Table_ID());
            printFormatBuilder.setTableName(ValueUtil.validateNull(table.getTableName()));
            if (printFormatReference.getAD_ReportView_ID() != 0) {
                MReportView reportView = MReportView.get((Properties)context, (int)printFormatReference.getAD_ReportView_ID());
                printFormatBuilder.setReportViewUuid(ValueUtil.validateNull(reportView.getUUID()));
            }
            builder.addPrintFormats(printFormatBuilder);
        });
        return builder;
    }

    private String getValidName(String name) {
        if (Util.isEmpty((String)name)) {
            return "";
        }
        return name.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()*#/><]", "").replaceAll(" ", "-");
    }

    private String convertOperator(int gRpcOperator) {
        String operator = "=";
        switch (gRpcOperator) {
            case 8: {
                operator = " BETWEEN ";
                break;
            }
            case 0: {
                operator = "=";
                break;
            }
            case 5: {
                operator = ">=";
                break;
            }
            case 4: {
                operator = ">";
                break;
            }
            case 11: {
                operator = " IN ";
                break;
            }
            case 7: {
                operator = "<=";
                break;
            }
            case 6: {
                operator = "<";
                break;
            }
            case 2: {
                operator = " LIKE ";
                break;
            }
            case 1: {
                operator = "!=";
                break;
            }
            case 12: {
                operator = " NOT IN ";
                break;
            }
            case 3: {
                operator = " NOT LIKE ";
                break;
            }
            case 9: {
                operator = " IS NOT NULL ";
                break;
            }
            case 10: {
                operator = " IS NULL ";
                break;
            }
        }
        return operator;
    }

    private Entity.Builder rollbackLastEntityAction(RollbackEntityRequest request) {
        if (Util.isEmpty((String)request.getTableName())) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        MTable table = MTable.get((Properties)Env.getCtx(), (String)request.getTableName());
        if (table == null || table.getAD_Table_ID() == 0) {
            throw new AdempiereException("@AD_Table_ID@ @Invalid@");
        }
        AtomicReference entityWrapper = new AtomicReference();
        Trx.run(transactionName -> {
            int logId;
            int id = request.getId();
            if (id <= 0) {
                id = RecordUtil.getIdFromUuid(request.getTableName(), request.getUuid(), transactionName);
            }
            if ((logId = request.getLogId()) <= 0) {
                logId = this.getLastChangeLogId(table.getAD_Table_ID(), id, transactionName);
            }
            if (logId > 0) {
                List changeLogList = new Query(Env.getCtx(), "AD_ChangeLog", "AD_ChangeLog_ID = ?", transactionName).setParameters(new Object[]{logId}).list();
                String eventType = "U";
                if (changeLogList.size() > 0) {
                    MChangeLog log = (MChangeLog)changeLogList.get(0);
                    eventType = log.getEventChangeLog();
                    if (eventType.equals("I")) {
                        MChangeLog changeLog2 = new MChangeLog(Env.getCtx(), logId, transactionName);
                        PO entity = RecordUtil.getEntity(Env.getCtx(), table.getTableName(), request.getUuid(), changeLog2.getRecord_ID(), transactionName);
                        if (entity != null && entity.get_ID() >= 0) {
                            entity.delete(true);
                        }
                    } else if (eventType.equals("D") || eventType.equals("U")) {
                        PO entity = table.getPO(id, transactionName);
                        if (entity == null || entity.get_ID() <= 0) {
                            throw new AdempiereException("@Error@ @PO@ @NotFound@");
                        }
                        changeLogList.forEach(changeLog -> this.setValueFromChangeLog(entity, (MChangeLog)changeLog));
                        entity.saveEx(transactionName);
                        entityWrapper.set(entity);
                    }
                }
            } else {
                throw new AdempiereException("@AD_ChangeLog_ID@ @NotFound@");
            }
        });
        if (entityWrapper.get() != null) {
            return ConvertUtil.convertEntity((PO)entityWrapper.get());
        }
        return Entity.newBuilder();
    }

    private void setValueFromChangeLog(PO entity, MChangeLog changeLog) {
        Object value = null;
        try {
            if (!changeLog.isOldNull()) {
                MColumn column = MColumn.get((Properties)Env.getCtx(), (int)changeLog.getAD_Column_ID());
                value = this.stringToObject(column, changeLog.getOldValue());
            }
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
        entity.set_ValueOfColumn(changeLog.getAD_Column_ID(), value);
    }

    private Object stringToObject(MColumn column, String value) {
        if (value == null) {
            return null;
        }
        if (DisplayType.isText((int)column.getAD_Reference_ID()) || column.getAD_Reference_ID() == 17 || column.getColumnName().equals("EntityType") || column.getColumnName().equals("AD_Language")) {
            return value;
        }
        if (DisplayType.isNumeric((int)column.getAD_Reference_ID())) {
            return new BigDecimal(value);
        }
        if (DisplayType.isID((int)column.getAD_Reference_ID())) {
            return Integer.valueOf(value);
        }
        if (20 == column.getAD_Reference_ID()) {
            return "true".equalsIgnoreCase(value);
        }
        if (28 == column.getAD_Reference_ID() && column.getAD_Reference_Value_ID() == 0) {
            return "true".equalsIgnoreCase(value) ? "Y" : "N";
        }
        if (28 == column.getAD_Reference_ID() && column.getAD_Reference_Value_ID() != 0) {
            return value;
        }
        if (DisplayType.isDate((int)column.getAD_Reference_ID())) {
            return Timestamp.valueOf(value);
        }
        return null;
    }

    private ChatEntry.Builder addChatEntry(Properties context, CreateChatEntryRequest request) {
        if (Util.isEmpty((String)request.getTableName())) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        AtomicReference entryReference = new AtomicReference();
        Trx.run(transactionName -> {
            String tableName = request.getTableName();
            MTable table = MTable.get((Properties)context, (String)tableName);
            PO entity = RecordUtil.getEntity(context, tableName, request.getUuid(), request.getId(), transactionName);
            StringBuffer whereClause = new StringBuffer();
            ArrayList<Integer> parameters = new ArrayList<Integer>();
            whereClause.append("AD_Table_ID").append(" = ?").append(" AND ").append("Record_ID").append(" = ?");
            parameters.add(table.getAD_Table_ID());
            parameters.add(request.getId());
            MChat chat = (MChat)new Query(context, "CM_Chat", whereClause.toString(), transactionName).setParameters(parameters).setClient_ID().first();
            if (chat == null || chat.getCM_Chat_ID() == 0) {
                chat = new MChat(context, table.getAD_Table_ID(), entity.get_ID(), entity.getDisplayValue(), transactionName);
                chat.saveEx();
            }
            MChatEntry entry = new MChatEntry(chat, request.getComment());
            entry.saveEx(transactionName);
            entryReference.set(entry);
        });
        return ConvertUtil.convertChatEntry((MChatEntry)entryReference.get());
    }

    private int getLastChangeLogId(int tableId, int recordId, String transactionName) {
        return DB.getSQLValue(null, (String)"SELECT AD_ChangeLog_ID FROM AD_ChangeLog WHERE AD_Table_ID = ? AND Record_ID = ? AND ROWNUM <= 1 ORDER BY Updated DESC", (int)tableId, (int)recordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object convertDefaultValue(String sql) {
        ResultSet rs;
        CPreparedStatement pstmt;
        Object defaultValue;
        block4: {
            defaultValue = null;
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                defaultValue = rs.getObject(1);
            }
            catch (Exception e) {
                try {
                    this.log.severe(e.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return defaultValue;
    }

    private DefaultValue.Builder getInfoFromDefaultValueRequest(GetDefaultValueRequest request) {
        int referenceId = 0;
        int referenceValueId = 0;
        int validationRuleId = 0;
        String columnName = null;
        String defaultValue = null;
        if (!Util.isEmpty((String)request.getFieldUuid())) {
            Optional<MField> maybeField;
            MField field = (MField)RecordUtil.getEntity(Env.getCtx(), "AD_Field", request.getFieldUuid(), 0, null);
            int fieldId = field.getAD_Field_ID();
            List customFields = ASPUtil.getInstance((Properties)Env.getCtx()).getWindowFields(field.getAD_Tab_ID());
            if (customFields != null && (maybeField = customFields.stream().filter(customField -> customField.getAD_Field_ID() == fieldId).findFirst()).isPresent()) {
                field = maybeField.get();
                defaultValue = field.getDefaultValue();
                MColumn column = MColumn.get((Properties)Env.getCtx(), (int)field.getAD_Column_ID());
                referenceId = column.getAD_Reference_ID();
                referenceValueId = column.getAD_Reference_Value_ID();
                validationRuleId = column.getAD_Val_Rule_ID();
                columnName = column.getColumnName();
                if (field.getAD_Reference_ID() > 0) {
                    referenceId = field.getAD_Reference_ID();
                }
                if (field.getAD_Reference_Value_ID() > 0) {
                    referenceValueId = field.getAD_Reference_Value_ID();
                }
                if (field.getAD_Val_Rule_ID() > 0) {
                    validationRuleId = field.getAD_Val_Rule_ID();
                }
                if (Util.isEmpty((String)defaultValue) && !Util.isEmpty((String)column.getDefaultValue())) {
                    defaultValue = column.getDefaultValue();
                }
            }
        } else if (!Util.isEmpty((String)request.getBrowseFieldUuid())) {
            Optional<MBrowseField> maybeField;
            MBrowseField browseField = (MBrowseField)RecordUtil.getEntity(Env.getCtx(), "AD_Browse_Field", request.getBrowseFieldUuid(), 0, null);
            int browseFieldId = browseField.getAD_Browse_Field_ID();
            List customFields = ASPUtil.getInstance((Properties)Env.getCtx()).getBrowseFields(browseField.getAD_Browse_ID());
            if (customFields != null && (maybeField = customFields.stream().filter(customField -> customField.getAD_Browse_Field_ID() == browseFieldId).findFirst()).isPresent()) {
                browseField = maybeField.get();
                defaultValue = browseField.getDefaultValue();
                referenceId = browseField.getAD_Reference_ID();
                referenceValueId = browseField.getAD_Reference_Value_ID();
                validationRuleId = browseField.getAD_Val_Rule_ID();
                MViewColumn viewColumn = browseField.getAD_View_Column();
                if (viewColumn.getAD_Column_ID() > 0) {
                    MColumn column = MColumn.get((Properties)Env.getCtx(), (int)viewColumn.getAD_Column_ID());
                    columnName = column.getColumnName();
                    if (Util.isEmpty((String)defaultValue) && !Util.isEmpty((String)column.getDefaultValue())) {
                        defaultValue = column.getDefaultValue();
                    }
                } else {
                    columnName = browseField.getAD_Element().getColumnName();
                }
            }
        } else if (!Util.isEmpty((String)request.getProcessParameterUuid())) {
            Optional<MProcessPara> maybeParameter;
            MProcessPara processParameter = (MProcessPara)RecordUtil.getEntity(Env.getCtx(), "AD_Process_Para", request.getProcessParameterUuid(), 0, null);
            int processParameterId = processParameter.getAD_Process_Para_ID();
            List customParameters = ASPUtil.getInstance((Properties)Env.getCtx()).getProcessParameters(processParameter.getAD_Process_ID());
            if (customParameters != null && (maybeParameter = customParameters.stream().filter(customField -> customField.getAD_Process_Para_ID() == processParameterId).findFirst()).isPresent()) {
                processParameter = maybeParameter.get();
                referenceId = processParameter.getAD_Reference_ID();
                referenceValueId = processParameter.getAD_Reference_Value_ID();
                validationRuleId = processParameter.getAD_Val_Rule_ID();
                columnName = processParameter.getColumnName();
                defaultValue = processParameter.getDefaultValue();
            }
        } else if (!Util.isEmpty((String)request.getColumnUuid())) {
            int columnId = RecordUtil.getIdFromUuid("AD_Column", request.getColumnUuid(), null);
            if (columnId > 0) {
                MColumn column = MColumn.get((Properties)Env.getCtx(), (int)columnId);
                referenceId = column.getAD_Reference_ID();
                referenceValueId = column.getAD_Reference_Value_ID();
                validationRuleId = column.getAD_Val_Rule_ID();
                columnName = column.getColumnName();
                defaultValue = column.getDefaultValue();
            }
        } else {
            throw new AdempiereException("@AD_Reference_ID@ / @AD_Column_ID@ / @AD_Table_ID@ / @AD_Process_Para_ID@ / @IsMandatory@");
        }
        return this.getDefaultKeyAndValue(request.getContextAttributesList(), defaultValue, referenceId, referenceValueId, columnName, validationRuleId);
    }

    private DefaultValue.Builder getDefaultKeyAndValue(List<KeyValue> contextAttributes, String defaultValue, int referenceId, int referenceValueId, String columnName, int validationRuleId) {
        DefaultValue.Builder builder;
        block15: {
            Object defaultValueAsObject;
            block16: {
                ResultSet rs;
                CPreparedStatement pstmt;
                block14: {
                    block17: {
                        builder = DefaultValue.newBuilder();
                        if (Util.isEmpty((String)defaultValue)) break block15;
                        defaultValueAsObject = null;
                        Properties context = Env.getCtx();
                        int windowNo = ThreadLocalRandom.current().nextInt(1, 8997);
                        Env.clearWinContext((int)windowNo);
                        Map<String, Object> attributes = ValueUtil.convertValuesToObjects(contextAttributes);
                        attributes.entrySet().forEach(attribute -> {
                            if (attribute.getValue() instanceof Integer) {
                                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (int)((Integer)attribute.getValue()));
                            } else if (attribute.getValue() instanceof Timestamp) {
                                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (Timestamp)((Timestamp)attribute.getValue()));
                            } else if (attribute.getValue() instanceof Boolean) {
                                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (boolean)((Boolean)attribute.getValue()));
                            } else if (attribute.getValue() instanceof String) {
                                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (String)((String)attribute.getValue()));
                            }
                        });
                        if (defaultValue.trim().startsWith("@SQL=")) {
                            defaultValue = defaultValue.replace("@SQL=", "");
                            defaultValue = Env.parseContext((Properties)context, (int)windowNo, (String)defaultValue, (boolean)false);
                            defaultValueAsObject = this.convertDefaultValue(defaultValue);
                        } else {
                            defaultValueAsObject = Env.parseContext((Properties)context, (int)windowNo, (String)defaultValue, (boolean)false);
                        }
                        if (defaultValueAsObject == null) break block15;
                        if (DisplayType.isID((int)referenceId) || referenceId == 11) {
                            try {
                                defaultValueAsObject = Integer.parseInt(String.valueOf(defaultValueAsObject));
                            }
                            catch (Exception e) {
                                this.log.warning(e.getLocalizedMessage());
                            }
                        } else if (DisplayType.isNumeric((int)validationRuleId)) {
                            try {
                                defaultValueAsObject = new BigDecimal(String.valueOf(defaultValueAsObject));
                            }
                            catch (Exception e) {
                                this.log.warning(e.getLocalizedMessage());
                            }
                        }
                        if (!DisplayType.isLookup((int)referenceId)) break block16;
                        if (referenceId != 17) break block17;
                        MRefList referenceList = MRefList.get((Properties)Env.getCtx(), (int)referenceValueId, (String)String.valueOf(defaultValueAsObject), null);
                        builder = this.convertDefaultValueFromResult(referenceList.getValue(), referenceList.getUUID(), referenceList.getValue(), referenceList.get_Translation("Name"));
                        break block15;
                    }
                    MLookupInfo lookupInfo = ReferenceUtil.getReferenceLookupInfo(referenceId, referenceValueId, columnName, validationRuleId);
                    if (Util.isEmpty((String)lookupInfo.QueryDirect)) break block15;
                    String sql = MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(lookupInfo.QueryDirect, lookupInfo.TableName, true, false);
                    pstmt = null;
                    rs = null;
                    try {
                        pstmt = DB.prepareStatement((String)sql.toString(), null);
                        ValueUtil.setParameterFromObject((PreparedStatement)pstmt, defaultValueAsObject, 1);
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block14;
                        ResultSetMetaData metaData = rs.getMetaData();
                        int keyValueType = metaData.getColumnType(1);
                        Object keyValue = null;
                        keyValue = keyValueType == 12 || keyValueType == -9 || keyValueType == 1 || keyValueType == -15 ? rs.getString(2) : Integer.valueOf(rs.getInt(1));
                        String uuid = null;
                        int uuidIndex = this.getColumnIndex(metaData, "UUID");
                        if (uuidIndex != -1) {
                            uuid = rs.getString(uuidIndex);
                        }
                        builder = this.convertDefaultValueFromResult(keyValue, uuid, rs.getString(2), rs.getString(3));
                    }
                    catch (Exception e) {
                        try {
                            this.log.severe(e.getLocalizedMessage());
                            throw new AdempiereException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, (Statement)pstmt);
                            throw throwable;
                        }
                    }
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                break block15;
            }
            builder.putValues(columnName, ValueUtil.getValueFromObject(defaultValueAsObject).build());
        }
        return builder;
    }

    private ContextInfoValue.Builder convertContextInfoValue(Properties context, GetContextInfoValueRequest request) {
        MADContextInfo contextInfo;
        ContextInfoValue.Builder builder = ContextInfoValue.newBuilder();
        if (request == null) {
            throw new AdempiereException("Object Request Null");
        }
        if (request.getId() <= 0 && Util.isEmpty((String)request.getUuid())) {
            throw new AdempiereException("@Record_ID@ / @UUID@ @NotFound@");
        }
        int id = request.getId();
        if (id <= 0) {
            id = RecordUtil.getIdFromUuid("AD_ContextInfo", request.getUuid(), null);
        }
        if ((contextInfo = MADContextInfo.getById((Properties)context, (int)id)) != null && contextInfo.getAD_ContextInfo_ID() > 0) {
            try {
                contextInfo.setSQLStatement(request.getQuery());
                MMessage message = MMessage.get((Properties)Env.getCtx(), (int)contextInfo.getAD_Message_ID());
                if (message != null) {
                    Object[] arguments = contextInfo.getArguments(0);
                    if (arguments == null) {
                        return builder;
                    }
                    String messageText = Msg.getMsg((String)Env.getAD_Language((Properties)Env.getCtx()), (String)message.getValue(), (Object[])arguments);
                    builder.setMessageText(ValueUtil.validateNull(messageText));
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
        return builder;
    }

    private PrivateAccess.Builder convertPrivateAccess(Properties context, MPrivateAccess privateAccess) {
        PrivateAccess.Builder builder = PrivateAccess.newBuilder();
        if (privateAccess == null) {
            return builder;
        }
        MTable table = MTable.get((Properties)context, (int)privateAccess.getAD_Table_ID());
        builder.setTableName(table.getTableName());
        MUser user = MUser.get((Properties)context, (int)privateAccess.getAD_User_ID());
        builder.setUuid(ValueUtil.validateNull(user.getUUID()));
        builder.setId(privateAccess.getRecord_ID());
        builder.setIsLocked(privateAccess.isActive());
        return builder;
    }

    private LookupItem.Builder convertLookupItem(GetLookupItemRequest request) {
        MLookupInfo reference = this.getInfoFromRequest(request.getReferenceUuid(), request.getFieldUuid(), request.getProcessParameterUuid(), request.getBrowseFieldUuid(), request.getColumnUuid(), request.getColumnName(), request.getTableName());
        if (reference == null) {
            throw new AdempiereException("@AD_Reference_ID@ @NotFound@");
        }
        String sql = reference.QueryDirect;
        Properties context = Env.getCtx();
        int windowNo = ThreadLocalRandom.current().nextInt(1, 8997);
        Env.clearWinContext((int)windowNo);
        Map<String, Object> attributes = ValueUtil.convertValuesToObjects(request.getContextAttributesList());
        attributes.entrySet().forEach(attribute -> {
            if (attribute.getValue() instanceof Integer) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (int)((Integer)attribute.getValue()));
            } else if (attribute.getValue() instanceof Timestamp) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (Timestamp)((Timestamp)attribute.getValue()));
            } else if (attribute.getValue() instanceof Boolean) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (boolean)((Boolean)attribute.getValue()));
            } else if (attribute.getValue() instanceof String) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (String)((String)attribute.getValue()));
            }
        });
        sql = Env.parseContext((Properties)context, (int)windowNo, (String)sql, (boolean)false);
        if (Util.isEmpty((String)sql) && !Util.isEmpty((String)reference.QueryDirect)) {
            throw new AdempiereException("@AD_Tab_ID@ @WhereClause@ @Unparseable@");
        }
        sql = MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(sql, reference.TableName, true, false);
        LookupItem.Builder builder = LookupItem.newBuilder();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), null);
            ValueUtil.setParameterFromObject((PreparedStatement)pstmt, request.getId(), 1);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ResultSetMetaData metaData = rs.getMetaData();
                int keyValueType = metaData.getColumnType(1);
                Object keyValue = null;
                keyValue = keyValueType == 12 || keyValueType == -9 || keyValueType == 1 || keyValueType == -15 ? rs.getString(2) : Integer.valueOf(rs.getInt(1));
                String uuid = null;
                int uuidIndex = this.getColumnIndex(metaData, "UUID");
                if (uuidIndex != -1) {
                    uuid = rs.getString(uuidIndex);
                }
                builder = this.convertObjectFromResult(keyValue, uuid, rs.getString(2), rs.getString(3));
            }
        }
        catch (Exception e) {
            try {
                this.log.severe(e.getLocalizedMessage());
                throw new AdempiereException((Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return builder;
    }

    private MLookupInfo getInfoFromRequest(String referenceUuid, String fieldUuid, String processParameterUuid, String browseFieldUuid, String columnUuid, String columnName, String tableName) {
        int referenceId = 0;
        int referenceValueId = 0;
        int validationRuleId = 0;
        if (!Util.isEmpty((String)referenceUuid)) {
            referenceId = RecordUtil.getIdFromUuid("AD_Reference", referenceUuid, null);
        } else if (!Util.isEmpty((String)fieldUuid)) {
            Optional<MField> maybeField;
            MField field = (MField)RecordUtil.getEntity(Env.getCtx(), "AD_Field", fieldUuid, 0, null);
            int fieldId = field.getAD_Field_ID();
            List customFields = ASPUtil.getInstance((Properties)Env.getCtx()).getWindowFields(field.getAD_Tab_ID());
            if (customFields != null && (maybeField = customFields.stream().filter(customField -> customField.getAD_Field_ID() == fieldId).findFirst()).isPresent()) {
                field = maybeField.get();
                MColumn column = MColumn.get((Properties)Env.getCtx(), (int)field.getAD_Column_ID());
                referenceId = column.getAD_Reference_ID();
                referenceValueId = column.getAD_Reference_Value_ID();
                validationRuleId = column.getAD_Val_Rule_ID();
                columnName = column.getColumnName();
                if (field.getAD_Reference_ID() > 0) {
                    referenceId = field.getAD_Reference_ID();
                }
                if (field.getAD_Reference_Value_ID() > 0) {
                    referenceValueId = field.getAD_Reference_Value_ID();
                }
                if (field.getAD_Val_Rule_ID() > 0) {
                    validationRuleId = field.getAD_Val_Rule_ID();
                }
            }
        } else if (!Util.isEmpty((String)browseFieldUuid)) {
            Optional<MBrowseField> maybeField;
            MBrowseField browseField = (MBrowseField)RecordUtil.getEntity(Env.getCtx(), "AD_Browse_Field", browseFieldUuid, 0, null);
            int browseFieldId = browseField.getAD_Browse_Field_ID();
            List customFields = ASPUtil.getInstance((Properties)Env.getCtx()).getBrowseFields(browseField.getAD_Browse_ID());
            if (customFields != null && (maybeField = customFields.stream().filter(customField -> customField.getAD_Browse_Field_ID() == browseFieldId).findFirst()).isPresent()) {
                browseField = maybeField.get();
                referenceId = browseField.getAD_Reference_ID();
                referenceValueId = browseField.getAD_Reference_Value_ID();
                validationRuleId = browseField.getAD_Val_Rule_ID();
                MViewColumn viewColumn = browseField.getAD_View_Column();
                columnName = viewColumn.getAD_Column_ID() > 0 ? MColumn.getColumnName((Properties)Env.getCtx(), (int)viewColumn.getAD_Column_ID()) : browseField.getAD_Element().getColumnName();
            }
        } else if (!Util.isEmpty((String)processParameterUuid)) {
            Optional<MProcessPara> maybeParameter;
            MProcessPara processParameter = (MProcessPara)RecordUtil.getEntity(Env.getCtx(), "AD_Process_Para", processParameterUuid, 0, null);
            int processParameterId = processParameter.getAD_Process_Para_ID();
            List customParameters = ASPUtil.getInstance((Properties)Env.getCtx()).getProcessParameters(processParameter.getAD_Process_ID());
            if (customParameters != null && (maybeParameter = customParameters.stream().filter(customField -> customField.getAD_Process_Para_ID() == processParameterId).findFirst()).isPresent()) {
                processParameter = maybeParameter.get();
                referenceId = processParameter.getAD_Reference_ID();
                referenceValueId = processParameter.getAD_Reference_Value_ID();
                validationRuleId = processParameter.getAD_Val_Rule_ID();
                columnName = processParameter.getColumnName();
            }
        } else if (!Util.isEmpty((String)columnUuid)) {
            int columnId = RecordUtil.getIdFromUuid("AD_Column", columnUuid, null);
            if (columnId > 0) {
                MColumn column = MColumn.get((Properties)Env.getCtx(), (int)columnId);
                referenceId = column.getAD_Reference_ID();
                referenceValueId = column.getAD_Reference_Value_ID();
                validationRuleId = column.getAD_Val_Rule_ID();
                columnName = column.getColumnName();
            }
        } else if (!Util.isEmpty((String)columnName)) {
            referenceId = 19;
        } else if (!Util.isEmpty((String)tableName)) {
            referenceId = 19;
            columnName = tableName + "_ID";
        } else {
            throw new AdempiereException("@AD_Reference_ID@ / @AD_Column_ID@ / @AD_Table_ID@ / @AD_Process_Para_ID@ / @IsMandatory@");
        }
        return ReferenceUtil.getReferenceLookupInfo(referenceId, referenceValueId, columnName, validationRuleId);
    }

    private ListLookupItemsResponse.Builder convertLookupItemsList(ListLookupItemsRequest request) {
        MLookupInfo reference = this.getInfoFromRequest(request.getReferenceUuid(), request.getFieldUuid(), request.getProcessParameterUuid(), request.getBrowseFieldUuid(), request.getColumnUuid(), request.getColumnName(), request.getTableName());
        if (reference == null) {
            throw new AdempiereException("@AD_Reference_ID@ @NotFound@");
        }
        String sql = reference.Query;
        Properties context = Env.getCtx();
        int windowNo = ThreadLocalRandom.current().nextInt(1, 8997);
        Env.clearWinContext((int)windowNo);
        Map<String, Object> attributes = ValueUtil.convertValuesToObjects(request.getContextAttributesList());
        attributes.entrySet().forEach(attribute -> {
            if (attribute.getValue() instanceof Integer) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (int)((Integer)attribute.getValue()));
            } else if (attribute.getValue() instanceof Timestamp) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (Timestamp)((Timestamp)attribute.getValue()));
            } else if (attribute.getValue() instanceof Boolean) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (boolean)((Boolean)attribute.getValue()));
            } else if (attribute.getValue() instanceof String) {
                Env.setContext((Properties)context, (int)windowNo, (String)((String)attribute.getKey()), (String)((String)attribute.getValue()));
            }
        });
        sql = Env.parseContext((Properties)context, (int)windowNo, (String)sql, (boolean)false);
        if (Util.isEmpty((String)sql) && !Util.isEmpty((String)reference.Query)) {
            throw new AdempiereException("@AD_Tab_ID@ @WhereClause@ @Unparseable@");
        }
        sql = MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(sql, reference.TableName, true, false);
        ListLookupItemsResponse.Builder builder = ListLookupItemsResponse.newBuilder();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        long recordCount = 0L;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ResultSetMetaData metaData = rs.getMetaData();
                int keyValueType = metaData.getColumnType(1);
                Object keyValue = null;
                keyValue = keyValueType == 12 || keyValueType == -9 || keyValueType == 1 || keyValueType == -15 || keyValueType == 1111 ? rs.getString(2) : Integer.valueOf(rs.getInt(1));
                String uuid = null;
                int uuidIndex = this.getColumnIndex(metaData, "UUID");
                if (uuidIndex != -1) {
                    uuid = rs.getString(uuidIndex);
                }
                LookupItem.Builder valueObject = this.convertObjectFromResult(keyValue, uuid, rs.getString(2), rs.getString(3));
                builder.addRecords(valueObject.build());
                ++recordCount;
            }
        }
        catch (Exception e) {
            try {
                this.log.severe(e.getLocalizedMessage());
                throw new AdempiereException((Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        builder.setRecordCount(recordCount);
        return builder;
    }

    private int getColumnIndex(ResultSetMetaData metaData, String columnName) throws SQLException {
        for (int columnIndex = 1; columnIndex <= metaData.getColumnCount(); ++columnIndex) {
            if (!metaData.getColumnName(columnIndex).toLowerCase().equals(columnName.toLowerCase())) continue;
            return columnIndex;
        }
        return -1;
    }

    private void setParameterFromObject(PreparedStatement pstmt, Object value, int index) throws SQLException {
        if (value instanceof Integer) {
            pstmt.setInt(index, (Integer)value);
        } else if (value instanceof Double) {
            pstmt.setDouble(index, (Double)value);
        } else if (value instanceof Long) {
            pstmt.setLong(index, (Long)value);
        } else if (value instanceof BigDecimal) {
            pstmt.setBigDecimal(index, (BigDecimal)value);
        } else if (value instanceof String) {
            pstmt.setString(index, (String)value);
        } else if (value instanceof Timestamp) {
            pstmt.setTimestamp(index, (Timestamp)value);
        } else if (value instanceof Boolean) {
            pstmt.setString(index, (Boolean)value != false ? "Y" : "N");
        }
    }

    private MQuery getReportQueryFromCriteria(Criteria criteria) {
        MTable table = MTable.get((Properties)Env.getCtx(), (String)criteria.getTableName());
        MQuery query = new MQuery(table.getTableName());
        criteria.getConditionsList().stream().filter(condition -> !Util.isEmpty((String)condition.getColumnName())).forEach(condition -> {
            String columnName = condition.getColumnName();
            String operator = this.convertOperator(condition.getOperatorValue());
            if (condition.getOperatorValue() == 2 || condition.getOperatorValue() == 3) {
                columnName = "UPPER(" + columnName + ")";
                query.addRestriction(columnName, operator, ValueUtil.getObjectFromValue(condition.getValue(), true));
            }
            if (condition.getOperatorValue() == 11 || condition.getOperatorValue() == 12) {
                StringBuffer whereClause = new StringBuffer();
                whereClause.append(columnName).append(this.convertOperator(condition.getOperatorValue()));
                StringBuffer parameter = new StringBuffer();
                condition.getValuesList().forEach(value -> {
                    Object convertedValue;
                    if (parameter.length() > 0) {
                        parameter.append(", ");
                    }
                    if ((convertedValue = ValueUtil.getObjectFromValue(value)) instanceof String) {
                        convertedValue = "'" + convertedValue + "'";
                    }
                    parameter.append(convertedValue);
                });
                whereClause.append("(").append(parameter).append(")");
                query.addRestriction(whereClause.toString());
            } else if (condition.getOperatorValue() == 8) {
                query.addRangeRestriction(columnName, ValueUtil.getObjectFromValue(condition.getValue()), ValueUtil.getObjectFromValue(condition.getValueTo()));
            } else if (condition.getOperatorValue() == 10 || condition.getOperatorValue() == 9) {
                query.addRestriction(columnName, operator, null);
            } else {
                query.addRestriction(columnName, operator, ValueUtil.getObjectFromValue(condition.getValue()));
            }
        });
        return query;
    }

    private String getBrowserWhereClause(MBrowse browser, String parsedWhereClause, List<KeyValue> contextAttributes, HashMap<String, Object> parameterMap, List<Object> values) {
        StringBuilder browserWhereClause = new StringBuilder();
        List fields = ASPUtil.getInstance().getBrowseFields(browser.getAD_Browse_ID());
        LinkedHashMap<String, MBrowseField> fieldsMap = new LinkedHashMap<String, MBrowseField>();
        AtomicReference<String> convertedWhereClause = new AtomicReference<String>(parsedWhereClause);
        if (parsedWhereClause != null && contextAttributes != null) {
            contextAttributes.forEach(contextValue -> convertedWhereClause.set(((String)convertedWhereClause.get()).replaceAll("@" + contextValue.getKey() + "@", String.valueOf(ValueUtil.getObjectFromValue(contextValue.getValue())))));
        }
        for (Object field : fields) {
            fieldsMap.put(field.getAD_View_Column().getColumnName(), (MBrowseField)field);
        }
        boolean onRange = false;
        if (parameterMap.size() > 0) {
            for (Map.Entry entry : parameterMap.entrySet()) {
                MBrowseField field = (MBrowseField)fieldsMap.get(entry.getKey());
                if (field == null) continue;
                String columnName = field.getAD_View_Column().getColumnSQL();
                Object parameterValue = entry.getValue();
                if (!onRange) {
                    if (parameterValue != null && !field.isRange()) {
                        if (browserWhereClause.length() > 0) {
                            browserWhereClause.append(" AND ");
                        }
                        if (10 == field.getAD_Reference_ID()) {
                            String value = (String)parameterValue;
                            if (value.contains(",")) {
                                value = value.replace(" ", "");
                                String inStr = new String(value);
                                StringBuffer outStr = new StringBuffer("(");
                                int i = inStr.indexOf(44);
                                while (i != -1) {
                                    outStr.append("'" + inStr.substring(0, i) + "',");
                                    inStr = inStr.substring(i + 1, inStr.length());
                                    i = inStr.indexOf(44);
                                }
                                outStr.append("'" + inStr + "')");
                                browserWhereClause.append(columnName).append(" IN ").append(outStr);
                                continue;
                            }
                            if (value.contains("%")) {
                                browserWhereClause.append(" lower( ").append(columnName).append(") LIKE ? ");
                                values.add(parameterValue.toString().toLowerCase());
                                continue;
                            }
                            browserWhereClause.append(" lower( ").append(columnName).append(") = ? ");
                            values.add(parameterValue.toString().toLowerCase());
                            continue;
                        }
                        browserWhereClause.append(columnName).append("=? ");
                        values.add(parameterValue);
                        continue;
                    }
                    if (parameterValue != null && field.isRange()) {
                        if (browserWhereClause.length() > 0) {
                            browserWhereClause.append(" AND ");
                        }
                        if (10 == field.getAD_Reference_ID()) {
                            browserWhereClause.append(" lower( ").append(columnName).append(") >= ? ");
                            values.add(parameterValue.toString().toLowerCase());
                        } else {
                            browserWhereClause.append(columnName).append(" >= ? ");
                            values.add(parameterValue);
                        }
                        onRange = true;
                        continue;
                    }
                    if (parameterValue != null || !field.isRange()) continue;
                    onRange = true;
                    continue;
                }
                if (parameterValue != null) {
                    if (browserWhereClause.length() > 0) {
                        browserWhereClause.append(" AND ");
                    }
                    if (10 == field.getAD_Reference_ID()) {
                        browserWhereClause.append(" lower( ").append(columnName).append(") <= ? ");
                        values.add(parameterValue.toString().toLowerCase());
                    } else {
                        browserWhereClause.append(columnName).append(" <= ? ");
                        values.add(parameterValue);
                    }
                    onRange = false;
                    continue;
                }
                onRange = false;
            }
        }
        String whereClause = null;
        if (!Util.isEmpty((String)convertedWhereClause.get())) {
            whereClause = convertedWhereClause.get();
        }
        if (browserWhereClause.length() > 0) {
            whereClause = Util.isEmpty((String)whereClause) ? browserWhereClause.toString() : whereClause + " AND (" + browserWhereClause + ")";
        }
        return whereClause;
    }

    private ListBrowserItemsResponse.Builder convertBrowserList(ListBrowserItemsRequest request) {
        int pageMultiplier;
        ListBrowserItemsResponse.Builder builder = ListBrowserItemsResponse.newBuilder();
        MBrowse browser = this.getBrowser(request.getUuid());
        if (browser == null) {
            return builder;
        }
        Criteria criteria = request.getCriteria();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        criteria.getConditionsList().forEach(condition -> parameterMap.put(condition.getColumnName(), ValueUtil.getObjectFromValue(condition.getValue())));
        ArrayList<Object> values = new ArrayList<Object>();
        String whereClause = this.getBrowserWhereClause(browser, browser.getWhereClause(), request.getContextAttributesList(), parameterMap, values);
        int page = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        String query = DictionaryUtil.addQueryReferencesFromBrowser(browser);
        String orderByClause = DictionaryUtil.getSQLOrderBy(browser);
        StringBuilder sql = new StringBuilder(query);
        if (!Util.isEmpty((String)whereClause)) {
            sql.append(" WHERE ").append(whereClause);
        } else {
            sql.append(" WHERE 1=1");
        }
        MView view = browser.getAD_View();
        MViewDefinition parentDefinition = view.getParentViewDefinition();
        String tableNameAlias = parentDefinition.getTableAlias();
        String tableName = parentDefinition.getAD_Table().getTableName();
        String parsedSQL = MRole.getDefault().addAccessSQL(sql.toString(), tableNameAlias, true, false);
        orderByClause = Util.isEmpty((String)orderByClause) ? "" : " ORDER BY " + orderByClause;
        int count = RecordUtil.countRecords(parsedSQL, tableName, values);
        String nexPageToken = null;
        int n = pageMultiplier = page == 0 ? 1 : page;
        if (count > 50 * pageMultiplier) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (page + 1);
        }
        parsedSQL = parsedSQL + " AND ROWNUM >= " + page + " AND ROWNUM <= " + 50;
        parsedSQL = parsedSQL + orderByClause;
        builder = this.convertBrowserResult(browser, parsedSQL, values);
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListBrowserItemsResponse.Builder convertBrowserResult(MBrowse browser, String sql, List<Object> values) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ListBrowserItemsResponse.Builder builder = ListBrowserItemsResponse.newBuilder();
        long recordCount = 0L;
        try {
            LinkedHashMap<String, MBrowseField> fieldsMap = new LinkedHashMap<String, MBrowseField>();
            for (Object field : ASPUtil.getInstance().getBrowseFields(browser.getAD_Browse_ID())) {
                fieldsMap.put(field.getAD_View_Column().getColumnName().toUpperCase(), (MBrowseField)field);
            }
            pstmt = DB.prepareStatement((String)sql, null);
            AtomicInteger parameterIndex = new AtomicInteger(1);
            for (Object e : values) {
                this.setParameterFromObject((PreparedStatement)pstmt, e, parameterIndex.getAndIncrement());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Entity.Builder valueObjectBuilder = Entity.newBuilder();
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                for (int index = 1; index <= resultSetMetaData.getColumnCount(); ++index) {
                    try {
                        String columnName = resultSetMetaData.getColumnName(index);
                        MBrowseField field = (MBrowseField)fieldsMap.get(columnName.toUpperCase());
                        Value.Builder valueBuilder = null;
                        if (field == null) {
                            String value = rs.getString(index);
                            if (Util.isEmpty((String)value)) continue;
                            valueBuilder = ValueUtil.getValueFromString(value);
                            valueObjectBuilder.putValues(columnName, valueBuilder.build());
                            continue;
                        }
                        String fieldColumnName = field.getAD_View_Column().getColumnName();
                        valueBuilder = ValueUtil.getValueFromReference(rs.getObject(index), field.getAD_Reference_ID());
                        if (valueBuilder.getValueType().equals((Object)Value.ValueType.UNRECOGNIZED)) continue;
                        valueObjectBuilder.putValues(fieldColumnName, valueBuilder.build());
                        continue;
                    }
                    catch (Exception e) {
                        this.log.severe(e.getLocalizedMessage());
                    }
                }
                builder.addRecords(valueObjectBuilder.build());
                ++recordCount;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
        finally {
            DB.close(rs, pstmt);
        }
        builder.setRecordCount(recordCount);
        return builder;
    }

    private MBrowse getBrowser(String uuid) {
        String key = uuid + "|" + Env.getAD_Language((Properties)Env.getCtx());
        MBrowse browser = (MBrowse)browserRequested.get((Object)key);
        if (browser == null) {
            browser = (MBrowse)new Query(Env.getCtx(), "AD_Browse", "UUID = ?", null).setParameters(new Object[]{uuid}).setOnlyActiveRecords(true).first();
            browser = ASPUtil.getInstance((Properties)Env.getCtx()).getBrowse(browser.getAD_Browse_ID());
        }
        if (browser != null) {
            browserRequested.put((Object)key, (Object)browser);
        }
        return browser;
    }

    private Callout.Builder runcallout(RunCalloutRequest request) {
        Callout.Builder calloutBuilder = Callout.newBuilder();
        Trx.run(transactionName -> {
            MTab tab = (MTab)tabRequested.get((Object)request.getTabUuid());
            if (tab == null) {
                tab = MTab.get((Properties)Env.getCtx(), (int)RecordUtil.getIdFromUuid("AD_Tab", request.getTabUuid(), transactionName));
            }
            if (tab != null) {
                int windowNo;
                int tabNo;
                Optional<MField> searchedValue;
                MField field = null;
                if (tab != null && (searchedValue = Arrays.asList(tab.getFields(false, null)).stream().filter(searchField -> searchField.getAD_Column().getColumnName().equals(request.getColumnName())).findFirst()).isPresent()) {
                    field = searchedValue.get();
                }
                if ((tabNo = tab.getSeqNo() / 10 - 1) < 0) {
                    tabNo = 0;
                }
                if ((windowNo = request.getWindowNo()) <= 0) {
                    windowNo = this.windowNoEmulation.getAndIncrement();
                }
                GridWindowVO gridWindowVo = GridWindowVO.create((Properties)Env.getCtx(), (int)windowNo, (int)tab.getAD_Window_ID());
                GridWindow gridWindow = new GridWindow(gridWindowVo, true);
                GridTabVO gridTabVo = GridTabVO.create((GridWindowVO)gridWindowVo, (int)tabNo, (MTab)tab, (boolean)false, (boolean)true);
                GridFieldVO gridFieldVo = GridFieldVO.create((Properties)Env.getCtx(), (int)windowNo, (int)tabNo, (int)tab.getAD_Window_ID(), (int)tab.getAD_Tab_ID(), (boolean)false, (MField)field);
                GridField gridField = new GridField(gridFieldVo);
                GridTab gridTab = new GridTab(gridTabVo, gridWindow, true);
                gridTab.query(false);
                gridTab.clearSelection();
                gridTab.dataNew(false);
                Map<String, Object> attributes = ValueUtil.convertValuesToObjects(request.getContextAttributesList());
                for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                    gridTab.setValue(attribute.getKey(), attribute.getValue());
                }
                gridField.setValue(ValueUtil.getObjectFromValue(request.getOldValue()), false);
                gridField.setValue(ValueUtil.getObjectFromValue(request.getValue()), false);
                String result = this.processCallout(windowNo, gridTab, gridField);
                Arrays.asList(gridTab.getFields()).stream().filter(fieldValue -> this.isValidChange((GridField)fieldValue)).forEach(fieldValue -> calloutBuilder.putValues(fieldValue.getColumnName(), ValueUtil.getValueFromObject(fieldValue.getValue()).build()));
                calloutBuilder.setResult(ValueUtil.validateNull(result));
            }
        });
        return calloutBuilder;
    }

    private boolean isValidChange(GridField gridField) {
        if (gridField.getColumnName().equals("Created") || gridField.getColumnName().equals("CreatedBy") || gridField.getColumnName().equals("Updated") || gridField.getColumnName().equals("UpdatedBy") || gridField.getColumnName().equals("UUID")) {
            return false;
        }
        if (!gridField.isDisplayed()) {
            return false;
        }
        if (gridField.isKey()) {
            return false;
        }
        if (gridField.getValue() == null && gridField.getOldValue() == null) {
            return false;
        }
        return gridField.getOldValue() == null || gridField.getValue() == null || !gridField.getValue().equals(gridField.getOldValue());
    }

    private String processCallout(int windowNo, GridTab gridTab, GridField field) {
        String callout = field.getCallout();
        if (callout.length() == 0) {
            return "";
        }
        Object value = field.getValue();
        Object oldValue = field.getOldValue();
        this.log.fine(field.getColumnName() + "=" + value + " (" + callout + ") - old=" + oldValue);
        StringTokenizer st = new StringTokenizer(callout, ";,", false);
        while (st.hasMoreTokens()) {
            String cmd = st.nextToken().trim();
            String retValue = "";
            if (cmd.toLowerCase().startsWith("@script:")) {
                MRule rule = MRule.get((Properties)Env.getCtx(), (String)cmd.substring("@script:".length()));
                if (rule == null) {
                    retValue = "Callout " + cmd + " not found";
                    this.log.log(Level.SEVERE, retValue);
                    return retValue;
                }
                if (!rule.getEventType().equals("C") || !rule.getRuleType().equals("S")) {
                    retValue = "Callout " + cmd + " must be of type JSR 223 and event Callout";
                    this.log.log(Level.SEVERE, retValue);
                    return retValue;
                }
                ScriptEngine engine = rule.getScriptEngine();
                MRule.setContext((ScriptEngine)engine, (Properties)Env.getCtx(), (int)windowNo);
                engine.put("A_WindowNo", windowNo);
                engine.put("A_Tab", this);
                engine.put("A_Field", field);
                engine.put("A_Value", value);
                engine.put("A_OldValue", oldValue);
                engine.put("A_Ctx", Env.getCtx());
                try {
                    retValue = engine.eval(rule.getScript()).toString();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "", (Throwable)e);
                    retValue = "Callout Invalid: " + e.toString();
                    return retValue;
                }
            }
            org.compiere.model.Callout call = null;
            String method = null;
            int methodStart = cmd.lastIndexOf(46);
            try {
                if (methodStart != -1) {
                    Class<?> cClass = Class.forName(cmd.substring(0, methodStart));
                    call = (org.compiere.model.Callout)cClass.newInstance();
                    method = cmd.substring(methodStart + 1);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "class", (Throwable)e);
                return "Callout Invalid: " + cmd + " (" + e.toString() + ")";
            }
            if (call == null || method == null || method.length() == 0) {
                return "Callout Invalid: " + method;
            }
            try {
                retValue = call.start(Env.getCtx(), method, windowNo, gridTab, field, value, oldValue);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "start", (Throwable)e);
                retValue = "Callout Invalid: " + e.toString();
                return retValue;
            }
            if (Util.isEmpty((String)retValue)) continue;
            this.log.severe(retValue);
            return retValue;
        }
        return "";
    }

    private LookupItem.Builder convertObjectFromResult(Object keyValue, String uuidValue, String value, String displayValue) {
        LookupItem.Builder builder = LookupItem.newBuilder();
        if (keyValue == null) {
            return builder;
        }
        builder.setUuid(ValueUtil.validateNull(uuidValue));
        if (keyValue instanceof Integer) {
            builder.setId((Integer)keyValue);
            builder.putValues("KeyColumn", ValueUtil.getValueFromInteger((Integer)keyValue).build());
        } else {
            builder.putValues("KeyColumn", ValueUtil.getValueFromString((String)keyValue).build());
        }
        if (!Util.isEmpty((String)value)) {
            builder.putValues("ValueColumn", ValueUtil.getValueFromString(value).build());
        }
        if (!Util.isEmpty((String)displayValue)) {
            builder.putValues("DisplayColumn", ValueUtil.getValueFromString(displayValue).build());
        }
        return builder;
    }

    private DefaultValue.Builder convertDefaultValueFromResult(Object keyValue, String uuidValue, String value, String displayValue) {
        DefaultValue.Builder builder = DefaultValue.newBuilder();
        if (keyValue == null) {
            return builder;
        }
        builder.setUuid(ValueUtil.validateNull(uuidValue));
        if (keyValue instanceof Integer) {
            builder.setId((Integer)keyValue);
            builder.putValues("KeyColumn", ValueUtil.getValueFromInteger((Integer)keyValue).build());
        } else {
            builder.putValues("KeyColumn", ValueUtil.getValueFromString((String)keyValue).build());
        }
        if (!Util.isEmpty((String)value)) {
            builder.putValues("ValueColumn", ValueUtil.getValueFromString(value).build());
        }
        if (!Util.isEmpty((String)displayValue)) {
            builder.putValues("DisplayColumn", ValueUtil.getValueFromString(displayValue).build());
        }
        return builder;
    }
}

