/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MEntityType;
import org.compiere.model.MMigration;
import org.compiere.model.MMigrationData;
import org.compiere.model.MMigrationStep;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Modification;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.SessionManager;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.ListPackagesRequest;
import org.spin.grpc.util.ListPackagesResponse;
import org.spin.grpc.util.ListStepsRequest;
import org.spin.grpc.util.ListStepsResponse;
import org.spin.grpc.util.ListUpdatesRequest;
import org.spin.grpc.util.ListUpdatesResponse;
import org.spin.grpc.util.Package;
import org.spin.grpc.util.PackageVersion;
import org.spin.grpc.util.Step;
import org.spin.grpc.util.StepValue;
import org.spin.grpc.util.Update;
import org.spin.grpc.util.UpdateCenterGrpc;

public class UpdateImplementation
extends UpdateCenterGrpc.UpdateCenterImplBase {
    private CLogger log = CLogger.getCLogger(UpdateImplementation.class);

    @Override
    public void listPackages(ListPackagesRequest request, StreamObserver<ListPackagesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Packages Requested is Null");
            }
            this.log.fine("Object List Requested = " + request);
            SessionManager.createSessionFromToken(request.getToken());
            ListPackagesResponse.Builder packagesList = this.convertPackagesList(request);
            responseObserver.onNext((Object)packagesList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listUpdates(ListUpdatesRequest request, StreamObserver<ListUpdatesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Updates Requested is Null");
            }
            this.log.fine("Object List Requested = " + request);
            SessionManager.createSessionFromToken(request.getToken());
            ListUpdatesResponse.Builder updatesList = this.convertUpdatesList(request);
            responseObserver.onNext((Object)updatesList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listSteps(ListStepsRequest request, StreamObserver<ListStepsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Steps Requested is Null");
            }
            this.log.fine("Object List Requested = " + request);
            SessionManager.createSessionFromToken(request.getToken());
            ListStepsResponse.Builder stepsList = this.convertStepsList(request);
            responseObserver.onNext((Object)stepsList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private ListStepsResponse.Builder convertStepsList(ListStepsRequest request) {
        ListStepsResponse.Builder builder = ListStepsResponse.newBuilder();
        int migrationId = request.getUpdateId();
        if (migrationId <= 0) {
            migrationId = RecordUtil.getIdFromUuid("AD_Migration", request.getUpdateUuid(), null);
        }
        if (request.getUpdateId() < 0) {
            throw new AdempiereException("@AD_Migration_ID@ @NotFound@");
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber("page-token", request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        StringBuffer whereClause = new StringBuffer("AD_Migration_ID = ?");
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        parameters.add(migrationId);
        if (request.getFromStep() > 0) {
            parameters.add(request.getFromStep());
            whereClause.append(" AND ").append("SeqNo").append(" >= ?");
        }
        Query query = new Query(Env.getCtx(), "AD_MigrationStep", whereClause.toString(), null).setOnlyActiveRecords(true).setParameters(parameters).setOrderBy("SeqNo");
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(migration -> builder.addSteps(this.convertStep((MMigrationStep)migration)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix("page-token") + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private Step.Builder convertStep(MMigrationStep migrationStep) {
        Step.Builder builder = Step.newBuilder().setId(migrationStep.getAD_MigrationStep_ID()).setUuid(ValueUtil.validateNull(migrationStep.getUUID())).setAction(ValueUtil.validateNull(migrationStep.getAction())).setComments(ValueUtil.validateNull(migrationStep.getComments())).setStepType(ValueUtil.validateNull(migrationStep.getStepType())).setTableId(migrationStep.getAD_Table_ID()).setRecordId(migrationStep.getRecord_ID()).setIsParsed(migrationStep.isParse()).setSequence(migrationStep.getSeqNo()).setSqlStatement(ValueUtil.validateNull(migrationStep.getSQLStatement())).setRollbackStatement(ValueUtil.validateNull(migrationStep.getRollbackStatement()));
        new Query(Env.getCtx(), "AD_MigrationData", "AD_MigrationStep_ID = ?", null).setParameters(new Object[]{migrationStep.getAD_MigrationStep_ID()}).list().forEach(modification -> builder.addStepValues(this.convertStepValue((MMigrationData)modification)));
        return builder;
    }

    private StepValue.Builder convertStepValue(MMigrationData migrationData) {
        StepValue.Builder builder = StepValue.newBuilder().setId(migrationData.getAD_MigrationData_ID()).setUuid(ValueUtil.validateNull(migrationData.getUUID())).setColumnId(migrationData.getAD_Column_ID()).setOldValue(ValueUtil.validateNull(migrationData.getOldValue())).setBackupValue(ValueUtil.validateNull(migrationData.getBackupValue())).setNewValue(ValueUtil.validateNull(migrationData.getNewValue())).setIsOldNull(migrationData.isOldNull()).setIsBackupNull(migrationData.isBackupNull()).setIsNewNull(migrationData.isNewNull());
        return builder;
    }

    private ListUpdatesResponse.Builder convertUpdatesList(ListUpdatesRequest request) {
        ListUpdatesResponse.Builder builder = ListUpdatesResponse.newBuilder();
        if (Util.isEmpty((String)request.getEntityType())) {
            throw new AdempiereException("@EntityType@ @NotFound@");
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber("page-token", request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        StringBuffer whereClause = new StringBuffer("EntityType = ?");
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(request.getEntityType());
        if (!Util.isEmpty((String)request.getReleaseNo())) {
            parameters.add(request.getReleaseNo());
            whereClause.append(" AND ReleaseNo = ?");
        }
        Query query = new Query(Env.getCtx(), "AD_Migration", whereClause.toString(), null).setOnlyActiveRecords(true).setParameters(parameters).setOrderBy("SeqNo");
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(migration -> builder.addUpdates(this.convertMigration((MMigration)migration)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix("page-token") + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private Update.Builder convertMigration(MMigration migration) {
        return Update.newBuilder().setId(migration.getAD_Migration_ID()).setUuid(ValueUtil.validateNull(migration.getUUID())).setEntityType(ValueUtil.validateNull(migration.getEntityType())).setSequence(migration.getSeqNo()).setName(ValueUtil.validateNull(migration.getName())).setComments(ValueUtil.validateNull(migration.getComments())).setReleaseNo(ValueUtil.validateNull(migration.getReleaseNo())).setStepQuantity(this.getStepQuantity(migration));
    }

    private int getStepQuantity(MMigration migration) {
        return new Query(Env.getCtx(), "AD_MigrationStep", "AD_Migration_ID = ?", null).setParameters(new Object[]{migration.getAD_Migration_ID()}).count();
    }

    private ListPackagesResponse.Builder convertPackagesList(ListPackagesRequest request) {
        ListPackagesResponse.Builder builder = ListPackagesResponse.newBuilder();
        if (Util.isEmpty((String)request.getReleaseNo())) {
            throw new AdempiereException("@ReleaseNo@ @NotFound@");
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber("page-token", request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        String whereClause = null;
        ArrayList<String> parameters = new ArrayList<String>();
        if (!Util.isEmpty((String)request.getVersion())) {
            whereClause = "Version = ? OR EXISTS(SELECT 1 FROM AD_Modification WHERE EntityType = AD_EntityType.EntityType AND Version = ?)";
            parameters.add(request.getVersion());
            parameters.add(request.getVersion());
        }
        Query query = new Query(Env.getCtx(), "AD_EntityType", whereClause, null).setOnlyActiveRecords(true).setOrderBy("Name");
        if (whereClause != null) {
            query.setParameters(parameters);
        }
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(packageValue -> builder.addPackages(this.convertPackage((MEntityType)packageValue)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix("page-token") + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private Package.Builder convertPackage(MEntityType entityType) {
        Package.Builder builder = Package.newBuilder().setId(entityType.getAD_EntityType_ID()).setUuid(ValueUtil.validateNull(entityType.getUUID())).setEntityType(ValueUtil.validateNull(entityType.getEntityType())).setName(ValueUtil.validateNull(entityType.getName())).setDescription(ValueUtil.validateNull(entityType.getDescription())).setHelp(ValueUtil.validateNull(entityType.getHelp())).setVersion(ValueUtil.validateNull(entityType.getVersion())).setModelPackage(ValueUtil.validateNull(entityType.getModelPackage()));
        new Query(Env.getCtx(), "AD_Modification", "EntityType = ?", null).setParameters(new Object[]{entityType.getEntityType()}).setOrderBy("SeqNo").list().forEach(modification -> builder.addVersions(this.convertPackageVersion((X_AD_Modification)modification)));
        return builder;
    }

    private PackageVersion.Builder convertPackageVersion(X_AD_Modification modification) {
        return PackageVersion.newBuilder().setId(modification.getAD_Modification_ID()).setUuid(ValueUtil.validateNull(modification.getUUID())).setSequence(modification.getSeqNo()).setName(ValueUtil.validateNull(modification.getName())).setDescription(ValueUtil.validateNull(modification.getDescription())).setHelp(ValueUtil.validateNull(modification.getHelp())).setVersion(ValueUtil.validateNull(modification.getVersion()));
    }
}

