/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GenericPO;
import org.adempiere.pos.process.ReverseTheSalesTransaction;
import org.adempiere.pos.service.CPOS;
import org.adempiere.pos.util.POSTicketHandler;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MCharge;
import org.compiere.model.MColumn;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProductPricing;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_BPartner;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.base.util.ContextManager;
import org.spin.base.util.ConvertUtil;
import org.spin.base.util.DocumentUtil;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.AddressRequest;
import org.spin.grpc.util.AllocateSellerRequest;
import org.spin.grpc.util.AvailableDocumentType;
import org.spin.grpc.util.AvailablePaymentMethod;
import org.spin.grpc.util.AvailablePriceList;
import org.spin.grpc.util.AvailableRefund;
import org.spin.grpc.util.AvailableWarehouse;
import org.spin.grpc.util.CashClosing;
import org.spin.grpc.util.CashClosingRequest;
import org.spin.grpc.util.CashOpeningRequest;
import org.spin.grpc.util.CashWithdrawalRequest;
import org.spin.grpc.util.CreateCustomerBankAccountRequest;
import org.spin.grpc.util.CreateCustomerRequest;
import org.spin.grpc.util.CreateOrderLineRequest;
import org.spin.grpc.util.CreateOrderRequest;
import org.spin.grpc.util.CreatePaymentReferenceRequest;
import org.spin.grpc.util.CreatePaymentRequest;
import org.spin.grpc.util.CreateShipmentLineRequest;
import org.spin.grpc.util.CreateShipmentRequest;
import org.spin.grpc.util.Customer;
import org.spin.grpc.util.CustomerBankAccount;
import org.spin.grpc.util.DeallocateSellerRequest;
import org.spin.grpc.util.DeleteCustomerBankAccountRequest;
import org.spin.grpc.util.DeleteOrderLineRequest;
import org.spin.grpc.util.DeleteOrderRequest;
import org.spin.grpc.util.DeletePaymentReferenceRequest;
import org.spin.grpc.util.DeletePaymentRequest;
import org.spin.grpc.util.DeleteShipmentLineRequest;
import org.spin.grpc.util.Empty;
import org.spin.grpc.util.GetAvailableRefundRequest;
import org.spin.grpc.util.GetCustomerBankAccountRequest;
import org.spin.grpc.util.GetCustomerRequest;
import org.spin.grpc.util.GetKeyLayoutRequest;
import org.spin.grpc.util.GetOrderRequest;
import org.spin.grpc.util.GetProductPriceRequest;
import org.spin.grpc.util.HoldOrderRequest;
import org.spin.grpc.util.KeyLayout;
import org.spin.grpc.util.KeyValue;
import org.spin.grpc.util.ListAvailableCurrenciesRequest;
import org.spin.grpc.util.ListAvailableCurrenciesResponse;
import org.spin.grpc.util.ListAvailableDocumentTypesRequest;
import org.spin.grpc.util.ListAvailableDocumentTypesResponse;
import org.spin.grpc.util.ListAvailablePaymentMethodsRequest;
import org.spin.grpc.util.ListAvailablePaymentMethodsResponse;
import org.spin.grpc.util.ListAvailablePriceListRequest;
import org.spin.grpc.util.ListAvailablePriceListResponse;
import org.spin.grpc.util.ListAvailableSellersRequest;
import org.spin.grpc.util.ListAvailableSellersResponse;
import org.spin.grpc.util.ListAvailableWarehousesRequest;
import org.spin.grpc.util.ListAvailableWarehousesResponse;
import org.spin.grpc.util.ListCashMovementsRequest;
import org.spin.grpc.util.ListCashMovementsResponse;
import org.spin.grpc.util.ListCashSummaryMovementsRequest;
import org.spin.grpc.util.ListCashSummaryMovementsResponse;
import org.spin.grpc.util.ListCustomerBankAccountsRequest;
import org.spin.grpc.util.ListCustomerBankAccountsResponse;
import org.spin.grpc.util.ListOrderLinesRequest;
import org.spin.grpc.util.ListOrderLinesResponse;
import org.spin.grpc.util.ListOrdersRequest;
import org.spin.grpc.util.ListOrdersResponse;
import org.spin.grpc.util.ListPaymentReferencesRequest;
import org.spin.grpc.util.ListPaymentReferencesResponse;
import org.spin.grpc.util.ListPaymentsRequest;
import org.spin.grpc.util.ListPaymentsResponse;
import org.spin.grpc.util.ListPointOfSalesRequest;
import org.spin.grpc.util.ListPointOfSalesResponse;
import org.spin.grpc.util.ListProductPriceRequest;
import org.spin.grpc.util.ListProductPriceResponse;
import org.spin.grpc.util.ListShipmentLinesRequest;
import org.spin.grpc.util.ListShipmentLinesResponse;
import org.spin.grpc.util.Order;
import org.spin.grpc.util.OrderLine;
import org.spin.grpc.util.Payment;
import org.spin.grpc.util.PaymentReference;
import org.spin.grpc.util.PaymentSummary;
import org.spin.grpc.util.PointOfSales;
import org.spin.grpc.util.PointOfSalesRequest;
import org.spin.grpc.util.PrintTicketRequest;
import org.spin.grpc.util.PrintTicketResponse;
import org.spin.grpc.util.ProcessOrderRequest;
import org.spin.grpc.util.ProcessShipmentRequest;
import org.spin.grpc.util.ProductPrice;
import org.spin.grpc.util.ReleaseOrderRequest;
import org.spin.grpc.util.ReverseSalesRequest;
import org.spin.grpc.util.Shipment;
import org.spin.grpc.util.ShipmentLine;
import org.spin.grpc.util.StoreGrpc;
import org.spin.grpc.util.UpdateCustomerBankAccountRequest;
import org.spin.grpc.util.UpdateCustomerRequest;
import org.spin.grpc.util.UpdateOrderLineRequest;
import org.spin.grpc.util.UpdateOrderRequest;
import org.spin.grpc.util.UpdatePaymentRequest;
import org.spin.grpc.util.ValidatePINRequest;

public class PointOfSalesServiceImplementation
extends StoreGrpc.StoreImplBase {
    private CLogger log = CLogger.getCLogger(PointOfSalesServiceImplementation.class);
    private static CCache<String, MProduct> productCache = new CCache("M_Product", 30, 20);

    @Override
    public void getProductPrice(GetProductPriceRequest request, StreamObserver<ProductPrice> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getSearchValue());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ProductPrice.Builder productPrice = this.getProductPrice(request);
            responseObserver.onNext((Object)productPrice.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createOrder(CreateOrderRequest request, StreamObserver<Order> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Create Order = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Order.Builder order = this.createOrder(request);
            responseObserver.onNext((Object)order.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getPointOfSales(PointOfSalesRequest request, StreamObserver<PointOfSales> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Get Point of Sales = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            PointOfSales.Builder pos = this.getPosBuilder(request);
            responseObserver.onNext((Object)pos.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listPointOfSales(ListPointOfSalesRequest request, StreamObserver<ListPointOfSalesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Get Point of Sales List = " + request.getUserUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListPointOfSalesResponse.Builder posList = this.convertPointOfSalesList(request);
            responseObserver.onNext((Object)posList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createOrderLine(CreateOrderLineRequest request, StreamObserver<OrderLine> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Add Line for Order = " + request.getOrderUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            OrderLine.Builder orderLine = this.createAndConvertOrderLine(request);
            responseObserver.onNext((Object)orderLine.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void deleteOrderLine(DeleteOrderLineRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Add Line for Order = " + request.getOrderLineUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder orderLine = this.deleteOrderLine(request);
            responseObserver.onNext((Object)orderLine.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void deleteOrder(DeleteOrderRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Add Line for Order = " + request.getOrderUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder order = this.deleteOrder(request);
            responseObserver.onNext((Object)order.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void updateOrderLine(UpdateOrderLineRequest request, StreamObserver<OrderLine> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Add Line for Order = " + request.getOrderLineUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            OrderLine.Builder orderLine = this.updateAndConvertOrderLine(request);
            responseObserver.onNext((Object)orderLine.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listProductPrice(ListProductPriceRequest request, StreamObserver<ListProductPriceResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Add Line for Order = " + request.getSearchValue());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListProductPriceResponse.Builder productPriceList = this.getProductPriceList(request);
            responseObserver.onNext((Object)productPriceList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getOrder(GetOrderRequest request, StreamObserver<Order> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Create Order = " + request.getOrderUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Order.Builder order = ConvertUtil.convertOrder(this.getOrder(request.getOrderUuid(), null));
            responseObserver.onNext((Object)order.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createPayment(CreatePaymentRequest request, StreamObserver<Payment> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Create Order = " + request.getOrderUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Payment.Builder payment = ConvertUtil.convertPayment(this.createPayment(request));
            responseObserver.onNext((Object)payment.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void updatePayment(UpdatePaymentRequest request, StreamObserver<Payment> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Create Order = " + request.getPaymentUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Payment.Builder payment = ConvertUtil.convertPayment(this.updatePayment(request));
            responseObserver.onNext((Object)payment.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void deletePayment(DeletePaymentRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Create Order = " + request.getPaymentUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder empty = this.deletePayment(request);
            responseObserver.onNext((Object)empty.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listPayments(ListPaymentsRequest request, StreamObserver<ListPaymentsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("List Payment = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListPaymentsResponse.Builder paymentList = this.listPayments(request);
            responseObserver.onNext((Object)paymentList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listOrders(ListOrdersRequest request, StreamObserver<ListOrdersResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Add Line for Order = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListOrdersResponse.Builder ordersList = this.listOrders(request);
            responseObserver.onNext((Object)ordersList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listOrderLines(ListOrderLinesRequest request, StreamObserver<ListOrderLinesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("List Order Lines from order = " + request.getOrderUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListOrderLinesResponse.Builder orderLinesList = this.listOrderLines(request);
            responseObserver.onNext((Object)orderLinesList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getKeyLayout(GetKeyLayoutRequest request, StreamObserver<KeyLayout> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Get Key Layout = " + request.getKeyLayoutUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            KeyLayout.Builder keyLayout = ConvertUtil.convertKeyLayout(RecordUtil.getIdFromUuid("C_POSKeyLayout", request.getKeyLayoutUuid(), null));
            responseObserver.onNext((Object)keyLayout.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void updateOrder(UpdateOrderRequest request, StreamObserver<Order> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Update Order = " + request.getOrderUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Order.Builder order = ConvertUtil.convertOrder(this.updateOrder(request));
            responseObserver.onNext((Object)order.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void releaseOrder(ReleaseOrderRequest request, StreamObserver<Order> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Update Order = " + request.getOrderUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Order.Builder order = ConvertUtil.convertOrder(this.changeOrderAssigned(request.getOrderUuid(), null));
            responseObserver.onNext((Object)order.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void holdOrder(HoldOrderRequest request, StreamObserver<Order> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Update Order = " + request.getOrderUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Order.Builder order = ConvertUtil.convertOrder(this.changeOrderAssigned(request.getOrderUuid(), request.getSalesRepresentativeUuid()));
            responseObserver.onNext((Object)order.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getAvailableRefund(GetAvailableRefundRequest request, StreamObserver<AvailableRefund> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Available Refund = " + request.getDate());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            AvailableRefund.Builder availableRefund = this.getAvailableRefund(request);
            responseObserver.onNext((Object)availableRefund.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private AvailableRefund.Builder getAvailableRefund(GetAvailableRefundRequest request) {
        return AvailableRefund.newBuilder();
    }

    @Override
    public void processOrder(ProcessOrderRequest request, StreamObserver<Order> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Update Order = " + request.getOrderUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Order.Builder order = ConvertUtil.convertOrder(this.processOrder(request));
            responseObserver.onNext((Object)order.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void validatePIN(ValidatePINRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Validate PIN = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder empty = this.validatePIN(request);
            responseObserver.onNext((Object)empty.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listAvailableWarehouses(ListAvailableWarehousesRequest request, StreamObserver<ListAvailableWarehousesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("List Available Warehouses = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListAvailableWarehousesResponse.Builder warehouses = this.listWarehouses(request);
            responseObserver.onNext((Object)warehouses.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listAvailablePriceList(ListAvailablePriceListRequest request, StreamObserver<ListAvailablePriceListResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("List Available Price List = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListAvailablePriceListResponse.Builder priceList = this.listPriceList(request);
            responseObserver.onNext((Object)priceList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listAvailablePaymentMethods(ListAvailablePaymentMethodsRequest request, StreamObserver<ListAvailablePaymentMethodsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("List Available Tender Types = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListAvailablePaymentMethodsResponse.Builder tenderTypes = this.listPaymentMethods(request);
            responseObserver.onNext((Object)tenderTypes.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listAvailableDocumentTypes(ListAvailableDocumentTypesRequest request, StreamObserver<ListAvailableDocumentTypesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("List Available Tender Types = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListAvailableDocumentTypesResponse.Builder documentTypes = this.listDocumentTypes(request);
            responseObserver.onNext((Object)documentTypes.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listAvailableCurrencies(ListAvailableCurrenciesRequest request, StreamObserver<ListAvailableCurrenciesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("List Available Warehouses = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListAvailableCurrenciesResponse.Builder currencies = this.listCurrencies(request);
            responseObserver.onNext((Object)currencies.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createCustomer(CreateCustomerRequest request, StreamObserver<Customer> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Create customer = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Customer.Builder customer = this.createCustomer(request);
            responseObserver.onNext((Object)customer.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void updateCustomer(UpdateCustomerRequest request, StreamObserver<Customer> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Update customer = " + request.getUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Customer.Builder customer = this.updateCustomer(request);
            responseObserver.onNext((Object)customer.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getCustomer(GetCustomerRequest request, StreamObserver<Customer> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Get customer = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Customer.Builder customer = this.getCustomer(request);
            responseObserver.onNext((Object)customer.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void printTicket(PrintTicketRequest request, StreamObserver<PrintTicketResponse> responseObserver) {
        try {
            if (Util.isEmpty((String)request.getOrderUuid())) {
                throw new AdempiereException("@C_Order_ID@ @NotFound@");
            }
            this.log.fine("Print Ticket = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            MPOS pos = this.getPOSFromUuid(request.getPosUuid(), true);
            int orderId = RecordUtil.getIdFromUuid("C_Order", request.getOrderUuid(), null);
            Env.clearWinContext((int)1);
            CPOS posController = new CPOS();
            posController.setOrder(orderId);
            posController.setM_POS(pos);
            posController.setWindowNo(1);
            POSTicketHandler handler = POSTicketHandler.getTicketHandler((CPOS)posController);
            if (handler == null) {
                throw new AdempiereException("@TicketClassName@ " + pos.getTicketClassName() + " @NotFound@");
            }
            handler.printTicket();
            PrintTicketResponse.Builder ticket = PrintTicketResponse.newBuilder().setResult("Ok");
            responseObserver.onNext((Object)ticket.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createCustomerBankAccount(CreateCustomerBankAccountRequest request, StreamObserver<CustomerBankAccount> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Get customer = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            if (Util.isEmpty((String)request.getCustomerUuid())) {
                throw new AdempiereException("@C_BPartner_ID@ @IsMandatory@");
            }
            MBPartner businessPartner = MBPartner.get((Properties)Env.getCtx(), (int)RecordUtil.getIdFromUuid("C_BPartner", request.getCustomerUuid(), null));
            MBPBankAccount businessPartnerBankAccount = new MBPBankAccount(Env.getCtx(), 0, null);
            businessPartnerBankAccount.setC_BPartner_ID(businessPartner.getC_BPartner_ID());
            businessPartnerBankAccount.setIsACH(request.getIsAch());
            Optional.ofNullable(request.getCity()).ifPresent(value -> businessPartnerBankAccount.setA_City(value));
            Optional.ofNullable(request.getCountry()).ifPresent(value -> businessPartnerBankAccount.setA_Country(value));
            Optional.ofNullable(request.getEmail()).ifPresent(value -> businessPartnerBankAccount.setA_EMail(value));
            Optional.ofNullable(request.getDriverLicense()).ifPresent(value -> businessPartnerBankAccount.setA_Ident_DL(value));
            Optional.ofNullable(request.getSocialSecurityNumber()).ifPresent(value -> businessPartnerBankAccount.setA_Ident_SSN(value));
            Optional.ofNullable(request.getName()).ifPresent(value -> businessPartnerBankAccount.setA_Name(value));
            Optional.ofNullable(request.getState()).ifPresent(value -> businessPartnerBankAccount.setA_State(value));
            Optional.ofNullable(request.getStreet()).ifPresent(value -> businessPartnerBankAccount.setA_Street(value));
            Optional.ofNullable(request.getZip()).ifPresent(value -> businessPartnerBankAccount.setA_Zip(value));
            Optional.ofNullable(request.getAccountNo()).ifPresent(value -> businessPartnerBankAccount.setAccountNo(value));
            if (!Util.isEmpty((String)request.getBankUuid())) {
                businessPartnerBankAccount.setC_Bank_ID(RecordUtil.getIdFromUuid("C_Bank", request.getBankUuid(), null));
            }
            Optional.ofNullable(request.getAddressVerified()).ifPresent(value -> businessPartnerBankAccount.setR_AvsAddr(value));
            Optional.ofNullable(request.getZipVerified()).ifPresent(value -> businessPartnerBankAccount.setR_AvsZip(value));
            Optional.ofNullable(request.getRoutingNo()).ifPresent(value -> businessPartnerBankAccount.setRoutingNo(value));
            Optional.ofNullable(request.getIban()).ifPresent(value -> businessPartnerBankAccount.setIBAN(value));
            if (Util.isEmpty((String)request.getBankAccountType())) {
                businessPartnerBankAccount.setBankAccountType("S");
            } else {
                businessPartnerBankAccount.setBankAccountType(request.getBankAccountType());
            }
            businessPartnerBankAccount.saveEx();
            responseObserver.onNext((Object)ConvertUtil.convertCustomerBankAccount(businessPartnerBankAccount).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void updateCustomerBankAccount(UpdateCustomerBankAccountRequest request, StreamObserver<CustomerBankAccount> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Update customer bank account = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            if (Util.isEmpty((String)request.getCustomerBankAccountUuid())) {
                throw new AdempiereException("@C_BPBankAccount_ID@ @IsMandatory@");
            }
            MBPBankAccount businessPartnerBankAccount = new MBPBankAccount(Env.getCtx(), RecordUtil.getIdFromUuid("C_BP_BankAccount", request.getCustomerBankAccountUuid(), null), null);
            businessPartnerBankAccount.setIsACH(request.getIsAch());
            Optional.ofNullable(request.getCity()).ifPresent(value -> businessPartnerBankAccount.setA_City(value));
            Optional.ofNullable(request.getCountry()).ifPresent(value -> businessPartnerBankAccount.setA_Country(value));
            Optional.ofNullable(request.getEmail()).ifPresent(value -> businessPartnerBankAccount.setA_EMail(value));
            Optional.ofNullable(request.getDriverLicense()).ifPresent(value -> businessPartnerBankAccount.setA_Ident_DL(value));
            Optional.ofNullable(request.getSocialSecurityNumber()).ifPresent(value -> businessPartnerBankAccount.setA_Ident_SSN(value));
            Optional.ofNullable(request.getName()).ifPresent(value -> businessPartnerBankAccount.setA_Name(value));
            Optional.ofNullable(request.getState()).ifPresent(value -> businessPartnerBankAccount.setA_State(value));
            Optional.ofNullable(request.getStreet()).ifPresent(value -> businessPartnerBankAccount.setA_Street(value));
            Optional.ofNullable(request.getZip()).ifPresent(value -> businessPartnerBankAccount.setA_Zip(value));
            Optional.ofNullable(request.getAccountNo()).ifPresent(value -> businessPartnerBankAccount.setAccountNo(value));
            if (!Util.isEmpty((String)request.getBankUuid())) {
                businessPartnerBankAccount.setC_Bank_ID(RecordUtil.getIdFromUuid("C_Bank", request.getBankUuid(), null));
            }
            Optional.ofNullable(request.getAddressVerified()).ifPresent(value -> businessPartnerBankAccount.setR_AvsAddr(value));
            Optional.ofNullable(request.getZipVerified()).ifPresent(value -> businessPartnerBankAccount.setR_AvsZip(value));
            Optional.ofNullable(request.getRoutingNo()).ifPresent(value -> businessPartnerBankAccount.setRoutingNo(value));
            Optional.ofNullable(request.getIban()).ifPresent(value -> businessPartnerBankAccount.setIBAN(value));
            if (Util.isEmpty((String)request.getBankAccountType())) {
                businessPartnerBankAccount.setBankAccountType("S");
            } else {
                businessPartnerBankAccount.setBankAccountType(request.getBankAccountType());
            }
            businessPartnerBankAccount.saveEx();
            responseObserver.onNext((Object)ConvertUtil.convertCustomerBankAccount(businessPartnerBankAccount).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getCustomerBankAccount(GetCustomerBankAccountRequest request, StreamObserver<CustomerBankAccount> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Get customer bank account = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            if (Util.isEmpty((String)request.getCustomerBankAccountUuid())) {
                throw new AdempiereException("@C_BP_BankAccount_ID@ @IsMandatory@");
            }
            MBPBankAccount businessPartnerBankAccount = new MBPBankAccount(Env.getCtx(), RecordUtil.getIdFromUuid("C_BP_BankAccount", request.getCustomerBankAccountUuid(), null), null);
            responseObserver.onNext((Object)ConvertUtil.convertCustomerBankAccount(businessPartnerBankAccount).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void deleteCustomerBankAccount(DeleteCustomerBankAccountRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Delete customer bank account = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            if (Util.isEmpty((String)request.getCustomerBankAccountUuid())) {
                throw new AdempiereException("@C_BP_BankAccount_ID@ @IsMandatory@");
            }
            MBPBankAccount businessPartnerBankAccount = new MBPBankAccount(Env.getCtx(), RecordUtil.getIdFromUuid("C_BP_BankAccount", request.getCustomerBankAccountUuid(), null), null);
            businessPartnerBankAccount.deleteEx(true);
            responseObserver.onNext((Object)Empty.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listCustomerBankAccounts(ListCustomerBankAccountsRequest request, StreamObserver<ListCustomerBankAccountsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("list customer bank accounts = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            if (Util.isEmpty((String)request.getCustomerUuid())) {
                throw new AdempiereException("@C_BPartner_ID@ @IsMandatory@");
            }
            ListCustomerBankAccountsResponse.Builder builder = ListCustomerBankAccountsResponse.newBuilder();
            int customerId = RecordUtil.getIdFromUuid("C_BPartner", request.getCustomerUuid(), null);
            String nexPageToken = null;
            int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
            int limit = 50;
            int offset = pageNumber * 50;
            Query query = new Query(Env.getCtx(), "C_BP_BankAccount", "C_BPartner_ID = ?", null).setParameters(new Object[]{customerId}).setClient_ID().setOnlyActiveRecords(true);
            int count = query.count();
            query.setLimit(limit, offset).list().forEach(customerBankAccount -> builder.addCustomerBankAccounts(ConvertUtil.convertCustomerBankAccount(customerBankAccount)));
            builder.setRecordCount(count);
            if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
                nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
            }
            builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createShipment(CreateShipmentRequest request, StreamObserver<Shipment> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Create Shipment = " + request.getOrderUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Shipment.Builder shipment = this.createShipment(request);
            responseObserver.onNext((Object)shipment.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createShipmentLine(CreateShipmentLineRequest request, StreamObserver<ShipmentLine> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Add Line for Order = " + request.getShipmentUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ShipmentLine.Builder shipmentLine = this.createAndConvertShipmentLine(request);
            responseObserver.onNext((Object)shipmentLine.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void deleteShipmentLine(DeleteShipmentLineRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Delete Shipment Line = " + request.getShipmentLineUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder nothing = this.deleteShipmentLine(request);
            responseObserver.onNext((Object)nothing.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listShipmentLines(ListShipmentLinesRequest request, StreamObserver<ListShipmentLinesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("List Shipment Lines from order = " + request.getShipmentUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListShipmentLinesResponse.Builder shipmentLinesList = this.listShipmentLines(request);
            responseObserver.onNext((Object)shipmentLinesList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void processShipment(ProcessShipmentRequest request, StreamObserver<Shipment> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Create customer = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Shipment.Builder shipment = this.processShipment(request);
            responseObserver.onNext((Object)shipment.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void reverseSales(ReverseSalesRequest request, StreamObserver<Order> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Create customer = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Order.Builder order = this.reverseSalesTransaction(request);
            responseObserver.onNext((Object)order.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void processCashOpening(CashOpeningRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Cash Opening = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder empty = this.cashOpening(request);
            responseObserver.onNext((Object)empty.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void processCashWithdrawal(CashWithdrawalRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Cash Withdrawal = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder empty = this.cashWithdrawal(request);
            responseObserver.onNext((Object)empty.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void processCashClosing(CashClosingRequest request, StreamObserver<CashClosing> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Cash Withdrawal = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            CashClosing.Builder closing = this.cashClosing(request);
            responseObserver.onNext((Object)closing.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listCashMovements(ListCashMovementsRequest request, StreamObserver<ListCashMovementsResponse> responseObserver) {
    }

    @Override
    public void listCashSummaryMovements(ListCashSummaryMovementsRequest request, StreamObserver<ListCashSummaryMovementsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Cash Summary Movements = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListCashSummaryMovementsResponse.Builder response = this.listCashSummaryMovements(request);
            responseObserver.onNext((Object)response.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void allocateSeller(AllocateSellerRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Cash Withdrawal = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder empty = this.allocateSeller(request);
            responseObserver.onNext((Object)empty.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createPaymentReference(CreatePaymentReferenceRequest request, StreamObserver<PaymentReference> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Cash Withdrawal = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            PaymentReference.Builder refund = this.createPaymentReference(request);
            responseObserver.onNext((Object)refund.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void deletePaymentReference(DeletePaymentReferenceRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Delete Refund Reference = " + request.getUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder orderLine = this.deletePaymentReference(request);
            responseObserver.onNext((Object)orderLine.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listPaymentReferences(ListPaymentReferencesRequest request, StreamObserver<ListPaymentReferencesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Get Refund Reference List = " + request.getCustomerUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListPaymentReferencesResponse.Builder refundReferenceList = this.listPaymentReferencesLines(request);
            responseObserver.onNext((Object)refundReferenceList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void deallocateSeller(DeallocateSellerRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Cash Withdrawal = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder empty = this.deallocateSeller(request);
            responseObserver.onNext((Object)empty.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listAvailableSellers(ListAvailableSellersRequest request, StreamObserver<ListAvailableSellersResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Available Sellers = " + request.getPosUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListAvailableSellersResponse.Builder response = this.listAvailableSellers(request);
            responseObserver.onNext((Object)response.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private ListAvailableSellersResponse.Builder listAvailableSellers(ListAvailableSellersRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @NotFound@");
        }
        ListAvailableSellersResponse.Builder builder = ListAvailableSellersResponse.newBuilder();
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null);
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        parameters.add(posId);
        if (request.getIsOnlyAllocated()) {
            whereClause.append("EXISTS(SELECT 1 FROM C_POSSellerAllocation s WHERE s.C_POS_ID = ? AND s.SalesRep_ID = AD_User.AD_User_ID AND s.IsActive = 'Y')");
        } else {
            whereClause.append("EXISTS(SELECT 1 FROM C_POSSellerAllocation s WHERE s.C_POS_ID <> ? AND s.SalesRep_ID = AD_User.AD_User_ID OR s.IsActive = 'N')");
        }
        Query query = new Query(Env.getCtx(), "AD_User", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(seller -> builder.addSellers(ConvertUtil.convertSeller(seller)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private Empty.Builder deallocateSeller(DeallocateSellerRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getSalesRepresentativeUuid())) {
            throw new AdempiereException("@SalesRep_ID@ @IsMandatory@");
        }
        int posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null);
        int salesRepresentativeId = RecordUtil.getIdFromUuid("AD_User", request.getSalesRepresentativeUuid(), null);
        MPOS pointOfSales = new MPOS(Env.getCtx(), posId, null);
        if (!pointOfSales.get_ValueAsBoolean("IsAllowsAllocateSeller")) {
            throw new AdempiereException("@ActionNotAllowedHere@");
        }
        Trx.run(transactionName -> {
            PO seller = new Query(Env.getCtx(), "C_POSSellerAllocation", "C_POS_ID = ? AND SalesRep_ID = ?", transactionName).setParameters(new Object[]{posId, salesRepresentativeId}).first();
            if (seller == null || seller.get_ID() <= 0) {
                throw new AdempiereException("@SalesRep_ID@ @NotFound@");
            }
            seller.set_ValueOfColumn("IsActive", (Object)false);
            seller.saveEx();
        });
        return Empty.newBuilder();
    }

    private Empty.Builder allocateSeller(AllocateSellerRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getSalesRepresentativeUuid())) {
            throw new AdempiereException("@SalesRep_ID@ @IsMandatory@");
        }
        int posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null);
        int salesRepresentativeId = RecordUtil.getIdFromUuid("AD_User", request.getSalesRepresentativeUuid(), null);
        MPOS pointOfSales = new MPOS(Env.getCtx(), posId, null);
        if (!pointOfSales.get_ValueAsBoolean("IsAllowsAllocateSeller")) {
            throw new AdempiereException("@ActionNotAllowedHere@");
        }
        Trx.run(transactionName -> {
            PO seller;
            List allocatedSellersIds = new Query(Env.getCtx(), "C_POSSellerAllocation", "C_POS_ID = ?", transactionName).setParameters(new Object[]{posId}).getIDsAsList();
            if (!pointOfSales.get_ValueAsBoolean("IsAllowsConcurrentUse")) {
                allocatedSellersIds.forEach(allocatedSellerId -> {
                    GenericPO allocatedSeller = new GenericPO("C_POSSellerAllocation", Env.getCtx(), allocatedSellerId.intValue(), transactionName);
                    if (allocatedSeller.get_ValueAsInt("SalesRep_ID") != salesRepresentativeId) {
                        allocatedSeller.set_ValueOfColumn("IsActive", (Object)false);
                        allocatedSeller.saveEx();
                    }
                });
            }
            if ((seller = new Query(Env.getCtx(), "C_POSSellerAllocation", "C_POS_ID = ? AND SalesRep_ID = ?", transactionName).setParameters(new Object[]{posId, salesRepresentativeId}).first()) == null || seller.get_ID() <= 0) {
                seller = new GenericPO("C_POSSellerAllocation", Env.getCtx(), 0, transactionName);
                seller.set_ValueOfColumn("C_POS_ID", (Object)posId);
                seller.set_ValueOfColumn("SalesRep_ID", (Object)salesRepresentativeId);
                seller.set_ValueOfColumn("IsAllowsModifyQuantity", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsModifyQuantity"));
                seller.set_ValueOfColumn("IsAllowsReturnOrder", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsReturnOrder"));
                seller.set_ValueOfColumn("IsAllowsCollectOrder", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsCollectOrder"));
                seller.set_ValueOfColumn("IsAllowsCreateOrder", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsCreateOrder"));
                seller.set_ValueOfColumn("IsDisplayTaxAmount", (Object)pointOfSales.get_ValueAsBoolean("IsDisplayTaxAmount"));
                seller.set_ValueOfColumn("IsDisplayDiscount", (Object)pointOfSales.get_ValueAsBoolean("IsDisplayDiscount"));
                seller.set_ValueOfColumn("IsAllowsConfirmShipment", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsConfirmShipment"));
                seller.set_ValueOfColumn("IsConfirmCompleteShipment", (Object)pointOfSales.get_ValueAsBoolean("IsConfirmCompleteShipment"));
                seller.set_ValueOfColumn("IsAllowsAllocateSeller", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsAllocateSeller"));
                seller.set_ValueOfColumn("IsAllowsConcurrentUse", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsConcurrentUse"));
                seller.set_ValueOfColumn("IsAllowsCashOpening", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsCashOpening"));
                seller.set_ValueOfColumn("IsAllowsCashClosing", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsCashClosing"));
                seller.set_ValueOfColumn("IsAllowsCashWithdrawal", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsCashWithdrawal"));
                seller.set_ValueOfColumn("IsAllowsApplyDiscount", (Object)pointOfSales.get_ValueAsBoolean("IsAllowsApplyDiscount"));
                seller.set_ValueOfColumn("MaximumRefundAllowed", (Object)pointOfSales.get_ValueAsBoolean("MaximumRefundAllowed"));
                seller.set_ValueOfColumn("MaximumDailyRefundAllowed", (Object)pointOfSales.get_ValueAsBoolean("MaximumDailyRefundAllowed"));
                seller.set_ValueOfColumn("MaximumDiscountAllowed", (Object)pointOfSales.get_ValueAsBoolean("MaximumDiscountAllowed"));
                seller.set_ValueOfColumn("WriteOffAmtTolerance", (Object)pointOfSales.get_ValueAsBoolean("WriteOffAmtTolerance"));
            }
            seller.set_ValueOfColumn("IsActive", (Object)true);
            seller.saveEx();
        });
        return Empty.newBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListCashSummaryMovementsResponse.Builder listCashSummaryMovements(ListCashSummaryMovementsRequest request) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ListCashSummaryMovementsResponse.Builder builder = ListCashSummaryMovementsResponse.newBuilder();
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @IsMandatory@");
        }
        int posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null);
        MBankStatement cashClosing = this.getCurrentCashclosing(posId, null);
        if (cashClosing == null || cashClosing.getC_BankStatement_ID() <= 0) {
            throw new AdempiereException("@C_BankStatement_ID@ @NotFound@");
        }
        builder.setId(cashClosing.getC_BankStatement_ID()).setUuid(ValueUtil.validateNull(cashClosing.getUUID()));
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int count = 0;
        try {
            String sql = "SELECT pm.UUID AS PaymentMethodUUID, pm.Name AS PaymentMethodName, pm.TenderType AS TenderTypeCode, p.C_Currency_ID, p.IsReceipt, (SUM(p.PayAmt) * CASE WHEN p.IsReceipt = 'Y' THEN 1 ELSE -1 END) AS PaymentAmount FROM C_Payment p INNER JOIN C_PaymentMethod pm ON(pm.C_PaymentMethod_ID = p.C_PaymentMethod_ID) WHERE p.DocStatus IN('CO', 'CL') AND p.C_POS_ID = ? AND EXISTS(SELECT 1 FROM C_BankStatementLine bsl WHERE bsl.C_Payment_ID = p.C_Payment_ID AND bsl.C_BankStatement_ID = ?) GROUP BY pm.UUID, pm.Name, pm.TenderType, p.C_Currency_ID, p.IsReceipt";
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(posId);
            count = RecordUtil.countRecords(sql, "C_Payment p", parameters);
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, posId);
            pstmt.setInt(2, cashClosing.getC_BankStatement_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PaymentSummary.Builder paymentSummary = PaymentSummary.newBuilder().setPaymentMethodUuid(ValueUtil.validateNull(rs.getString("PaymentMethodUUID"))).setPaymentMethodName(ValueUtil.validateNull(rs.getString("PaymentMethodName"))).setTenderTypeCode(ValueUtil.validateNull(rs.getString("TenderTypeCode"))).setCurrency(ConvertUtil.convertCurrency(MCurrency.get((Properties)Env.getCtx(), (int)rs.getInt("C_Currency_ID")))).setIsRefund(!rs.getString("IsReceipt").equals("Y")).setAmount(ValueUtil.getDecimalFromBigDecimal(rs.getBigDecimal("PaymentAmount")));
                builder.addCashMovements(paymentSummary.build());
                ++count;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
        finally {
            DB.close(rs, pstmt);
        }
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private PaymentReference.Builder createPaymentReference(CreatePaymentReferenceRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getOrderUuid())) {
            throw new AdempiereException("@C_Order_ID@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getSalesRepresentativeUuid())) {
            throw new AdempiereException("@SalesRep_ID@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getCurrencyUuid())) {
            throw new AdempiereException("@C_Currency_ID@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getCustomerUuid())) {
            throw new AdempiereException("@C_BPartner_ID@ @IsMandatory@");
        }
        if (request.getAmount() == null) {
            throw new AdempiereException("@Amount@ @IsMandatory@");
        }
        AtomicReference refundReference = new AtomicReference();
        Trx.run(transactionName -> {
            GenericPO refundReferenceToCreate = new GenericPO("C_POSPaymentReference", Env.getCtx(), 0, transactionName);
            refundReferenceToCreate.set_ValueOfColumn("Amount", (Object)ValueUtil.getBigDecimalFromDecimal(request.getAmount()));
            refundReferenceToCreate.set_ValueOfColumn("AmtSource", (Object)ValueUtil.getBigDecimalFromDecimal(request.getSourceAmount()));
            if (!Util.isEmpty((String)request.getCustomerBankAccountUuid())) {
                refundReferenceToCreate.set_ValueOfColumn("C_BP_BankAccount_ID", (Object)RecordUtil.getIdFromUuid("C_BP_BankAccount", request.getCustomerBankAccountUuid(), transactionName));
            }
            refundReferenceToCreate.set_ValueOfColumn("C_BPartner_ID", (Object)RecordUtil.getIdFromUuid("C_BPartner", request.getCustomerUuid(), transactionName));
            int id = RecordUtil.getIdFromUuid("C_ConversionType", request.getConversionTypeUuid(), transactionName);
            if (id > 0) {
                refundReferenceToCreate.set_ValueOfColumn("C_ConversionType_ID", (Object)id);
            }
            if ((id = RecordUtil.getIdFromUuid("C_Currency", request.getCurrencyUuid(), transactionName)) > 0) {
                refundReferenceToCreate.set_ValueOfColumn("C_Currency_ID", (Object)id);
            }
            refundReferenceToCreate.set_ValueOfColumn("C_Order_ID", (Object)RecordUtil.getIdFromUuid("C_Order", request.getOrderUuid(), transactionName));
            id = RecordUtil.getIdFromUuid("C_PaymentMethod", request.getPaymentMethodUuid(), transactionName);
            if (id > 0) {
                refundReferenceToCreate.set_ValueOfColumn("C_PaymentMethod_ID", (Object)id);
            }
            if ((id = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), transactionName)) > 0) {
                refundReferenceToCreate.set_ValueOfColumn("C_POS_ID", (Object)id);
            }
            if ((id = RecordUtil.getIdFromUuid("AD_User", request.getSalesRepresentativeUuid(), transactionName)) > 0) {
                refundReferenceToCreate.set_ValueOfColumn("SalesRep_ID", (Object)id);
            }
            refundReferenceToCreate.set_ValueOfColumn("IsReceipt", (Object)request.getIsReceipt());
            refundReferenceToCreate.set_ValueOfColumn("TenderType", (Object)request.getTenderTypeCode());
            refundReferenceToCreate.set_ValueOfColumn("Description", (Object)request.getDescription());
            refundReferenceToCreate.saveEx();
            refundReference.set(refundReferenceToCreate);
        });
        return this.convertPaymentReference((PO)refundReference.get());
    }

    private Empty.Builder cashOpening(CashOpeningRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)request.getCollectingAgentUuid())) {
            throw new AdempiereException("@CollectingAgent_ID@ @NotFound@");
        }
        Trx.run(transactionName -> {
            MPOS pos = this.getPOSFromUuid(request.getPosUuid(), true);
            if (request.getPaymentsList().size() == 0) {
                throw new AdempiereException("@C_Payment_ID@ @NotFound@");
            }
            if (pos.getC_BankAccount_ID() <= 0) {
                throw new AdempiereException("@C_BankAccount_ID@ @NotFound@");
            }
            MBankAccount cashAccount = MBankAccount.get((Properties)Env.getCtx(), (int)pos.getC_BankAccount_ID());
            if (cashAccount.get_ValueAsInt("DefaultOpeningCharge_ID") <= 0) {
                throw new AdempiereException("@DefaultOpeningCharge_ID@ @NotFound@");
            }
            request.getPaymentsList().forEach(paymentRequest -> {
                MPayment payment = this.createPaymentFromCharge(cashAccount.get_ValueAsInt("DefaultOpeningCharge_ID"), (CreatePaymentRequest)paymentRequest, pos, transactionName);
                int cashClosingDocumentTypeId = pos.get_ValueAsInt("POSCashClosingDocumentType_ID");
                if (cashClosingDocumentTypeId > 0) {
                    this.createBankStatement(payment, cashClosingDocumentTypeId);
                }
                this.processPayment(payment);
            });
        });
        return Empty.newBuilder();
    }

    private void createBankStatement(MPayment payment, int documentTypeId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_BankAccount_ID").append(" = ? AND ").append("TRUNC(").append("StatementDate").append(",'DD') = ? AND ").append("Processed").append(" = ?").append(" AND ").append("C_DocType_ID").append(" = ?");
        MBankStatement bankStatement = (MBankStatement)new Query(payment.getCtx(), "C_BankStatement", whereClause.toString(), payment.get_TrxName()).setClient_ID().setParameters(new Object[]{payment.getC_BankAccount_ID(), TimeUtil.getDay((Timestamp)payment.getDateTrx()), false, documentTypeId}).first();
        if (bankStatement == null || bankStatement.get_ID() <= 0) {
            bankStatement = new MBankStatement(payment.getCtx(), 0, payment.get_TrxName());
            bankStatement.setC_BankAccount_ID(payment.getC_BankAccount_ID());
            bankStatement.setStatementDate(payment.getDateAcct());
            bankStatement.setC_DocType_ID(documentTypeId);
            if (payment.getDescription() != null) {
                bankStatement.setName(payment.getDescription());
            } else {
                SimpleDateFormat format = DisplayType.getDateFormat((int)15);
                bankStatement.setName(Msg.parseTranslation((Properties)payment.getCtx(), (String)"@Generate@: ") + format.format(payment.getDateAcct()));
            }
            bankStatement.saveEx();
        }
    }

    private void processPayment(MPayment payment) {
        if (!payment.isProcessed()) {
            payment.setDocStatus("DR");
            payment.setDocAction("CO");
        }
        payment.saveEx();
        if (!payment.isProcessed()) {
            if (!payment.processIt("CO")) {
                throw new AdempiereException(payment.getProcessMsg());
            }
            payment.saveEx();
        }
        MBankStatement.addPayment((MPayment)payment);
    }

    private MBankStatement getCurrentCashclosing(int posId, String transactionName) {
        return (MBankStatement)new Query(Env.getCtx(), "C_BankStatement", "Processed = 'N' AND EXISTS(SELECT 1 FROM C_BankStatementLine bsl INNER JOIN C_Payment p ON(p.C_Payment_ID = bsl.C_Payment_ID) WHERE bsl.C_BankStatement_ID = C_BankStatement.C_BankStatement_ID AND p.DocStatus IN('CO', 'CL') AND p.C_POS_ID = ?)", transactionName).setParameters(new Object[]{posId}).first();
    }

    private CashClosing.Builder cashClosing(CashClosingRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @NotFound@");
        }
        CashClosing.Builder cashClosing = CashClosing.newBuilder();
        Trx.run(transactionName -> {
            MBankStatement bankStatement;
            int bankStatementId = request.getId();
            if (bankStatementId <= 0 && Util.isEmpty((String)request.getUuid())) {
                throw new AdempiereException("@C_BankStatement_ID@ @NotFound@");
            }
            if (bankStatementId <= 0) {
                bankStatementId = RecordUtil.getIdFromUuid("C_BankStatement", request.getUuid(), transactionName);
            }
            if ((bankStatement = new MBankStatement(Env.getCtx(), bankStatementId, transactionName)).isProcessed()) {
                throw new AdempiereException("@C_BankStatement_ID@ @Processed@");
            }
            if (!Util.isEmpty((String)request.getDescription())) {
                bankStatement.addDescription(request.getDescription());
            }
            bankStatement.setDocStatus("DR");
            bankStatement.setDocAction("CO");
            bankStatement.saveEx();
            if (!bankStatement.processIt("CO")) {
                throw new AdempiereException(bankStatement.getProcessMsg());
            }
            bankStatement.saveEx();
            cashClosing.setId(bankStatement.getC_BankStatement_ID()).setUuid(ValueUtil.validateNull(bankStatement.getUUID())).setDocumentNo(ValueUtil.validateNull(bankStatement.getDocumentNo())).setDescription(ValueUtil.validateNull(bankStatement.getDescription())).setDocumentStatus(ConvertUtil.convertDocumentStatus(bankStatement.getDocStatus(), bankStatement.getDocStatus(), bankStatement.getDocStatus())).setDocumentType(ConvertUtil.convertDocumentType(MDocType.get((Properties)Env.getCtx(), (int)bankStatement.getC_DocType_ID())));
        });
        return cashClosing;
    }

    private Empty.Builder cashWithdrawal(CashWithdrawalRequest request) {
        MPOS pos = this.getPOSFromUuid(request.getPosUuid(), true);
        if (Util.isEmpty((String)request.getCollectingAgentUuid())) {
            throw new AdempiereException("@CollectingAgent_ID@ @NotFound@");
        }
        Trx.run(transactionName -> {
            if (request.getPaymentsList().size() == 0) {
                throw new AdempiereException("@C_Payment_ID@ @NotFound@");
            }
            if (pos.getC_BankAccount_ID() <= 0) {
                throw new AdempiereException("@C_BankAccount_ID@ @NotFound@");
            }
            MBankAccount cashAccount = MBankAccount.get((Properties)Env.getCtx(), (int)pos.getC_BankAccount_ID());
            if (cashAccount.get_ValueAsInt("DefaultWithdrawalCharge_ID") <= 0) {
                throw new AdempiereException("@DefaultWithdrawalCharge_ID@ @NotFound@");
            }
            request.getPaymentsList().forEach(paymentRequest -> {
                MPayment payment = this.createPaymentFromCharge(cashAccount.get_ValueAsInt("DefaultWithdrawalCharge_ID"), (CreatePaymentRequest)paymentRequest, pos, transactionName);
                this.processPayment(payment);
            });
        });
        return Empty.newBuilder();
    }

    private Order.Builder reverseSalesTransaction(ReverseSalesRequest request) {
        if (Util.isEmpty((String)request.getOrderUuid())) {
            throw new AdempiereException("@C_Order_ID@ @NotFound@");
        }
        MPOS pointOfSales = this.getPOSFromUuid(request.getPosUuid(), true);
        if (pointOfSales.get_ValueAsInt("C_DocTypeRMA_ID") <= 0) {
            throw new AdempiereException("@C_DocTypeRMA_ID@ @NotFound@");
        }
        AtomicReference returnOrderReference = new AtomicReference();
        Trx.run(transactionName -> {
            int orderId = RecordUtil.getIdFromUuid("C_Order", request.getOrderUuid(), transactionName);
            MOrder order = new MOrder(Env.getCtx(), orderId, transactionName);
            ProcessInfo infoProcess = ProcessBuilder.create((Properties)Env.getCtx()).process(Integer.valueOf(ReverseTheSalesTransaction.getProcessId())).withoutTransactionClose().withRecordId(Integer.valueOf(MOrder.Table_ID), Integer.valueOf(orderId)).withParameter("C_Order_ID", (Object)orderId).withParameter("Bill_BPartner_ID", (Object)order.getC_BPartner_ID()).withParameter("IsCancelled", (Object)true).withParameter("C_DocTypeRMA_ID", (Object)pointOfSales.get_ValueAsInt("C_DocTypeRMA_ID")).execute(transactionName);
            MOrder returnOrder = new MOrder(Env.getCtx(), infoProcess.getRecord_ID(), transactionName);
            if (!Util.isEmpty((String)request.getDescription())) {
                returnOrder.setDescription(request.getDescription());
                returnOrder.saveEx();
            }
            returnOrderReference.set(returnOrder);
        });
        return ConvertUtil.convertOrder((MOrder)returnOrderReference.get());
    }

    private Shipment.Builder processShipment(ProcessShipmentRequest request) {
        if (Util.isEmpty((String)request.getShipmentUuid())) {
            throw new AdempiereException("@M_InOut_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)request.getDocumentAction())) {
            throw new AdempiereException("@DocStatus@ @IsMandatory@");
        }
        if (!(request.getDocumentAction().equals("CO") || request.getDocumentAction().equals("RA") || request.getDocumentAction().equals("RC"))) {
            throw new AdempiereException("@DocStatus@ @Invalid@");
        }
        AtomicReference shipmentReference = new AtomicReference();
        Trx.run(transactionName -> {
            int shipmentId = RecordUtil.getIdFromUuid("M_InOut", request.getShipmentUuid(), transactionName);
            MInOut shipment = new MInOut(Env.getCtx(), shipmentId, transactionName);
            if (shipment.isProcessed()) {
                throw new AdempiereException("@M_InOut_ID@ @Processed@");
            }
            if (!shipment.processIt(request.getDocumentAction())) {
                this.log.warning("@ProcessFailed@ :" + shipment.getProcessMsg());
                throw new AdempiereException("@ProcessFailed@ :" + shipment.getProcessMsg());
            }
            shipment.saveEx();
            shipmentReference.set(shipment);
        });
        return ConvertUtil.convertShipment((MInOut)shipmentReference.get());
    }

    private ListShipmentLinesResponse.Builder listShipmentLines(ListShipmentLinesRequest request) {
        if (Util.isEmpty((String)request.getShipmentUuid())) {
            throw new AdempiereException("@M_InOut_ID@ @NotFound@");
        }
        ListShipmentLinesResponse.Builder builder = ListShipmentLinesResponse.newBuilder();
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int shipmentId = RecordUtil.getIdFromUuid("M_InOut", request.getShipmentUuid(), null);
        Query query = new Query(Env.getCtx(), "M_InOutLine", "M_InOut_ID = ?", null).setParameters(new Object[]{shipmentId}).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(order -> builder.addShipmentLines(ConvertUtil.convertShipmentLine(order)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListPaymentReferencesResponse.Builder listPaymentReferencesLines(ListPaymentReferencesRequest request) {
        if (Util.isEmpty((String)request.getCustomerUuid()) && Util.isEmpty((String)request.getOrderUuid())) {
            throw new AdempiereException("@C_BPartner_ID@ / @C_Order_ID@ @IsMandatory@");
        }
        ListPaymentReferencesResponse.Builder builder = ListPaymentReferencesResponse.newBuilder();
        if (MTable.get((Properties)Env.getCtx(), (String)"C_POSPaymentReference") == null) {
            return builder;
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        StringBuffer whereClause = new StringBuffer("IsPaid = 'N' AND Processed = 'N'");
        if (!Util.isEmpty((String)request.getOrderUuid())) {
            parameters.add(RecordUtil.getIdFromUuid("C_Order", request.getOrderUuid(), null));
            whereClause.append(" AND C_Order_ID = ?");
        } else if (!Util.isEmpty((String)request.getCustomerUuid())) {
            parameters.add(RecordUtil.getIdFromUuid("C_BPartner", request.getCustomerUuid(), null));
            whereClause.append(" AND EXISTS(SELECT 1 FROM C_BP_BankAccount ba WHERE ba.C_BP_BankAccount_ID = C_POSPaymentReference.C_BP_BankAccount_ID AND ba.C_BPartner_ID = ?)");
        } else if (!Util.isEmpty((String)request.getPosUuid())) {
            parameters.add(RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null));
            whereClause.append(" AND C_POS_ID = ?");
        }
        Query query = new Query(Env.getCtx(), "C_POSPaymentReference", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(refundReference -> builder.addPaymentReferences(this.convertPaymentReference((PO)refundReference)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private PaymentReference.Builder convertPaymentReference(PO paymentReference) {
        PaymentReference.Builder builder = PaymentReference.newBuilder();
        if (paymentReference != null && paymentReference.get_ID() > 0) {
            builder.setAmount(ValueUtil.getDecimalFromBigDecimal((BigDecimal)paymentReference.get_Value("Amount"))).setDescription(ValueUtil.validateNull(paymentReference.get_ValueAsString("Description"))).setIsPaid(paymentReference.get_ValueAsBoolean("IsPaid")).setTenderTypeCode(ValueUtil.validateNull(paymentReference.get_ValueAsString("TenderType"))).setCurrency(ConvertUtil.convertCurrency(MCurrency.get((Properties)Env.getCtx(), (int)paymentReference.get_ValueAsInt("C_Currency_ID")))).setCustomerBankAccountUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_BP_BankAccount", paymentReference.get_ValueAsInt("C_BP_BankAccount_ID")))).setOrderUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_Order", paymentReference.get_ValueAsInt("C_Order_ID")))).setPosUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_POS", paymentReference.get_ValueAsInt("C_POS_ID")))).setSalesRepresentative(ConvertUtil.convertSalesRepresentative(MUser.get((Properties)Env.getCtx(), (int)paymentReference.get_ValueAsInt("SalesRep_ID")))).setId(paymentReference.get_ID()).setUuid(ValueUtil.validateNull(paymentReference.get_UUID())).setPaymentMethodUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_PaymentMethod", paymentReference.get_ValueAsInt("C_PaymentMethod_ID")))).setPaymentDate(ValueUtil.validateNull(ValueUtil.convertDateToString((Timestamp)paymentReference.get_Value("PayDate")))).setIsAutomatic(paymentReference.get_ValueAsBoolean("IsAutoCreatedReference")).setIsProcessed(paymentReference.get_ValueAsBoolean("Processed"));
        }
        return builder;
    }

    private Empty.Builder deleteShipmentLine(DeleteShipmentLineRequest request) {
        if (Util.isEmpty((String)request.getShipmentLineUuid())) {
            throw new AdempiereException("@M_InOutLine_ID@ @NotFound@");
        }
        Trx.run(transactionName -> {
            MInOutLine shipmentLine = (MInOutLine)new Query(Env.getCtx(), "M_InOutLine", "UUID = ?", transactionName).setParameters(new Object[]{request.getShipmentLineUuid()}).setClient_ID().first();
            if (shipmentLine != null && shipmentLine.getM_InOutLine_ID() != 0) {
                if (shipmentLine.isProcessed()) {
                    throw new AdempiereException("@M_InOutLine_ID@ @Processed@");
                }
                if (shipmentLine != null && shipmentLine.getM_InOutLine_ID() >= 0) {
                    shipmentLine.deleteEx(true);
                }
            }
        });
        return Empty.newBuilder();
    }

    private ShipmentLine.Builder createAndConvertShipmentLine(CreateShipmentLineRequest request) {
        if (Util.isEmpty((String)request.getShipmentUuid())) {
            throw new AdempiereException("@M_InOut_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)request.getOrderLineUuid())) {
            throw new AdempiereException("@C_OrderLine_ID@ @NotFound@");
        }
        int shipmentId = RecordUtil.getIdFromUuid("M_InOut", request.getShipmentUuid(), null);
        int salesOrderLineId = RecordUtil.getIdFromUuid("C_OrderLine", request.getOrderLineUuid(), null);
        if (shipmentId <= 0) {
            return ShipmentLine.newBuilder();
        }
        if (salesOrderLineId <= 0) {
            throw new AdempiereException("@C_OrderLine_ID@ @NotFound@");
        }
        MInOut shipmentHeader = new MInOut(Env.getCtx(), shipmentId, null);
        if (!DocumentUtil.isDrafted((DocAction)shipmentHeader)) {
            throw new AdempiereException("@M_InOut_ID@ @Processed@");
        }
        MOrderLine salesOrderLine = new MOrderLine(Env.getCtx(), salesOrderLineId, null);
        Optional<MInOutLine> maybeOrderLine = Arrays.asList(shipmentHeader.getLines(true)).stream().filter(shipmentLineTofind -> shipmentLineTofind.getC_OrderLine_ID() == salesOrderLine.getC_OrderLine_ID()).findFirst();
        AtomicReference<MInOutLine> shipmentLineReference = new AtomicReference<MInOutLine>();
        BigDecimal quantity = ValueUtil.getBigDecimalFromDecimal(request.getQuantity());
        if (salesOrderLine.getQtyOrdered().subtract(salesOrderLine.getQtyDelivered()).compareTo(Optional.ofNullable(quantity).orElse(Env.ONE)) < 0) {
            throw new AdempiereException("@QtyInsufficient@");
        }
        if (maybeOrderLine.isPresent()) {
            MInOutLine shipmentLine = maybeOrderLine.get();
            BigDecimal quantityToOrder = quantity;
            if (quantity == null) {
                quantityToOrder = shipmentLine.getMovementQty();
                quantityToOrder = quantityToOrder.add(Env.ONE);
            }
            if (salesOrderLine.getQtyOrdered().subtract(salesOrderLine.getQtyDelivered()).compareTo(quantityToOrder) < 0) {
                throw new AdempiereException("@QtyInsufficient@");
            }
            shipmentLine.setQty(quantityToOrder);
            shipmentLine.saveEx();
            shipmentLineReference.set(shipmentLine);
        } else {
            MInOutLine shipmentLine = new MInOutLine(shipmentHeader);
            BigDecimal quantityToOrder = quantity;
            if (quantity == null) {
                quantityToOrder = Env.ONE;
            }
            shipmentLine.setOrderLine(salesOrderLine, 0, quantityToOrder);
            Optional.ofNullable(request.getDescription()).ifPresent(description -> shipmentLine.setDescription(description));
            shipmentLine.saveEx();
            shipmentLineReference.set(shipmentLine);
        }
        return ConvertUtil.convertShipmentLine((MInOutLine)shipmentLineReference.get());
    }

    private Shipment.Builder createShipment(CreateShipmentRequest request) {
        if (Util.isEmpty((String)request.getOrderUuid())) {
            throw new AdempiereException("@C_Order_ID@ @NotFound@");
        }
        AtomicReference maybeShipment = new AtomicReference();
        Trx.run(transactionName -> {
            int orderId = RecordUtil.getIdFromUuid("C_Order", request.getOrderUuid(), transactionName);
            int salesRepresentativeId = RecordUtil.getIdFromUuid("AD_User", request.getSalesRepresentativeUuid(), transactionName);
            if (orderId <= 0) {
                throw new AdempiereException("@C_Order_ID@ @NotFound@");
            }
            if (salesRepresentativeId <= 0) {
                throw new AdempiereException("@SalesRep_ID@ @NotFound@");
            }
            MOrder salesOrder = new MOrder(Env.getCtx(), orderId, transactionName);
            if (salesOrder.isDelivered()) {
                throw new AdempiereException("@C_Order_ID@ @IsDelivered@");
            }
            MInOut shipment = (MInOut)new Query(Env.getCtx(), "M_InOut", "DocStatus = 'DR' AND C_Order_ID = ? AND SalesRep_ID = ?", transactionName).setParameters(new Object[]{salesOrder.getC_Order_ID(), salesRepresentativeId}).first();
            if (shipment == null) {
                shipment = new MInOut(salesOrder, 0, RecordUtil.getDate());
            } else {
                shipment.setDateOrdered(RecordUtil.getDate());
                shipment.setDateAcct(RecordUtil.getDate());
                shipment.setDateReceived(RecordUtil.getDate());
                shipment.setMovementDate(RecordUtil.getDate());
            }
            shipment.setC_Order_ID(orderId);
            shipment.setSalesRep_ID(salesRepresentativeId);
            shipment.setC_POS_ID(salesOrder.getC_POS_ID());
            if (!DocumentUtil.isCompleted((DocAction)salesOrder)) {
                throw new AdempiereException("@Invalid@ @C_Order_ID@ " + salesOrder.getDocumentNo());
            }
            shipment.saveEx(transactionName);
            maybeShipment.set(shipment);
        });
        return ConvertUtil.convertShipment((MInOut)maybeShipment.get());
    }

    private Customer.Builder getCustomer(GetCustomerRequest request) {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<String> parameters = new ArrayList<String>();
        if (!Util.isEmpty((String)request.getSearchValue())) {
            whereClause.append("(UPPER(Value) = UPPER(?) OR UPPER(Name) = UPPER(?))");
            parameters.add(request.getSearchValue());
            parameters.add(request.getSearchValue());
        }
        if (!Util.isEmpty((String)request.getValue())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(UPPER(Value) = UPPER(?))");
            parameters.add(request.getValue());
        }
        if (!Util.isEmpty((String)request.getName())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(UPPER(Name) = UPPER(?))");
            parameters.add(request.getName());
        }
        if (!Util.isEmpty((String)request.getContactName())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM AD_User u WHERE u.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(u.Name) = UPPER(?)))");
            parameters.add(request.getContactName());
        }
        if (!Util.isEmpty((String)request.getEmail())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM AD_User u WHERE u.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(u.EMail) = UPPER(?)))");
            parameters.add(request.getEmail());
        }
        if (!Util.isEmpty((String)request.getPhone())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM AD_User u WHERE u.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(u.Phone) = UPPER(?)) OR EXISTS(SELECT 1 FROM C_BPartner_Location bpl WHERE bpl.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(bpl.Phone) = UPPER(?)))");
            parameters.add(request.getPhone());
            parameters.add(request.getPhone());
        }
        if (!Util.isEmpty((String)request.getPostalCode())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM C_BPartner_Location bpl INNER JOIN C_Location l ON(l.C_Location_ID = bpl.C_Location_ID) WHERE bpl.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(l.Postal) = UPPER(?)))");
            parameters.add(request.getPostalCode());
        }
        MBPartner businessPartner = (MBPartner)new Query(Env.getCtx(), "C_BPartner", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true).first();
        return ConvertUtil.convertCustomer(businessPartner);
    }

    private Customer.Builder createCustomer(CreateCustomerRequest request) {
        if (Util.isEmpty((String)request.getName())) {
            throw new AdempiereException("@Name@ @IsMandatory@");
        }
        MPOS pos = this.getPOSFromUuid(request.getPosUuid(), true);
        MBPartner businessPartner = MBPartner.getTemplate((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)pos.getC_POS_ID());
        if (pos.getC_BPartnerCashTrx_ID() <= 0) {
            throw new AdempiereException("@C_BPartnerCashTrx_ID@ @NotFound@");
        }
        MBPartner template = MBPartner.get((Properties)Env.getCtx(), (int)pos.getC_BPartnerCashTrx_ID());
        Optional maybeTemplateLocation = Arrays.asList(template.getLocations(false)).stream().findFirst();
        if (!maybeTemplateLocation.isPresent()) {
            throw new AdempiereException("@C_BPartnerCashTrx_ID@ @C_BPartner_Location_ID@ @NotFound@");
        }
        MLocation templateLocation = ((MBPartnerLocation)maybeTemplateLocation.get()).getLocation(false);
        if (templateLocation == null || templateLocation.getC_Location_ID() <= 0) {
            throw new AdempiereException("@C_Location_ID@ @NotFound@");
        }
        Trx.run(transactionName -> {
            int businessPartnerGroupId;
            businessPartner.setAD_Org_ID(0);
            businessPartner.setIsCustomer(true);
            businessPartner.setIsVendor(false);
            businessPartner.set_TrxName(transactionName);
            String code = request.getValue();
            if (Util.isEmpty((String)code)) {
                code = DB.getDocumentNo((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (String)"C_BPartner", (String)transactionName, (PO)businessPartner);
            }
            businessPartner.setValue(code);
            Optional.ofNullable(request.getValue()).ifPresent(value -> businessPartner.setValue(value));
            Optional.ofNullable(request.getTaxId()).ifPresent(value -> businessPartner.setTaxID(value));
            Optional.ofNullable(request.getDuns()).ifPresent(value -> businessPartner.setDUNS(value));
            Optional.ofNullable(request.getNaics()).ifPresent(value -> businessPartner.setNAICS(value));
            Optional.ofNullable(request.getName()).ifPresent(value -> businessPartner.setName(value));
            Optional.ofNullable(request.getLastName()).ifPresent(value -> businessPartner.setName2(value));
            Optional.ofNullable(request.getDescription()).ifPresent(value -> businessPartner.setDescription(value));
            if (!Util.isEmpty((String)request.getBusinessPartnerGroupUuid()) && (businessPartnerGroupId = RecordUtil.getIdFromUuid("C_BP_Group", request.getBusinessPartnerGroupUuid(), transactionName)) != 0) {
                businessPartner.setC_BP_Group_ID(businessPartnerGroupId);
            }
            this.setAdditionalAttributes((PO)businessPartner, request.getAdditionalAttributesList());
            businessPartner.saveEx(transactionName);
            request.getAddressesList().forEach(address -> this.createCustomerAddress(businessPartner, (AddressRequest)address, templateLocation, transactionName));
        });
        return ConvertUtil.convertCustomer(businessPartner);
    }

    private void setAdditionalAttributes(PO entity, List<KeyValue> attributes) {
        attributes.forEach(attribute -> {
            int referenceId = this.getReferenceId(entity.get_Table_ID(), attribute.getKey());
            Object value = null;
            if (referenceId > 0) {
                value = ValueUtil.getObjectFromReference(attribute.getValue(), referenceId);
            }
            if (value == null) {
                value = ValueUtil.getObjectFromValue(attribute.getValue());
            }
            entity.set_ValueOfColumn(attribute.getKey(), value);
        });
    }

    private int getReferenceId(int tableId, String columnName) {
        MColumn column = MTable.get((Properties)Env.getCtx(), (int)tableId).getColumn(columnName);
        if (column == null) {
            return -1;
        }
        return column.getAD_Reference_ID();
    }

    private void createCustomerAddress(MBPartner customer, AddressRequest address, MLocation templateLocation, String transactionName) {
        int countryId = 0;
        if (!Util.isEmpty((String)address.getCountryUuid())) {
            countryId = RecordUtil.getIdFromUuid("C_Country", address.getCountryUuid(), transactionName);
        }
        MLocation location = new MLocation(Env.getCtx(), 0, transactionName);
        if (countryId > 0) {
            int regionId = 0;
            int cityId = 0;
            String cityName = null;
            if (!Util.isEmpty((String)address.getRegionUuid())) {
                regionId = RecordUtil.getIdFromUuid("C_Region", address.getRegionUuid(), transactionName);
            }
            if (!Util.isEmpty((String)address.getCityName())) {
                cityName = address.getCityName();
            }
            if (!Util.isEmpty((String)address.getCityUuid())) {
                cityId = RecordUtil.getIdFromUuid("C_City", address.getCityUuid(), transactionName);
            }
            location.setC_Country_ID(countryId);
            location.setC_Region_ID(regionId);
            location.setCity(cityName);
            if (cityId > 0) {
                location.setC_City_ID(cityId);
            }
        } else {
            PO.copyValues((PO)templateLocation, (PO)location);
        }
        if (!Util.isEmpty((String)address.getPostalCode())) {
            location.setPostal(address.getPostalCode());
        }
        Optional.ofNullable(address.getAddress1()).ifPresent(addressValue -> location.setAddress1(addressValue));
        Optional.ofNullable(address.getAddress2()).ifPresent(addressValue -> location.setAddress2(addressValue));
        Optional.ofNullable(address.getAddress3()).ifPresent(addressValue -> location.setAddress3(addressValue));
        Optional.ofNullable(address.getAddress4()).ifPresent(addressValue -> location.setAddress4(addressValue));
        Optional.ofNullable(address.getPostalCode()).ifPresent(postalCode -> location.setPostal(postalCode));
        location.saveEx(transactionName);
        MBPartnerLocation businessPartnerLocation = new MBPartnerLocation(customer);
        businessPartnerLocation.setC_Location_ID(location.getC_Location_ID());
        businessPartnerLocation.setIsBillTo(address.getIsDefaultBilling());
        businessPartnerLocation.set_ValueOfColumn("IsDefaultBilling", (Object)address.getIsDefaultBilling());
        businessPartnerLocation.setIsShipTo(address.getIsDefaultShipping());
        businessPartnerLocation.set_ValueOfColumn("IsDefaultShipping", (Object)address.getIsDefaultShipping());
        Optional.ofNullable(address.getContactName()).ifPresent(contact -> businessPartnerLocation.setContactPerson(contact));
        Optional.ofNullable(address.getFirstName()).ifPresent(firstName -> businessPartnerLocation.setName(firstName));
        Optional.ofNullable(address.getEmail()).ifPresent(email -> businessPartnerLocation.setEMail(email));
        Optional.ofNullable(address.getPhone()).ifPresent(phome -> businessPartnerLocation.setPhone(phome));
        Optional.ofNullable(address.getDescription()).ifPresent(description -> businessPartnerLocation.set_ValueOfColumn("Description", description));
        if (Util.isEmpty((String)businessPartnerLocation.getName())) {
            businessPartnerLocation.setName(".");
        }
        this.setAdditionalAttributes((PO)businessPartnerLocation, address.getAdditionalAttributesList());
        businessPartnerLocation.saveEx(transactionName);
        if (!(Util.isEmpty((String)address.getContactName()) && Util.isEmpty((String)address.getEmail()) && Util.isEmpty((String)address.getPhone()))) {
            MUser contact2 = new MUser((X_C_BPartner)customer);
            Optional.ofNullable(address.getEmail()).ifPresent(email -> contact2.setEMail(email));
            Optional.ofNullable(address.getPhone()).ifPresent(phome -> contact2.setPhone(phome));
            Optional.ofNullable(address.getDescription()).ifPresent(description -> contact2.setDescription(description));
            String contactName = address.getContactName();
            if (Util.isEmpty((String)contactName)) {
                contactName = address.getEmail();
            }
            if (Util.isEmpty((String)contactName)) {
                contactName = address.getPhone();
            }
            contact2.setName(contactName);
            contact2.setC_BPartner_Location_ID(businessPartnerLocation.getC_BPartner_Location_ID());
            contact2.saveEx(transactionName);
        }
    }

    private Customer.Builder updateCustomer(UpdateCustomerRequest request) {
        if (Util.isEmpty((String)request.getUuid())) {
            throw new AdempiereException("@C_BPartner_ID@ @IsMandatory@");
        }
        AtomicReference customer = new AtomicReference();
        Trx.run(transactionName -> {
            MBPartner businessPartner = MBPartner.get((Properties)Env.getCtx(), (int)RecordUtil.getIdFromUuid("C_BPartner", request.getUuid(), transactionName));
            if (businessPartner == null) {
                throw new AdempiereException("@C_BPartner_ID@ @NotFound@");
            }
            businessPartner.set_TrxName(transactionName);
            Optional.ofNullable(request.getValue()).ifPresent(value -> businessPartner.setValue(value));
            Optional.ofNullable(request.getTaxId()).ifPresent(value -> businessPartner.setTaxID(value));
            Optional.ofNullable(request.getDuns()).ifPresent(value -> businessPartner.setDUNS(value));
            Optional.ofNullable(request.getNaics()).ifPresent(value -> businessPartner.setNAICS(value));
            Optional.ofNullable(request.getName()).ifPresent(value -> businessPartner.setName(value));
            Optional.ofNullable(request.getLastName()).ifPresent(value -> businessPartner.setName2(value));
            Optional.ofNullable(request.getDescription()).ifPresent(value -> businessPartner.setDescription(value));
            this.setAdditionalAttributes((PO)businessPartner, request.getAdditionalAttributesList());
            businessPartner.saveEx(transactionName);
            request.getAddressesList().forEach(address -> {
                int countryId = 0;
                if (!Util.isEmpty((String)address.getCountryUuid())) {
                    countryId = RecordUtil.getIdFromUuid("C_Country", address.getCountryUuid(), transactionName);
                }
                int regionId = 0;
                if (!Util.isEmpty((String)address.getRegionUuid())) {
                    regionId = RecordUtil.getIdFromUuid("C_Region", address.getRegionUuid(), transactionName);
                }
                String cityName = null;
                int cityId = 0;
                if (!Util.isEmpty((String)address.getCityName())) {
                    cityName = address.getCityName();
                }
                if (!Util.isEmpty((String)address.getCityUuid())) {
                    cityId = RecordUtil.getIdFromUuid("C_City", address.getCityUuid(), transactionName);
                }
                if (countryId > 0 || regionId > 0 || cityId > 0 || !Util.isEmpty((String)cityName)) {
                    Optional<MBPartnerLocation> maybeCustomerLocation = Arrays.asList(businessPartner.getLocations(true)).stream().filter(customerLocation -> ValueUtil.validateNull(customerLocation.getUUID()).equals(ValueUtil.validateNull(address.getUuid()))).findFirst();
                    if (maybeCustomerLocation.isPresent()) {
                        MBPartnerLocation businessPartnerLocation = maybeCustomerLocation.get();
                        MLocation location = businessPartnerLocation.getLocation(true);
                        location.set_TrxName(transactionName);
                        if (countryId > 0) {
                            location.setC_Country_ID(countryId);
                        }
                        if (regionId > 0) {
                            location.setC_Region_ID(regionId);
                        }
                        if (cityId > 0) {
                            location.setC_City_ID(cityId);
                        }
                        Optional.ofNullable(cityName).ifPresent(city -> location.setCity(city));
                        Optional.ofNullable(address.getAddress1()).ifPresent(addressValue -> location.setAddress1(addressValue));
                        Optional.ofNullable(address.getAddress2()).ifPresent(addressValue -> location.setAddress2(addressValue));
                        Optional.ofNullable(address.getAddress3()).ifPresent(addressValue -> location.setAddress3(addressValue));
                        Optional.ofNullable(address.getAddress4()).ifPresent(addressValue -> location.setAddress4(addressValue));
                        Optional.ofNullable(address.getPostalCode()).ifPresent(postalCode -> location.setPostal(postalCode));
                        location.saveEx();
                        businessPartnerLocation.setIsBillTo(address.getIsDefaultBilling());
                        businessPartnerLocation.set_ValueOfColumn("IsDefaultBilling", (Object)address.getIsDefaultBilling());
                        businessPartnerLocation.setIsShipTo(address.getIsDefaultShipping());
                        businessPartnerLocation.set_ValueOfColumn("IsDefaultShipping", (Object)address.getIsDefaultShipping());
                        Optional.ofNullable(address.getContactName()).ifPresent(contactName -> businessPartnerLocation.set_ValueOfColumn("ContactName", contactName));
                        Optional.ofNullable(address.getContactName()).ifPresent(contact -> businessPartnerLocation.setContactPerson(contact));
                        Optional.ofNullable(address.getFirstName()).ifPresent(firstName -> businessPartnerLocation.setName(firstName));
                        Optional.ofNullable(address.getLastName()).ifPresent(lastName -> businessPartnerLocation.set_ValueOfColumn("Name2", lastName));
                        Optional.ofNullable(address.getEmail()).ifPresent(email -> businessPartnerLocation.setEMail(email));
                        Optional.ofNullable(address.getPhone()).ifPresent(phome -> businessPartnerLocation.setPhone(phome));
                        Optional.ofNullable(address.getDescription()).ifPresent(description -> businessPartnerLocation.set_ValueOfColumn("Description", description));
                        this.setAdditionalAttributes((PO)businessPartnerLocation, address.getAdditionalAttributesList());
                        businessPartnerLocation.saveEx(transactionName);
                        AtomicReference<MUser> contactReference = new AtomicReference<MUser>(this.getOfBusinessPartnerLocation(businessPartnerLocation, transactionName));
                        if (contactReference.get() == null || contactReference.get().getAD_User_ID() <= 0) {
                            contactReference.set(new MUser((X_C_BPartner)businessPartner));
                        }
                        if (!(Util.isEmpty((String)address.getContactName()) && Util.isEmpty((String)address.getEmail()) && Util.isEmpty((String)address.getPhone()))) {
                            MUser contact2 = contactReference.get();
                            Optional.ofNullable(address.getEmail()).ifPresent(email -> contact2.setEMail(email));
                            Optional.ofNullable(address.getPhone()).ifPresent(phome -> contact2.setPhone(phome));
                            Optional.ofNullable(address.getDescription()).ifPresent(description -> contact2.setDescription(description));
                            String contactName2 = address.getContactName();
                            if (Util.isEmpty((String)contactName2)) {
                                contactName2 = address.getEmail();
                            }
                            if (Util.isEmpty((String)contactName2)) {
                                contactName2 = address.getPhone();
                            }
                            contact2.setName(contactName2);
                            contact2.setC_BPartner_Location_ID(businessPartnerLocation.getC_BPartner_Location_ID());
                            contact2.saveEx(transactionName);
                        }
                    } else {
                        Optional maybeTemplateLocation = Arrays.asList(businessPartner.getLocations(false)).stream().findFirst();
                        if (!maybeTemplateLocation.isPresent()) {
                            throw new AdempiereException("@C_BPartnerCashTrx_ID@ @C_BPartner_Location_ID@ @NotFound@");
                        }
                        MLocation templateLocation = ((MBPartnerLocation)maybeTemplateLocation.get()).getLocation(false);
                        if (templateLocation == null || templateLocation.getC_Location_ID() <= 0) {
                            throw new AdempiereException("@C_Location_ID@ @NotFound@");
                        }
                        this.createCustomerAddress(businessPartner, (AddressRequest)address, templateLocation, transactionName);
                    }
                    customer.set(businessPartner);
                }
            });
        });
        return ConvertUtil.convertCustomer((MBPartner)customer.get());
    }

    private MUser getOfBusinessPartnerLocation(MBPartnerLocation businessPartnerLocation, String transactionName) {
        return (MUser)new Query(businessPartnerLocation.getCtx(), "AD_User", "C_BPartner_Location_ID = ?", transactionName).setParameters(new Object[]{businessPartnerLocation.getC_BPartner_Location_ID()}).first();
    }

    private ListAvailableWarehousesResponse.Builder listWarehouses(ListAvailableWarehousesRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @NotFound@");
        }
        ListAvailableWarehousesResponse.Builder builder = ListAvailableWarehousesResponse.newBuilder();
        String TABLE_NAME = "C_POSWarehouseAllocation";
        if (MTable.getTable_ID((String)"C_POSWarehouseAllocation") <= 0) {
            return builder;
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null);
        Query query = new Query(Env.getCtx(), "C_POSWarehouseAllocation", "C_POS_ID = ?", null).setParameters(new Object[]{posId}).setClient_ID().setOnlyActiveRecords(true).setOrderBy("SeqNo");
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(availableWarehouse -> {
            MWarehouse warehouse = MWarehouse.get((Properties)Env.getCtx(), (int)availableWarehouse.get_ValueAsInt("M_Warehouse_ID"));
            builder.addWarehouses(AvailableWarehouse.newBuilder().setId(warehouse.getM_Warehouse_ID()).setUuid(ValueUtil.validateNull(warehouse.getUUID())).setKey(ValueUtil.validateNull(warehouse.getValue())).setName(ValueUtil.validateNull(warehouse.getName())).setIsPosRequiredPin(availableWarehouse.get_ValueAsBoolean("IsPOSRequiredPIN")));
        });
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListAvailablePriceListResponse.Builder listPriceList(ListAvailablePriceListRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @NotFound@");
        }
        ListAvailablePriceListResponse.Builder builder = ListAvailablePriceListResponse.newBuilder();
        String TABLE_NAME = "C_POSPriceListAllocation";
        if (MTable.getTable_ID((String)"C_POSPriceListAllocation") <= 0) {
            return builder;
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null);
        Query query = new Query(Env.getCtx(), "C_POSPriceListAllocation", "C_POS_ID = ?", null).setParameters(new Object[]{posId}).setClient_ID().setOnlyActiveRecords(true).setOrderBy("SeqNo");
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(availablePriceList -> {
            MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)availablePriceList.get_ValueAsInt("M_PriceList_ID"), null);
            builder.addPriceList(AvailablePriceList.newBuilder().setId(priceList.getM_PriceList_ID()).setUuid(ValueUtil.validateNull(priceList.getUUID())).setKey(ValueUtil.validateNull(priceList.getName())).setName(ValueUtil.validateNull(priceList.getName())).setIsPosRequiredPin(availablePriceList.get_ValueAsBoolean("IsPOSRequiredPIN")));
        });
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListAvailablePaymentMethodsResponse.Builder listPaymentMethods(ListAvailablePaymentMethodsRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @NotFound@");
        }
        ListAvailablePaymentMethodsResponse.Builder builder = ListAvailablePaymentMethodsResponse.newBuilder();
        String TABLE_NAME = "C_POSPaymentTypeAllocation";
        if (MTable.getTable_ID((String)"C_POSPaymentTypeAllocation") <= 0) {
            return builder;
        }
        String PAYMENT_METHOD_TABLE_NAME = "C_PaymentMethod";
        MTable paymentTypeTable = MTable.get((Properties)Env.getCtx(), (String)"C_PaymentMethod");
        if (paymentTypeTable == null || paymentTypeTable.getAD_Table_ID() <= 0) {
            return builder;
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null);
        Query query = new Query(Env.getCtx(), "C_POSPaymentTypeAllocation", "C_POS_ID = ?", null).setParameters(new Object[]{posId}).setOnlyActiveRecords(true).setOrderBy("SeqNo");
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(availablePaymentMethod -> {
            PO paymentMethod = paymentTypeTable.getPO(availablePaymentMethod.get_ValueAsInt("C_PaymentMethod_ID"), null);
            AvailablePaymentMethod.Builder tenderTypeValue = AvailablePaymentMethod.newBuilder();
            tenderTypeValue.setId(paymentMethod.get_ID()).setUuid(ValueUtil.validateNull(paymentMethod.get_UUID())).setKey(ValueUtil.validateNull(paymentMethod.get_ValueAsString("Value"))).setName(ValueUtil.validateNull(paymentMethod.get_ValueAsString("Name"))).setTenderType(ValueUtil.validateNull(paymentMethod.get_ValueAsString("TenderType"))).setIsPosRequiredPin(availablePaymentMethod.get_ValueAsBoolean("IsPOSRequiredPIN")).setIsAllowedToRefund(availablePaymentMethod.get_ValueAsBoolean("IsAllowedToRefund")).setIsAllowedToRefundOpen(availablePaymentMethod.get_ValueAsBoolean("IsAllowedToRefundOpen")).setMaximumRefundAllowed(ValueUtil.getDecimalFromBigDecimal((BigDecimal)availablePaymentMethod.get_Value("MaximumRefundAllowed"))).setMaximumDailyRefundAllowed(ValueUtil.getDecimalFromBigDecimal((BigDecimal)availablePaymentMethod.get_Value("MaximumDailyRefundAllowed"))).setIsPaymentReference(availablePaymentMethod.get_ValueAsBoolean("IsPaymentReference"));
            if (availablePaymentMethod.get_ValueAsInt("RefundReferenceCurrency_ID") > 0) {
                tenderTypeValue.setRefundReferenceCurrency(ConvertUtil.convertCurrency(MCurrency.get((Properties)Env.getCtx(), (int)availablePaymentMethod.get_ValueAsInt("RefundReferenceCurrency_ID"))));
            }
            if (availablePaymentMethod.get_ValueAsInt("ReferenceCurrency_ID") > 0) {
                tenderTypeValue.setReferenceCurrency(ConvertUtil.convertCurrency(MCurrency.get((Properties)Env.getCtx(), (int)availablePaymentMethod.get_ValueAsInt("ReferenceCurrency_ID"))));
            }
            builder.addPaymentMethods(tenderTypeValue);
        });
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListAvailableDocumentTypesResponse.Builder listDocumentTypes(ListAvailableDocumentTypesRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @NotFound@");
        }
        ListAvailableDocumentTypesResponse.Builder builder = ListAvailableDocumentTypesResponse.newBuilder();
        String TABLE_NAME = "C_POSDocumentTypeAllocation";
        if (MTable.getTable_ID((String)"C_POSDocumentTypeAllocation") <= 0) {
            return builder;
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null);
        Query query = new Query(Env.getCtx(), "C_POSDocumentTypeAllocation", "C_POS_ID = ?", null).setParameters(new Object[]{posId}).setClient_ID().setOnlyActiveRecords(true).setOrderBy("SeqNo");
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(availableDocumentType -> {
            MDocType documentType = MDocType.get((Properties)Env.getCtx(), (int)availableDocumentType.get_ValueAsInt("C_DocType_ID"));
            builder.addDocumentTypes(AvailableDocumentType.newBuilder().setId(documentType.getC_DocType_ID()).setUuid(ValueUtil.validateNull(documentType.getUUID())).setKey(ValueUtil.validateNull(documentType.getName())).setName(ValueUtil.validateNull(documentType.getPrintName())).setIsPosRequiredPin(availableDocumentType.get_ValueAsBoolean("IsPOSRequiredPIN")));
        });
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListAvailableCurrenciesResponse.Builder listCurrencies(ListAvailableCurrenciesRequest request) {
        MPOS pos = this.getPOSFromUuid(request.getPosUuid(), true);
        ListAvailableCurrenciesResponse.Builder builder = ListAvailableCurrenciesResponse.newBuilder();
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        String whereClause = "EXISTS(SELECT 1 FROM C_Conversion_Rate cr WHERE (cr.C_Currency_ID = C_Currency.C_Currency_ID  OR cr.C_Currency_ID_To = C_Currency.C_Currency_ID) AND cr.C_ConversionType_ID = ? AND ? >= cr.ValidFrom AND ? <= cr.ValidTo)";
        Timestamp now = TimeUtil.getDay((long)System.currentTimeMillis());
        Query query = new Query(Env.getCtx(), "C_Currency", whereClause.toString(), null).setParameters(new Object[]{pos.get_ValueAsInt("C_ConversionType_ID"), now, now}).setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(currency -> builder.addCurrencies(ConvertUtil.convertCurrency(currency)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private MOrder processOrder(ProcessOrderRequest request) {
        AtomicReference orderReference = new AtomicReference();
        if (!Util.isEmpty((String)request.getOrderUuid())) {
            Trx.run(transactionName -> {
                MOrder salesOrder = this.getOrder(request.getOrderUuid(), transactionName);
                if (salesOrder == null) {
                    throw new AdempiereException("@C_Order_ID@ @NotFound@");
                }
                MPOS pos = this.getPOSFromUuid(request.getPosUuid(), true);
                List<PO> paymentReferences = PointOfSalesServiceImplementation.getPaymentReferences(salesOrder);
                if (DocumentUtil.isDrafted((DocAction)salesOrder)) {
                    if (salesOrder.getDocStatus().equalsIgnoreCase("IN")) {
                        salesOrder.setDocStatus("IP");
                    }
                    boolean isOpenRefund = request.getIsOpenRefund();
                    if (PointOfSalesServiceImplementation.getPaymentReferenceAmount(salesOrder, paymentReferences).compareTo(Env.ZERO) != 0) {
                        isOpenRefund = true;
                    }
                    salesOrder.setDocAction("CO");
                    this.setCurrentDate(salesOrder);
                    salesOrder.saveEx();
                    if (!salesOrder.processIt("CO")) {
                        this.log.warning("@ProcessFailed@ :" + salesOrder.getProcessMsg());
                        throw new AdempiereException("@ProcessFailed@ :" + salesOrder.getProcessMsg());
                    }
                    salesOrder.set_ValueOfColumn("AssignedSalesRep_ID", null);
                    salesOrder.saveEx();
                    if (request.getCreatePayments()) {
                        if (request.getPaymentsList().size() == 0) {
                            throw new AdempiereException("@C_Payment_ID@ @NotFound@");
                        }
                        request.getPaymentsList().forEach(paymentRequest -> this.createPaymentFromOrder(salesOrder, (CreatePaymentRequest)paymentRequest, pos, transactionName));
                    }
                    this.processPayments(salesOrder, pos, isOpenRefund, transactionName);
                } else {
                    boolean isOpenRefund = request.getIsOpenRefund();
                    if (PointOfSalesServiceImplementation.getPaymentReferenceAmount(salesOrder, paymentReferences).compareTo(Env.ZERO) != 0) {
                        isOpenRefund = true;
                    }
                    this.processPayments(salesOrder, pos, isOpenRefund, transactionName);
                }
                this.processPaymentReferences(salesOrder, pos, paymentReferences, transactionName);
                orderReference.set(salesOrder);
            });
        }
        return (MOrder)orderReference.get();
    }

    private void processPaymentReferences(MOrder salesOrder, MPOS pos, List<PO> paymentReferences, String transactionName) {
        paymentReferences.stream().filter(paymentReference -> {
            PO paymentMethodAlocation = this.getPaymentMethodAllocation(paymentReference.get_ValueAsInt("C_PaymentMethod_ID"), paymentReference.get_ValueAsInt("C_POS_ID"), paymentReference.get_TrxName());
            if (paymentMethodAlocation == null) {
                return false;
            }
            return paymentMethodAlocation.get_ValueAsBoolean("IsPaymentReference");
        }).forEach(paymentReference -> {
            paymentReference.set_ValueOfColumn("Processed", (Object)true);
            paymentReference.saveEx();
        });
    }

    private boolean getBooleanValueFromPOS(MPOS pos, int userId, String columnName) {
        if (!pos.get_ValueAsBoolean("IsAllowsAllocateSeller")) {
            return pos.get_ValueAsBoolean(columnName);
        }
        PO userAllocated = PointOfSalesServiceImplementation.getUserAllowed(Env.getCtx(), pos.getC_POS_ID(), userId, null);
        if (userAllocated != null) {
            return userAllocated.get_ValueAsBoolean(columnName);
        }
        return false;
    }

    private BigDecimal getBigDecimalValueFromPOS(MPOS pos, int userId, String columnName) {
        if (!pos.get_ValueAsBoolean("IsAllowsAllocateSeller")) {
            return Optional.ofNullable((BigDecimal)pos.get_Value(columnName)).orElse(Env.ZERO);
        }
        PO userAllocated = PointOfSalesServiceImplementation.getUserAllowed(Env.getCtx(), pos.getC_POS_ID(), userId, null);
        if (userAllocated != null) {
            return Optional.ofNullable((BigDecimal)userAllocated.get_Value(columnName)).orElse(Env.ZERO);
        }
        return Env.ZERO;
    }

    private void processPayments(MOrder salesOrder, MPOS pos, boolean isOpenRefund, String transactionName) {
        BigDecimal writeOffAmtTolerance;
        int invoiceId = salesOrder.getC_Invoice_ID();
        AtomicReference<BigDecimal> openAmount = new AtomicReference<BigDecimal>(salesOrder.getGrandTotal());
        AtomicReference<BigDecimal> currentAmount = new AtomicReference<BigDecimal>(salesOrder.getGrandTotal());
        ArrayList paymentsIds = new ArrayList();
        List payments = MPayment.getOfOrder((MOrder)salesOrder);
        payments.stream().sorted(Comparator.comparing(PO::getCreated)).forEach(payment -> {
            BigDecimal convertedAmount = this.getConvetedAmount(salesOrder, (MPayment)payment, payment.getPayAmt());
            AtomicReference<BigDecimal> multiplier = new AtomicReference<BigDecimal>(Env.ONE);
            if (!payment.isReceipt()) {
                multiplier.set(Env.ONE.negate());
            }
            openAmount.updateAndGet(amount -> amount.subtract(convertedAmount.multiply((BigDecimal)multiplier.get())));
            if (payment.isAllocated()) {
                currentAmount.updateAndGet(amount -> amount.subtract(convertedAmount.multiply((BigDecimal)multiplier.get())));
            }
            if (DocumentUtil.isDrafted((DocAction)payment)) {
                payment.setIsPrepayment(true);
                payment.setOverUnderAmt(Env.ZERO);
                if (payment.getTenderType().equals("M")) {
                    this.createCreditMemo(salesOrder, (MPayment)payment, transactionName);
                }
                payment.setDocAction("CO");
                this.setCurrentDate((MPayment)payment);
                payment.saveEx(transactionName);
                if (!payment.processIt("CO")) {
                    this.log.warning("@ProcessFailed@ :" + payment.getProcessMsg());
                    throw new AdempiereException("@ProcessFailed@ :" + payment.getProcessMsg());
                }
                payment.saveEx(transactionName);
                paymentsIds.add(payment.getC_Payment_ID());
                salesOrder.saveEx(transactionName);
            }
            MBankStatement.addPayment((MPayment)payment);
        });
        if (!isOpenRefund && (writeOffAmtTolerance = this.getBigDecimalValueFromPOS(pos, salesOrder.getSalesRep_ID(), "WriteOffAmtTolerance")).compareTo(Env.ZERO) > 0 && openAmount.get().abs().compareTo(writeOffAmtTolerance) > 0) {
            throw new AdempiereException("@POS.WriteOffAmtToleranceExceeded@");
        }
        if (paymentsIds.size() > 0) {
            String description = Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_POS_ID@: " + pos.getName() + " - " + salesOrder.getDocumentNo()));
            MAllocationHdr paymentAllocation = new MAllocationHdr(Env.getCtx(), true, RecordUtil.getDate(), salesOrder.getC_Currency_ID(), description, transactionName);
            paymentAllocation.setAD_Org_ID(salesOrder.getAD_Org_ID());
            paymentAllocation.saveEx();
            AtomicBoolean isAllocationLineCreated = new AtomicBoolean(false);
            paymentsIds.stream().map(paymentId -> new MPayment(Env.getCtx(), paymentId.intValue(), transactionName)).filter(payment -> payment.getC_POS_ID() != 0 && !payment.getTenderType().equals("M")).forEach(payment -> {
                BigDecimal multiplier = Env.ONE;
                if (!payment.isReceipt()) {
                    multiplier = Env.ONE.negate();
                }
                BigDecimal paymentAmount = this.getConvetedAmount(salesOrder, (MPayment)payment, payment.getPayAmt());
                BigDecimal discountAmount = this.getConvetedAmount(salesOrder, (MPayment)payment, payment.getDiscountAmt());
                BigDecimal overUnderAmount = this.getConvetedAmount(salesOrder, (MPayment)payment, payment.getOverUnderAmt());
                BigDecimal writeOffAmount = this.getConvetedAmount(salesOrder, (MPayment)payment, payment.getWriteOffAmt());
                if (overUnderAmount.signum() < 0 && paymentAmount.signum() > 0) {
                    paymentAmount = paymentAmount.add(overUnderAmount);
                }
                MAllocationLine paymentAllocationLine = new MAllocationLine(paymentAllocation, paymentAmount.multiply(multiplier), discountAmount.multiply(multiplier), writeOffAmount.multiply(multiplier), overUnderAmount.multiply(multiplier));
                paymentAllocationLine.setDocInfo(salesOrder.getC_BPartner_ID(), salesOrder.getC_Order_ID(), invoiceId);
                paymentAllocationLine.setPaymentInfo(payment.getC_Payment_ID(), 0);
                paymentAllocationLine.saveEx();
                isAllocationLineCreated.set(true);
            });
            paymentsIds.stream().map(paymentId -> new MPayment(Env.getCtx(), paymentId.intValue(), transactionName)).filter(payment -> payment.getC_POS_ID() != 0 && payment.getTenderType().equals("M")).forEach(payment -> {
                if (!isAllocationLineCreated.get()) {
                    BigDecimal discountAmount = Env.ZERO;
                    BigDecimal overUnderAmount = Env.ZERO;
                    BigDecimal writeOffAmount = Env.ZERO;
                    MAllocationLine paymentAllocationLine = new MAllocationLine(paymentAllocation, (BigDecimal)currentAmount.get(), discountAmount, writeOffAmount, overUnderAmount);
                    paymentAllocationLine.setDocInfo(salesOrder.getC_BPartner_ID(), salesOrder.getC_Order_ID(), invoiceId);
                    paymentAllocationLine.saveEx();
                }
                BigDecimal multiplier = Env.ONE.negate();
                MInvoice creditMemo = (MInvoice)new Query(payment.getCtx(), "C_Invoice", "C_Payment_ID = ?", payment.get_TrxName()).setParameters(new Object[]{payment.getC_Payment_ID()}).first();
                BigDecimal paymentAmount = this.getConvetedAmount(salesOrder, (MPayment)payment, creditMemo.getGrandTotal());
                BigDecimal discountAmount = Env.ZERO;
                BigDecimal overUnderAmount = Env.ZERO;
                BigDecimal writeOffAmount = Env.ZERO;
                if (overUnderAmount.signum() < 0 && paymentAmount.signum() > 0) {
                    paymentAmount = paymentAmount.add(overUnderAmount);
                }
                MAllocationLine paymentAllocationLine = new MAllocationLine(paymentAllocation, paymentAmount.multiply(multiplier), discountAmount.multiply(multiplier), writeOffAmount.multiply(multiplier), overUnderAmount.multiply(multiplier));
                paymentAllocationLine.setDocInfo(salesOrder.getC_BPartner_ID(), salesOrder.getC_Order_ID(), creditMemo.getC_Invoice_ID());
                paymentAllocationLine.saveEx();
            });
            if (!isOpenRefund && openAmount.get().compareTo(Env.ZERO) != 0) {
                MAllocationLine paymentAllocationLine = new MAllocationLine(paymentAllocation, Env.ZERO, Env.ZERO, openAmount.get(), Env.ZERO);
                paymentAllocationLine.setDocInfo(salesOrder.getC_BPartner_ID(), salesOrder.getC_Order_ID(), invoiceId);
                paymentAllocationLine.saveEx();
            }
            if (!paymentAllocation.processIt("CO")) {
                this.log.warning("@ProcessFailed@ :" + paymentAllocation.getProcessMsg());
                throw new AdempiereException("@ProcessFailed@ :" + paymentAllocation.getProcessMsg());
            }
            paymentAllocation.saveEx();
            paymentsIds.stream().map(paymentId -> new MPayment(Env.getCtx(), paymentId.intValue(), transactionName)).forEach(payment -> {
                payment.setIsAllocated(true);
                payment.saveEx();
            });
        }
    }

    private PO getPaymentMethodAllocation(int paymentMethodId, int posId, String transactionName) {
        if (MTable.get((Properties)Env.getCtx(), (String)"C_POSPaymentTypeAllocation") == null) {
            return null;
        }
        return new Query(Env.getCtx(), "C_POSPaymentTypeAllocation", "C_POS_ID = ? AND C_PaymentMethod_ID = ?", transactionName).setParameters(new Object[]{posId, paymentMethodId}).setOnlyActiveRecords(true).first();
    }

    private void createCreditMemo(MOrder salesOrder, MPayment payment, String transactionName) {
        MInvoice creditMemo = new MInvoice(salesOrder.getCtx(), 0, transactionName);
        creditMemo.setBPartner((MBPartner)payment.getC_BPartner());
        creditMemo.setDescription(payment.getDescription());
        creditMemo.setIsSOTrx(true);
        creditMemo.setSalesRep_ID(salesOrder.getSalesRep_ID());
        creditMemo.setAD_Org_ID(salesOrder.getAD_Org_ID());
        creditMemo.setC_POS_ID(salesOrder.getC_POS_ID());
        if (creditMemo.getM_PriceList_ID() <= 0 || creditMemo.getC_Currency_ID() != payment.getC_Currency_ID()) {
            MPriceList priceList = MPriceList.getDefault((Properties)salesOrder.getCtx(), (boolean)true, (String)MCurrency.getISO_Code((Properties)salesOrder.getCtx(), (int)payment.getC_Currency_ID()));
            if (priceList == null) {
                throw new AdempiereException("@M_PriceList_ID@ @NotFound@");
            }
            creditMemo.setM_PriceList_ID(priceList.getM_PriceList_ID());
        }
        PO paymentTypeAllocation = this.getPaymentMethodAllocation(payment.get_ValueAsInt("C_PaymentMethod_ID"), payment.getC_POS_ID(), payment.get_TrxName());
        int chargeId = 0;
        if (paymentTypeAllocation != null) {
            chargeId = paymentTypeAllocation.get_ValueAsInt("C_Charge_ID");
            if (paymentTypeAllocation.get_ValueAsInt("C_DocTypeCreditMemo_ID") > 0) {
                creditMemo.setC_DocTypeTarget_ID(paymentTypeAllocation.get_ValueAsInt("C_DocTypeCreditMemo_ID"));
            }
        }
        if (creditMemo.getC_DocTypeTarget_ID() <= 0) {
            creditMemo.setC_DocTypeTarget_ID("ARC");
        }
        creditMemo.setDocumentNo(payment.getDocumentNo());
        creditMemo.setC_ConversionType_ID(payment.getC_ConversionType_ID());
        creditMemo.setC_Order_ID(salesOrder.getC_Order_ID());
        creditMemo.setC_Payment_ID(payment.getC_Payment_ID());
        creditMemo.saveEx(transactionName);
        MInvoiceLine creditMemoLine = new MInvoiceLine(creditMemo);
        if (chargeId <= 0) {
            chargeId = new Query(salesOrder.getCtx(), "C_Charge", null, transactionName).setClient_ID().firstId();
        }
        MCharge charge = MCharge.get((Properties)payment.getCtx(), (int)chargeId);
        Optional<MTax> optionalTax = Arrays.asList(MTax.getAll((Properties)Env.getCtx())).stream().filter(tax -> tax.getC_TaxCategory_ID() == charge.getC_TaxCategory_ID() && (tax.isSalesTax() || !Util.isEmpty((String)tax.getSOPOType()) && (tax.getSOPOType().equals("B") || tax.getSOPOType().equals("S")))).findFirst();
        creditMemoLine.setC_Charge_ID(chargeId);
        creditMemoLine.setC_Tax_ID(optionalTax.get().getC_Tax_ID());
        creditMemoLine.setQty(Env.ONE);
        creditMemoLine.setPrice(payment.getPayAmt());
        creditMemoLine.setDescription(payment.getDescription());
        creditMemoLine.saveEx(transactionName);
        payment.setC_Invoice_ID(-1);
        payment.setPayAmt(Env.ZERO);
        payment.saveEx(transactionName);
        if (!creditMemo.processIt("CO")) {
            this.log.warning("@ProcessFailed@ :" + creditMemo.getProcessMsg());
            throw new AdempiereException("@ProcessFailed@ :" + creditMemo.getProcessMsg());
        }
        creditMemo.saveEx(transactionName);
    }

    private static List<PO> getPaymentReferences(MOrder order) {
        if (MTable.get((Properties)Env.getCtx(), (String)"C_POSPaymentReference") == null) {
            return new ArrayList<PO>();
        }
        return new Query(order.getCtx(), "C_POSPaymentReference", "C_Order_ID = ? AND IsPaid = 'N' AND Processed = 'N'", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).list();
    }

    private static BigDecimal getPaymentReferenceAmount(MOrder order, List<PO> paymentReferences) {
        Optional paymentReferenceAmount = paymentReferences.stream().map(refundReference -> PointOfSalesServiceImplementation.getConvetedAmount(order, refundReference, (BigDecimal)refundReference.get_Value("Amount"))).collect(Collectors.reducing(BigDecimal::add));
        if (paymentReferenceAmount.isPresent()) {
            return (BigDecimal)paymentReferenceAmount.get();
        }
        return Env.ZERO;
    }

    private static BigDecimal getConvetedAmount(MOrder order, PO payment, BigDecimal amount) {
        if (payment.get_ValueAsInt("C_Currency_ID") == order.getC_Currency_ID() || amount == null || amount.compareTo(Env.ZERO) == 0) {
            return amount;
        }
        BigDecimal convertedAmount = MConversionRate.convert((Properties)payment.getCtx(), (BigDecimal)amount, (int)payment.get_ValueAsInt("C_Currency_ID"), (int)order.getC_Currency_ID(), (Timestamp)order.getDateAcct(), (int)payment.get_ValueAsInt("C_ConversionType_ID"), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID());
        return Optional.ofNullable(convertedAmount).orElse(Env.ZERO);
    }

    private BigDecimal getConvetedAmount(MOrder order, MPayment payment, BigDecimal amount) {
        if (payment.getC_Currency_ID() == order.getC_Currency_ID() || amount == null || amount.compareTo(Env.ZERO) == 0) {
            return amount;
        }
        BigDecimal convertedAmount = MConversionRate.convert((Properties)payment.getCtx(), (BigDecimal)amount, (int)payment.getC_Currency_ID(), (int)order.getC_Currency_ID(), (Timestamp)payment.getDateAcct(), (int)payment.getC_ConversionType_ID(), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID());
        if (convertedAmount == null || convertedAmount.compareTo(Env.ZERO) == 0) {
            throw new AdempiereException(MConversionRate.getErrorMessage((Properties)payment.getCtx(), (String)"ErrorConvertingDocumentCurrencyToBaseCurrency", (int)payment.getC_Currency_ID(), (int)order.getC_Currency_ID(), (int)payment.getC_ConversionType_ID(), (Timestamp)payment.getDateAcct(), (String)payment.get_TrxName()));
        }
        return convertedAmount;
    }

    private ListOrdersResponse.Builder listOrders(ListOrdersRequest request) {
        BigDecimal openAmount;
        BigDecimal grandTotal;
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getSalesRepresentativeUuid())) {
            throw new AdempiereException("@SalesRep_ID@ @IsMandatory@");
        }
        ListOrdersResponse.Builder builder = ListOrdersResponse.newBuilder();
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null);
        int salesRepresentativeId = RecordUtil.getIdFromUuid("AD_User", request.getSalesRepresentativeUuid(), null);
        int orgId = Env.getAD_Org_ID((Properties)Env.getCtx());
        MUser salesRepresentative = MUser.get((Properties)Env.getCtx(), (int)salesRepresentativeId);
        boolean isAppliedNewFeaturesPOS = M_Element.get((Properties)Env.getCtx(), (String)"IsSharedPOS") != null && M_Element.get((Properties)Env.getCtx(), (String)"IsAllowsAllocateSeller") != null;
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> parameters = new ArrayList<Object>();
        whereClause.append("(C_Order.AD_Org_ID = ? OR C_Order.C_POS_ID = ?)");
        parameters.add(orgId);
        parameters.add(posId);
        if (!salesRepresentative.get_ValueAsBoolean("IsPOSManager")) {
            if (isAppliedNewFeaturesPOS) {
                if (request.getIsOnlyAisleSeller()) {
                    whereClause.append(" AND ((C_Order.SalesRep_ID = ? OR COALESCE(C_Order.AssignedSalesRep_ID, ?) = ?) AND EXISTS(SELECT 1 FROM C_POS p WHERE p.C_POS_ID = C_Order.C_POS_ID AND p.IsAisleSeller = 'Y'))");
                    parameters.add(salesRepresentativeId);
                    parameters.add(salesRepresentativeId);
                    parameters.add(salesRepresentativeId);
                } else {
                    whereClause.append(" AND ((C_Order.SalesRep_ID = ? OR COALESCE(C_Order.AssignedSalesRep_ID, ?) = ?) AND EXISTS(SELECT 1 FROM C_POS p WHERE p.C_POS_ID = C_Order.C_POS_ID AND p.IsSharedPOS = 'Y'))");
                    parameters.add(salesRepresentativeId);
                    parameters.add(salesRepresentativeId);
                    parameters.add(salesRepresentativeId);
                }
            } else {
                whereClause.append(" AND C_Order.C_POS_ID = ?");
                parameters.add(posId);
            }
        }
        if (!Util.isEmpty((String)request.getDocumentNo())) {
            whereClause.append(" AND UPPER(DocumentNo) LIKE '%' || UPPER(?) || '%'");
            parameters.add(request.getDocumentNo());
        }
        if (!Util.isEmpty((String)request.getBusinessPartnerUuid())) {
            int businessPartnerId = RecordUtil.getIdFromUuid("C_BPartner", request.getBusinessPartnerUuid(), null);
            whereClause.append(" AND C_BPartner_ID = ?");
            parameters.add(businessPartnerId);
        }
        if ((grandTotal = ValueUtil.getBigDecimalFromDecimal(request.getGrandTotal())) != null && !grandTotal.equals(Env.ZERO)) {
            whereClause.append(" AND GrandTotal = ?");
            parameters.add(grandTotal);
        }
        if ((openAmount = ValueUtil.getBigDecimalFromDecimal(request.getOpenAmount())) != null && !openAmount.equals(Env.ZERO)) {
            whereClause.append(" (EXISTS(SELECT 1 FROM C_Invoice i WHERE i.C_Order_ID = C_Order.C_Order_ID GROUP BY i.C_Order_ID HAVING(SUM(invoiceopen(i.C_Invoice_ID, 0)) = ?)) OR EXISTS(SELECT 1 FROM C_Payment p WHERE C_Order_ID = C_Order.C_Order_ID GROUP BY p.C_Order_ID HAVING(SUM(p.PayAmt) = ?))");
            parameters.add(openAmount);
            parameters.add(openAmount);
        }
        if (request.getIsOnlyProcessed()) {
            whereClause.append(" AND DocStatus IN('CO')");
        }
        if (request.getIsWaitingForInvoice()) {
            whereClause.append(" AND C_Order.Processed = 'N' AND NOT EXISTS(SELECT 1 FROM C_Invoice i WHERE i.C_Order_ID = C_Order.C_Order_ID AND i.DocStatus IN('CO', 'CL'))");
        }
        if (request.getIsWaitingForPay()) {
            whereClause.append(" AND NOT EXISTS(SELECT 1 FROM C_Payment p WHERE p.C_Order_ID = C_Order.C_Order_ID)");
        }
        if (request.getIsWaitingForShipment()) {
            whereClause.append(" AND DocStatus IN('CO') AND NOT EXISTS(SELECT 1 FROM M_InOut io WHERE io.C_Order_ID = C_Order.C_Order_ID AND io.DocStatus IN('CO', 'CL'))");
        }
        if (!Util.isEmpty((String)request.getDateOrderedFrom())) {
            whereClause.append(" AND DateOrdered >= ?");
            parameters.add(TimeUtil.getDay((Timestamp)ValueUtil.convertStringToDate(request.getDateOrderedFrom())));
        }
        if (!Util.isEmpty((String)request.getDateOrderedTo())) {
            whereClause.append(" AND DateOrdered <= ?");
            parameters.add(TimeUtil.getDay((Timestamp)ValueUtil.convertStringToDate(request.getDateOrderedTo())));
        }
        Query query = new Query(Env.getCtx(), "C_Order", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true).setOrderBy("DateOrdered DESC, Updated DESC");
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(order -> builder.addOrders(ConvertUtil.convertOrder(order)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListPaymentsResponse.Builder listPayments(ListPaymentsRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @NotFound@");
        }
        ListPaymentsResponse.Builder builder = ListPaymentsResponse.newBuilder();
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        int posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null);
        int orderId = RecordUtil.getIdFromUuid("C_Order", request.getOrderUuid(), null);
        if (orderId > 0) {
            whereClause.append("C_Payment.C_Order_ID = ?");
            parameters.add(orderId);
        } else {
            whereClause.append("C_Payment.C_POS_ID = ?");
            parameters.add(posId);
            whereClause.append(" AND C_Payment.C_Charge_ID IS NOT NULL AND C_Payment.Processed = 'N'");
        }
        if (request.getIsOnlyRefund()) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("C_Payment.IsReceipt = 'N'");
        }
        if (request.getIsOnlyReceipt()) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("C_Payment.IsReceipt = 'Y'");
        }
        Query query = new Query(Env.getCtx(), "C_Payment", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(payment -> builder.addPayments(ConvertUtil.convertPayment(payment)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListOrderLinesResponse.Builder listOrderLines(ListOrderLinesRequest request) {
        if (Util.isEmpty((String)request.getOrderUuid())) {
            throw new AdempiereException("@C_Order_ID@ @NotFound@");
        }
        int orderId = RecordUtil.getIdFromUuid("C_Order", request.getOrderUuid(), null);
        MOrder order = new MOrder(Env.getCtx(), orderId, null);
        MPOS pos = new MPOS(Env.getCtx(), order.getC_POS_ID(), order.get_TrxName());
        ListOrderLinesResponse.Builder builder = ListOrderLinesResponse.newBuilder();
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        StringBuffer whereClause = new StringBuffer("C_Order_ID = ?");
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        parameters.add(orderId);
        if (pos.get_ValueAsInt("DefaultDiscountCharge_ID") > 0) {
            parameters.add(pos.get_ValueAsInt("DefaultDiscountCharge_ID"));
            whereClause.append(" AND (C_Charge_ID IS NULL OR C_Charge_ID <> ?)");
        }
        Query query = new Query(Env.getCtx(), "C_OrderLine", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(orderLine -> builder.addOrderLines(ConvertUtil.convertOrderLine(orderLine)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private MOrder getOrder(String uuid, String transactionName) {
        return (MOrder)RecordUtil.getEntity(Env.getCtx(), "C_Order", uuid, 0, transactionName);
    }

    private MOrder changeOrderAssigned(String orderUuid, String salesRepresentativeUuid) {
        AtomicReference orderReference = new AtomicReference();
        if (!Util.isEmpty((String)orderUuid)) {
            Trx.run(transactionName -> {
                MOrder salesOrder = this.getOrder(orderUuid, transactionName);
                if (salesOrder == null) {
                    throw new AdempiereException("@C_Order_ID@ @NotFound@");
                }
                if (!DocumentUtil.isDrafted((DocAction)salesOrder)) {
                    throw new AdempiereException("@C_Order_ID@ @Processed@");
                }
                if (!Util.isEmpty((String)salesRepresentativeUuid)) {
                    int salesRepresentativeId = RecordUtil.getIdFromUuid("AD_User", salesRepresentativeUuid, transactionName);
                    if (salesOrder.get_ValueAsInt("AssignedSalesRep_ID") > 0 && salesRepresentativeId != salesOrder.get_ValueAsInt("AssignedSalesRep_ID")) {
                        throw new AdempiereException("@POS.SalesRepAssigned@");
                    }
                    salesOrder.set_ValueOfColumn("AssignedSalesRep_ID", (Object)salesRepresentativeId);
                } else {
                    salesOrder.set_ValueOfColumn("AssignedSalesRep_ID", null);
                }
                salesOrder.saveEx(transactionName);
                orderReference.set(salesOrder);
            });
        }
        return (MOrder)orderReference.get();
    }

    private MOrder updateOrder(UpdateOrderRequest request) {
        AtomicReference orderReference = new AtomicReference();
        if (!Util.isEmpty((String)request.getOrderUuid())) {
            Trx.run(transactionName -> {
                BigDecimal discountRate;
                int businessPartnerId;
                int documentTypeId;
                int posId;
                MOrder salesOrder = this.getOrder(request.getOrderUuid(), transactionName);
                if (salesOrder == null) {
                    throw new AdempiereException("@C_Order_ID@ @NotFound@");
                }
                if (!DocumentUtil.isDrafted((DocAction)salesOrder)) {
                    throw new AdempiereException("@C_Order_ID@ @Processed@");
                }
                this.validateOrderReleased(salesOrder);
                Timestamp now = TimeUtil.getDay((long)System.currentTimeMillis());
                salesOrder.setDateOrdered(now);
                salesOrder.setDateAcct(now);
                salesOrder.setDatePromised(now);
                if (!Util.isEmpty((String)request.getPosUuid()) && (posId = RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), transactionName)) > 0 && salesOrder.getC_POS_ID() <= 0) {
                    salesOrder.setC_POS_ID(posId);
                }
                if (!Util.isEmpty((String)request.getDocumentTypeUuid()) && (documentTypeId = RecordUtil.getIdFromUuid("C_DocType", request.getDocumentTypeUuid(), transactionName)) > 0 && documentTypeId != salesOrder.getC_DocTypeTarget_ID()) {
                    salesOrder.setC_DocTypeTarget_ID(documentTypeId);
                    salesOrder.setC_DocType_ID(documentTypeId);
                    String value = DB.getDocumentNo((int)documentTypeId, (String)transactionName, (boolean)false, (PO)salesOrder);
                    if (value != null) {
                        salesOrder.setDocumentNo(value);
                    }
                }
                if (!Util.isEmpty((String)request.getCustomerUuid()) && (businessPartnerId = RecordUtil.getIdFromUuid("C_BPartner", request.getCustomerUuid(), transactionName)) > 0 && salesOrder.getC_POS_ID() > 0) {
                    this.configureBPartner(salesOrder, businessPartnerId, transactionName);
                }
                if (!Util.isEmpty((String)request.getDescription())) {
                    salesOrder.setDescription(request.getDescription());
                }
                int warehouseId = 0;
                int priceListId = 0;
                int campaignId = RecordUtil.getIdFromUuid("C_Campaign", request.getCampaignUuid(), transactionName);
                if (campaignId > 0 && campaignId != salesOrder.getC_Campaign_ID()) {
                    salesOrder.setC_Campaign_ID(campaignId);
                }
                if (!Util.isEmpty((String)request.getWarehouseUuid())) {
                    warehouseId = RecordUtil.getIdFromUuid("M_Warehouse", request.getWarehouseUuid(), transactionName);
                }
                if (!Util.isEmpty((String)request.getPriceListUuid())) {
                    priceListId = RecordUtil.getIdFromUuid("M_PriceList", request.getPriceListUuid(), transactionName);
                }
                if (priceListId > 0 && priceListId != salesOrder.getM_PriceList_ID()) {
                    salesOrder.setM_PriceList_ID(priceListId);
                    salesOrder.saveEx(transactionName);
                    this.configurePriceList(salesOrder);
                }
                if (warehouseId > 0) {
                    salesOrder.setM_Warehouse_ID(warehouseId);
                    salesOrder.saveEx(transactionName);
                    this.configureWarehouse(salesOrder);
                }
                if ((discountRate = ValueUtil.getBigDecimalFromDecimal(request.getDiscountRate())) != null) {
                    this.configureDiscount(salesOrder, discountRate, transactionName);
                }
                BigDecimal discountRateOff = ValueUtil.getBigDecimalFromDecimal(request.getDiscountRateOff());
                BigDecimal discountAmountOff = ValueUtil.getBigDecimalFromDecimal(request.getDiscountAmountOff());
                if (discountRateOff != null) {
                    this.configureDiscountRateOff(salesOrder, discountRateOff, transactionName);
                } else if (discountAmountOff != null) {
                    this.configureDiscountAmountOff(salesOrder, discountAmountOff, transactionName);
                }
                salesOrder.saveEx(transactionName);
                orderReference.set(salesOrder);
            });
        }
        return (MOrder)orderReference.get();
    }

    public void configureBPartner(MOrder order, int businessPartnerId, String transactionName) {
        MBPartnerLocation[] partnerLocations;
        if (DocumentUtil.isCompleted((DocAction)order) || DocumentUtil.isVoided((DocAction)order)) {
            return;
        }
        this.log.fine("CPOS.setC_BPartner_ID=" + businessPartnerId);
        boolean isSamePOSPartner = false;
        MPOS pos = new MPOS(Env.getCtx(), order.getC_POS_ID(), null);
        if (businessPartnerId == 0) {
            isSamePOSPartner = true;
            businessPartnerId = pos.getC_BPartnerCashTrx_ID();
        }
        MBPartner partner = MBPartner.get((Properties)Env.getCtx(), (int)businessPartnerId);
        partner.set_TrxName(null);
        if (partner == null || partner.get_ID() == 0) {
            throw new AdempiereException("POS.NoBPartnerForOrder");
        }
        this.log.info("CPOS.SetC_BPartner_ID -" + partner);
        order.setBPartner(partner);
        AtomicBoolean priceListIsChanged = new AtomicBoolean(false);
        if (partner.getM_PriceList_ID() > 0) {
            MPriceList businesPartnerPriceList = MPriceList.get((Properties)Env.getCtx(), (int)partner.getM_PriceList_ID(), null);
            MPriceList currentPriceList = MPriceList.get((Properties)Env.getCtx(), (int)pos.getM_PriceList_ID(), null);
            if (currentPriceList.getC_Currency_ID() != businesPartnerPriceList.getC_Currency_ID()) {
                order.setM_PriceList_ID(currentPriceList.getM_PriceList_ID());
            } else if (currentPriceList.getM_PriceList_ID() != partner.getM_PriceList_ID()) {
                priceListIsChanged.set(true);
            }
        }
        if ((partnerLocations = partner.getLocations(true)).length > 0) {
            for (MBPartnerLocation partnerLocation : partnerLocations) {
                if (partnerLocation.isBillTo()) {
                    order.setBill_Location_ID(partnerLocation.getC_BPartner_Location_ID());
                }
                if (!partnerLocation.isShipTo()) continue;
                order.setShip_Location_ID(partnerLocation.getC_BPartner_Location_ID());
            }
        }
        if (isSamePOSPartner && order.getPaymentRule() == null) {
            order.setPaymentRule("B");
        }
        if (order.getC_BPartner().getSalesRep_ID() != 0) {
            order.setSalesRep_ID(order.getC_BPartner().getSalesRep_ID());
        } else {
            order.setSalesRep_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        }
        order.saveEx(transactionName);
        Arrays.asList(order.getLines(true, "Line")).forEach(orderLine -> {
            orderLine.setC_BPartner_ID(partner.getC_BPartner_ID());
            orderLine.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
            orderLine.setPrice();
            orderLine.setTax();
            orderLine.saveEx(transactionName);
            if (Optional.ofNullable(orderLine.getPriceActual()).orElse(Env.ZERO).signum() == 0 && priceListIsChanged.get()) {
                orderLine.saveEx(transactionName);
            }
        });
        MPayment.getOfOrder((MOrder)order).forEach(payment -> {
            if (DocumentUtil.isCompleted((DocAction)payment) || DocumentUtil.isVoided((DocAction)payment)) {
                throw new AdempiereException("@C_Payment_ID@ @Processed@ " + payment.getDocumentNo());
            }
            payment.setC_BPartner_ID(order.getC_BPartner_ID());
            payment.saveEx(transactionName);
        });
    }

    private void configureWarehouse(MOrder order) {
        Arrays.asList(order.getLines()).forEach(orderLine -> {
            orderLine.setM_Warehouse_ID(order.getM_Warehouse_ID());
            orderLine.saveEx();
        });
    }

    private void configureDiscount(MOrder order, BigDecimal discountRate, String transactionName) {
        Arrays.asList(order.getLines()).forEach(orderLine -> {
            BigDecimal discountAmount = orderLine.getPriceList().multiply(Optional.ofNullable(discountRate).orElse(Env.ZERO).divide(Env.ONEHUNDRED));
            BigDecimal price = orderLine.getPriceList().subtract(discountAmount);
            orderLine.setPrice(price);
            orderLine.setTax();
            orderLine.saveEx(transactionName);
        });
    }

    private void configureDiscountRateOff(MOrder order, BigDecimal discountRateOff, String transactionName) {
        if (discountRateOff == null) {
            return;
        }
        MPOS pos = new MPOS(order.getCtx(), order.getC_POS_ID(), order.get_TrxName());
        if (pos.get_ValueAsInt("DefaultDiscountCharge_ID") <= 0) {
            throw new AdempiereException("@DefaultDiscountCharge_ID@ @NotFound@");
        }
        boolean isAllowsApplyDiscount = this.getBooleanValueFromPOS(pos, Env.getAD_User_ID((Properties)Env.getCtx()), "IsAllowsApplyDiscount");
        if (!isAllowsApplyDiscount) {
            throw new AdempiereException("@ActionNotAllowedHere@");
        }
        BigDecimal maximumDiscountAllowed = this.getBigDecimalValueFromPOS(pos, Env.getAD_User_ID((Properties)Env.getCtx()), "MaximumDiscountAllowed");
        if (maximumDiscountAllowed.compareTo(Env.ZERO) > 0 && discountRateOff.compareTo(maximumDiscountAllowed) > 0) {
            throw new AdempiereException("@POS.MaximumDiscountAllowedExceeded@");
        }
        Optional baseAmount = Arrays.asList(order.getLines()).stream().filter(ordeLine -> ordeLine.getC_Charge_ID() != pos.get_ValueAsInt("DefaultDiscountCharge_ID")).map(ordeLine -> ordeLine.getLineNetAmt()).collect(Collectors.reducing(BigDecimal::add));
        if (baseAmount.isPresent() && ((BigDecimal)baseAmount.get()).compareTo(Env.ZERO) > 0) {
            int precision = MCurrency.getStdPrecision((Properties)order.getCtx(), (int)order.getC_Currency_ID());
            BigDecimal finalPrice = PointOfSalesServiceImplementation.getFinalPrice((BigDecimal)baseAmount.get(), discountRateOff, precision);
            this.createDiscountLine(pos, order, ((BigDecimal)baseAmount.get()).subtract(finalPrice), transactionName);
            order.set_ValueOfColumn("FlatDiscount", (Object)discountRateOff);
            order.saveEx(transactionName);
        } else {
            this.deleteDiscountLine(pos, order, transactionName);
        }
    }

    public static BigDecimal getFinalPrice(BigDecimal basePrice, BigDecimal discount, int precision) {
        basePrice = Optional.ofNullable(basePrice).orElse(Env.ZERO);
        discount = Optional.ofNullable(discount).orElse(Env.ZERO);
        BigDecimal multiplier = Env.ONE.subtract(discount.divide(Env.ONEHUNDRED, MathContext.DECIMAL128));
        BigDecimal finalPrice = basePrice.multiply(multiplier);
        finalPrice = finalPrice.setScale(precision, 4);
        return finalPrice;
    }

    public static BigDecimal getDiscount(BigDecimal basePrice, BigDecimal finalPrice, int precision) {
        finalPrice = Optional.ofNullable(finalPrice).orElse(Env.ZERO);
        basePrice = Optional.ofNullable(basePrice).orElse(Env.ZERO);
        BigDecimal discount = Env.ZERO;
        if (basePrice.compareTo(Env.ZERO) != 0) {
            discount = basePrice.subtract(finalPrice);
            discount = discount.divide(basePrice, MathContext.DECIMAL128);
            discount = discount.multiply(Env.ONEHUNDRED);
        }
        if (discount.scale() > precision) {
            discount = discount.setScale(precision, 4);
        }
        return discount.negate();
    }

    private void configureDiscountAmountOff(MOrder order, BigDecimal discountAmountOff, String transactionName) {
        if (discountAmountOff == null) {
            return;
        }
        MPOS pos = new MPOS(order.getCtx(), order.getC_POS_ID(), order.get_TrxName());
        if (pos.get_ValueAsInt("DefaultDiscountCharge_ID") <= 0) {
            throw new AdempiereException("@DefaultDiscountCharge_ID@ @NotFound@");
        }
        int defaultDiscountChargeId = pos.get_ValueAsInt("DefaultDiscountCharge_ID");
        boolean isAllowsApplyDiscount = this.getBooleanValueFromPOS(pos, Env.getAD_User_ID((Properties)Env.getCtx()), "IsAllowsApplyDiscount");
        if (!isAllowsApplyDiscount) {
            throw new AdempiereException("@ActionNotAllowedHere@");
        }
        BigDecimal maximumDiscountAllowed = this.getBigDecimalValueFromPOS(pos, Env.getAD_User_ID((Properties)Env.getCtx()), "MaximumDiscountAllowed");
        BigDecimal baseAmount = Optional.ofNullable(Arrays.asList(order.getLines()).stream().filter(orderLine -> orderLine.getC_Charge_ID() != defaultDiscountChargeId || defaultDiscountChargeId == 0).map(ordeLine -> ordeLine.getLineNetAmt()).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(Env.ZERO);
        if (baseAmount.compareTo(Env.ZERO) <= 0) {
            this.deleteDiscountLine(pos, order, transactionName);
            return;
        }
        int precision = MCurrency.getStdPrecision((Properties)order.getCtx(), (int)order.getC_Currency_ID());
        BigDecimal discountRateOff = PointOfSalesServiceImplementation.getDiscount(baseAmount, baseAmount.add(discountAmountOff), precision);
        if (maximumDiscountAllowed.compareTo(Env.ZERO) > 0 && discountRateOff.compareTo(maximumDiscountAllowed) > 0) {
            throw new AdempiereException("@POS.MaximumDiscountAllowedExceeded@");
        }
        this.createDiscountLine(pos, order, discountAmountOff, transactionName);
        order.set_ValueOfColumn("FlatDiscount", (Object)discountRateOff);
        order.saveEx(transactionName);
    }

    private void deleteDiscountLine(MPOS pos, MOrder order, String transactionName) {
        Optional<MOrderLine> maybeOrderLine = Arrays.asList(order.getLines()).stream().filter(ordeLine -> ordeLine.getC_Charge_ID() == pos.get_ValueAsInt("DefaultDiscountCharge_ID")).findFirst();
        maybeOrderLine.ifPresent(discountLine -> discountLine.deleteEx(true, transactionName));
    }

    private void createDiscountLine(MPOS pos, MOrder order, BigDecimal amount, String transactionName) {
        Optional<MOrderLine> maybeOrderLine = Arrays.asList(order.getLines()).stream().filter(ordeLine -> ordeLine.getC_Charge_ID() == pos.get_ValueAsInt("DefaultDiscountCharge_ID")).findFirst();
        MOrderLine discountOrderLine = null;
        if (maybeOrderLine.isPresent()) {
            discountOrderLine = maybeOrderLine.get();
            discountOrderLine.setQty(Env.ONE);
            discountOrderLine.setPrice(amount.negate());
        } else {
            discountOrderLine = new MOrderLine(order);
            discountOrderLine.setQty(Env.ONE);
            discountOrderLine.setC_Charge_ID(pos.get_ValueAsInt("DefaultDiscountCharge_ID"));
            discountOrderLine.setPrice(amount.negate());
        }
        discountOrderLine.saveEx(transactionName);
    }

    private void configurePriceList(MOrder order) {
        Arrays.asList(order.getLines()).forEach(orderLine -> {
            orderLine.setPrice();
            orderLine.setTax();
            orderLine.saveEx();
            if (Optional.ofNullable(orderLine.getPriceActual()).orElse(Env.ZERO).signum() == 0) {
                orderLine.deleteEx(true);
            }
        });
    }

    private Empty.Builder validatePIN(ValidatePINRequest request) {
        MPOS pos = this.getPOSFromUuid(request.getPosUuid(), false);
        if (Util.isEmpty((String)request.getPin())) {
            throw new AdempiereException("@UserPIN@ @IsMandatory@");
        }
        int supervisorId = pos.get_ValueAsInt("Supervisor_ID");
        MUser user = MUser.get((Properties)Env.getCtx(), (int)(supervisorId > 0 ? supervisorId : pos.getSalesRep_ID()));
        if (supervisorId <= 0) {
            supervisorId = user.getSupervisor_ID();
        }
        if (supervisorId > 0) {
            MUser supervisor = MUser.get((Properties)Env.getCtx(), (int)supervisorId);
            Optional<String> superVisorName = Optional.ofNullable(supervisor.getName());
            if (Util.isEmpty((String)supervisor.getUserPIN())) {
                throw new AdempiereException("@Supervisor@ \"" + superVisorName.orElseGet(() -> "") + "\": @UserPIN@ @NotFound@");
            }
            if (!request.getPin().equals(supervisor.getUserPIN())) {
                throw new AdempiereException("@Invalid@ @UserPIN@");
            }
        } else {
            boolean match = new Query(Env.getCtx(), "AD_User", "IsPOSManager = 'Y' AND UserPIN = ?", null).setParameters(new Object[]{String.valueOf(request.getPin())}).setClient_ID().setOnlyActiveRecords(true).match();
            if (!match) {
                throw new AdempiereException("@Invalid@ @UserPIN@");
            }
        }
        return Empty.newBuilder();
    }

    public MPriceListVersion loadPriceListVersion(int priceListId, Timestamp validFrom, String transactionName) {
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)priceListId, (String)transactionName);
        return priceList.getPriceListVersion(validFrom);
    }

    private Empty.Builder deleteOrderLine(DeleteOrderLineRequest request) {
        if (Util.isEmpty((String)request.getOrderLineUuid())) {
            throw new AdempiereException("@C_OrderLine_ID@ @NotFound@");
        }
        Trx.run(transactionName -> {
            MOrderLine orderLine = (MOrderLine)new Query(Env.getCtx(), "C_OrderLine", "UUID = ?", transactionName).setParameters(new Object[]{request.getOrderLineUuid()}).setClient_ID().first();
            if (orderLine != null && orderLine.getC_OrderLine_ID() != 0) {
                if (orderLine.isProcessed()) {
                    throw new AdempiereException("@C_OrderLine_ID@ @Processed@");
                }
                if (orderLine != null && orderLine.getC_Order_ID() >= 0) {
                    MOrder order = orderLine.getParent();
                    this.validateOrderReleased(order);
                    orderLine.deleteEx(true);
                    this.configureDiscountRateOff(order, (BigDecimal)order.get_Value("FlatDiscount"), transactionName);
                }
            }
        });
        return Empty.newBuilder();
    }

    private Empty.Builder deletePaymentReference(DeletePaymentReferenceRequest request) {
        if (Util.isEmpty((String)request.getUuid()) && request.getId() <= 0) {
            throw new AdempiereException("@C_POSPaymentReference_ID@ @IsMandatory@");
        }
        if (MTable.get((Properties)Env.getCtx(), (String)"C_POSPaymentReference") == null) {
            return Empty.newBuilder();
        }
        Trx.run(transactionName -> {
            PO refundReference = RecordUtil.getEntity(Env.getCtx(), "C_POSPaymentReference", request.getUuid(), request.getId(), transactionName);
            if (refundReference == null || refundReference.get_ID() == 0) {
                throw new AdempiereException("@C_POSPaymentReference_ID@ @NotFound@");
            }
            refundReference.deleteEx(true);
        });
        return Empty.newBuilder();
    }

    private Empty.Builder deleteOrder(DeleteOrderRequest request) {
        if (Util.isEmpty((String)request.getOrderUuid())) {
            throw new AdempiereException("@C_Order_ID@ @NotFound@");
        }
        int orderId = RecordUtil.getIdFromUuid("C_Order", request.getOrderUuid(), null);
        MOrder order = (MOrder)new Query(Env.getCtx(), "C_Order", "C_Order_ID = ?", null).setParameters(new Object[]{orderId}).setClient_ID().first();
        if (order == null || order.getC_Order_ID() == 0) {
            throw new AdempiereException("@C_Order_ID@ @NotFound@");
        }
        if (!DocumentUtil.isDrafted((DocAction)order)) {
            throw new AdempiereException("@C_Order_ID@ @Processed@");
        }
        if (order.isProcessed()) {
            throw new AdempiereException("@C_Order_ID@ @Processed@");
        }
        if (order != null && order.getC_Order_ID() >= 0) {
            this.validateOrderReleased(order);
            order.deleteEx(true);
        }
        return Empty.newBuilder();
    }

    private Empty.Builder deletePayment(DeletePaymentRequest request) {
        if (Util.isEmpty((String)request.getPaymentUuid())) {
            throw new AdempiereException("@C_Payment_ID@ @NotFound@");
        }
        int paymentId = RecordUtil.getIdFromUuid("C_Payment", request.getPaymentUuid(), null);
        MPayment payment = (MPayment)new Query(Env.getCtx(), "C_Payment", "C_Payment_ID = ?", null).setParameters(new Object[]{paymentId}).setClient_ID().first();
        if (payment == null || payment.getC_Payment_ID() == 0) {
            return Empty.newBuilder();
        }
        if (!DocumentUtil.isDrafted((DocAction)payment)) {
            throw new AdempiereException("@C_Payment_ID@ @Processed@");
        }
        if (payment.isProcessed()) {
            throw new AdempiereException("@C_Payment_ID@ @Processed@");
        }
        if (payment != null && payment.getC_Payment_ID() >= 0) {
            if (payment.getC_Order_ID() > 0) {
                MOrder salesOrder = new MOrder(Env.getCtx(), payment.getC_Order_ID(), null);
                this.validateOrderReleased(salesOrder);
            }
            payment.deleteEx(true);
        }
        return Empty.newBuilder();
    }

    private OrderLine.Builder updateAndConvertOrderLine(UpdateOrderLineRequest request) {
        if (Util.isEmpty((String)request.getOrderLineUuid())) {
            throw new AdempiereException("@C_OrderLine_ID@ @NotFound@");
        }
        int orderLineId = RecordUtil.getIdFromUuid("C_OrderLine", request.getOrderLineUuid(), null);
        if (orderLineId <= 0) {
            return OrderLine.newBuilder();
        }
        return ConvertUtil.convertOrderLine(this.updateOrderLine(orderLineId, ValueUtil.getBigDecimalFromDecimal(request.getQuantity()), ValueUtil.getBigDecimalFromDecimal(request.getPrice()), ValueUtil.getBigDecimalFromDecimal(request.getDiscountRate()), request.getIsAddQuantity(), RecordUtil.getIdFromUuid("M_Warehouse", request.getWarehouseUuid(), null)));
    }

    private OrderLine.Builder createAndConvertOrderLine(CreateOrderLineRequest request) {
        if (Util.isEmpty((String)request.getOrderUuid())) {
            throw new AdempiereException("@C_Order_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)request.getProductUuid()) && Util.isEmpty((String)request.getChargeUuid())) {
            throw new AdempiereException("@M_Product_ID@ / @C_Charge_ID@ @NotFound@");
        }
        int orderId = RecordUtil.getIdFromUuid("C_Order", request.getOrderUuid(), null);
        if (orderId <= 0) {
            return OrderLine.newBuilder();
        }
        return ConvertUtil.convertOrderLine(this.addOrderLine(orderId, RecordUtil.getIdFromUuid("M_Product", request.getProductUuid(), null), RecordUtil.getIdFromUuid("C_Charge", request.getChargeUuid(), null), RecordUtil.getIdFromUuid("M_Warehouse", request.getWarehouseUuid(), null), ValueUtil.getBigDecimalFromDecimal(request.getQuantity())));
    }

    private MOrderLine addOrderLine(int orderId, int productId, int chargeId, int warehouseId, BigDecimal quantity) {
        if (orderId <= 0) {
            return null;
        }
        AtomicReference orderLineReference = new AtomicReference();
        Trx.run(transactionName -> {
            MOrder order = new MOrder(Env.getCtx(), orderId, transactionName);
            if (!DocumentUtil.isDrafted((DocAction)order)) {
                throw new AdempiereException("@C_Order_ID@ @Processed@");
            }
            this.setCurrentDate(order);
            Optional<MOrderLine> maybeOrderLine = Arrays.asList(order.getLines(true, "Line")).stream().filter(orderLine -> productId != 0 && productId == orderLine.getM_Product_ID() || chargeId != 0 && chargeId == orderLine.getC_Charge_ID()).findFirst();
            if (maybeOrderLine.isPresent()) {
                MOrderLine orderLine2 = maybeOrderLine.get();
                BigDecimal currentPrice = orderLine2.getPriceEntered();
                BigDecimal quantityToOrder = quantity;
                if (quantity == null) {
                    quantityToOrder = orderLine2.getQtyOrdered();
                    quantityToOrder = quantityToOrder.add(Env.ONE);
                }
                orderLine2.setQty(quantityToOrder);
                orderLine2.setPrice(currentPrice);
                orderLine2.saveEx(transactionName);
                orderLineReference.set(orderLine2);
            } else {
                BigDecimal quantityToOrder = quantity;
                if (quantity == null) {
                    quantityToOrder = Env.ONE;
                }
                MOrderLine orderLine3 = new MOrderLine(order);
                if (chargeId > 0) {
                    orderLine3.setC_Charge_ID(chargeId);
                } else if (productId > 0) {
                    orderLine3.setProduct(MProduct.get((Properties)order.getCtx(), (int)productId));
                }
                orderLine3.setQty(quantityToOrder);
                orderLine3.setPrice();
                orderLine3.saveEx(transactionName);
                this.configureDiscountRateOff(order, (BigDecimal)order.get_Value("FlatDiscount"), transactionName);
                orderLineReference.set(orderLine3);
            }
        });
        return (MOrderLine)orderLineReference.get();
    }

    private void validateOrderReleased(MOrder salesOrder) {
        if (salesOrder.get_ValueAsInt("AssignedSalesRep_ID") > 0 && salesOrder.get_ValueAsInt("AssignedSalesRep_ID") != Env.getAD_User_ID((Properties)Env.getCtx())) {
            throw new AdempiereException("@POS.SalesRepAssigned@");
        }
    }

    private MOrderLine updateOrderLine(int orderLineId, BigDecimal quantity, BigDecimal price, BigDecimal discountRate, boolean isAddQuantity, int warehouseId) {
        if (orderLineId <= 0) {
            return null;
        }
        AtomicReference maybeOrderLine = new AtomicReference();
        Trx.run(transactionName -> {
            MOrderLine orderLine = new MOrderLine(Env.getCtx(), orderLineId, transactionName);
            MOrder order = orderLine.getParent();
            this.validateOrderReleased(order);
            this.setCurrentDate(order);
            orderLine.setHeaderInfo(order);
            if (!DocumentUtil.isDrafted((DocAction)order)) {
                throw new AdempiereException("@C_Order_ID@ @IsDrafted@");
            }
            BigDecimal quantityToOrder = quantity;
            if (quantity == null || quantity.equals(Env.ZERO)) {
                quantityToOrder = orderLine.getQtyEntered();
            } else if (isAddQuantity) {
                BigDecimal currentQuantity = orderLine.getQtyEntered();
                if (currentQuantity == null) {
                    currentQuantity = Env.ZERO;
                }
                quantityToOrder = currentQuantity.add(quantity);
            }
            BigDecimal priceToOrder = price;
            if (price == null || price.equals(Env.ZERO)) {
                BigDecimal discountAmount = orderLine.getPriceList().multiply(Optional.ofNullable(discountRate).orElse(Env.ZERO).divide(Env.ONEHUNDRED));
                priceToOrder = orderLine.getPriceList().subtract(discountAmount);
            }
            if (warehouseId > 0) {
                orderLine.setM_Warehouse_ID(warehouseId);
            }
            orderLine.setPrice(priceToOrder);
            orderLine.setQty(quantityToOrder);
            orderLine.setTax();
            orderLine.saveEx();
            this.configureDiscountRateOff(order, (BigDecimal)order.get_Value("FlatDiscount"), transactionName);
            maybeOrderLine.set(orderLine);
        });
        return (MOrderLine)maybeOrderLine.get();
    }

    private ListPointOfSalesResponse.Builder convertPointOfSalesList(ListPointOfSalesRequest request) {
        ListPointOfSalesResponse.Builder builder = ListPointOfSalesResponse.newBuilder();
        if (Util.isEmpty((String)request.getUserUuid())) {
            throw new AdempiereException("@SalesRep_ID@ @NotFound@");
        }
        productCache.clear();
        int salesRepresentativeId = RecordUtil.getIdFromUuid("AD_User", request.getUserUuid(), null);
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        boolean isAppliedNewFeaturesPOS = M_Element.get((Properties)Env.getCtx(), (String)"IsSharedPOS") != null && M_Element.get((Properties)Env.getCtx(), (String)"IsAllowsAllocateSeller") != null;
        StringBuffer whereClause = new StringBuffer("SalesRep_ID = ? OR EXISTS(SELECT 1 FROM AD_User u WHERE u.AD_User_ID = ? AND IsPOSManager = 'Y')");
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        parameters.add(salesRepresentativeId);
        parameters.add(salesRepresentativeId);
        if (isAppliedNewFeaturesPOS) {
            whereClause.append(" OR (AD_Org_ID = ? AND IsSharedPOS = 'Y' AND IsAllowsAllocateSeller = 'N')");
            whereClause.append(" OR (IsAllowsAllocateSeller = 'Y' AND EXISTS(SELECT 1 FROM C_POSSellerAllocation sa WHERE sa.C_POS_ID = C_POS.C_POS_ID AND sa.SalesRep_ID = ? AND sa.IsActive = 'Y'))");
            parameters.add(Env.getAD_Org_ID((Properties)Env.getCtx()));
            parameters.add(salesRepresentativeId);
        }
        Query query = new Query(Env.getCtx(), "C_POS", whereClause.toString(), null).setClient_ID().setOnlyActiveRecords(true).setParameters(parameters).setOrderBy("Name");
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(pos -> builder.addSellingPoints(this.convertPointOfSales((MPOS)pos)));
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private PointOfSales.Builder getPosBuilder(PointOfSalesRequest request) {
        return this.convertPointOfSales(this.getPOSFromUuid(request.getPosUuid(), true));
    }

    private MPOS getPOSFromUuid(String uuid, boolean requery) {
        int posId = RecordUtil.getIdFromUuid("C_POS", uuid, null);
        if (posId <= 0) {
            throw new AdempiereException("@C_POS_ID@ @NotFound@");
        }
        if (requery) {
            return new MPOS(Env.getCtx(), posId, null);
        }
        return MPOS.get((Properties)Env.getCtx(), (int)posId);
    }

    private PointOfSales.Builder convertPointOfSales(MPOS pos) {
        PointOfSales.Builder builder = PointOfSales.newBuilder().setUuid(ValueUtil.validateNull(pos.getUUID())).setId(pos.getC_POS_ID()).setName(ValueUtil.validateNull(pos.getName())).setDescription(ValueUtil.validateNull(pos.getDescription())).setHelp(ValueUtil.validateNull(pos.getHelp())).setIsModifyPrice(pos.isModifyPrice()).setIsPosRequiredPin(pos.isPOSRequiredPIN()).setSalesRepresentative(ConvertUtil.convertSalesRepresentative(MUser.get((Properties)pos.getCtx(), (int)pos.getSalesRep_ID()))).setTemplateCustomer(ConvertUtil.convertCustomer(pos.getBPartner())).setKeyLayoutUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_POSKeyLayout", pos.getC_POSKeyLayout_ID()))).setIsAisleSeller(pos.get_ValueAsBoolean("IsAisleSeller")).setIsSharedPos(pos.get_ValueAsBoolean("IsSharedPOS")).setConversionTypeUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_ConversionType", pos.get_ValueAsInt("C_ConversionType_ID"))));
        builder.setDefaultCampaignUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_Campaign", pos.get_ValueAsInt("DefaultCampaign_ID")))).setMaximumRefundAllowed(ValueUtil.getDecimalFromBigDecimal((BigDecimal)pos.get_Value("MaximumRefundAllowed"))).setMaximumDailyRefundAllowed(ValueUtil.getDecimalFromBigDecimal((BigDecimal)pos.get_Value("MaximumDailyRefundAllowed"))).setMaximumDiscountAllowed(ValueUtil.getDecimalFromBigDecimal((BigDecimal)pos.get_Value("MaximumDiscountAllowed"))).setWriteOffAmountTolerance(ValueUtil.getDecimalFromBigDecimal((BigDecimal)pos.get_Value("WriteOffAmtTolerance")));
        if (!pos.get_ValueAsBoolean("IsAllowsAllocateSeller")) {
            builder.setIsAllowsModifyQuantity(pos.get_ValueAsBoolean("IsAllowsModifyQuantity")).setIsAllowsReturnOrder(pos.get_ValueAsBoolean("IsAllowsReturnOrder")).setIsAllowsCollectOrder(pos.get_ValueAsBoolean("IsAllowsCollectOrder")).setIsAllowsCreateOrder(pos.get_ValueAsBoolean("IsAllowsCreateOrder")).setIsDisplayTaxAmount(pos.get_ValueAsBoolean("IsDisplayTaxAmount")).setIsDisplayDiscount(pos.get_ValueAsBoolean("IsDisplayDiscount")).setIsAllowsConfirmShipment(pos.get_ValueAsBoolean("IsAllowsConfirmShipment")).setIsConfirmCompleteShipment(pos.get_ValueAsBoolean("IsConfirmCompleteShipment")).setIsAllowsAllocateSeller(pos.get_ValueAsBoolean("IsAllowsAllocateSeller")).setIsAllowsConcurrentUse(pos.get_ValueAsBoolean("IsAllowsConcurrentUse")).setIsAllowsCashOpening(pos.get_ValueAsBoolean("IsAllowsCashOpening")).setIsAllowsCashClosing(pos.get_ValueAsBoolean("IsAllowsCashClosing")).setIsAllowsCashWithdrawal(pos.get_ValueAsBoolean("IsAllowsCashWithdrawal")).setIsAllowsApplyDiscount(pos.get_ValueAsBoolean("IsAllowsApplyDiscount"));
        } else {
            PO userAllocated = PointOfSalesServiceImplementation.getUserAllowed(pos.getCtx(), pos.getC_POS_ID(), Env.getAD_User_ID((Properties)pos.getCtx()), null);
            if (userAllocated != null && userAllocated.get_ID() > 0) {
                builder.setIsAllowsModifyQuantity(userAllocated.get_ValueAsBoolean("IsAllowsModifyQuantity")).setIsAllowsReturnOrder(userAllocated.get_ValueAsBoolean("IsAllowsReturnOrder")).setIsAllowsCollectOrder(userAllocated.get_ValueAsBoolean("IsAllowsCollectOrder")).setIsAllowsCreateOrder(userAllocated.get_ValueAsBoolean("IsAllowsCreateOrder")).setIsDisplayTaxAmount(userAllocated.get_ValueAsBoolean("IsDisplayTaxAmount")).setIsDisplayDiscount(userAllocated.get_ValueAsBoolean("IsDisplayDiscount")).setIsAllowsConfirmShipment(userAllocated.get_ValueAsBoolean("IsAllowsConfirmShipment")).setIsConfirmCompleteShipment(userAllocated.get_ValueAsBoolean("IsConfirmCompleteShipment")).setIsAllowsAllocateSeller(userAllocated.get_ValueAsBoolean("IsAllowsAllocateSeller")).setIsAllowsConcurrentUse(userAllocated.get_ValueAsBoolean("IsAllowsConcurrentUse")).setIsAllowsCashOpening(userAllocated.get_ValueAsBoolean("IsAllowsCashOpening")).setIsAllowsCashClosing(userAllocated.get_ValueAsBoolean("IsAllowsCashClosing")).setIsAllowsCashWithdrawal(userAllocated.get_ValueAsBoolean("IsAllowsCashWithdrawal")).setIsAllowsApplyDiscount(userAllocated.get_ValueAsBoolean("IsAllowsApplyDiscount"));
                if (userAllocated.get_Value("MaximumRefundAllowed") != null) {
                    builder.setMaximumRefundAllowed(ValueUtil.getDecimalFromBigDecimal((BigDecimal)userAllocated.get_Value("MaximumRefundAllowed")));
                }
                if (userAllocated.get_Value("MaximumDailyRefundAllowed") != null) {
                    builder.setMaximumDailyRefundAllowed(ValueUtil.getDecimalFromBigDecimal((BigDecimal)userAllocated.get_Value("MaximumDailyRefundAllowed")));
                }
                if (userAllocated.get_Value("MaximumDiscountAllowed") != null) {
                    builder.setMaximumDiscountAllowed(ValueUtil.getDecimalFromBigDecimal((BigDecimal)userAllocated.get_Value("MaximumDiscountAllowed")));
                }
                if (userAllocated.get_Value("WriteOffAmtTolerance") != null) {
                    builder.setWriteOffAmountTolerance(ValueUtil.getDecimalFromBigDecimal((BigDecimal)userAllocated.get_Value("WriteOffAmtTolerance")));
                }
            }
        }
        if (pos.get_ValueAsInt("RefundReferenceCurrency_ID") > 0) {
            builder.setRefundReferenceCurrency(ConvertUtil.convertCurrency(MCurrency.get((Properties)Env.getCtx(), (int)pos.get_ValueAsInt("RefundReferenceCurrency_ID"))));
        }
        if (pos.getM_PriceList_ID() != 0) {
            MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)pos.getM_PriceList_ID(), null);
            builder.setPriceList(ConvertUtil.convertPriceList(priceList));
        }
        if (pos.getC_BankAccount_ID() != 0) {
            MBankAccount cashAccount = MBankAccount.get((Properties)Env.getCtx(), (int)pos.getC_BankAccount_ID());
            builder.setDefaultOpeningChargeUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_Charge", cashAccount.get_ValueAsInt("DefaultOpeningCharge_ID")))).setDefaultWithdrawalChargeUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_Charge", cashAccount.get_ValueAsInt("DefaultWithdrawalCharge_ID")))).setCashBankAccount(ConvertUtil.convertBankAccount(cashAccount));
        }
        if (pos.getCashTransferBankAccount_ID() != 0) {
            builder.setCashBankAccount(ConvertUtil.convertBankAccount(MBankAccount.get((Properties)Env.getCtx(), (int)pos.getCashTransferBankAccount_ID())));
        }
        if (pos.getM_Warehouse_ID() > 0) {
            MWarehouse warehouse = MWarehouse.get((Properties)Env.getCtx(), (int)pos.getM_Warehouse_ID());
            builder.setWarehouse(ConvertUtil.convertWarehouse(warehouse));
        }
        if (pos.get_ValueAsInt("DisplayCurrency_ID") > 0) {
            MCurrency displayCurency = MCurrency.get((Properties)Env.getCtx(), (int)pos.get_ValueAsInt("DisplayCurrency_ID"));
            builder.setDisplayCurrency(ConvertUtil.convertCurrency(displayCurency));
        }
        if (pos.getC_DocType_ID() > 0) {
            builder.setDocumentType(ConvertUtil.convertDocumentType(MDocType.get((Properties)Env.getCtx(), (int)pos.getC_DocType_ID())));
        }
        if (pos.get_ValueAsInt("C_DocTypeRMA_ID") > 0) {
            builder.setReturnDocumentType(ConvertUtil.convertDocumentType(MDocType.get((Properties)Env.getCtx(), (int)pos.get_ValueAsInt("C_DocTypeRMA_ID"))));
        }
        return builder;
    }

    public static PO getUserAllowed(Properties context, int posId, int userId, String transactionName) {
        return new Query(context, "C_POSSellerAllocation", "C_POS_ID = ?  AND SalesRep_ID = ?", transactionName).setParameters(new Object[]{posId, userId}).setOnlyActiveRecords(true).setClient_ID().first();
    }

    private Order.Builder createOrder(CreateOrderRequest request) {
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getSalesRepresentativeUuid())) {
            throw new AdempiereException("@SalesRep_ID@ @IsMandatory@");
        }
        AtomicReference maybeOrder = new AtomicReference();
        Trx.run(transactionName -> {
            int campaignId;
            MOrder salesOrder;
            MPOS pos = this.getPOSFromUuid(request.getPosUuid(), true);
            StringBuffer whereClause = new StringBuffer("DocStatus = 'DR' AND C_POS_ID = ? AND NOT EXISTS(SELECT 1 \t\t\t\t\tFROM C_OrderLine ol \t\t\t\t\tWHERE ol.C_Order_ID = C_Order.C_Order_ID)");
            ArrayList<Integer> parameters = new ArrayList<Integer>();
            parameters.add(pos.getC_POS_ID());
            if (pos.get_ValueAsBoolean("IsSharedPOS")) {
                whereClause.append(" AND SalesRep_ID = ?");
                parameters.add(RecordUtil.getIdFromUuid("AD_User", request.getSalesRepresentativeUuid(), transactionName));
            }
            if ((salesOrder = (MOrder)new Query(Env.getCtx(), "C_Order", whereClause.toString(), transactionName).setParameters(parameters).first()) == null) {
                salesOrder = new MOrder(Env.getCtx(), 0, transactionName);
            } else {
                salesOrder.setDateOrdered(RecordUtil.getDate());
                salesOrder.setDateAcct(RecordUtil.getDate());
                salesOrder.setDatePromised(RecordUtil.getDate());
            }
            salesOrder.setIsSOTrx(true);
            salesOrder.setAD_Org_ID(pos.getAD_Org_ID());
            salesOrder.setC_POS_ID(pos.getC_POS_ID());
            int warehouseId = pos.getM_Warehouse_ID();
            int priceListId = pos.getM_PriceList_ID();
            if (!Util.isEmpty((String)request.getWarehouseUuid())) {
                warehouseId = RecordUtil.getIdFromUuid("M_Warehouse", request.getWarehouseUuid(), transactionName);
            }
            if (warehouseId < 0) {
                warehouseId = pos.getM_Warehouse_ID();
            }
            if (!Util.isEmpty((String)request.getPriceListUuid())) {
                priceListId = RecordUtil.getIdFromUuid("M_PriceList", request.getPriceListUuid(), transactionName);
            }
            if (priceListId < 0) {
                priceListId = pos.getM_Warehouse_ID();
            }
            salesOrder.setM_PriceList_ID(priceListId);
            salesOrder.setM_Warehouse_ID(warehouseId);
            int documentTypeId = 0;
            if (!Util.isEmpty((String)request.getDocumentTypeUuid())) {
                documentTypeId = RecordUtil.getIdFromUuid("C_DocType", request.getDocumentTypeUuid(), transactionName);
            }
            if (documentTypeId <= 0 && pos.getC_DocType_ID() != 0) {
                documentTypeId = pos.getC_DocType_ID();
            }
            if (documentTypeId > 0) {
                salesOrder.setC_DocTypeTarget_ID(documentTypeId);
            } else {
                salesOrder.setC_DocTypeTarget_ID("WR");
            }
            if (pos.getDeliveryRule() != null) {
                salesOrder.setDeliveryRule(pos.getDeliveryRule());
            }
            if (pos.getInvoiceRule() != null) {
                salesOrder.setInvoiceRule(pos.getInvoiceRule());
            }
            if (pos.get_ValueAsInt("C_ConversionType_ID") > 0) {
                salesOrder.setC_ConversionType_ID(pos.get_ValueAsInt("C_ConversionType_ID"));
            }
            if ((campaignId = RecordUtil.getIdFromUuid("C_Campaign", request.getCampaignUuid(), transactionName)) > 0 && campaignId != salesOrder.getC_Campaign_ID()) {
                salesOrder.setC_Campaign_ID(campaignId);
            }
            this.setBPartner(pos, salesOrder, request.getCustomerUuid(), request.getSalesRepresentativeUuid(), transactionName);
            maybeOrder.set(salesOrder);
        });
        return ConvertUtil.convertOrder((MOrder)maybeOrder.get());
    }

    private void setCurrentDate(MOrder salesOrder) {
        if (!salesOrder.getDateOrdered().equals(RecordUtil.getDate()) || !salesOrder.getDateAcct().equals(RecordUtil.getDate())) {
            salesOrder.setDateOrdered(RecordUtil.getDate());
            salesOrder.setDateAcct(RecordUtil.getDate());
            salesOrder.saveEx();
        }
    }

    private void setCurrentDate(MPayment payment) {
        if (!payment.getDateTrx().equals(RecordUtil.getDate())) {
            payment.setDateTrx(RecordUtil.getDate());
            payment.saveEx();
        }
    }

    private void setBPartner(MPOS pos, MOrder salesOrder, String businessPartnerUuid, String salesRepresentativeUuid, String transactionName) {
        int salesRepresentativeId;
        MPriceList partnerLocations;
        int businessPartnerId;
        if (DocumentUtil.isCompleted((DocAction)salesOrder) || DocumentUtil.isVoided((DocAction)salesOrder)) {
            return;
        }
        MBPartner businessPartner = null;
        if (!Util.isEmpty((String)businessPartnerUuid) && (businessPartnerId = RecordUtil.getIdFromUuid("C_BPartner", businessPartnerUuid, transactionName)) > 0) {
            businessPartner = MBPartner.get((Properties)Env.getCtx(), (int)businessPartnerId);
        }
        boolean isSamePOSPartner = false;
        if (businessPartner == null) {
            businessPartner = pos.getBPartner();
            isSamePOSPartner = true;
        }
        if (businessPartner == null) {
            throw new AdempiereException("@C_BPartner_ID@ @NotFound@");
        }
        int businessPartnerId2 = businessPartner.getC_BPartner_ID();
        this.log.fine("CPOS.setC_BPartner_ID=" + businessPartner.getC_BPartner_ID());
        businessPartner.set_TrxName(transactionName);
        salesOrder.setBPartner(businessPartner);
        if (businessPartner.getM_PriceList_ID() > 0) {
            MPriceList businesPartnerPriceList = MPriceList.get((Properties)salesOrder.getCtx(), (int)businessPartner.getM_PriceList_ID(), (String)transactionName);
            MPriceList currentPriceList = MPriceList.get((Properties)salesOrder.getCtx(), (int)pos.getM_PriceList_ID(), (String)transactionName);
            if (currentPriceList.getC_Currency_ID() != businesPartnerPriceList.getC_Currency_ID()) {
                salesOrder.setM_PriceList_ID(currentPriceList.getM_PriceList_ID());
            }
        }
        if (((MBPartnerLocation[])(partnerLocations = businessPartner.getLocations(true))).length > 0) {
            for (MPriceList partnerLocation : partnerLocations) {
                if (partnerLocation.isBillTo()) {
                    salesOrder.setBill_Location_ID(partnerLocation.getC_BPartner_Location_ID());
                }
                if (!partnerLocation.isShipTo()) continue;
                salesOrder.setShip_Location_ID(partnerLocation.getC_BPartner_Location_ID());
            }
        }
        if (isSamePOSPartner && salesOrder.getPaymentRule() == null) {
            salesOrder.setPaymentRule("B");
        }
        if ((salesRepresentativeId = RecordUtil.getIdFromUuid("AD_User", salesRepresentativeUuid, transactionName)) <= 0) {
            MUser currentUser = MUser.get((Properties)salesOrder.getCtx());
            salesRepresentativeId = pos.get_ValueAsBoolean("IsSharedPOS") || currentUser.get_ValueAsBoolean("IsPOSManager") ? currentUser.getAD_User_ID() : (businessPartner.getSalesRep_ID() != 0 ? salesOrder.getC_BPartner().getSalesRep_ID() : pos.getSalesRep_ID());
        }
        if (salesRepresentativeId > 0) {
            salesOrder.setSalesRep_ID(salesRepresentativeId);
            if (salesOrder.get_ValueAsInt("AssignedSalesRep_ID") <= 0) {
                salesOrder.set_ValueOfColumn("AssignedSalesRep_ID", (Object)salesRepresentativeId);
            }
        }
        this.setCurrentDate(salesOrder);
        salesOrder.saveEx();
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)salesOrder.getM_PriceList_ID(), (String)transactionName);
        MPriceListVersion priceListVersion = priceList.getPriceListVersion(RecordUtil.getDate());
        List<MProductPrice> productPrices = Arrays.asList(priceListVersion.getProductPrice("AND EXISTS(SELECT 1 FROM C_OrderLine ol WHERE ol.C_Order_ID = " + salesOrder.getC_Order_ID() + " AND ol.M_Product_ID = M_ProductPrice.M_Product_ID)"));
        Arrays.asList(salesOrder.getLines()).forEach(orderLine -> {
            if (productPrices.stream().filter(productPrice -> productPrice.getM_Product_ID() == orderLine.getM_Product_ID()).findFirst().isPresent()) {
                orderLine.setC_BPartner_ID(businessPartnerId2);
                orderLine.setC_BPartner_Location_ID(salesOrder.getC_BPartner_Location_ID());
                orderLine.setPrice();
                orderLine.setTax();
                orderLine.saveEx();
            } else {
                orderLine.deleteEx(true);
            }
        });
    }

    private MPayment updatePayment(UpdatePaymentRequest request) {
        AtomicReference maybePayment = new AtomicReference();
        Trx.run(transactionName -> {
            Timestamp date;
            String tenderType = request.getTenderTypeCode();
            int paymentId = RecordUtil.getIdFromUuid("C_Payment", request.getPaymentUuid(), transactionName);
            if (paymentId <= 0) {
                throw new AdempiereException("@C_Payment_ID@ @NotFound@");
            }
            MPayment payment = new MPayment(Env.getCtx(), paymentId, transactionName);
            if (!DocumentUtil.isDrafted((DocAction)payment)) {
                throw new AdempiereException("@C_Payment_ID@ @Processed@");
            }
            if (payment.getC_Order_ID() > 0) {
                MOrder salesOrder = new MOrder(Env.getCtx(), payment.getC_Order_ID(), transactionName);
                this.validateOrderReleased(salesOrder);
            }
            if (!Util.isEmpty((String)tenderType)) {
                payment.setTenderType(tenderType);
            }
            if (!Util.isEmpty((String)request.getPaymentDate()) && (date = ValueUtil.getDateFromString(request.getPaymentDate())) != null) {
                payment.setDateTrx(date);
            }
            if (!Util.isEmpty((String)request.getPaymentAccountDate()) && (date = ValueUtil.getDateFromString(request.getPaymentAccountDate())) != null) {
                payment.setDateAcct(date);
            }
            if (!Util.isEmpty((String)request.getBankUuid())) {
                int bankId = RecordUtil.getIdFromUuid("C_Bank", request.getBankUuid(), transactionName);
                payment.set_ValueOfColumn("C_Bank_ID", (Object)bankId);
            }
            if (!Util.isEmpty((String)request.getReferenceNo())) {
                payment.addDescription(request.getReferenceNo());
            }
            if (!Util.isEmpty((String)request.getDescription())) {
                payment.addDescription(request.getDescription());
            }
            BigDecimal paymentAmount = ValueUtil.getBigDecimalFromDecimal(request.getAmount());
            payment.setPayAmt(paymentAmount);
            payment.setOverUnderAmt(Env.ZERO);
            this.setCurrentDate(payment);
            payment.saveEx(transactionName);
            maybePayment.set(payment);
        });
        return (MPayment)maybePayment.get();
    }

    private MPayment createPaymentFromOrder(MOrder salesOrder, CreatePaymentRequest request, MPOS pointOfSalesDefinition, String transactionName) {
        int paymentMethodId;
        Timestamp date;
        this.validateOrderReleased(salesOrder);
        this.setCurrentDate(salesOrder);
        String tenderType = request.getTenderTypeCode();
        if (Util.isEmpty((String)tenderType)) {
            tenderType = "X";
        }
        if (pointOfSalesDefinition.getC_BankAccount_ID() <= 0) {
            throw new AdempiereException("@NoCashBook@");
        }
        if (request.getAmount() == null) {
            throw new AdempiereException("@PayAmt@ @NotFound@");
        }
        int currencyId = RecordUtil.getIdFromUuid("C_Currency", request.getCurrencyUuid(), transactionName);
        if (currencyId <= 0) {
            currencyId = salesOrder.getC_Currency_ID();
        }
        MPayment payment = new MPayment(Env.getCtx(), 0, transactionName);
        payment.setC_BankAccount_ID(pointOfSalesDefinition.getC_BankAccount_ID());
        int documentTypeId = !request.getIsRefund() ? pointOfSalesDefinition.get_ValueAsInt("POSCollectingDocumentType_ID") : pointOfSalesDefinition.get_ValueAsInt("POSRefundDocumentType_ID");
        if (documentTypeId > 0) {
            payment.setC_DocType_ID(documentTypeId);
        } else {
            payment.setC_DocType_ID(!request.getIsRefund());
        }
        payment.setAD_Org_ID(salesOrder.getAD_Org_ID());
        String value = DB.getDocumentNo((int)payment.getC_DocType_ID(), (String)transactionName, (boolean)false, (PO)payment);
        payment.setDocumentNo(value);
        if (!Util.isEmpty((String)request.getPaymentAccountDate()) && (date = ValueUtil.getDateFromString(request.getPaymentAccountDate())) != null) {
            payment.setDateAcct(date);
        }
        payment.setTenderType(tenderType);
        payment.setDescription(Optional.ofNullable(request.getDescription()).orElse(salesOrder.getDescription()));
        payment.setC_BPartner_ID(salesOrder.getC_BPartner_ID());
        payment.setC_Currency_ID(currencyId);
        payment.setC_POS_ID(pointOfSalesDefinition.getC_POS_ID());
        if (salesOrder.getSalesRep_ID() > 0) {
            payment.set_ValueOfColumn("CollectingAgent_ID", (Object)salesOrder.getSalesRep_ID());
        }
        if (pointOfSalesDefinition.get_ValueAsInt("C_ConversionType_ID") > 0) {
            payment.setC_ConversionType_ID(pointOfSalesDefinition.get_ValueAsInt("C_ConversionType_ID"));
        }
        BigDecimal paymentAmount = ValueUtil.getBigDecimalFromDecimal(request.getAmount());
        payment.setPayAmt(paymentAmount);
        payment.setC_Order_ID(salesOrder.getC_Order_ID());
        payment.setDocStatus("DR");
        if (!Util.isEmpty((String)request.getDescription())) {
            payment.setDescription(request.getDescription());
        } else {
            int invoiceId = salesOrder.getC_Invoice_ID();
            if (invoiceId > 0) {
                MInvoice invoice = new MInvoice(Env.getCtx(), payment.getC_Invoice_ID(), transactionName);
                payment.setDescription(Msg.getMsg((Properties)Env.getCtx(), (String)"Invoice No ") + invoice.getDocumentNo());
            } else {
                payment.setDescription(Msg.getMsg((Properties)Env.getCtx(), (String)"Order No ") + salesOrder.getDocumentNo());
            }
        }
        switch (tenderType) {
            case "K": {
                payment.setCheckNo(request.getReferenceNo());
                break;
            }
            case "D": {
                break;
            }
            case "C": {
                break;
            }
            case "P": {
                payment.setR_PnRef(request.getReferenceNo());
                break;
            }
            case "Z": {
                payment.setR_PnRef(request.getReferenceNo());
                break;
            }
            case "M": {
                payment.setR_PnRef(request.getReferenceNo());
                payment.setDocumentNo(request.getReferenceNo());
                payment.setCheckNo(request.getReferenceNo());
                break;
            }
            default: {
                payment.setDescription(request.getDescription());
            }
        }
        if (!Util.isEmpty((String)request.getPaymentMethodUuid()) && (paymentMethodId = RecordUtil.getIdFromUuid("C_PaymentMethod", request.getPaymentMethodUuid(), transactionName)) > 0) {
            payment.set_ValueOfColumn("C_PaymentMethod_ID", (Object)paymentMethodId);
        }
        if (!Util.isEmpty((String)request.getBankUuid())) {
            int bankId = RecordUtil.getIdFromUuid("C_Bank", request.getBankUuid(), transactionName);
            payment.set_ValueOfColumn("C_Bank_ID", (Object)bankId);
        }
        if (!Util.isEmpty((String)request.getReferenceNo())) {
            payment.setDocumentNo(request.getReferenceNo());
            payment.addDescription(request.getReferenceNo());
        }
        this.setCurrentDate(payment);
        payment.saveEx(transactionName);
        return payment;
    }

    private MPayment createPaymentFromCharge(int defaultChargeId, CreatePaymentRequest request, MPOS pointOfSalesDefinition, String transactionName) {
        MPayment payment = null;
        String tenderType = request.getTenderTypeCode();
        if (Util.isEmpty((String)tenderType)) {
            tenderType = "X";
        }
        if (pointOfSalesDefinition.getC_BankAccount_ID() <= 0) {
            throw new AdempiereException("@NoCashBook@");
        }
        MBankAccount cashAccount = MBankAccount.get((Properties)Env.getCtx(), (int)pointOfSalesDefinition.getC_BankAccount_ID());
        if (cashAccount.getC_BPartner_ID() <= 0) {
            throw new AdempiereException("@C_BankAccount_ID@ @C_BPartner_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)request.getUuid())) {
            int paymentMethodId;
            Timestamp date;
            if (request.getAmount() == null) {
                throw new AdempiereException("@PayAmt@ @NotFound@");
            }
            int currencyId = RecordUtil.getIdFromUuid("C_Currency", request.getCurrencyUuid(), transactionName);
            if (currencyId <= 0) {
                throw new AdempiereException("@C_Currency_ID@ @NotFound@");
            }
            payment = new MPayment(Env.getCtx(), 0, transactionName);
            payment.setC_BankAccount_ID(pointOfSalesDefinition.getC_BankAccount_ID());
            int documentTypeId = !request.getIsRefund() ? pointOfSalesDefinition.get_ValueAsInt("POSOpeningDocumentType_ID") : pointOfSalesDefinition.get_ValueAsInt("POSWithdrawalDocumentType_ID");
            if (documentTypeId > 0) {
                payment.setC_DocType_ID(documentTypeId);
            } else {
                payment.setC_DocType_ID(!request.getIsRefund());
            }
            payment.setAD_Org_ID(pointOfSalesDefinition.getAD_Org_ID());
            String value = DB.getDocumentNo((int)payment.getC_DocType_ID(), (String)transactionName, (boolean)false, (PO)payment);
            payment.setDocumentNo(value);
            if (!Util.isEmpty((String)request.getPaymentAccountDate()) && (date = ValueUtil.getDateFromString(request.getPaymentAccountDate())) != null) {
                payment.setDateAcct(date);
            }
            payment.setTenderType(tenderType);
            if (!Util.isEmpty((String)request.getDescription())) {
                payment.setDescription(request.getDescription());
            }
            payment.setC_BPartner_ID(cashAccount.getC_BPartner_ID());
            payment.setC_Currency_ID(currencyId);
            payment.setC_POS_ID(pointOfSalesDefinition.getC_POS_ID());
            if (!Util.isEmpty((String)request.getCollectingAgentUuid())) {
                payment.set_ValueOfColumn("CollectingAgent_ID", (Object)RecordUtil.getIdFromUuid("AD_User", request.getCollectingAgentUuid(), transactionName));
            }
            if (pointOfSalesDefinition.get_ValueAsInt("C_ConversionType_ID") > 0) {
                payment.setC_ConversionType_ID(pointOfSalesDefinition.get_ValueAsInt("C_ConversionType_ID"));
            }
            payment.setC_Charge_ID(defaultChargeId);
            BigDecimal paymentAmount = ValueUtil.getBigDecimalFromDecimal(request.getAmount());
            payment.setPayAmt(paymentAmount);
            payment.setDocStatus("DR");
            switch (tenderType) {
                case "K": {
                    payment.setCheckNo(request.getReferenceNo());
                    break;
                }
                case "D": {
                    break;
                }
                case "C": {
                    break;
                }
                case "P": {
                    payment.setR_PnRef(request.getReferenceNo());
                    break;
                }
                case "Z": {
                    payment.setR_PnRef(request.getReferenceNo());
                    break;
                }
                case "M": {
                    payment.setR_PnRef(request.getReferenceNo());
                    break;
                }
                default: {
                    payment.setDescription(request.getDescription());
                }
            }
            if (!Util.isEmpty((String)request.getPaymentMethodUuid()) && (paymentMethodId = RecordUtil.getIdFromUuid("C_PaymentMethod", request.getPaymentMethodUuid(), transactionName)) > 0) {
                payment.set_ValueOfColumn("C_PaymentMethod_ID", (Object)paymentMethodId);
            }
            if (!Util.isEmpty((String)request.getBankUuid())) {
                int bankId = RecordUtil.getIdFromUuid("C_Bank", request.getBankUuid(), transactionName);
                payment.set_ValueOfColumn("C_Bank_ID", (Object)bankId);
            }
            if (!Util.isEmpty((String)request.getReferenceNo())) {
                payment.setDocumentNo(request.getReferenceNo());
                payment.addDescription(request.getReferenceNo());
            }
            this.setCurrentDate(payment);
            payment.saveEx(transactionName);
        } else {
            int paymentId = RecordUtil.getIdFromUuid("C_Payment", request.getUuid(), transactionName);
            if (paymentId <= 0) {
                throw new AdempiereException("@C_Payment_ID@ @NotFound@");
            }
            payment = new MPayment(Env.getCtx(), paymentId, transactionName);
            if (!Util.isEmpty((String)request.getDescription())) {
                payment.setDescription(request.getDescription());
            }
            if (!Util.isEmpty((String)request.getCollectingAgentUuid())) {
                payment.set_ValueOfColumn("CollectAgent_ID", (Object)RecordUtil.getIdFromUuid("AD_User", request.getCollectingAgentUuid(), transactionName));
            }
        }
        return payment;
    }

    private MPayment createPayment(CreatePaymentRequest request) {
        AtomicReference maybePayment = new AtomicReference();
        Trx.run(transactionName -> {
            MPOS pos = this.getPOSFromUuid(request.getPosUuid(), true);
            if (!Util.isEmpty((String)request.getOrderUuid())) {
                MOrder salesOrder = this.getOrder(request.getOrderUuid(), transactionName);
                maybePayment.set(this.createPaymentFromOrder(salesOrder, request, pos, transactionName));
            } else if (!Util.isEmpty((String)request.getChargeUuid())) {
                maybePayment.set(this.createPaymentFromCharge(RecordUtil.getIdFromUuid("C_Charge", request.getChargeUuid(), transactionName), request, pos, transactionName));
            } else {
                throw new AdempiereException("@C_Charge_ID@ / @C_Order_ID@ @NotFound@");
            }
        });
        return (MPayment)maybePayment.get();
    }

    private ListProductPriceResponse.Builder getProductPriceList(ListProductPriceRequest request) {
        ListProductPriceResponse.Builder builder = ListProductPriceResponse.newBuilder();
        MPOS pos = this.getPOSFromUuid(request.getPosUuid(), true);
        int priceListId = pos.getM_PriceList_ID();
        if (!Util.isEmpty((String)request.getPriceListUuid())) {
            priceListId = RecordUtil.getIdFromUuid("M_PriceList", request.getPriceListUuid(), null);
        }
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)priceListId, null);
        AtomicReference<Timestamp> validFrom = new AtomicReference<Timestamp>();
        if (!Util.isEmpty((String)request.getValidFrom())) {
            validFrom.set(ValueUtil.convertStringToDate(request.getValidFrom()));
        } else {
            validFrom.set(TimeUtil.getDay((long)System.currentTimeMillis()));
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (!Util.isEmpty((String)request.getSearchValue())) {
            whereClause.append("IsSold = 'Y' AND (UPPER(Value) LIKE '%' || UPPER(?) || '%'OR UPPER(Name) LIKE '%' || UPPER(?) || '%'OR UPPER(UPC) = UPPER(?)OR UPPER(SKU) = UPPER(?))");
            parameters.add(request.getSearchValue());
            parameters.add(request.getSearchValue());
            parameters.add(request.getSearchValue());
            parameters.add(request.getSearchValue());
        }
        if (whereClause.length() > 0) {
            whereClause.append(" AND ");
        }
        whereClause.append("(EXISTS(SELECT 1 FROM M_PriceList_Version plv INNER JOIN M_ProductPrice pp ON(pp.M_PriceList_Version_ID = plv.M_PriceList_Version_ID) WHERE plv.M_PriceList_ID = ? AND plv.ValidFrom <= ? AND plv.IsActive = 'Y' AND pp.PriceList IS NOT NULL AND pp.PriceList > 0 AND pp.PriceStd IS NOT NULL AND pp.PriceStd > 0 AND pp.M_Product_ID = M_Product.M_Product_ID))");
        parameters.add(priceList.getM_PriceList_ID());
        parameters.add(TimeUtil.getDay((Timestamp)((Timestamp)validFrom.get())));
        AtomicInteger warehouseId = new AtomicInteger(pos.getM_Warehouse_ID());
        if (!Util.isEmpty((String)request.getWarehouseUuid())) {
            warehouseId.set(RecordUtil.getIdFromUuid("M_Warehouse", request.getWarehouseUuid(), null));
        }
        int businessPartnerId = RecordUtil.getIdFromUuid("C_BPartner", request.getBusinessPartnerUuid(), null);
        int displayCurrencyId = pos.get_ValueAsInt("DisplayCurrency_ID");
        int conversionTypeId = pos.get_ValueAsInt("C_ConversionType_ID");
        Query query = new Query(Env.getCtx(), "M_Product", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(product -> {
            ProductPrice.Builder productPrice = this.convertProductPrice((MProduct)product, businessPartnerId, priceList, warehouseId.get(), (Timestamp)validFrom.get(), displayCurrencyId, conversionTypeId, null);
            if (productPrice.hasPriceList() && productPrice.hasPriceStandard() && productPrice.hasPriceLimit()) {
                builder.addProductPrices(productPrice);
            }
        });
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ProductPrice.Builder convertProductPrice(MProduct product, int businessPartnerId, MPriceList priceList, int warehouseId, Timestamp validFrom, int displayCurrencyId, int conversionTypeId, BigDecimal priceQuantity) {
        ProductPrice.Builder builder = ProductPrice.newBuilder();
        MProductPricing productPricing = new MProductPricing(product.getM_Product_ID(), businessPartnerId, priceQuantity, true, null);
        productPricing.setM_PriceList_ID(priceList.getM_PriceList_ID());
        productPricing.setPriceDate(validFrom);
        builder.setProduct(ConvertUtil.convertProduct(product));
        int taxCategoryId = product.getC_TaxCategory_ID();
        Optional<MTax> optionalTax = Arrays.asList(MTax.getAll((Properties)Env.getCtx())).stream().filter(tax -> tax.getC_TaxCategory_ID() == taxCategoryId && (tax.isSalesTax() || !Util.isEmpty((String)tax.getSOPOType()) && (tax.getSOPOType().equals("B") || tax.getSOPOType().equals("S")))).findFirst();
        if (optionalTax.isPresent()) {
            builder.setTaxRate(ConvertUtil.convertTaxRate(optionalTax.get()));
        }
        builder.setCurrency(ConvertUtil.convertCurrency(MCurrency.get((Properties)Env.getCtx(), (int)priceList.getC_Currency_ID())));
        builder.setIsTaxIncluded(priceList.isTaxIncluded());
        builder.setValidFrom(ValueUtil.validateNull(ValueUtil.convertDateToString(productPricing.getPriceDate())));
        builder.setPriceListName(ValueUtil.validateNull(priceList.getName()));
        builder.setPricePrecision(productPricing.getPrecision());
        if (Optional.ofNullable(productPricing.getPriceStd()).orElse(Env.ZERO).signum() > 0) {
            builder.setPriceList(ValueUtil.getDecimalFromBigDecimal(Optional.ofNullable(productPricing.getPriceList()).orElse(Env.ZERO)));
            builder.setPriceStandard(ValueUtil.getDecimalFromBigDecimal(Optional.ofNullable(productPricing.getPriceStd()).orElse(Env.ZERO)));
            builder.setPriceLimit(ValueUtil.getDecimalFromBigDecimal(Optional.ofNullable(productPricing.getPriceLimit()).orElse(Env.ZERO)));
            if (displayCurrencyId > 0) {
                builder.setDisplayCurrency(ConvertUtil.convertCurrency(MCurrency.get((Properties)Env.getCtx(), (int)displayCurrencyId)));
                BigDecimal conversionRate = Optional.ofNullable(MConversionRate.getRate((int)priceList.getC_Currency_ID(), (int)displayCurrencyId, (Timestamp)RecordUtil.getDate(), (int)conversionTypeId, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()))).orElse(Env.ZERO);
                builder.setDisplayPriceList(ValueUtil.getDecimalFromBigDecimal(Optional.ofNullable(productPricing.getPriceList()).orElse(Env.ZERO).multiply(conversionRate, MathContext.DECIMAL128)));
                builder.setDisplayPriceStandard(ValueUtil.getDecimalFromBigDecimal(Optional.ofNullable(productPricing.getPriceStd()).orElse(Env.ZERO).multiply(conversionRate, MathContext.DECIMAL128)));
                builder.setDisplayPriceLimit(ValueUtil.getDecimalFromBigDecimal(Optional.ofNullable(productPricing.getPriceLimit()).orElse(Env.ZERO).multiply(conversionRate, MathContext.DECIMAL128)));
            }
        }
        if (warehouseId > 0) {
            AtomicReference<BigDecimal> quantityOnHand = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> quantityReserved = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> quantityOrdered = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> quantityAvailable = new AtomicReference<BigDecimal>(Env.ZERO);
            Arrays.asList(MStorage.getOfProduct((Properties)Env.getCtx(), (int)product.getM_Product_ID(), null)).stream().filter(storage -> storage.getM_Warehouse_ID() == warehouseId).forEach(storage -> {
                quantityOnHand.updateAndGet(quantity -> quantity.add(storage.getQtyOnHand()));
                quantityReserved.updateAndGet(quantity -> quantity.add(storage.getQtyReserved()));
                quantityOrdered.updateAndGet(quantity -> quantity.add(storage.getQtyOrdered()));
                quantityAvailable.updateAndGet(quantity -> quantity.add(storage.getQtyOnHand().subtract(storage.getQtyReserved())));
            });
            builder.setQuantityOnHand(ValueUtil.getDecimalFromBigDecimal(quantityOnHand.get()));
            builder.setQuantityReserved(ValueUtil.getDecimalFromBigDecimal(quantityReserved.get()));
            builder.setQuantityOrdered(ValueUtil.getDecimalFromBigDecimal(quantityOrdered.get()));
            builder.setQuantityAvailable(ValueUtil.getDecimalFromBigDecimal(quantityAvailable.get()));
        }
        return builder;
    }

    private ProductPrice.Builder getProductPrice(GetProductPriceRequest request) {
        MProduct product = null;
        String key = Env.getAD_Client_ID((Properties)Env.getCtx()) + "|";
        if (!Util.isEmpty((String)request.getSearchValue())) {
            product = (MProduct)productCache.get((Object)(key = key + "SearchValue|" + request.getSearchValue()));
            if (product == null) {
                product = (MProduct)new Query(Env.getCtx(), "M_Product", "(UPPER(Value) = UPPER(?)OR UPPER(Name) = UPPER(?)OR UPPER(UPC) = UPPER(?)OR UPPER(SKU) = UPPER(?))", null).setParameters(new Object[]{request.getSearchValue(), request.getSearchValue(), request.getSearchValue(), request.getSearchValue()}).setClient_ID().setOnlyActiveRecords(true).first();
            }
        } else if (!Util.isEmpty((String)request.getUpc())) {
            Optional optionalProduct;
            product = (MProduct)productCache.get((Object)(key = key + "Upc|" + request.getUpc()));
            if (product == null && (optionalProduct = MProduct.getByUPC((Properties)Env.getCtx(), (String)request.getUpc(), null).stream().findAny()).isPresent()) {
                product = (MProduct)optionalProduct.get();
            }
        } else if (!Util.isEmpty((String)request.getValue())) {
            product = (MProduct)productCache.get((Object)(key = key + "Value|" + request.getValue()));
            if (product == null) {
                product = (MProduct)new Query(Env.getCtx(), "M_Product", "UPPER(Value) = UPPER(?)", null).setParameters(new Object[]{request.getValue()}).setClient_ID().setOnlyActiveRecords(true).first();
            }
        } else if (!Util.isEmpty((String)request.getName()) && (product = (MProduct)productCache.get((Object)(key = key + "Name|" + request.getName()))) == null) {
            product = (MProduct)new Query(Env.getCtx(), "M_Product", "UPPER(Name) LIKE UPPER(?)", null).setParameters(new Object[]{request.getName()}).setClient_ID().setOnlyActiveRecords(true).first();
        }
        if (product == null) {
            throw new AdempiereException("@M_Product_ID@ @NotFound@");
        }
        productCache.put((Object)key, (Object)product);
        MPOS pos = this.getPOSFromUuid(request.getPosUuid(), true);
        int priceListId = pos.getM_PriceList_ID();
        if (!Util.isEmpty((String)request.getPriceListUuid())) {
            priceListId = RecordUtil.getIdFromUuid("M_PriceList", request.getPriceListUuid(), null);
        }
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)priceListId, null);
        AtomicInteger warehouseId = new AtomicInteger(pos.getM_Warehouse_ID());
        if (!Util.isEmpty((String)request.getWarehouseUuid())) {
            warehouseId.set(RecordUtil.getIdFromUuid("M_Warehouse", request.getWarehouseUuid(), null));
        }
        AtomicReference<Timestamp> validFrom = new AtomicReference<Timestamp>();
        if (!Util.isEmpty((String)request.getValidFrom())) {
            validFrom.set(ValueUtil.convertStringToDate(request.getValidFrom()));
        } else {
            validFrom.set(TimeUtil.getDay((long)System.currentTimeMillis()));
        }
        int businessPartnerId = RecordUtil.getIdFromUuid("C_BPartner", request.getBusinessPartnerUuid(), null);
        int displayCurrencyId = pos.get_ValueAsInt("DisplayCurrency_ID");
        int conversionTypeId = pos.get_ValueAsInt("C_ConversionType_ID");
        return this.convertProductPrice(product, businessPartnerId, priceList, warehouseId.get(), (Timestamp)validFrom.get(), displayCurrencyId, conversionTypeId, Env.ONE);
    }
}

