/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.compiere.model.MChangeLog;
import org.compiere.model.MChat;
import org.compiere.model.MChatEntry;
import org.compiere.model.MChatType;
import org.compiere.model.MColumn;
import org.compiere.model.MForm;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MMenu;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MRecentItem;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MWindow;
import org.compiere.model.M_Element;
import org.compiere.model.Query;
import org.compiere.model.X_AD_PInstance_Log;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.compiere.wf.MWFProcess;
import org.spin.base.util.ContextManager;
import org.spin.base.util.ConvertUtil;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ValueUtil;
import org.spin.base.util.WorkflowUtil;
import org.spin.grpc.util.ChangeLog;
import org.spin.grpc.util.ChatEntry;
import org.spin.grpc.util.EntityChat;
import org.spin.grpc.util.EntityLog;
import org.spin.grpc.util.ListChatEntriesRequest;
import org.spin.grpc.util.ListChatEntriesResponse;
import org.spin.grpc.util.ListEntityChatsRequest;
import org.spin.grpc.util.ListEntityChatsResponse;
import org.spin.grpc.util.ListEntityLogsRequest;
import org.spin.grpc.util.ListEntityLogsResponse;
import org.spin.grpc.util.ListProcessLogsRequest;
import org.spin.grpc.util.ListProcessLogsResponse;
import org.spin.grpc.util.ListRecentItemsRequest;
import org.spin.grpc.util.ListRecentItemsResponse;
import org.spin.grpc.util.ListWorkflowLogsRequest;
import org.spin.grpc.util.ListWorkflowLogsResponse;
import org.spin.grpc.util.LogsGrpc;
import org.spin.grpc.util.ProcessInfoLog;
import org.spin.grpc.util.ProcessLog;
import org.spin.grpc.util.RecentItem;
import org.spin.grpc.util.ReportOutput;
import org.spin.grpc.util.Value;
import org.spin.grpc.util.WorkflowProcess;

public class LogsServiceImplementation
extends LogsGrpc.LogsImplBase {
    private CLogger log = CLogger.getCLogger(LogsServiceImplementation.class);
    private SimpleDateFormat dateTimeFormat = DisplayType.getDateFormat((int)16, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)16, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat numberFormat = DisplayType.getNumberFormat((int)22, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat amountFormat = DisplayType.getNumberFormat((int)12, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat intFormat = DisplayType.getNumberFormat((int)11, (Language)Env.getLanguage((Properties)Env.getCtx()));

    @Override
    public void listProcessLogs(ListProcessLogsRequest request, StreamObserver<ListProcessLogsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Process Activity Requested is Null");
            }
            this.log.fine("Object List Requested = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListProcessLogsResponse.Builder entityValueList = this.convertProcessLogs(request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listRecentItems(ListRecentItemsRequest request, StreamObserver<ListRecentItemsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Process Activity Requested is Null");
            }
            this.log.fine("Recent Items Requested = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListRecentItemsResponse.Builder entityValueList = this.convertRecentItems(request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listEntityLogs(ListEntityLogsRequest request, StreamObserver<ListEntityLogsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Record Logs Requested is Null");
            }
            this.log.fine("Object List Requested = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListEntityLogsResponse.Builder entityValueList = this.convertEntityLogs(request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listWorkflowLogs(ListWorkflowLogsRequest request, StreamObserver<ListWorkflowLogsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Workflow Logs Requested is Null");
            }
            this.log.fine("Object List Requested = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListWorkflowLogsResponse.Builder entityValueList = this.convertWorkflowLogs(request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listEntityChats(ListEntityChatsRequest request, StreamObserver<ListEntityChatsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Record Chats Requested is Null");
            }
            this.log.fine("Object List Requested = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListEntityChatsResponse.Builder entityValueList = this.convertEntityChats(request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listChatEntries(ListChatEntriesRequest request, StreamObserver<ListChatEntriesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Chat Entries Requested is Null");
            }
            this.log.fine("Object List Requested = " + request);
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListChatEntriesResponse.Builder entityValueList = this.convertChatEntries(request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private ListProcessLogsResponse.Builder convertProcessLogs(ListProcessLogsRequest request) {
        String sql = null;
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (!Util.isEmpty((String)request.getTableName())) {
            MTable table = MTable.get((Properties)Env.getCtx(), (String)request.getTableName());
            if (table == null || table.getAD_Table_ID() == 0) {
                throw new AdempiereException("@AD_Table_ID@ @Invalid@");
            }
            int id = request.getId();
            if (id <= 0) {
                id = RecordUtil.getIdFromUuid(table.getTableName(), request.getUuid(), null);
            }
            parameters.add(id);
            parameters.add(table.getAD_Table_ID());
            sql = "Record_ID = ? AND EXISTS(SELECT 1 FROM AD_Process WHERE AD_Table_ID = ? AND AD_Process_ID = AD_PInstance.AD_Process_ID)";
        }
        if (!Util.isEmpty((String)request.getUserUuid())) {
            parameters.add(request.getUserUuid());
            sql = "EXISTS(SELECT 1 FROM AD_User WHERE UUID = ? AND AD_User_ID = AD_PInstance.AD_User_ID)";
        } else if (!Util.isEmpty((String)request.getInstanceUuid())) {
            parameters.add(request.getInstanceUuid());
            sql = "UUID = ?";
        } else {
            parameters.add(request.getClientRequest().getSessionUuid());
            sql = "EXISTS(SELECT 1 FROM AD_Session WHERE UUID = ? AND AD_Session_ID = AD_PInstance.AD_Session_ID)";
        }
        List processInstanceList = new Query(Env.getCtx(), "AD_PInstance", sql, null).setParameters(parameters).setOrderBy("Created DESC").list();
        ListProcessLogsResponse.Builder builder = ListProcessLogsResponse.newBuilder();
        for (MPInstance processInstance : processInstanceList) {
            ProcessLog.Builder valueObject = this.convertProcessLog(processInstance);
            builder.addProcessLogs(valueObject.build());
        }
        return builder;
    }

    private ListWorkflowLogsResponse.Builder convertWorkflowLogs(ListWorkflowLogsRequest request) {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        if (Util.isEmpty((String)request.getTableName())) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        MTable table = MTable.get((Properties)Env.getCtx(), (String)request.getTableName());
        if (table == null || table.getAD_Table_ID() == 0) {
            throw new AdempiereException("@AD_Table_ID@ @Invalid@");
        }
        whereClause.append("AD_Table_ID").append(" = ?").append(" AND ").append("Record_ID").append(" = ?");
        int id = request.getId();
        if (id <= 0) {
            id = RecordUtil.getIdFromUuid(table.getTableName(), request.getUuid(), null);
        }
        parameters.add(table.getAD_Table_ID());
        parameters.add(id);
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        Query query = new Query(Env.getCtx(), "AD_WF_Process", whereClause.toString(), null).setParameters(parameters);
        int count = query.count();
        List workflowProcessLogList = query.setLimit(limit, offset).list();
        ListWorkflowLogsResponse.Builder builder = ListWorkflowLogsResponse.newBuilder();
        for (MWFProcess workflowProcessLog : workflowProcessLogList) {
            WorkflowProcess.Builder valueObject = WorkflowUtil.convertWorkflowProcess(workflowProcessLog);
            builder.addWorkflowLogs(valueObject.build());
        }
        builder.setRecordCount(count);
        if (count > offset && count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListEntityLogsResponse.Builder convertEntityLogs(ListEntityLogsRequest request) {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (!Util.isEmpty((String)request.getTableName())) {
            MTable table = MTable.get((Properties)Env.getCtx(), (String)request.getTableName());
            if (table == null || table.getAD_Table_ID() == 0) {
                throw new AdempiereException("@AD_Table_ID@ @Invalid@");
            }
            whereClause.append("AD_Table_ID").append(" = ?").append(" AND ").append("Record_ID").append(" = ?");
            int id = request.getId();
            if (id <= 0) {
                id = RecordUtil.getIdFromUuid(table.getTableName(), request.getUuid(), null);
            }
            parameters.add(table.getAD_Table_ID());
            parameters.add(id);
        } else {
            whereClause.append("EXISTS(SELECT 1 FROM AD_Session WHERE UUID = ? AND AD_Session_ID = AD_ChangeLog.AD_Session_ID)");
            parameters.add(request.getClientRequest().getSessionUuid());
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        Query query = new Query(Env.getCtx(), "AD_ChangeLog", whereClause.toString(), null).setParameters(parameters);
        int count = query.count();
        List recordLogList = query.setLimit(limit, offset).list();
        ListEntityLogsResponse.Builder builder = this.convertRecordLog(recordLogList);
        builder.setRecordCount(count);
        if (count > offset && count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private EntityLog.Builder convertRecordLogHeader(MChangeLog recordLog) {
        MTable table = MTable.get((Properties)recordLog.getCtx(), (int)recordLog.getAD_Table_ID());
        MUser user = MUser.get((Properties)recordLog.getCtx(), (int)recordLog.getCreatedBy());
        EntityLog.Builder builder = EntityLog.newBuilder();
        builder.setLogId(recordLog.getAD_ChangeLog_ID());
        builder.setId(recordLog.getRecord_ID());
        builder.setUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId(table.getTableName(), recordLog.getRecord_ID())));
        builder.setTableName(ValueUtil.validateNull(table.getTableName()));
        builder.setSessionUuid(ValueUtil.validateNull(recordLog.getAD_Session().getUUID()));
        builder.setUserUuid(ValueUtil.validateNull(user.getUUID()));
        builder.setUserName(ValueUtil.validateNull(user.getName()));
        builder.setTransactionName(ValueUtil.validateNull(recordLog.getTrxName()));
        builder.setLogDate(recordLog.getCreated().getTime());
        if (recordLog.getEventChangeLog().endsWith("I")) {
            builder.setEventType(EntityLog.EventType.INSERT);
        } else if (recordLog.getEventChangeLog().endsWith("U")) {
            builder.setEventType(EntityLog.EventType.UPDATE);
        } else if (recordLog.getEventChangeLog().endsWith("D")) {
            builder.setEventType(EntityLog.EventType.DELETE);
        }
        return builder;
    }

    private ListEntityLogsResponse.Builder convertRecordLog(List<MChangeLog> recordLogList) {
        HashMap indexMap = new HashMap();
        recordLogList.stream().filter(recordLog -> !indexMap.containsKey(recordLog.getAD_ChangeLog_ID())).forEach(recordLog -> indexMap.put(recordLog.getAD_ChangeLog_ID(), this.convertRecordLogHeader((MChangeLog)recordLog)));
        recordLogList.forEach(recordLog -> {
            ChangeLog.Builder changeLog = this.convertChangeLog((MChangeLog)recordLog);
            EntityLog.Builder recordLogBuilder = (EntityLog.Builder)indexMap.get(recordLog.getAD_ChangeLog_ID());
            recordLogBuilder.addChangeLogs(changeLog);
            indexMap.put(recordLog.getAD_ChangeLog_ID(), recordLogBuilder);
        });
        ListEntityLogsResponse.Builder builder = ListEntityLogsResponse.newBuilder();
        indexMap.values().stream().forEach(recordLog -> builder.addEntityLogs((EntityLog.Builder)recordLog));
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ChangeLog.Builder convertChangeLog(MChangeLog recordLog) {
        String displayNewValue;
        String displayOldValue;
        ChangeLog.Builder builder;
        block38: {
            String translation;
            builder = ChangeLog.newBuilder();
            MColumn column = MColumn.get((Properties)recordLog.getCtx(), (int)recordLog.getAD_Column_ID());
            builder.setColumnName(ValueUtil.validateNull(column.getColumnName()));
            String displayColumnName = column.getName();
            if (column.getColumnName().equals("ProcessedOn")) {
                String translation2;
                M_Element element = M_Element.get((Properties)recordLog.getCtx(), (String)"LastRun");
                displayColumnName = element.getName();
                if (!Env.isBaseLanguage((Properties)recordLog.getCtx(), (String)"") && !Util.isEmpty((String)(translation2 = element.get_Translation("Name")))) {
                    displayColumnName = translation2;
                }
            } else if (!Env.isBaseLanguage((Properties)recordLog.getCtx(), (String)"") && !Util.isEmpty((String)(translation = column.get_Translation("Name")))) {
                displayColumnName = translation;
            }
            builder.setDisplayColumnName(ValueUtil.validateNull(displayColumnName));
            builder.setDescription(ValueUtil.validateNull(recordLog.getDescription()));
            String oldValue = recordLog.getOldValue();
            String newValue = recordLog.getNewValue();
            builder.setOldValue(ValueUtil.validateNull(oldValue));
            builder.setNewValue(ValueUtil.validateNull(newValue));
            if (oldValue != null && oldValue.equals(MChangeLog.NULL)) {
                oldValue = null;
            }
            displayOldValue = oldValue;
            if (newValue != null && newValue.equals(MChangeLog.NULL)) {
                newValue = null;
            }
            displayNewValue = newValue;
            try {
                if (DisplayType.isText((int)column.getAD_Reference_ID())) break block38;
                if (column.getAD_Reference_ID() == 20) {
                    boolean yes;
                    if (oldValue != null) {
                        yes = oldValue.equals("true") || oldValue.equals("Y");
                        displayOldValue = Msg.getMsg((Properties)Env.getCtx(), (String)(yes ? "Y" : "N"));
                    }
                    if (newValue != null) {
                        yes = newValue.equals("true") || newValue.equals("Y");
                        displayNewValue = Msg.getMsg((Properties)Env.getCtx(), (String)(yes ? "Y" : "N"));
                    }
                    break block38;
                }
                if (column.getAD_Reference_ID() == 12) {
                    if (oldValue != null) {
                        displayOldValue = this.amountFormat.format(new BigDecimal(oldValue));
                    }
                    if (newValue != null) {
                        displayNewValue = this.amountFormat.format(new BigDecimal(newValue));
                    }
                    break block38;
                }
                if (column.getAD_Reference_ID() == 11) {
                    if (oldValue != null) {
                        displayOldValue = this.intFormat.format(new Integer(oldValue));
                    }
                    if (newValue != null) {
                        displayNewValue = this.intFormat.format(new Integer(newValue));
                    }
                    break block38;
                }
                if (DisplayType.isNumeric((int)column.getAD_Reference_ID())) {
                    if (column.getColumnName().equals("ProcessedOn")) {
                        if (oldValue != null) {
                            if (oldValue.indexOf(".") > 0) {
                                oldValue = oldValue.substring(0, oldValue.indexOf("."));
                            }
                            displayOldValue = TimeUtil.formatElapsed((long)(System.currentTimeMillis() - new BigDecimal(oldValue).longValue()));
                        }
                        if (newValue != null) {
                            if (newValue.indexOf(".") > 0) {
                                newValue = newValue.substring(0, newValue.indexOf("."));
                            }
                            displayNewValue = TimeUtil.formatElapsed((long)(System.currentTimeMillis() - new BigDecimal(newValue).longValue()));
                        }
                        break block38;
                    }
                    if (oldValue != null) {
                        displayOldValue = this.numberFormat.format(new BigDecimal(oldValue));
                    }
                    if (newValue != null) {
                        displayNewValue = this.numberFormat.format(new BigDecimal(newValue));
                    }
                    break block38;
                }
                if (column.getAD_Reference_ID() == 15) {
                    if (oldValue != null) {
                        displayOldValue = this.dateFormat.format(Timestamp.valueOf(oldValue));
                    }
                    if (newValue != null) {
                        displayNewValue = this.dateFormat.format(Timestamp.valueOf(newValue));
                    }
                    break block38;
                }
                if (column.getAD_Reference_ID() == 16) {
                    if (oldValue != null) {
                        displayOldValue = this.dateTimeFormat.format(Timestamp.valueOf(oldValue));
                    }
                    if (newValue != null) {
                        displayNewValue = this.dateTimeFormat.format(Timestamp.valueOf(newValue));
                    }
                    break block38;
                }
                if (DisplayType.isLookup((int)column.getAD_Reference_ID()) && column.getAD_Reference_ID() != 28 && column.getAD_Reference_ID() != 17) {
                    String key;
                    NamePair pp;
                    MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)column.getAD_Column_ID(), (int)column.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)Env.getCtx()), (String)column.getColumnName(), (int)column.getAD_Reference_Value_ID(), (boolean)column.isParent(), null);
                    if (oldValue != null && (pp = lookup.get((Object)(key = oldValue))) != null) {
                        displayOldValue = pp.getName();
                    }
                    if (newValue != null && (pp = lookup.get((Object)(key = newValue))) != null) {
                        displayNewValue = pp.getName();
                    }
                    break block38;
                }
                if ((28 == column.getAD_Reference_ID() || 17 == column.getAD_Reference_ID()) && column.getAD_Reference_Value_ID() != 0) {
                    String key;
                    NamePair pp;
                    MLookupInfo lookupInfo = MLookupFactory.getLookup_List((Language)Env.getLanguage((Properties)Env.getCtx()), (int)column.getAD_Reference_Value_ID());
                    MLookup lookup = new MLookup(lookupInfo, 0);
                    if (oldValue != null && (pp = lookup.get((Object)(key = oldValue))) != null) {
                        displayOldValue = pp.getName();
                    }
                    if (newValue != null && (pp = lookup.get((Object)(key = newValue))) != null) {
                        displayNewValue = pp.getName();
                    }
                    break block38;
                }
                if (!DisplayType.isLOB((int)column.getAD_Reference_ID())) {
                    // empty if block
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, oldValue + "->" + newValue, (Throwable)e);
            }
        }
        builder.setOldDisplayValue(ValueUtil.validateNull(displayOldValue));
        builder.setNewDisplayValue(ValueUtil.validateNull(displayNewValue));
        return builder;
    }

    private ListRecentItemsResponse.Builder convertRecentItems(ListRecentItemsRequest request) {
        ListRecentItemsResponse.Builder builder = ListRecentItemsResponse.newBuilder();
        List recentItemsList = MRecentItem.getFromUserAndRole((Properties)Env.getCtx());
        if (recentItemsList != null) {
            for (MRecentItem recentItem : recentItemsList) {
                try {
                    MTable table;
                    RecentItem.Builder recentItemBuilder = RecentItem.newBuilder().setDisplayName(ValueUtil.validateNull(recentItem.getLabel()));
                    String menuName = "";
                    String menuDescription = "";
                    String referenceUuid = null;
                    if (recentItem.getAD_Tab_ID() > 0) {
                        MTab tab = MTab.get((Properties)Env.getCtx(), (int)recentItem.getAD_Tab_ID());
                        recentItemBuilder.setTabUuid(ValueUtil.validateNull(tab.getUUID()));
                        menuName = tab.getName();
                        menuDescription = tab.getDescription();
                        if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"")) {
                            menuName = tab.get_Translation("Name");
                            menuDescription = tab.get_Translation("Description");
                        }
                        recentItemBuilder.setAction(ValueUtil.validateNull("W"));
                    }
                    if (recentItem.getAD_Window_ID() > 0) {
                        MWindow window = MWindow.get((Properties)Env.getCtx(), (int)recentItem.getAD_Window_ID());
                        recentItemBuilder.setWindowUuid(ValueUtil.validateNull(window.getUUID()));
                        menuName = window.getName();
                        menuDescription = window.getDescription();
                        referenceUuid = window.getUUID();
                        if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"")) {
                            menuName = window.get_Translation("Name");
                            menuDescription = window.get_Translation("Description");
                        }
                        recentItemBuilder.setAction(ValueUtil.validateNull("W"));
                    }
                    if (recentItem.getAD_Menu_ID() > 0) {
                        MMenu menu = MMenu.getFromId((Properties)Env.getCtx(), (int)recentItem.getAD_Menu_ID());
                        recentItemBuilder.setMenuUuid(ValueUtil.validateNull(menu.getUUID()));
                        menuName = menu.getName();
                        menuDescription = menu.getDescription();
                        if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"")) {
                            menuName = menu.get_Translation("Name");
                            menuDescription = menu.get_Translation("Description");
                        }
                        recentItemBuilder.setAction(ValueUtil.validateNull(menu.getAction()));
                        if (!Util.isEmpty((String)menu.getAction())) {
                            if (menu.getAction().equals("X")) {
                                if (menu.getAD_Form_ID() > 0) {
                                    MForm form = new MForm(Env.getCtx(), menu.getAD_Form_ID(), null);
                                    referenceUuid = form.getUUID();
                                }
                            } else if (menu.getAction().equals("W")) {
                                if (menu.getAD_Window_ID() > 0) {
                                    MWindow window = new MWindow(Env.getCtx(), menu.getAD_Window_ID(), null);
                                    referenceUuid = window.getUUID();
                                }
                            } else if (menu.getAction().equals("P") || menu.getAction().equals("R")) {
                                if (menu.getAD_Process_ID() > 0) {
                                    MProcess process = MProcess.get((Properties)Env.getCtx(), (int)menu.getAD_Process_ID());
                                    referenceUuid = process.getUUID();
                                }
                            } else if (menu.getAction().equals("S") && menu.getAD_Browse_ID() > 0) {
                                MBrowse smartBrowser = MBrowse.get((Properties)Env.getCtx(), (int)menu.getAD_Browse_ID());
                                referenceUuid = smartBrowser.getUUID();
                            }
                        }
                    }
                    recentItemBuilder.setMenuName(ValueUtil.validateNull(menuName));
                    recentItemBuilder.setMenuDescription(ValueUtil.validateNull(menuDescription));
                    recentItemBuilder.setUpdated(recentItem.getUpdated().getTime());
                    recentItemBuilder.setReferenceUuid(ValueUtil.validateNull(referenceUuid));
                    if (recentItem.getAD_Table_ID() != 0 && recentItem.getRecord_ID() != 0 && (table = MTable.get((Properties)Env.getCtx(), (int)recentItem.getAD_Table_ID())) != null && table.getAD_Table_ID() != 0) {
                        recentItemBuilder.setId(recentItem.getRecord_ID()).setUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId(table.getTableName(), recentItem.getRecord_ID()))).setTableName(ValueUtil.validateNull(table.getTableName())).setTableId(recentItem.getAD_Table_ID());
                    }
                    builder.addRecentItems(recentItemBuilder.build());
                }
                catch (Exception e) {
                    this.log.severe(e.getLocalizedMessage());
                }
            }
        }
        return builder;
    }

    private ProcessLog.Builder convertProcessLog(MPInstance instance) {
        ProcessLog.Builder builder = ProcessLog.newBuilder();
        builder.setInstanceUuid(ValueUtil.validateNull(instance.getUUID()));
        builder.setIsError(!instance.isOK());
        builder.setIsProcessing(instance.isProcessing());
        builder.setLastRun(instance.getUpdated().getTime());
        String summary = instance.getErrorMsg();
        if (!Util.isEmpty((String)summary)) {
            summary = Msg.parseTranslation((Properties)Env.getCtx(), (String)summary);
        }
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)instance.getAD_Process_ID());
        builder.setUuid(ValueUtil.validateNull(process.getUUID()));
        builder.setName(ValueUtil.validateNull(process.getName()));
        builder.setDescription(ValueUtil.validateNull(process.getDescription()));
        if (process.isReport()) {
            ReportOutput.Builder outputBuilder = ReportOutput.newBuilder();
            outputBuilder.setReportType(ValueUtil.validateNull(instance.getReportType()));
            outputBuilder.setName(ValueUtil.validateNull(instance.getName()));
            builder.setOutput(outputBuilder.build());
        }
        builder.setSummary(ValueUtil.validateNull(summary));
        List logList = new Query(Env.getCtx(), "AD_PInstance_Log", "AD_PInstance_ID = ?", null).setParameters(new Object[]{instance.getAD_PInstance_ID()}).list();
        for (X_AD_PInstance_Log log : logList) {
            ProcessInfoLog.Builder logBuilder = ProcessInfoLog.newBuilder();
            logBuilder.setRecordId(log.getAD_PInstance_Log_ID());
            String message = log.getP_Msg();
            if (!Util.isEmpty((String)message)) {
                message = Msg.parseTranslation((Properties)Env.getCtx(), (String)message);
            }
            logBuilder.setLog(ValueUtil.validateNull(message));
            builder.addLogs(logBuilder.build());
        }
        for (MPInstancePara parameter : instance.getParameters()) {
            String value;
            BigDecimal numberTo;
            BigDecimal number;
            Value.Builder parameterBuilder = Value.newBuilder();
            Value.Builder parameterToBuilder = Value.newBuilder();
            boolean hasFromParameter = false;
            boolean hasToParameter = false;
            String parameterName = parameter.getParameterName();
            int displayType = parameter.getDisplayType();
            if (displayType == -1) {
                displayType = 10;
            }
            if (DisplayType.isID((int)displayType)) {
                number = parameter.getP_Number();
                numberTo = parameter.getP_Number_To();
                if (number != null && !number.equals(Env.ZERO)) {
                    hasFromParameter = true;
                    parameterBuilder = ValueUtil.getValueFromInteger(number.intValue());
                }
                if (numberTo != null && !numberTo.equals(Env.ZERO)) {
                    hasToParameter = true;
                    parameterBuilder = ValueUtil.getValueFromInteger(numberTo.intValue());
                }
            } else if (DisplayType.isNumeric((int)displayType)) {
                number = parameter.getP_Number();
                numberTo = parameter.getP_Number_To();
                if (number != null && !number.equals(Env.ZERO)) {
                    hasFromParameter = true;
                    parameterBuilder = ValueUtil.getValueFromDecimal(number);
                }
                if (numberTo != null && !numberTo.equals(Env.ZERO)) {
                    hasToParameter = true;
                    parameterBuilder = ValueUtil.getValueFromDecimal(numberTo);
                }
            } else if (DisplayType.isDate((int)displayType)) {
                Timestamp date = parameter.getP_Date();
                Timestamp dateTo = parameter.getP_Date_To();
                if (date != null) {
                    hasFromParameter = true;
                    parameterBuilder = ValueUtil.getValueFromDate(date);
                }
                if (dateTo != null) {
                    hasToParameter = true;
                    parameterBuilder = ValueUtil.getValueFromDate(dateTo);
                }
            } else if (20 == displayType) {
                value = parameter.getP_String();
                if (!Util.isEmpty((String)value)) {
                    hasFromParameter = true;
                    parameterBuilder = ValueUtil.getValueFromBoolean(!Util.isEmpty((String)value) && value.equals("Y"));
                }
            } else {
                value = parameter.getP_String();
                String valueTo = parameter.getP_String_To();
                if (!Util.isEmpty((String)value)) {
                    hasFromParameter = true;
                    parameterBuilder = ValueUtil.getValueFromString(value);
                }
                if (!Util.isEmpty((String)valueTo)) {
                    hasToParameter = true;
                    parameterBuilder = ValueUtil.getValueFromString(valueTo);
                }
            }
            if (hasFromParameter) {
                builder.putParameters(parameterName, parameterBuilder.build());
            }
            if (!hasToParameter) continue;
            builder.putParameters(parameterName + "_To", parameterToBuilder.build());
        }
        return builder;
    }

    private ListChatEntriesResponse.Builder convertChatEntries(ListChatEntriesRequest request) {
        if (request.getId() <= 0 && Util.isEmpty((String)request.getUuid())) {
            throw new AdempiereException("@CM_Chat_ID@ @NotFound@");
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int id = request.getId();
        if (id <= 0) {
            id = RecordUtil.getIdFromUuid("CM_Chat", request.getUuid(), null);
        }
        Query query = new Query(Env.getCtx(), "CM_ChatEntry", "CM_Chat_ID = ?", null).setParameters(new Object[]{id});
        int count = query.count();
        List chatEntryList = query.setLimit(limit, offset).list();
        ListChatEntriesResponse.Builder builder = ListChatEntriesResponse.newBuilder();
        for (MChatEntry chatEntry : chatEntryList) {
            ChatEntry.Builder valueObject = ConvertUtil.convertChatEntry(chatEntry);
            builder.addChatEntries(valueObject.build());
        }
        builder.setRecordCount(count);
        if (count > offset && count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListEntityChatsResponse.Builder convertEntityChats(ListEntityChatsRequest request) {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        if (Util.isEmpty((String)request.getTableName())) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        MTable table = MTable.get((Properties)Env.getCtx(), (String)request.getTableName());
        if (table == null || table.getAD_Table_ID() == 0) {
            throw new AdempiereException("@AD_Table_ID@ @Invalid@");
        }
        whereClause.append("AD_Table_ID").append(" = ?").append(" AND ").append("Record_ID").append(" = ?");
        int id = request.getId();
        if (id <= 0) {
            id = RecordUtil.getIdFromUuid(table.getTableName(), request.getUuid(), null);
        }
        parameters.add(table.getAD_Table_ID());
        parameters.add(id);
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        Query query = new Query(Env.getCtx(), "CM_Chat", whereClause.toString(), null).setParameters(parameters);
        int count = query.count();
        List chatList = query.setLimit(limit, offset).list();
        ListEntityChatsResponse.Builder builder = ListEntityChatsResponse.newBuilder();
        for (MChat chat : chatList) {
            EntityChat.Builder valueObject = this.convertRecordChat(chat);
            builder.addEntityChats(valueObject.build());
        }
        builder.setRecordCount(count);
        if (count > offset && count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private EntityChat.Builder convertRecordChat(MChat recordChat) {
        MTable table = MTable.get((Properties)recordChat.getCtx(), (int)recordChat.getAD_Table_ID());
        EntityChat.Builder builder = EntityChat.newBuilder();
        builder.setChatUuid(ValueUtil.validateNull(recordChat.getUUID()));
        builder.setTableName(ValueUtil.validateNull(table.getTableName()));
        if (recordChat.getCM_ChatType_ID() != 0) {
            MChatType chatType = MChatType.get((Properties)recordChat.getCtx(), (int)recordChat.getCM_Chat_ID());
            builder.setChatTypeUuid(ValueUtil.validateNull(chatType.getUUID()));
        }
        builder.setId(recordChat.getRecord_ID());
        builder.setUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId(table.getTableName(), recordChat.getRecord_ID())));
        builder.setDescription(ValueUtil.validateNull(recordChat.getDescription()));
        builder.setLogDate(recordChat.getCreated().getTime());
        if (!Util.isEmpty((String)recordChat.getConfidentialType())) {
            if (recordChat.getConfidentialType().equals("A")) {
                builder.setConfidentialType(EntityChat.ConfidentialType.PUBLIC);
            } else if (recordChat.getConfidentialType().equals("C")) {
                builder.setConfidentialType(EntityChat.ConfidentialType.PARTER);
            } else if (recordChat.getConfidentialType().equals("I")) {
                builder.setConfidentialType(EntityChat.ConfidentialType.INTERNAL);
            }
        }
        if (!Util.isEmpty((String)recordChat.getModerationType())) {
            if (recordChat.getModerationType().equals("N")) {
                builder.setModerationType(EntityChat.ModerationType.NOT_MODERATED);
            } else if (recordChat.getModerationType().equals("B")) {
                builder.setModerationType(EntityChat.ModerationType.BEFORE_PUBLISHING);
            } else if (recordChat.getModerationType().equals("A")) {
                builder.setModerationType(EntityChat.ModerationType.AFTER_PUBLISHING);
            }
        }
        return builder;
    }
}

