/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MMailText;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.grpc.enrollment.ActivateUserRequest;
import org.spin.grpc.enrollment.ActivateUserResponse;
import org.spin.grpc.enrollment.EnrollUserRequest;
import org.spin.grpc.enrollment.RegisterGrpc;
import org.spin.grpc.enrollment.ResetPasswordRequest;
import org.spin.grpc.enrollment.ResetPasswordResponse;
import org.spin.grpc.enrollment.ResetPasswordTokenRequest;
import org.spin.grpc.enrollment.User;
import org.spin.model.MADToken;
import org.spin.util.TokenGeneratorHandler;

public class EnrollmentServiceImplementation
extends RegisterGrpc.RegisterImplBase {
    private CLogger log = CLogger.getCLogger(EnrollmentServiceImplementation.class);

    @Override
    public void enrollUser(EnrollUserRequest request, StreamObserver<User> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getUserName() + " - " + request.getEmail());
            User.Builder userInfoValue = this.enrollUser(request);
            responseObserver.onNext((Object)userInfoValue.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getMessage()).augmentDescription(e.getMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void resetPassword(ResetPasswordRequest request, StreamObserver<ResetPasswordResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getUserName() + " - " + request.getEmail());
            ResetPasswordResponse.Builder passwordResetReponse = this.resetPassword(request);
            responseObserver.onNext((Object)passwordResetReponse.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getMessage()).augmentDescription(e.getMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void resetPasswordFromToken(ResetPasswordTokenRequest request, StreamObserver<ResetPasswordResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getToken());
            ResetPasswordResponse.Builder passwordResetReponse = this.resetPasswordFromToken(request);
            responseObserver.onNext((Object)passwordResetReponse.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getMessage()).augmentDescription(e.getMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void activateUser(ActivateUserRequest request, StreamObserver<ActivateUserResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getToken());
            ActivateUserResponse.Builder response = this.activateUser(request);
            responseObserver.onNext((Object)response.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getMessage()).augmentDescription(e.getMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private ResetPasswordResponse.Builder resetPasswordFromToken(ResetPasswordTokenRequest request) {
        if (Util.isEmpty((String)request.getToken()) && Util.isEmpty((String)request.getPassword())) {
            throw new AdempiereException("@Token@ / @Password@ @IsMandatory@");
        }
        ResetPasswordResponse.Builder builder = ResetPasswordResponse.newBuilder();
        MADToken token = (MADToken)new Query(Env.getCtx(), "AD_Token", "TokenValue = ?", null).setParameters(new Object[]{request.getToken()}).first();
        if (token == null || token.getAD_Token_ID() == 0) {
            builder.setResponseType(ResetPasswordResponse.ResponseType.TOKEN_NOT_FOUND);
            throw new AdempiereException("@Token@ @NotFound@");
        }
        try {
            if (!TokenGeneratorHandler.getInstance().validateToken("URL", request.getToken(), token.getAD_User_ID())) {
                throw new AdempiereException("@Token@ @NotFound@");
            }
            MUser user = MUser.get((Properties)Env.getCtx(), (int)token.getAD_User_ID());
            user.setPassword(request.getPassword());
            user.saveEx();
        }
        catch (Exception e) {
            builder.setResponseType(ResetPasswordResponse.ResponseType.ERROR);
            throw new AdempiereException(e.getMessage());
        }
        builder.setResponseType(ResetPasswordResponse.ResponseType.OK);
        return builder;
    }

    private ActivateUserResponse.Builder activateUser(ActivateUserRequest request) {
        ActivateUserResponse.Builder builder = ActivateUserResponse.newBuilder();
        if (Util.isEmpty((String)request.getToken())) {
            builder.setResponseType(ActivateUserResponse.ResponseType.TOKEN_NOT_FOUND);
            throw new AdempiereException("@Token@ @IsMandatory@");
        }
        MADToken token = (MADToken)new Query(Env.getCtx(), "AD_Token", "TokenValue = ?", null).setParameters(new Object[]{request.getToken()}).first();
        if (token == null || token.getAD_Token_ID() == 0) {
            throw new AdempiereException("@Token@ @NotFound@");
        }
        try {
            if (!TokenGeneratorHandler.getInstance().validateToken("URL", request.getToken(), token.getAD_User_ID())) {
                throw new AdempiereException("@Token@ @NotFound@");
            }
            MUser user = MUser.get((Properties)Env.getCtx(), (int)token.getAD_User_ID());
            user.setIsActive(true);
            user.saveEx();
        }
        catch (Exception e) {
            builder.setResponseType(ActivateUserResponse.ResponseType.ERROR);
            throw new AdempiereException(e.getMessage());
        }
        return builder;
    }

    private ResetPasswordResponse.Builder resetPassword(ResetPasswordRequest request) {
        if (Util.isEmpty((String)request.getUserName()) && Util.isEmpty((String)request.getEmail())) {
            throw new AdempiereException("@UserName@ / @EMail@ @IsMandatory@");
        }
        ResetPasswordResponse.Builder builder = ResetPasswordResponse.newBuilder();
        MUser user = (MUser)new Query(Env.getCtx(), "AD_User", "Value = ? OR EMail = ?", null).setParameters(new Object[]{request.getUserName(), request.getEmail()}).first();
        if (user == null || user.getAD_User_ID() <= 0) {
            builder.setResponseType(ResetPasswordResponse.ResponseType.USER_NOT_FOUND);
            throw new AdempiereException("@UserName@ / @EMail@ @NotFound@");
        }
        try {
            MADToken token = this.generateToken(user);
            this.sendEMail(user, token);
        }
        catch (Exception e) {
            builder.setResponseType(ResetPasswordResponse.ResponseType.ERROR);
            throw new AdempiereException(e.getMessage());
        }
        builder.setResponseType(ResetPasswordResponse.ResponseType.OK);
        return builder;
    }

    private User.Builder enrollUser(EnrollUserRequest request) {
        if (Util.isEmpty((String)request.getUserName())) {
            throw new AdempiereException("@UserName@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getEmail())) {
            throw new AdempiereException("@EMail@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getName())) {
            throw new AdempiereException("@Name@ @IsMandatory@");
        }
        User.Builder builder = User.newBuilder();
        int userId = new Query(Env.getCtx(), "AD_User", "Value = ? OR EMail = ?", null).setParameters(new Object[]{request.getUserName(), request.getEmail()}).firstId();
        if (userId > 0) {
            throw new AdempiereException("@UserName@ / @EMail@ @AlreadyExists@");
        }
        MUser newUser = new MUser(Env.getCtx(), 0, null);
        newUser.setName(request.getName());
        newUser.setEMail(request.getEmail());
        newUser.setValue(request.getUserName());
        newUser.setIsLoginUser(true);
        newUser.setIsInternalUser(false);
        newUser.set_ValueOfColumn("ClientVersion", (Object)request.getClientVersion());
        newUser.set_ValueOfColumn("ApplicationTypeCode", (Object)request.getApplicationType());
        newUser.saveEx();
        if (!Util.isEmpty((String)request.getPassword())) {
            newUser.setPassword(request.getPassword());
            newUser.setIsActive(false);
            newUser.saveEx();
        }
        try {
            MADToken token = this.generateToken(newUser);
            this.sendEMail(newUser, token);
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
        }
        builder.setUserName(newUser.getValue());
        builder.setName(newUser.getName());
        builder.setEmail(newUser.getEMail());
        return builder;
    }

    private MADToken generateToken(MUser user) throws Exception {
        if (user == null) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)user.getEMail())) {
            throw new AdempiereException("@AD_User_ID@ - @Email@ @NotFound@");
        }
        TokenGeneratorHandler.getInstance().generateToken("URL", user.getAD_User_ID());
        return TokenGeneratorHandler.getInstance().getToken("URL");
    }

    private void sendEMail(MUser user, MADToken token) {
        MClient client = MClient.get((Properties)user.getCtx(), (int)user.getAD_Client_ID());
        MClientInfo clientInfo = client.getInfo();
        int mailTextId = clientInfo.getRestorePassword_MailText_ID();
        if (mailTextId <= 0) {
            throw new AdempiereException("@RestorePassword_MailText_ID@ @NotFound@");
        }
        MMailText text = new MMailText(Env.getCtx(), mailTextId, null);
        text.setPO((PO)token);
        text.setUser(user);
        EMail email = client.createEMail(user.getEMail(), null, null);
        String msg = null;
        if (!email.isValid()) {
            msg = "@RequestActionEMailError@ Invalid EMail: " + user;
            throw new AdempiereException("@RequestActionEMailError@ Invalid EMail: " + user);
        }
        String message = text.getMailText(true);
        email.setMessageHTML(text.getMailHeader(), message);
        msg = email.send();
        MUserMail userMail = new MUserMail(text, user.getAD_User_ID(), email);
        userMail.saveEx();
        if (!msg.equals("OK")) {
            throw new AdempiereException(user.getName() + " @RequestActionEMailError@ " + msg);
        }
    }
}

