/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MForm;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MMessage;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRecentItem;
import org.compiere.model.MReportView;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MValRule;
import org.compiere.model.MWindow;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_FieldGroup;
import org.compiere.model.X_AD_Reference;
import org.compiere.model.X_AD_Tab;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.spin.base.util.ContextManager;
import org.spin.base.util.DictionaryUtil;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.ApplicationRequest;
import org.spin.grpc.util.Browser;
import org.spin.grpc.util.ContextInfo;
import org.spin.grpc.util.DictionaryGrpc;
import org.spin.grpc.util.EntityRequest;
import org.spin.grpc.util.Field;
import org.spin.grpc.util.FieldCondition;
import org.spin.grpc.util.FieldDefinition;
import org.spin.grpc.util.FieldGroup;
import org.spin.grpc.util.FieldRequest;
import org.spin.grpc.util.Form;
import org.spin.grpc.util.MessageText;
import org.spin.grpc.util.Process;
import org.spin.grpc.util.Reference;
import org.spin.grpc.util.ReferenceRequest;
import org.spin.grpc.util.ReportExportType;
import org.spin.grpc.util.Tab;
import org.spin.grpc.util.ValidationRule;
import org.spin.grpc.util.Window;
import org.spin.grpc.util.ZoomWindow;
import org.spin.model.MADContextInfo;
import org.spin.model.MADFieldCondition;
import org.spin.model.MADFieldDefinition;
import org.spin.util.ASPUtil;
import org.spin.util.AbstractExportFormat;
import org.spin.util.ReportExportHandler;

public class DictionaryServiceImplementation
extends DictionaryGrpc.DictionaryImplBase {
    private CLogger log = CLogger.getCLogger(DictionaryServiceImplementation.class);

    @Override
    public void getWindow(EntityRequest request, StreamObserver<Window> responseObserver) {
        this.requestWindow(request, responseObserver, true);
    }

    @Override
    public void getTab(EntityRequest request, StreamObserver<Tab> responseObserver) {
        this.requestTab(request, responseObserver, true);
    }

    @Override
    public void getField(FieldRequest request, StreamObserver<Field> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Menu Requested = " + request.getFieldUuid());
            ApplicationRequest applicationInfo = request.getApplicationRequest();
            if (applicationInfo == null || Util.isEmpty((String)applicationInfo.getSessionUuid())) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getApplicationRequest().getSessionUuid(), request.getApplicationRequest().getLanguage());
            Field.Builder fieldBuilder = this.convertField(context, request);
            responseObserver.onNext((Object)fieldBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getReference(ReferenceRequest request, StreamObserver<Reference> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Menu Requested = " + request.getReferenceUuid());
            ApplicationRequest applicationInfo = request.getApplicationRequest();
            if (applicationInfo == null || Util.isEmpty((String)applicationInfo.getSessionUuid())) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getApplicationRequest().getSessionUuid(), request.getApplicationRequest().getLanguage());
            Reference.Builder fieldBuilder = this.convertReference(context, request);
            responseObserver.onNext((Object)fieldBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getValidationRule(EntityRequest request, StreamObserver<ValidationRule> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Menu Requested = " + request.getUuid());
            ApplicationRequest applicationInfo = request.getApplicationRequest();
            if (applicationInfo == null || Util.isEmpty((String)applicationInfo.getSessionUuid())) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getApplicationRequest().getSessionUuid(), request.getApplicationRequest().getLanguage());
            ValidationRule.Builder fieldBuilder = this.convertValidationRule(context, request);
            responseObserver.onNext((Object)fieldBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getProcess(EntityRequest request, StreamObserver<Process> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Menu Requested = " + request.getUuid());
            ApplicationRequest applicationInfo = request.getApplicationRequest();
            if (applicationInfo == null || Util.isEmpty((String)applicationInfo.getSessionUuid())) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getApplicationRequest().getSessionUuid(), request.getApplicationRequest().getLanguage());
            Process.Builder processBuilder = this.convertProcess(context, request.getUuid(), request.getId(), true);
            responseObserver.onNext((Object)processBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getBrowser(EntityRequest request, StreamObserver<Browser> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Menu Requested = " + request.getUuid());
            ApplicationRequest applicationInfo = request.getApplicationRequest();
            if (applicationInfo == null || Util.isEmpty((String)applicationInfo.getSessionUuid())) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getApplicationRequest().getSessionUuid(), request.getApplicationRequest().getLanguage());
            Browser.Builder browserBuilder = this.convertBrowser(context, request.getUuid(), true);
            responseObserver.onNext((Object)browserBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getForm(EntityRequest request, StreamObserver<Form> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Menu Requested = " + request.getUuid());
            ApplicationRequest applicationInfo = request.getApplicationRequest();
            if (applicationInfo == null || Util.isEmpty((String)applicationInfo.getSessionUuid())) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getApplicationRequest().getSessionUuid(), request.getApplicationRequest().getLanguage());
            Form.Builder formBuilder = this.convertForm(context, request.getUuid(), request.getId());
            responseObserver.onNext((Object)formBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    public void requestWindow(EntityRequest request, StreamObserver<Window> responseObserver, boolean withTabs) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Menu Requested = " + request.getUuid());
            ApplicationRequest applicationInfo = request.getApplicationRequest();
            if (applicationInfo == null || Util.isEmpty((String)applicationInfo.getSessionUuid())) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getApplicationRequest().getSessionUuid(), request.getApplicationRequest().getLanguage());
            Window.Builder windowBuilder = this.convertWindow(context, request.getUuid(), request.getId(), withTabs);
            responseObserver.onNext((Object)windowBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    public void requestTab(EntityRequest request, StreamObserver<Tab> responseObserver, boolean withFields) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Menu Requested = " + request.getUuid());
            ApplicationRequest applicationInfo = request.getApplicationRequest();
            if (applicationInfo == null || Util.isEmpty((String)applicationInfo.getSessionUuid())) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getApplicationRequest().getSessionUuid(), request.getApplicationRequest().getLanguage());
            Tab.Builder tabBuilder = this.convertTab(context, request.getUuid(), withFields);
            responseObserver.onNext((Object)tabBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private Window.Builder convertWindow(Properties context, String uuid, int id, boolean withTabs) {
        MWindow window = null;
        if (id > 0) {
            window = MWindow.get((Properties)context, (int)id);
        } else if (!Util.isEmpty((String)uuid)) {
            window = (MWindow)new Query(context, "AD_Window", "UUID = ?", null).setParameters(new Object[]{uuid}).setOnlyActiveRecords(true).first();
        }
        if (window == null) {
            return Window.newBuilder();
        }
        return this.convertWindow(context, window, withTabs);
    }

    private Form.Builder convertForm(Properties context, String uuid, int id) {
        String whereClause = null;
        Object parameter = null;
        if (id > 0) {
            whereClause = "AD_Form_ID = ?";
            parameter = id;
        } else if (!Util.isEmpty((String)uuid)) {
            whereClause = "UUID = ?";
            parameter = uuid;
        }
        if (parameter == null) {
            return Form.newBuilder();
        }
        MForm form = (MForm)new Query(context, "AD_Form", whereClause, null).setParameters(new Object[]{parameter}).setOnlyActiveRecords(true).first();
        return this.convertForm(context, form);
    }

    private Form.Builder convertForm(Properties context, MForm form) {
        Form.Builder builder = null;
        builder = Form.newBuilder().setId(form.getAD_Form_ID()).setUuid(ValueUtil.validateNull(form.getUUID())).setName(ValueUtil.validateNull(ValueUtil.getTranslation((PO)form, "Name"))).setDescription(ValueUtil.validateNull(ValueUtil.getTranslation((PO)form, "Description"))).setHelp(ValueUtil.validateNull(ValueUtil.getTranslation((PO)form, "Help"))).setIsActive(form.isActive());
        String fileName = form.getClassname();
        if (!Util.isEmpty((String)fileName)) {
            int endIndex = fileName.lastIndexOf(".");
            int beginIndex = fileName.lastIndexOf("/");
            if (beginIndex == -1) {
                beginIndex = fileName.lastIndexOf(".");
                endIndex = -1;
            }
            beginIndex = beginIndex == -1 ? 0 : ++beginIndex;
            if (endIndex == -1) {
                endIndex = fileName.length();
            }
            builder.setFileName(ValueUtil.validateNull(fileName.substring(beginIndex, endIndex)));
        }
        this.addToRecentItem("X", form.getAD_Form_ID());
        return builder;
    }

    private Window.Builder convertWindow(Properties context, MWindow window, boolean withTabs) {
        window = ASPUtil.getInstance((Properties)context).getWindow(window.getAD_Window_ID());
        Window.Builder builder = null;
        ContextInfo.Builder contextInfoBuilder = this.convertContextInfo(context, window.getAD_ContextInfo_ID());
        builder = Window.newBuilder().setId(window.getAD_Window_ID()).setUuid(ValueUtil.validateNull(window.getUUID())).setName(window.getName()).setDescription(ValueUtil.validateNull(window.getDescription())).setHelp(ValueUtil.validateNull(window.getHelp())).setWindowType(ValueUtil.validateNull(window.getWindowType())).setIsSalesTransaction(window.isSOTrx()).setIsActive(window.isActive());
        if (contextInfoBuilder != null) {
            builder.setContextInfo(contextInfoBuilder.build());
        }
        if (withTabs) {
            ArrayList<Tab.Builder> tabListForGroup = new ArrayList<Tab.Builder>();
            List tabs = ASPUtil.getInstance((Properties)context).getWindowTabs(window.getAD_Window_ID());
            for (MTab tab : tabs) {
                if (!tab.isActive()) continue;
                Tab.Builder tabBuilder = this.convertTab(context, tab, tabs, withTabs);
                builder.addTabs(tabBuilder.build());
                int[] fieldGroupIdArray = this.getFieldGroupIdsFromTab(tab.getAD_Tab_ID());
                if (fieldGroupIdArray == null) continue;
                for (int fieldGroupId : fieldGroupIdArray) {
                    Tab.Builder tabFieldGroup = this.convertTab(context, tab, false);
                    FieldGroup.Builder fieldGroup = this.convertFieldGroup(context, fieldGroupId);
                    tabFieldGroup.setFieldGroup(fieldGroup);
                    tabFieldGroup.setName(fieldGroup.getName());
                    tabListForGroup.add(tabFieldGroup);
                }
            }
            for (Tab.Builder tabFieldGroup : tabListForGroup) {
                builder.addTabs(tabFieldGroup.build());
            }
        }
        this.addToRecentItem("W", window.getAD_Window_ID());
        return builder;
    }

    private void addToRecentItem(String action, int optionId) {
        if (Util.isEmpty((String)action)) {
            return;
        }
        String whereClause = null;
        if (action.equals("W")) {
            whereClause = "AD_Window_ID = ?";
        } else if (action.equals("X")) {
            whereClause = "AD_Form_ID = ?";
        } else if (action.equals("P") || action.equals("R")) {
            whereClause = "AD_Process_ID = ?";
        } else if (action.equals("F")) {
            whereClause = "AD_Workflow_ID = ?";
        } else if (action.equals("S")) {
            whereClause = "AD_Browse_ID = ?";
        }
        int menuId = new Query(Env.getCtx(), "AD_Menu", whereClause, null).setParameters(new Object[]{optionId}).firstId();
        MRecentItem.addMenuOption((Properties)Env.getCtx(), (int)menuId, (int)optionId);
    }

    private int[] getFieldGroupIdsFromTab(int tabId) {
        return DB.getIDsEx(null, (String)"SELECT f.AD_FieldGroup_ID FROM AD_Field f INNER JOIN AD_FieldGroup fg ON(fg.AD_FieldGroup_ID = f.AD_FieldGroup_ID) WHERE f.AD_Tab_ID = ? AND fg.FieldGroupType = ? GROUP BY f.AD_FieldGroup_ID", (Object[])new Object[]{tabId, "T"});
    }

    private Tab.Builder convertTab(Properties context, String uuid, boolean withFields) {
        MTab tab = MTab.get((Properties)context, (int)RecordUtil.getIdFromUuid("AD_Tab", uuid, null));
        return this.convertTab(context, tab, withFields);
    }

    private Process.Builder convertProcess(Properties context, String uuid, int id, boolean withParameters) {
        MProcess process = null;
        if (id > 0) {
            process = MProcess.get((Properties)context, (int)id);
        } else if (!Util.isEmpty((String)uuid)) {
            process = MProcess.get((Properties)context, (int)RecordUtil.getIdFromUuid("AD_Process", uuid, null));
        }
        if (process == null) {
            return Process.newBuilder();
        }
        return this.convertProcess(context, process, withParameters);
    }

    private Browser.Builder convertBrowser(Properties context, String uuid, boolean withFields) {
        MBrowse browser = ASPUtil.getInstance((Properties)context).getBrowse(RecordUtil.getIdFromUuid("AD_Browse", uuid, null));
        return this.convertBrowser(context, browser, withFields);
    }

    private Tab.Builder convertTab(Properties context, MTab tab, boolean withFields) {
        return this.convertTab(context, tab, null, withFields);
    }

    private Tab.Builder convertTab(Properties context, MTab tab, List<MTab> tabs, boolean withFields) {
        List<MProcess> processList;
        MColumn column;
        String parentTabUuid = null;
        int tabId = tab.getAD_Tab_ID();
        int seqNo = tab.getSeqNo();
        int tabLevel = tab.getTabLevel();
        Optional<MTab> currentOptionalTab = ASPUtil.getInstance((Properties)context).getWindowTabs(tab.getAD_Window_ID()).stream().filter(filterTab -> filterTab.getAD_Tab_ID() == tabId).findFirst();
        tab = currentOptionalTab.get();
        MTable table = MTable.get((Properties)context, (int)tab.getAD_Table_ID());
        boolean isReadOnly = tab.isReadOnly() || table.isView();
        int contextInfoId = tab.getAD_ContextInfo_ID();
        if (contextInfoId <= 0) {
            contextInfoId = table.getAD_ContextInfo_ID();
        }
        StringBuffer whereClause = new StringBuffer();
        if (tab.getTabLevel() > 0 && tabs != null) {
            List tabList;
            Optional<MTab> optionalTab = tabs.stream().filter(parentTab -> parentTab.getAD_Tab_ID() != tabId).filter(parentTab -> parentTab.getTabLevel() == 0).findFirst();
            String mainColumnName = null;
            MTable mainTable = null;
            if (optionalTab.isPresent()) {
                mainTable = MTable.get((Properties)context, (int)optionalTab.get().getAD_Table_ID());
                mainColumnName = mainTable.getKeyColumns()[0];
            }
            if ((tabList = tabs.stream().filter(parentTab -> parentTab.getAD_Tab_ID() != tabId).filter(parentTab -> parentTab.getAD_Tab_ID() != ((MTab)optionalTab.get()).getAD_Tab_ID()).filter(parentTab -> parentTab.getSeqNo() < seqNo).filter(parentTab -> parentTab.getTabLevel() < tabLevel).filter(parentTab -> !parentTab.isTranslationTab()).sorted(Comparator.comparing(X_AD_Tab::getSeqNo).thenComparing(X_AD_Tab::getTabLevel).reversed()).collect(Collectors.toList())).size() == 0) {
                if (tab.getParent_Column_ID() != 0) {
                    mainColumnName = MColumn.getColumnName((Properties)context, (int)tab.getParent_Column_ID());
                }
                String childColumn = mainColumnName;
                if (tab.getAD_Column_ID() != 0) {
                    childColumn = MColumn.getColumnName((Properties)context, (int)tab.getAD_Column_ID());
                }
                whereClause.append(table.getTableName()).append(".").append(childColumn).append(" = ").append("@").append(mainColumnName).append("@");
                if (optionalTab.isPresent()) {
                    parentTabUuid = optionalTab.get().getUUID();
                }
            } else {
                whereClause.append("EXISTS(SELECT 1 FROM");
                HashMap<Integer, MTab> tablesMap = new HashMap<Integer, MTab>();
                int aliasIndex = 0;
                boolean firstResult = true;
                for (MTab currentTab : tabList) {
                    tablesMap.put(aliasIndex, currentTab);
                    MTable currentTable = MTable.get((Properties)context, (int)currentTab.getAD_Table_ID());
                    if (firstResult) {
                        whereClause.append(" ").append(currentTable.getTableName()).append(" AS t").append(aliasIndex);
                        firstResult = false;
                    } else {
                        MTab childTab = (MTab)tablesMap.get(aliasIndex - 1);
                        String childColumnName = this.getParentColumnNameFromTab(childTab);
                        String childLinkColumnName = this.getLinkColumnNameFromTab(childTab);
                        if (Util.isEmpty((String)childColumnName)) {
                            MTable childTable = MTable.get((Properties)context, (int)currentTab.getAD_Table_ID());
                            childColumnName = childTable.getKeyColumns()[0];
                        }
                        if (Util.isEmpty((String)childLinkColumnName)) {
                            childLinkColumnName = childColumnName;
                        }
                        whereClause.append(" INNER JOIN ").append(currentTable.getTableName()).append(" AS t").append(aliasIndex).append(" ON(").append("t").append(aliasIndex).append(".").append(childLinkColumnName).append("=").append("t").append(aliasIndex - 1).append(".").append(childColumnName).append(")");
                    }
                    ++aliasIndex;
                    if (!Util.isEmpty((String)parentTabUuid)) continue;
                    parentTabUuid = currentTab.getUUID();
                }
                whereClause.append(" WHERE t").append(aliasIndex - 1).append(".").append(mainColumnName).append(" = ").append("@").append(mainColumnName).append("@");
                MTab parentTab2 = (MTab)tablesMap.get(aliasIndex - 1);
                String parentColumnName = this.getParentColumnNameFromTab(tab);
                String linkColumnName = this.getLinkColumnNameFromTab(tab);
                if (Util.isEmpty((String)parentColumnName)) {
                    MTable parentTable = MTable.get((Properties)context, (int)parentTab2.getAD_Table_ID());
                    parentColumnName = parentTable.getKeyColumns()[0];
                }
                if (Util.isEmpty((String)linkColumnName)) {
                    linkColumnName = parentColumnName;
                }
                whereClause.append(" AND t").append(0).append(".").append(parentColumnName).append(" = ").append(table.getTableName()).append(".").append(linkColumnName);
                whereClause.append(")");
            }
        }
        if (whereClause.length() > 0) {
            if (!Util.isEmpty((String)tab.getWhereClause())) {
                whereClause.append(" AND ").append("(").append(tab.getWhereClause()).append(")");
            }
        } else {
            whereClause.append(ValueUtil.validateNull(tab.getWhereClause()));
        }
        Tab.Builder builder = Tab.newBuilder().setId(tab.getAD_Tab_ID()).setUuid(ValueUtil.validateNull(tab.getUUID())).setName(ValueUtil.validateNull(tab.getName())).setDescription(ValueUtil.validateNull(tab.getDescription())).setHelp(ValueUtil.validateNull(tab.getHelp())).setAccessLevel(Integer.parseInt(table.getAccessLevel())).setCommitWarning(ValueUtil.validateNull(tab.getCommitWarning())).setSequence(tab.getSeqNo()).setDisplayLogic(ValueUtil.validateNull(tab.getDisplayLogic())).setIsAdvancedTab(tab.isAdvancedTab()).setIsDeleteable(table.isDeleteable()).setIsDocument(table.isDocument()).setIsHasTree(tab.isHasTree()).setIsInfoTab(tab.isInfoTab()).setIsInsertRecord(!isReadOnly && tab.isInsertRecord()).setIsReadOnly(isReadOnly).setIsSingleRow(tab.isSingleRow()).setIsSortTab(tab.isSortTab()).setIsTranslationTab(tab.isTranslationTab()).setIsView(table.isView()).setTabLevel(tab.getTabLevel()).setTableName(ValueUtil.validateNull(table.getTableName())).setParentTabUuid(ValueUtil.validateNull(parentTabUuid)).setIsChangeLog(table.isChangeLog()).setIsActive(tab.isActive()).addAllContextColumnNames(DictionaryUtil.getContextColumnNames(Optional.ofNullable(whereClause.toString()).orElse("") + Optional.ofNullable(tab.getOrderByClause()).orElse("")));
        if (contextInfoId > 0) {
            ContextInfo.Builder contextInfoBuilder = this.convertContextInfo(context, contextInfoId);
            builder.setContextInfo(contextInfoBuilder.build());
        }
        if (tab.getParent_Column_ID() > 0) {
            column = MColumn.get((Properties)context, (int)tab.getParent_Column_ID());
            builder.setParentColumnName(column.getColumnName());
        }
        if (tab.getAD_Column_ID() > 0) {
            column = MColumn.get((Properties)context, (int)tab.getAD_Column_ID());
            builder.setLinkColumnName(column.getColumnName());
        }
        if (tab.isSortTab()) {
            if (tab.getAD_ColumnSortOrder_ID() > 0) {
                column = MColumn.get((Properties)context, (int)tab.getAD_ColumnSortOrder_ID());
                builder.setSortOrderColumnName(column.getColumnName());
            }
            if (tab.getAD_ColumnSortYesNo_ID() > 0) {
                column = MColumn.get((Properties)context, (int)tab.getAD_ColumnSortYesNo_ID());
                builder.setSortYesNoColumnName(column.getColumnName());
            }
        }
        if ((processList = this.getProcessActionFromTab(context, tab)) != null && processList.size() > 0) {
            for (MProcess process : processList) {
                Process.Builder processBuilder = this.convertProcess(context, process, true);
                builder.addProcesses(processBuilder.build());
            }
        }
        if (withFields) {
            for (MField field : ASPUtil.getInstance((Properties)context).getWindowFields(tab.getAD_Tab_ID())) {
                Field.Builder fieldBuilder = this.convertField(context, field, false);
                builder.addFields(fieldBuilder.build());
            }
        }
        return builder;
    }

    private String getParentColumnNameFromTab(MTab tab) {
        String parentColumnName = null;
        if (tab.getParent_Column_ID() != 0) {
            parentColumnName = MColumn.getColumnName((Properties)tab.getCtx(), (int)tab.getParent_Column_ID());
        }
        return parentColumnName;
    }

    private String getLinkColumnNameFromTab(MTab tab) {
        String parentColumnName = null;
        if (tab.getAD_Column_ID() != 0) {
            parentColumnName = MColumn.getColumnName((Properties)tab.getCtx(), (int)tab.getAD_Column_ID());
        }
        return parentColumnName;
    }

    private ContextInfo.Builder convertContextInfo(Properties context, int contextInfoId) {
        ContextInfo.Builder builder = null;
        if (contextInfoId > 0) {
            MADContextInfo contextInfoValue = MADContextInfo.getById((Properties)context, (int)contextInfoId);
            MMessage message = MMessage.get((Properties)context, (int)contextInfoValue.getAD_Message_ID());
            String msgText = null;
            String msgTip = null;
            String language = Env.getAD_Language((Properties)context);
            if (!Util.isEmpty((String)language)) {
                msgText = message.get_Translation("MsgText", language);
                msgTip = message.get_Translation("MsgTip", language);
            }
            if (Util.isEmpty(msgText)) {
                msgText = message.getMsgText();
            }
            if (Util.isEmpty(msgTip)) {
                msgTip = message.getMsgTip();
            }
            MessageText messageText = MessageText.newBuilder().setId(message.getAD_Message_ID()).setUuid(ValueUtil.validateNull(message.getUUID())).setValue(ValueUtil.validateNull(message.getValue())).setMessageText(ValueUtil.validateNull(msgText)).setMessageTip(ValueUtil.validateNull(msgTip)).build();
            builder = ContextInfo.newBuilder().setId(contextInfoValue.getAD_ContextInfo_ID()).setUuid(ValueUtil.validateNull(contextInfoValue.getUUID())).setName(ValueUtil.validateNull(contextInfoValue.getName())).setDescription(ValueUtil.validateNull(contextInfoValue.getDescription())).setMessageText(messageText).setSqlStatement(ValueUtil.validateNull(contextInfoValue.getSQLStatement()));
        }
        return builder;
    }

    private Process.Builder convertProcess(Properties context, MProcess process, boolean withParams) {
        process = ASPUtil.getInstance((Properties)context).getProcess(process.getAD_Process_ID());
        Process.Builder builder = Process.newBuilder().setId(process.getAD_Process_ID()).setUuid(ValueUtil.validateNull(process.getUUID())).setValue(ValueUtil.validateNull(process.getValue())).setName(ValueUtil.validateNull(process.getName())).setDescription(ValueUtil.validateNull(process.getDescription())).setHelp(ValueUtil.validateNull(process.getHelp())).setAccessLevel(Integer.parseInt(process.getAccessLevel())).setIsDirectPrint(process.isDirectPrint()).setIsReport(process.isReport()).setIsActive(process.isActive());
        if (process.isReport()) {
            MReportView reportView = null;
            if (process.getAD_ReportView_ID() > 0) {
                reportView = MReportView.get((Properties)context, (int)process.getAD_ReportView_ID());
            }
            ReportExportHandler exportHandler = new ReportExportHandler(Env.getCtx(), reportView);
            for (AbstractExportFormat reportType : exportHandler.getExportFormatList()) {
                ReportExportType.Builder reportExportType = ReportExportType.newBuilder();
                reportExportType.setName(ValueUtil.validateNull(reportType.getName()));
                reportExportType.setDescription(ValueUtil.validateNull(reportType.getName()));
                reportExportType.setType(ValueUtil.validateNull(reportType.getExtension()));
                builder.addReportExportTypes(reportExportType.build());
            }
        }
        if (withParams) {
            for (MProcessPara parameter : ASPUtil.getInstance((Properties)context).getProcessParameters(process.getAD_Process_ID())) {
                Field.Builder fieldBuilder = this.convertProcessParameter(context, parameter);
                builder.addParameters(fieldBuilder.build());
            }
        }
        return builder;
    }

    private Browser.Builder convertBrowser(Properties context, MBrowse browser, boolean withFields) {
        String query = DictionaryUtil.addQueryReferencesFromBrowser(browser);
        String orderByClause = DictionaryUtil.getSQLOrderBy(browser);
        Browser.Builder builder = Browser.newBuilder().setId(browser.getAD_Process_ID()).setUuid(ValueUtil.validateNull(browser.getUUID())).setValue(ValueUtil.validateNull(browser.getValue())).setName(browser.getName()).setDescription(ValueUtil.validateNull(browser.getDescription())).setHelp(ValueUtil.validateNull(browser.getHelp())).setAccessLevel(Integer.parseInt(browser.getAccessLevel())).setIsActive(browser.isActive()).setIsCollapsibleByDefault(browser.isCollapsibleByDefault()).setIsDeleteable(browser.isDeleteable()).setIsExecutedQueryByDefault(browser.isExecutedQueryByDefault()).setIsSelectedByDefault(browser.isSelectedByDefault()).setIsShowTotal(browser.isShowTotal()).setIsUpdateable(browser.isUpdateable()).addAllContextColumnNames(DictionaryUtil.getContextColumnNames(Optional.ofNullable(query).orElse("") + Optional.ofNullable(browser.getWhereClause()).orElse("") + Optional.ofNullable(orderByClause).orElse("")));
        if (browser.getAD_View_ID() > 0) {
            builder.setViewUuid(ValueUtil.validateNull(browser.getAD_View().getUUID()));
        }
        if (browser.getAD_Window_ID() > 0) {
            MWindow window = new MWindow(context, browser.getAD_Window_ID(), null);
            Window.Builder windowBuilder = this.convertWindow(context, window, false);
            builder.setWindow(windowBuilder.build());
        }
        if (browser.getAD_Process_ID() > 0) {
            Process.Builder processBuilder = this.convertProcess(context, MProcess.get((Properties)context, (int)browser.getAD_Process_ID()), false);
            builder.setProcess(processBuilder.build());
        }
        if (withFields) {
            for (MBrowseField field : ASPUtil.getInstance((Properties)context).getBrowseFields(browser.getAD_Browse_ID())) {
                Field.Builder fieldBuilder = this.convertBrowseField(context, field);
                builder.addFields(fieldBuilder.build());
            }
        }
        this.addToRecentItem("S", browser.getAD_Window_ID());
        return builder;
    }

    private List<MProcess> getProcessActionFromTab(Properties context, MTab tab) {
        ArrayList<MProcess> processList = new ArrayList<MProcess>();
        if (tab.getAD_Process_ID() > 0) {
            processList.add(MProcess.get((Properties)context, (int)tab.getAD_Process_ID()));
        }
        List processFromTabList = new Query(tab.getCtx(), "AD_Process", "EXISTS(SELECT 1 FROM AD_Field f INNER JOIN AD_Column c ON(c.AD_Column_ID = f.AD_Column_ID) WHERE c.AD_Process_ID = AD_Process.AD_Process_ID AND f.AD_Tab_ID = ? AND f.IsActive = 'Y')", null).setParameters(new Object[]{tab.getAD_Tab_ID()}).setOnlyActiveRecords(true).list();
        for (MProcess process : processFromTabList) {
            processList.add(process);
        }
        List processFromTableList = new Query(tab.getCtx(), "AD_Process", "EXISTS(SELECT 1 FROM AD_Table_Process WHERE AD_Process_ID = AD_Process.AD_Process_ID AND AD_Table_ID = ?)", null).setParameters(new Object[]{tab.getAD_Table_ID()}).setOnlyActiveRecords(true).list();
        for (MProcess process : processFromTableList) {
            processList.add(process);
        }
        return processList;
    }

    private Field.Builder convertProcessParameter(Properties context, MProcessPara processParameter) {
        Field.Builder builder = Field.newBuilder().setId(processParameter.getAD_Process_Para_ID()).setUuid(ValueUtil.validateNull(processParameter.getUUID())).setName(ValueUtil.validateNull(processParameter.getName())).setDescription(ValueUtil.validateNull(processParameter.getDescription())).setHelp(ValueUtil.validateNull(processParameter.getHelp())).setColumnName(ValueUtil.validateNull(processParameter.getColumnName())).setElementName(ValueUtil.validateNull(processParameter.getColumnName())).setDefaultValue(ValueUtil.validateNull(processParameter.getDefaultValue())).setDefaultValueTo(ValueUtil.validateNull(processParameter.getDefaultValue2())).setDisplayLogic(ValueUtil.validateNull(processParameter.getDisplayLogic())).setDisplayType(processParameter.getAD_Reference_ID()).setIsDisplayed(true).setIsInfoOnly(processParameter.isInfoOnly()).setIsMandatory(processParameter.isMandatory()).setIsRange(processParameter.isRange()).setReadOnlyLogic(ValueUtil.validateNull(processParameter.getReadOnlyLogic())).setSequence(processParameter.getSeqNo()).setValueMax(ValueUtil.validateNull(processParameter.getValueMax())).setValueMin(ValueUtil.validateNull(processParameter.getValueMin())).setVFormat(ValueUtil.validateNull(processParameter.getVFormat())).setFieldLength(processParameter.getFieldLength()).setIsActive(processParameter.isActive());
        int displayTypeId = processParameter.getAD_Reference_ID();
        if (DisplayType.isLookup((int)displayTypeId)) {
            int referenceValueId = processParameter.getAD_Reference_Value_ID();
            int validationRuleId = processParameter.getAD_Val_Rule_ID();
            String validationCode = null;
            if (validationRuleId > 0) {
                MValRule validationRule = MValRule.get((Properties)context, (int)validationRuleId);
                validationCode = validationRule.getCode();
            }
            String columnName = processParameter.getColumnName();
            if (processParameter.getAD_Element_ID() > 0) {
                columnName = processParameter.getAD_Element().getColumnName();
            }
            MLookupInfo info = MLookupFactory.getLookupInfo((Properties)context, (int)0, (int)0, (int)displayTypeId, (Language)Language.getLanguage((String)Env.getAD_Language((Properties)context)), (String)columnName, (int)referenceValueId, (boolean)false, (String)validationCode, (boolean)false);
            Reference.Builder referenceBuilder = this.convertReference(context, info);
            builder.setReference(referenceBuilder.build());
        }
        return builder;
    }

    private Field.Builder convertBrowseField(Properties context, MBrowseField browseField) {
        Field.Builder builder = Field.newBuilder().setId(browseField.getAD_Browse_Field_ID()).setUuid(ValueUtil.validateNull(browseField.getUUID())).setName(ValueUtil.validateNull(browseField.getName())).setDescription(ValueUtil.validateNull(browseField.getDescription())).setHelp(ValueUtil.validateNull(browseField.getHelp())).setDefaultValue(ValueUtil.validateNull(browseField.getDefaultValue())).setDefaultValueTo(ValueUtil.validateNull(browseField.getDefaultValue2())).setDisplayLogic(ValueUtil.validateNull(browseField.getDisplayLogic())).setDisplayType(browseField.getAD_Reference_ID()).setIsDisplayed(browseField.isDisplayed()).setIsQueryCriteria(browseField.isQueryCriteria()).setIsOrderBy(browseField.isOrderBy()).setIsInfoOnly(browseField.isInfoOnly()).setIsMandatory(browseField.isMandatory()).setIsRange(browseField.isRange()).setIsReadOnly(browseField.isReadOnly()).setReadOnlyLogic(ValueUtil.validateNull(browseField.getReadOnlyLogic())).setIsKey(browseField.isKey()).setIsIdentifier(browseField.isIdentifier()).setSeqNoGrid(browseField.getSeqNoGrid()).setSequence(browseField.getSeqNo()).setValueMax(ValueUtil.validateNull(browseField.getValueMax())).setValueMin(ValueUtil.validateNull(browseField.getValueMin())).setVFormat(ValueUtil.validateNull(browseField.getVFormat())).setIsActive(browseField.isActive()).setCallout(ValueUtil.validateNull(browseField.getCallout())).setFieldLength(browseField.getFieldLength());
        builder.setColumnName(ValueUtil.validateNull(browseField.getAD_View_Column().getColumnName()));
        String elementName = null;
        if (browseField.getAD_View_Column().getAD_Column_ID() != 0) {
            MColumn column = MColumn.get((Properties)context, (int)browseField.getAD_View_Column().getAD_Column_ID());
            elementName = column.getColumnName();
        }
        if (Util.isEmpty(elementName)) {
            elementName = browseField.getAD_Element().getColumnName();
        }
        builder.setElementName(ValueUtil.validateNull(elementName));
        int displayTypeId = browseField.getAD_Reference_ID();
        if (DisplayType.isLookup((int)displayTypeId)) {
            MLookupInfo info;
            int referenceValueId = browseField.getAD_Reference_Value_ID();
            int validationRuleId = browseField.getAD_Val_Rule_ID();
            String validationCode = null;
            if (validationRuleId > 0) {
                MValRule validationRule = MValRule.get((Properties)context, (int)validationRuleId);
                validationCode = validationRule.getCode();
            }
            String columnName = browseField.getAD_Element().getColumnName();
            if (browseField.getAD_View_Column().getAD_Column_ID() > 0) {
                columnName = browseField.getAD_View_Column().getAD_Column().getColumnName();
            }
            if ((info = MLookupFactory.getLookupInfo((Properties)context, (int)0, (int)0, (int)displayTypeId, (Language)Language.getLanguage((String)Env.getAD_Language((Properties)context)), (String)columnName, (int)referenceValueId, (boolean)false, (String)validationCode, (boolean)false)) != null) {
                Reference.Builder referenceBuilder = this.convertReference(context, info);
                builder.setReference(referenceBuilder.build());
            } else {
                builder.setDisplayType(10);
            }
        }
        return builder;
    }

    private Field.Builder convertField(Properties context, FieldRequest request) {
        MTable table;
        Field.Builder builder = Field.newBuilder();
        if (!Util.isEmpty((String)request.getFieldUuid())) {
            builder = this.convertField(context, request.getFieldUuid());
        } else if (!Util.isEmpty((String)request.getColumnUuid())) {
            MColumn column = (MColumn)new Query(context, "AD_Column", "UUID = ?", null).setParameters(new Object[]{request.getColumnUuid()}).setOnlyActiveRecords(true).first();
            builder = this.convertField(context, column);
        } else if (!Util.isEmpty((String)request.getElementUuid())) {
            M_Element element = (M_Element)new Query(context, "AD_Element", "UUID = ?", null).setParameters(new Object[]{request.getElementUuid()}).setOnlyActiveRecords(true).first();
            builder = this.convertField(context, element);
        } else if (!Util.isEmpty((String)request.getElementColumnName())) {
            M_Element element = (M_Element)new Query(context, "AD_Element", "ColumnName = ?", null).setParameters(new Object[]{request.getElementColumnName()}).setOnlyActiveRecords(true).first();
            builder = this.convertField(context, element);
        } else if (!Util.isEmpty((String)request.getTableName()) && !Util.isEmpty((String)request.getColumnName()) && (table = MTable.get((Properties)context, (String)request.getTableName())) != null) {
            MColumn column = table.getColumn(request.getColumnName());
            builder = this.convertField(context, column);
        }
        return builder;
    }

    private Field.Builder convertField(Properties context, String uuid) {
        Optional<MField> maybeField;
        MField field = (MField)new Query(context, "AD_Field", "AD_Field_ID = ?", null).setParameters(new Object[]{RecordUtil.getIdFromUuid("AD_Field", uuid, null)}).setOnlyActiveRecords(true).first();
        int fieldId = field.getAD_Field_ID();
        List customFields = ASPUtil.getInstance((Properties)context).getWindowFields(field.getAD_Tab_ID());
        if (customFields != null && (maybeField = customFields.stream().filter(customField -> customField.getAD_Field_ID() == fieldId).findFirst()).isPresent()) {
            field = maybeField.get();
        }
        return this.convertField(context, field, true);
    }

    private Field.Builder convertField(Properties context, MColumn column) {
        String defaultValue = column.getDefaultValue();
        if (Util.isEmpty((String)defaultValue)) {
            defaultValue = column.getDefaultValue();
        }
        int displayTypeId = column.getAD_Reference_ID();
        Field.Builder builder = Field.newBuilder().setId(column.getAD_Column_ID()).setUuid(ValueUtil.validateNull(column.getUUID())).setName(ValueUtil.validateNull(column.getName())).setDescription(ValueUtil.validateNull(column.getDescription())).setHelp(ValueUtil.validateNull(column.getHelp())).setCallout(ValueUtil.validateNull(column.getCallout())).setColumnName(ValueUtil.validateNull(column.getColumnName())).setElementName(ValueUtil.validateNull(column.getColumnName())).setColumnSql(ValueUtil.validateNull(column.getColumnSQL())).setDefaultValue(ValueUtil.validateNull(defaultValue)).setDisplayType(displayTypeId).setFormatPattern(ValueUtil.validateNull(column.getFormatPattern())).setIdentifierSequence(column.getSeqNo()).setIsAllowCopy(column.isAllowCopy()).setIsAllowLogging(column.isAllowLogging()).setIsAlwaysUpdateable(column.isAlwaysUpdateable()).setIsEncrypted(column.isEncrypted()).setIsIdentifier(column.isIdentifier()).setIsKey(column.isKey()).setIsMandatory(column.isMandatory()).setIsParent(column.isParent()).setIsRange(column.isRange()).setIsSelectionColumn(column.isSelectionColumn()).setIsTranslated(column.isTranslated()).setIsUpdateable(column.isUpdateable()).setMandatoryLogic(ValueUtil.validateNull(column.getMandatoryLogic())).setReadOnlyLogic(ValueUtil.validateNull(column.getReadOnlyLogic())).setSequence(column.getSeqNo()).setValueMax(ValueUtil.validateNull(column.getValueMax())).setValueMin(ValueUtil.validateNull(column.getValueMin())).setFieldLength(column.getFieldLength()).setIsActive(column.isActive());
        if (column.getAD_Process_ID() > 0) {
            MProcess process = MProcess.get((Properties)context, (int)column.getAD_Process_ID());
            Process.Builder processBuilder = this.convertProcess(context, process, false);
            builder.setProcess(processBuilder.build());
        }
        if (DisplayType.isLookup((int)displayTypeId)) {
            MLookupInfo info;
            int referenceValueId = column.getAD_Reference_Value_ID();
            if (column.getAD_Reference_Value_ID() > 0) {
                referenceValueId = column.getAD_Reference_Value_ID();
            }
            int validationRuleId = column.getAD_Val_Rule_ID();
            String validationCode = null;
            if (validationRuleId > 0) {
                MValRule validationRule = MValRule.get((Properties)context, (int)validationRuleId);
                validationCode = validationRule.getCode();
            }
            if ((info = MLookupFactory.getLookupInfo((Properties)context, (int)0, (int)column.getAD_Column_ID(), (int)displayTypeId, (Language)Language.getLanguage((String)Env.getAD_Language((Properties)context)), (String)column.getColumnName(), (int)referenceValueId, (boolean)false, (String)validationCode, (boolean)false)) != null) {
                Reference.Builder referenceBuilder = this.convertReference(context, info);
                builder.setReference(referenceBuilder.build());
            } else {
                builder.setDisplayType(10);
            }
        }
        return builder;
    }

    private Field.Builder convertField(Properties context, M_Element element) {
        int displayTypeId = element.getAD_Reference_ID();
        if (element.getAD_Reference_ID() > 0) {
            displayTypeId = element.getAD_Reference_ID();
        }
        Field.Builder builder = Field.newBuilder().setId(element.getAD_Element_ID()).setUuid(ValueUtil.validateNull(element.getUUID())).setName(ValueUtil.validateNull(ValueUtil.getTranslation((PO)element, "Name"))).setDescription(ValueUtil.validateNull(ValueUtil.getTranslation((PO)element, "Description"))).setHelp(ValueUtil.validateNull(ValueUtil.getTranslation((PO)element, "Help"))).setColumnName(ValueUtil.validateNull(element.getColumnName())).setElementName(ValueUtil.validateNull(element.getColumnName())).setDisplayType(displayTypeId).setFieldLength(element.getFieldLength()).setIsActive(element.isActive());
        if (DisplayType.isLookup((int)displayTypeId)) {
            MLookupInfo info;
            int referenceValueId = element.getAD_Reference_Value_ID();
            if (element.getAD_Reference_Value_ID() > 0) {
                referenceValueId = element.getAD_Reference_Value_ID();
            }
            if ((info = MLookupFactory.getLookupInfo((Properties)context, (int)0, (int)element.getAD_Element_ID(), (int)displayTypeId, (Language)Language.getLanguage((String)Env.getAD_Language((Properties)context)), (String)element.getColumnName(), (int)referenceValueId, (boolean)false, null, (boolean)false)) != null) {
                Reference.Builder referenceBuilder = this.convertReference(context, info);
                builder.setReference(referenceBuilder.build());
            } else {
                builder.setDisplayType(10);
            }
        }
        return builder;
    }

    private Field.Builder convertField(Properties context, MField field, boolean translate) {
        MColumn column = MColumn.get((Properties)context, (int)field.getAD_Column_ID());
        String defaultValue = field.getDefaultValue();
        if (Util.isEmpty((String)defaultValue)) {
            defaultValue = column.getDefaultValue();
        }
        int displayTypeId = column.getAD_Reference_ID();
        if (field.getAD_Reference_ID() > 0) {
            displayTypeId = field.getAD_Reference_ID();
        }
        boolean isMandatory = column.isMandatory();
        if (!Util.isEmpty((String)field.getIsMandatory())) {
            isMandatory = !Util.isEmpty((String)field.getIsMandatory()) && field.getIsMandatory().equals("Y");
        }
        Field.Builder builder = Field.newBuilder().setId(field.getAD_Field_ID()).setUuid(ValueUtil.validateNull(field.getUUID())).setName(ValueUtil.validateNull(field.getName())).setDescription(ValueUtil.validateNull(field.getDescription())).setHelp(ValueUtil.validateNull(field.getHelp())).setCallout(ValueUtil.validateNull(column.getCallout())).setColumnName(ValueUtil.validateNull(column.getColumnName())).setElementName(ValueUtil.validateNull(column.getColumnName())).setColumnSql(ValueUtil.validateNull(column.getColumnSQL())).setDefaultValue(ValueUtil.validateNull(defaultValue)).setDisplayLogic(ValueUtil.validateNull(field.getDisplayLogic())).setDisplayType(displayTypeId).setFormatPattern(ValueUtil.validateNull(column.getFormatPattern())).setIdentifierSequence(column.getSeqNo()).setIsAllowCopy(field.isAllowCopy()).setIsAllowLogging(column.isAllowLogging()).setIsDisplayed(field.isDisplayed()).setIsAlwaysUpdateable(column.isAlwaysUpdateable()).setIsDisplayedGrid(field.isDisplayedGrid()).setIsEncrypted(field.isEncrypted() || column.isEncrypted()).setIsFieldOnly(field.isFieldOnly()).setIsHeading(field.isHeading()).setIsIdentifier(column.isIdentifier()).setIsKey(column.isKey()).setIsMandatory(isMandatory).setIsParent(column.isParent()).setIsQuickEntry(field.isQuickEntry()).setIsRange(column.isRange()).setIsReadOnly(field.isReadOnly()).setIsSameLine(field.isSameLine()).setIsSelectionColumn(column.isSelectionColumn()).setIsTranslated(column.isTranslated()).setIsUpdateable(column.isUpdateable()).setMandatoryLogic(ValueUtil.validateNull(column.getMandatoryLogic())).setReadOnlyLogic(ValueUtil.validateNull(column.getReadOnlyLogic())).setSequence(field.getSeqNo()).setValueMax(ValueUtil.validateNull(column.getValueMax())).setValueMin(ValueUtil.validateNull(column.getValueMin())).setFieldLength(column.getFieldLength()).setIsActive(field.isActive());
        if (field.getAD_ContextInfo_ID() > 0) {
            ContextInfo.Builder contextInfoBuilder = this.convertContextInfo(context, field.getAD_ContextInfo_ID());
            builder.setContextInfo(contextInfoBuilder.build());
        }
        if (column.getAD_Process_ID() > 0) {
            MProcess process = MProcess.get((Properties)context, (int)column.getAD_Process_ID());
            Process.Builder processBuilder = this.convertProcess(context, process, false);
            builder.setProcess(processBuilder.build());
        }
        if (DisplayType.isLookup((int)displayTypeId)) {
            MLookupInfo info;
            int referenceValueId = column.getAD_Reference_Value_ID();
            if (field.getAD_Reference_Value_ID() > 0) {
                referenceValueId = field.getAD_Reference_Value_ID();
            }
            int validationRuleId = column.getAD_Val_Rule_ID();
            if (field.getAD_Val_Rule_ID() > 0) {
                validationRuleId = field.getAD_Val_Rule_ID();
            }
            String validationCode = null;
            if (validationRuleId > 0) {
                MValRule validationRule = MValRule.get((Properties)context, (int)validationRuleId);
                validationCode = validationRule.getCode();
            }
            if ((info = MLookupFactory.getLookupInfo((Properties)context, (int)0, (int)column.getAD_Column_ID(), (int)displayTypeId, (Language)Language.getLanguage((String)Env.getAD_Language((Properties)context)), (String)column.getColumnName(), (int)referenceValueId, (boolean)false, (String)validationCode, (boolean)false)) != null) {
                Reference.Builder referenceBuilder = this.convertReference(context, info);
                builder.setReference(referenceBuilder.build());
            } else {
                builder.setDisplayType(10);
            }
        }
        if (field.getAD_FieldDefinition_ID() > 0) {
            FieldDefinition.Builder fieldDefinitionBuilder = this.convertFieldDefinition(context, field.getAD_FieldDefinition_ID());
            builder.setFieldDefinition(fieldDefinitionBuilder);
        }
        if (field.getAD_FieldGroup_ID() > 0) {
            FieldGroup.Builder fieldGroup = this.convertFieldGroup(context, field.getAD_FieldGroup_ID());
            builder.setFieldGroup(fieldGroup.build());
        }
        return builder;
    }

    private FieldDefinition.Builder convertFieldDefinition(Properties context, int fieldDefinitionId) {
        FieldDefinition.Builder builder = null;
        if (fieldDefinitionId > 0) {
            MADFieldDefinition fieldDefinition = new MADFieldDefinition(context, fieldDefinitionId, null);
            builder = FieldDefinition.newBuilder().setId(fieldDefinition.getAD_FieldDefinition_ID()).setUuid(ValueUtil.validateNull(fieldDefinition.getUUID())).setValue(ValueUtil.validateNull(fieldDefinition.getValue())).setName(ValueUtil.validateNull(fieldDefinition.getName()));
            for (MADFieldCondition condition : fieldDefinition.getConditions()) {
                if (!condition.isActive()) continue;
                FieldCondition.Builder fieldConditionBuilder = FieldCondition.newBuilder().setId(fieldDefinition.getAD_FieldDefinition_ID()).setUuid(ValueUtil.validateNull(condition.getUUID())).setCondition(ValueUtil.validateNull(condition.getCondition())).setStylesheet(ValueUtil.validateNull(condition.getStylesheet())).setIsActive(fieldDefinition.isActive());
                builder.addConditions(fieldConditionBuilder);
            }
        }
        return builder;
    }

    private FieldGroup.Builder convertFieldGroup(Properties context, int fieldGroupId) {
        FieldGroup.Builder builder = null;
        if (fieldGroupId > 0) {
            X_AD_FieldGroup fieldGroup = new X_AD_FieldGroup(context, fieldGroupId, null);
            String name = null;
            String language = Env.getAD_Language((Properties)context);
            if (!Util.isEmpty((String)language)) {
                name = fieldGroup.get_Translation("Name", language);
            }
            if (Util.isEmpty(name)) {
                name = fieldGroup.getName();
            }
            builder = FieldGroup.newBuilder().setId(fieldGroup.getAD_FieldGroup_ID()).setUuid(ValueUtil.validateNull(fieldGroup.getUUID())).setName(ValueUtil.validateNull(name)).setFieldGroupType(fieldGroup.getFieldGroupType()).setIsActive(fieldGroup.isActive());
        }
        return builder;
    }

    private Reference.Builder convertReference(Properties context, ReferenceRequest request) {
        MLookupInfo info;
        Reference.Builder builder = Reference.newBuilder();
        if (!Util.isEmpty((String)request.getReferenceUuid())) {
            MLookupInfo info2;
            X_AD_Reference reference = (X_AD_Reference)new Query(context, "AD_Reference", "UUID = ?", null).setParameters(new Object[]{request.getReferenceUuid()}).first();
            if (reference.getValidationType().equals("T")) {
                MLookupInfo info3 = MLookupFactory.getLookupInfo((Properties)context, (int)0, (int)0, (int)30, (Language)Language.getLanguage((String)Env.getAD_Language((Properties)context)), null, (int)reference.getAD_Reference_ID(), (boolean)false, null, (boolean)false);
                if (info3 != null) {
                    builder = this.convertReference(context, info3);
                }
            } else if (reference.getValidationType().equals("L") && (info2 = MLookupFactory.getLookup_List((Language)Language.getLanguage((String)Env.getAD_Language((Properties)context)), (int)reference.getAD_Reference_ID())) != null) {
                builder = this.convertReference(context, info2);
            }
        } else if (!Util.isEmpty((String)request.getColumnName()) && (info = MLookupFactory.getLookupInfo((Properties)context, (int)0, (int)0, (int)19, (Language)Language.getLanguage((String)Env.getAD_Language((Properties)context)), (String)request.getColumnName(), (int)0, (boolean)false, null, (boolean)false)) != null) {
            builder = this.convertReference(context, info);
        }
        return builder;
    }

    private ValidationRule.Builder convertValidationRule(Properties context, EntityRequest request) {
        MValRule validationRule = null;
        validationRule = request.getId() > 0 ? MValRule.get((Properties)context, (int)request.getId()) : (MValRule)new Query(context, "AD_Val_Rule", "UUID = ?", null).setParameters(new Object[]{request.getUuid()}).first();
        return ValidationRule.newBuilder().setId(validationRule.getAD_Val_Rule_ID()).setUuid(ValueUtil.validateNull(validationRule.getUUID())).setName(ValueUtil.validateNull(validationRule.getName())).setDescription(ValueUtil.validateNull(validationRule.getDescription())).setValidationCode(ValueUtil.validateNull(validationRule.getCode())).setType(ValueUtil.validateNull(validationRule.getType()));
    }

    private Reference.Builder convertReference(Properties context, MLookupInfo info) {
        Reference.Builder builder = Reference.newBuilder().setTableName(ValueUtil.validateNull(info.TableName)).setKeyColumnName(ValueUtil.validateNull(info.KeyColumn)).setDisplayColumnName(ValueUtil.validateNull(info.DisplayColumn)).addAllContextColumnNames(DictionaryUtil.getContextColumnNames(Optional.ofNullable(info.QueryDirect).orElse("") + Optional.ofNullable(info.Query).orElse("") + Optional.ofNullable(info.ValidationCode).orElse("")));
        if (info.ZoomWindow > 0) {
            builder.addZoomWindows(this.convertZoomWindow(context, info.ZoomWindow).build());
        }
        if (info.ZoomWindowPO > 0) {
            builder.addZoomWindows(this.convertZoomWindow(context, info.ZoomWindowPO).build());
        }
        return builder;
    }

    private ZoomWindow.Builder convertZoomWindow(Properties context, int windowId) {
        MWindow window = new MWindow(context, windowId, null);
        String name = null;
        String description = null;
        String language = Env.getAD_Language((Properties)context);
        if (!Util.isEmpty((String)language)) {
            name = window.get_Translation("Name", language);
            description = window.get_Translation("Description", language);
        }
        if (Util.isEmpty(name)) {
            name = window.getName();
        }
        if (Util.isEmpty(description)) {
            description = window.getDescription();
        }
        return ZoomWindow.newBuilder().setId(window.getAD_Window_ID()).setUuid(ValueUtil.validateNull(window.getUUID())).setName(ValueUtil.validateNull(name)).setDescription(ValueUtil.validateNull(description)).setIsSalesTransaction(window.isSOTrx());
    }
}

