/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.IDocumentStatus;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MDocumentStatus;
import org.compiere.model.MChart;
import org.compiere.model.MColorSchema;
import org.compiere.model.MForm;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasure;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.Query;
import org.compiere.print.MPrintColor;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.jfree.data.category.CategoryDataset;
import org.spin.base.util.ContextManager;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.Chart;
import org.spin.grpc.util.ChartData;
import org.spin.grpc.util.ChartSerie;
import org.spin.grpc.util.ColorSchema;
import org.spin.grpc.util.Criteria;
import org.spin.grpc.util.Dashboard;
import org.spin.grpc.util.DashboardingGrpc;
import org.spin.grpc.util.Favorite;
import org.spin.grpc.util.GetChartRequest;
import org.spin.grpc.util.ListDashboardsRequest;
import org.spin.grpc.util.ListDashboardsResponse;
import org.spin.grpc.util.ListFavoritesRequest;
import org.spin.grpc.util.ListFavoritesResponse;
import org.spin.grpc.util.ListPendingDocumentsRequest;
import org.spin.grpc.util.ListPendingDocumentsResponse;
import org.spin.grpc.util.PendingDocument;

public class DashboardingServiceImplementation
extends DashboardingGrpc.DashboardingImplBase {
    private CLogger log = CLogger.getCLogger(DashboardingServiceImplementation.class);

    @Override
    public void listPendingDocuments(ListPendingDocumentsRequest request, StreamObserver<ListPendingDocumentsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListPendingDocumentsResponse.Builder pendingDocumentsList = this.convertPendingDocumentList(context, request);
            responseObserver.onNext((Object)pendingDocumentsList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listFavorites(ListFavoritesRequest request, StreamObserver<ListFavoritesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListFavoritesResponse.Builder favoritesList = this.convertFavoritesList(context, request);
            responseObserver.onNext((Object)favoritesList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listDashboards(ListDashboardsRequest request, StreamObserver<ListDashboardsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListDashboardsResponse.Builder dashboardsList = this.convertDashboarsList(context, request);
            responseObserver.onNext((Object)dashboardsList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getChart(GetChartRequest request, StreamObserver<Chart> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Chart.Builder chart = this.convertChart(request);
            responseObserver.onNext((Object)chart.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private Chart.Builder convertChart(GetChartRequest request) {
        Chart.Builder builder = Chart.newBuilder();
        MGoal goal = (MGoal)RecordUtil.getEntity(Env.getCtx(), "PA_Goal", request.getUuid(), request.getId(), null);
        if (goal == null) {
            throw new AdempiereException("@PA_Goal_ID@ @NotFound@");
        }
        HashMap chartSeries = new HashMap();
        if (goal.get_ValueAsInt("AD_Chart_ID") > 0) {
            MChart chart = new MChart(Env.getCtx(), goal.get_ValueAsInt("AD_Chart_ID"), null);
            CategoryDataset dataSet = chart.getCategoryDataset();
            dataSet.getRowKeys();
            dataSet.getColumnKeys().forEach(column -> dataSet.getRowKeys().forEach(row -> {
                Number value;
                ArrayList<ChartData> serie = (ArrayList<ChartData>)chartSeries.get(row);
                if (serie == null) {
                    serie = new ArrayList<ChartData>();
                }
                BigDecimal numberValue = (value = dataSet.getValue((Comparable)row, (Comparable)column)) != null ? new BigDecimal(value.doubleValue()) : Env.ZERO;
                serie.add(ChartData.newBuilder().setName(column.toString()).setValue(ValueUtil.getDecimalFromBigDecimal(numberValue)).build());
                chartSeries.put(row.toString(), serie);
            }));
        } else {
            MMeasure measure = goal.getMeasure();
            ArrayList chartData = measure.getGraphColumnList(goal);
            builder.setName(ValueUtil.validateNull(goal.getName()));
            builder.setDescription(ValueUtil.validateNull(goal.getDescription()));
            builder.setId(goal.getPA_Goal_ID());
            builder.setUuid(ValueUtil.validateNull(goal.getUUID()));
            builder.setXAxisLabel(ValueUtil.validateNull(goal.getXAxisText()));
            builder.setYAxisLabel(ValueUtil.validateNull(goal.getName()));
            chartData.forEach(data -> {
                ArrayList<ChartData> serie;
                String key = "";
                if (data.getDate() != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(data.getDate());
                    key = Integer.toString(cal.get(1));
                }
                if ((serie = (ArrayList<ChartData>)chartSeries.get(key)) == null) {
                    serie = new ArrayList<ChartData>();
                }
                serie.add(ChartData.newBuilder().setName(data.getLabel()).setValue(ValueUtil.getDecimalFromBigDecimal(new BigDecimal(data.getValue()))).build());
                chartSeries.put(key, serie);
            });
        }
        MColorSchema colorSchema = goal.getColorSchema();
        builder.setMeasureTarget(ValueUtil.getDecimalFromBigDecimal(goal.getMeasureTarget()));
        builder.addColorSchemas(ColorSchema.newBuilder().setPercent(ValueUtil.getDecimalFromBigDecimal(new BigDecimal(colorSchema.getMark1Percent()))).setColor(this.getColorAsHex(colorSchema.getAD_PrintColor1_ID())));
        builder.addColorSchemas(ColorSchema.newBuilder().setPercent(ValueUtil.getDecimalFromBigDecimal(new BigDecimal(colorSchema.getMark2Percent()))).setColor(this.getColorAsHex(colorSchema.getAD_PrintColor2_ID())));
        builder.addColorSchemas(ColorSchema.newBuilder().setPercent(ValueUtil.getDecimalFromBigDecimal(new BigDecimal(colorSchema.getMark3Percent()))).setColor(this.getColorAsHex(colorSchema.getAD_PrintColor3_ID())));
        builder.addColorSchemas(ColorSchema.newBuilder().setPercent(ValueUtil.getDecimalFromBigDecimal(new BigDecimal(colorSchema.getMark4Percent()))).setColor(this.getColorAsHex(colorSchema.getAD_PrintColor4_ID())));
        chartSeries.keySet().stream().sorted().forEach(serie -> builder.addSeries(ChartSerie.newBuilder().setName((String)serie).addAllDataSet((Iterable)chartSeries.get(serie))));
        return builder;
    }

    private String getColorAsHex(int printColorId) {
        if (printColorId <= 0) {
            return "";
        }
        MPrintColor printColor = MPrintColor.get((Properties)Env.getCtx(), (int)printColorId);
        int color = 0;
        try {
            color = Integer.parseInt(printColor.getCode());
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
        return String.format("#%06X", 0xFFFFFF & color);
    }

    private ListPendingDocumentsResponse.Builder convertPendingDocumentList(Properties context, ListPendingDocumentsRequest request) {
        int roleId;
        ListPendingDocumentsResponse.Builder builder = ListPendingDocumentsResponse.newBuilder();
        if (request.getUserId() <= 0 && Util.isEmpty((String)request.getUserUuid()) && request.getRoleId() <= 0 && Util.isEmpty((String)request.getRoleUuid())) {
            throw new AdempiereException("@AD_User_ID@ / @AD_Role_ID@ @NotFound@");
        }
        int userId = request.getUserId();
        if (userId <= 0) {
            userId = RecordUtil.getIdFromUuid("AD_User", request.getUserUuid(), null);
        }
        if ((roleId = request.getRoleId()) <= 0) {
            roleId = RecordUtil.getIdFromUuid("AD_Role", request.getRoleUuid(), null);
        }
        Arrays.asList(MDocumentStatus.getDocumentStatusIndicators((Properties)context, (int)userId, (int)roleId)).forEach(documentStatus -> {
            PendingDocument.Builder pendingDocument = PendingDocument.newBuilder();
            pendingDocument.setDocumentName(ValueUtil.validateNull(documentStatus.getName()));
            if (documentStatus.getAD_Window_ID() != 0) {
                MWindow window = MWindow.get((Properties)context, (int)documentStatus.getAD_Window_ID());
                pendingDocument.setWindowUuid(ValueUtil.validateNull(window.getUUID()));
            } else if (documentStatus.getAD_Form_ID() != 0) {
                MForm form = new MForm(context, documentStatus.getAD_Form_ID(), null);
                pendingDocument.setFormUuid(ValueUtil.validateNull(form.getUUID()));
            }
            MTable table = MTable.get((Properties)context, (int)documentStatus.getAD_Table_ID());
            pendingDocument.setCriteria(Criteria.newBuilder().setTableName(ValueUtil.validateNull(table.getTableName())).setWhereClause(ValueUtil.validateNull(documentStatus.getWhereClause())));
            pendingDocument.setRecordCount(MDocumentStatus.evaluate((IDocumentStatus)documentStatus));
            builder.addPendingDocuments(pendingDocument);
        });
        return builder;
    }

    private ListDashboardsResponse.Builder convertDashboarsList(Properties context, ListDashboardsRequest request) {
        ListDashboardsResponse.Builder builder = ListDashboardsResponse.newBuilder();
        if (request.getRoleId() <= 0 && Util.isEmpty((String)request.getRoleUuid())) {
            throw new AdempiereException("@AD_Role_ID@ @NotFound@");
        }
        int roleId = request.getRoleId();
        if (roleId <= 0) {
            roleId = RecordUtil.getIdFromUuid("AD_Role", request.getRoleUuid(), null);
        }
        new Query(Env.getCtx(), "PA_Goal", "((AD_User_ID IS NULL AND AD_Role_ID IS NULL) OR AD_Role_ID=? OR EXISTS (SELECT 1 FROM AD_User_Roles ur WHERE ur.AD_User_ID=PA_Goal.AD_User_ID AND ur.AD_Role_ID = ? AND ur.IsActive='Y')) ", null).setParameters(new Object[]{roleId, roleId}).setOnlyActiveRecords(true).setClient_ID().setOrderBy("SeqNo").list().forEach(chartDefinition -> {
            Dashboard.Builder dashboardBuilder = Dashboard.newBuilder();
            dashboardBuilder.setId(chartDefinition.getPA_Goal_ID());
            dashboardBuilder.setUuid(ValueUtil.validateNull(chartDefinition.getUUID()));
            dashboardBuilder.setName(ValueUtil.validateNull(chartDefinition.getName()));
            dashboardBuilder.setDescription(ValueUtil.validateNull(chartDefinition.getDescription()));
            dashboardBuilder.setDashboardType("chart");
            dashboardBuilder.setChartType(ValueUtil.validateNull(chartDefinition.getChartType()));
            dashboardBuilder.setIsCollapsible(true);
            dashboardBuilder.setIsOpenByDefault(true);
            builder.addDashboards(dashboardBuilder);
        });
        new Query(context, "PA_DashboardContent", "EXISTS(SELECT 1 FROM AD_Dashboard_Access da WHERE da.PA_DashboardContent_ID = PA_DashboardContent.PA_DashboardContent_ID AND da.AD_Role_ID = ?)", null).setParameters(new Object[]{roleId}).setOnlyActiveRecords(true).setOrderBy("ColumnNo,AD_Client_ID,Line").list().forEach(dashboard -> {
            String fileName;
            Dashboard.Builder dashboardBuilder = Dashboard.newBuilder();
            dashboardBuilder.setId(dashboard.getPA_DashboardContent_ID());
            dashboardBuilder.setUuid(ValueUtil.validateNull(dashboard.getUUID()));
            dashboardBuilder.setName(ValueUtil.validateNull(dashboard.getName()));
            dashboardBuilder.setDescription(ValueUtil.validateNull(dashboard.getDescription()));
            dashboardBuilder.setHtml(ValueUtil.validateNull(dashboard.getHTML()));
            dashboardBuilder.setColumnNo(dashboard.getColumnNo());
            dashboardBuilder.setLineNo(dashboard.getLine());
            dashboardBuilder.setIsEventRequired(dashboard.isEventRequired());
            dashboardBuilder.setIsCollapsible(dashboard.isCollapsible());
            dashboardBuilder.setIsOpenByDefault(dashboard.isOpenByDefault());
            dashboardBuilder.setDashboardType("dashboard");
            if (dashboard.getAD_Window_ID() != 0) {
                MWindow window = MWindow.get((Properties)context, (int)dashboard.getAD_Window_ID());
                dashboardBuilder.setWindowUuid(ValueUtil.validateNull(window.getUUID()));
            }
            if (dashboard.getAD_Browse_ID() != 0) {
                MBrowse browser = MBrowse.get((Properties)context, (int)dashboard.getAD_Browse_ID());
                dashboardBuilder.setWindowUuid(ValueUtil.validateNull(browser.getUUID()));
            }
            if (!Util.isEmpty((String)(fileName = dashboard.getZulFilePath()))) {
                int endIndex = fileName.lastIndexOf(".");
                int beginIndex = fileName.lastIndexOf("/");
                beginIndex = beginIndex == -1 ? 0 : ++beginIndex;
                if (endIndex == -1) {
                    endIndex = fileName.length();
                }
                dashboardBuilder.setFileName(ValueUtil.validateNull(fileName.substring(beginIndex, endIndex)));
            }
            builder.addDashboards(dashboardBuilder);
        });
        return builder;
    }

    private ListFavoritesResponse.Builder convertFavoritesList(Properties context, ListFavoritesRequest request) {
        ListFavoritesResponse.Builder builder = ListFavoritesResponse.newBuilder();
        if (request.getUserId() <= 0 && Util.isEmpty((String)request.getUserUuid())) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        int userId = request.getUserId();
        if (userId <= 0) {
            userId = RecordUtil.getIdFromUuid("AD_Role", request.getUserUuid(), null);
        }
        new Query(context, "AD_TreeNodeMM", "EXISTS(SELECT 1 FROM AD_TreeBar tb WHERE tb.AD_Tree_ID = AD_TreeNodeMM.AD_Tree_ID AND tb.Node_ID = AD_TreeNodeMM.Node_ID AND tb.AD_User_ID = ?)", null).setParameters(new Object[]{userId}).setClient_ID().list().forEach(treeNodeMenu -> {
            Favorite.Builder favorite = Favorite.newBuilder();
            String menuName = "";
            String menuDescription = "";
            MMenu menu = MMenu.getFromId((Properties)context, (int)treeNodeMenu.getNode_ID());
            favorite.setMenuUuid(ValueUtil.validateNull(menu.getUUID()));
            String action = "W";
            if (!menu.isCentrallyMaintained()) {
                menuName = menu.getName();
                menuDescription = menu.getDescription();
                if (!Env.isBaseLanguage((Properties)context, (String)"")) {
                    String translation = menu.get_Translation("Name");
                    if (!Util.isEmpty((String)translation)) {
                        menuName = translation;
                    }
                    if (!Util.isEmpty((String)(translation = menu.get_Translation("Description")))) {
                        menuDescription = translation;
                    }
                }
            }
            if (!Util.isEmpty((String)menu.getAction())) {
                action = menu.getAction();
                String referenceUuid = null;
                if (menu.getAction().equals("X")) {
                    if (menu.getAD_Form_ID() > 0) {
                        MForm form = new MForm(context, menu.getAD_Form_ID(), null);
                        referenceUuid = form.getUUID();
                        if (menu.isCentrallyMaintained()) {
                            menuName = form.getName();
                            menuDescription = form.getDescription();
                            if (!Env.isBaseLanguage((Properties)context, (String)"")) {
                                String translation = form.get_Translation("Name");
                                if (!Util.isEmpty((String)translation)) {
                                    menuName = translation;
                                }
                                if (!Util.isEmpty((String)(translation = form.get_Translation("Description")))) {
                                    menuDescription = translation;
                                }
                            }
                        }
                    }
                } else if (menu.getAction().equals("W")) {
                    if (menu.getAD_Window_ID() > 0) {
                        MWindow window = new MWindow(context, menu.getAD_Window_ID(), null);
                        referenceUuid = window.getUUID();
                        if (menu.isCentrallyMaintained()) {
                            menuName = window.getName();
                            menuDescription = window.getDescription();
                            if (!Env.isBaseLanguage((Properties)context, (String)"")) {
                                String translation = window.get_Translation("Name");
                                if (!Util.isEmpty((String)translation)) {
                                    menuName = translation;
                                }
                                if (!Util.isEmpty((String)(translation = window.get_Translation("Description")))) {
                                    menuDescription = translation;
                                }
                            }
                        }
                    }
                } else if (menu.getAction().equals("P") || menu.getAction().equals("R")) {
                    if (menu.getAD_Process_ID() > 0) {
                        MProcess process = MProcess.get((Properties)context, (int)menu.getAD_Process_ID());
                        referenceUuid = process.getUUID();
                        if (menu.isCentrallyMaintained()) {
                            menuName = process.getName();
                            menuDescription = process.getDescription();
                            if (!Env.isBaseLanguage((Properties)context, (String)"")) {
                                String translation = process.get_Translation("Name");
                                if (!Util.isEmpty((String)translation)) {
                                    menuName = translation;
                                }
                                if (!Util.isEmpty((String)(translation = process.get_Translation("Description")))) {
                                    menuDescription = translation;
                                }
                            }
                        }
                    }
                } else if (menu.getAction().equals("S") && menu.getAD_Browse_ID() > 0) {
                    MBrowse smartBrowser = MBrowse.get((Properties)context, (int)menu.getAD_Browse_ID());
                    referenceUuid = smartBrowser.getUUID();
                    if (menu.isCentrallyMaintained()) {
                        menuName = smartBrowser.getName();
                        menuDescription = smartBrowser.getDescription();
                        if (!Env.isBaseLanguage((Properties)context, (String)"")) {
                            String translation = smartBrowser.get_Translation("Name");
                            if (!Util.isEmpty((String)translation)) {
                                menuName = translation;
                            }
                            if (!Util.isEmpty((String)(translation = smartBrowser.get_Translation("Description")))) {
                                menuDescription = translation;
                            }
                        }
                    }
                }
                favorite.setReferenceUuid(ValueUtil.validateNull(referenceUuid));
                favorite.setAction(ValueUtil.validateNull(action));
            }
            favorite.setMenuName(ValueUtil.validateNull(menuName));
            favorite.setMenuDescription(ValueUtil.validateNull(menuDescription));
            builder.addFavorites(favorite);
        });
        return builder;
    }
}

