/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCountry;
import org.compiere.model.MLocation;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_BPartner;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.base.util.ContextManager;
import org.spin.base.util.ConvertUtil;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.BusinessPartner;
import org.spin.grpc.util.ConversionRate;
import org.spin.grpc.util.CoreFunctionalityGrpc;
import org.spin.grpc.util.Country;
import org.spin.grpc.util.CreateBusinessPartnerRequest;
import org.spin.grpc.util.GetBusinessPartnerRequest;
import org.spin.grpc.util.GetConversionRateRequest;
import org.spin.grpc.util.GetCountryRequest;
import org.spin.grpc.util.ListBusinessPartnersRequest;
import org.spin.grpc.util.ListBusinessPartnersResponse;
import org.spin.grpc.util.ListLanguagesRequest;
import org.spin.grpc.util.ListLanguagesResponse;
import org.spin.grpc.util.ListOrganizationsRequest;
import org.spin.grpc.util.ListOrganizationsResponse;
import org.spin.grpc.util.ListWarehousesRequest;
import org.spin.grpc.util.ListWarehousesResponse;

public class CoreFunctionalityImplementation
extends CoreFunctionalityGrpc.CoreFunctionalityImplBase {
    private CLogger log = CLogger.getCLogger(CoreFunctionalityImplementation.class);
    private static CCache<String, MCountry> countryCache = new CCache("C_Country_UUID", 30, 0);

    @Override
    public void listOrganizations(ListOrganizationsRequest request, StreamObserver<ListOrganizationsResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListOrganizationsResponse.Builder organizationsList = this.convertOrganizationsList(request);
            responseObserver.onNext((Object)organizationsList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listWarehouses(ListWarehousesRequest request, StreamObserver<ListWarehousesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListWarehousesResponse.Builder organizationsList = this.convertWarehousesList(request);
            responseObserver.onNext((Object)organizationsList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getCountry(GetCountryRequest request, StreamObserver<Country> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Country Request Null");
            }
            this.log.fine("Country Requested = " + request.getUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Country.Builder country = this.getCountry(request);
            responseObserver.onNext((Object)country.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listLanguages(ListLanguagesRequest request, StreamObserver<ListLanguagesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListLanguagesResponse.Builder languagesList = this.convertLanguagesList(request);
            responseObserver.onNext((Object)languagesList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getMessage()).augmentDescription(e.getMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listBusinessPartners(ListBusinessPartnersRequest request, StreamObserver<ListBusinessPartnersResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Add Line for Order = " + request.getSearchValue());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListBusinessPartnersResponse.Builder businessPartnerList = this.getBusinessPartnerList(request);
            responseObserver.onNext((Object)businessPartnerList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getBusinessPartner(GetBusinessPartnerRequest request, StreamObserver<BusinessPartner> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getSearchValue());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            BusinessPartner.Builder businessPartner = this.getBusinessPartner(request);
            responseObserver.onNext((Object)businessPartner.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createBusinessPartner(CreateBusinessPartnerRequest request, StreamObserver<BusinessPartner> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getValue());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            BusinessPartner.Builder businessPartner = this.createBusinessPartner(request);
            responseObserver.onNext((Object)businessPartner.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getConversionRate(GetConversionRateRequest request, StreamObserver<ConversionRate> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getConversionTypeUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ConversionRate.Builder conversionRate = ConvertUtil.convertConversionRate(this.getConversionRate(request));
            responseObserver.onNext((Object)conversionRate.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private MConversionRate getConversionRate(GetConversionRateRequest request) {
        int organizationId;
        if (Util.isEmpty((String)request.getConversionTypeUuid()) || Util.isEmpty((String)request.getCurrencyFromUuid()) || Util.isEmpty((String)request.getCurrencyToUuid())) {
            return null;
        }
        Timestamp conversionDate = ValueUtil.convertStringToDate(request.getConversionDate());
        if (conversionDate == null) {
            conversionDate = TimeUtil.getDay((long)System.currentTimeMillis());
        }
        if ((organizationId = RecordUtil.getIdFromUuid("AD_Org", request.getClientRequest().getOrganizationUuid(), null)) < 0) {
            organizationId = 0;
        }
        return RecordUtil.getConversionRate(organizationId, RecordUtil.getIdFromUuid("C_ConversionType", request.getConversionTypeUuid(), null), RecordUtil.getIdFromUuid("C_Currency", request.getCurrencyFromUuid(), null), RecordUtil.getIdFromUuid("C_Currency", request.getCurrencyToUuid(), null), TimeUtil.getDay((Timestamp)conversionDate));
    }

    private ListBusinessPartnersResponse.Builder getBusinessPartnerList(ListBusinessPartnersRequest request) {
        ListBusinessPartnersResponse.Builder builder = ListBusinessPartnersResponse.newBuilder();
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int offset = pageNumber * 50;
        int limit = (pageNumber + 1) * 50;
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (!Util.isEmpty((String)request.getSearchValue())) {
            whereClause.append("(UPPER(Value) LIKE '%' || UPPER(?) || '%' OR UPPER(Name) LIKE '%' || UPPER(?) || '%' OR UPPER(Name2) LIKE '%' || UPPER(?) || '%' OR UPPER(Description) LIKE '%' || UPPER(?) || '%')");
            parameters.add(request.getSearchValue());
            parameters.add(request.getSearchValue());
            parameters.add(request.getSearchValue());
            parameters.add(request.getSearchValue());
        }
        if (!Util.isEmpty((String)request.getValue())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(UPPER(Value) LIKE UPPER(?))");
            parameters.add(request.getValue());
        }
        if (!Util.isEmpty((String)request.getName())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(UPPER(Name) LIKE UPPER(?))");
            parameters.add(request.getName());
        }
        if (!Util.isEmpty((String)request.getContactName())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM AD_User u WHERE u.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(u.Name) LIKE UPPER(?)))");
            parameters.add(request.getContactName());
        }
        if (!Util.isEmpty((String)request.getEmail())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
        }
        if (!Util.isEmpty((String)request.getPhone())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM AD_User u WHERE u.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(u.Phone) LIKE UPPER(?)) OR EXISTS(SELECT 1 FROM C_BPartner_Location bpl WHERE bpl.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(bpl.Phone) LIKE UPPER(?)))");
            parameters.add(request.getPhone());
            parameters.add(request.getPhone());
        }
        if (!Util.isEmpty((String)request.getPostalCode())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM C_BPartner_Location bpl INNER JOIN C_Location l ON(l.C_Location_ID = bpl.C_Location_ID) WHERE bpl.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(l.Postal) LIKE UPPER(?)))");
            parameters.add(request.getPostalCode());
        }
        String criteriaWhereClause = ValueUtil.getWhereClauseFromCriteria(request.getCriteria(), "C_BPartner", parameters);
        if (whereClause.length() > 0 && !Util.isEmpty((String)criteriaWhereClause)) {
            whereClause.append(" AND (").append(criteriaWhereClause).append(")");
        }
        Query query = new Query(Env.getCtx(), "C_BPartner", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true);
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(businessPartner -> builder.addBusinessPartners(ConvertUtil.convertBusinessPartner(businessPartner)));
        builder.setRecordCount(count);
        if (count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private BusinessPartner.Builder createBusinessPartner(CreateBusinessPartnerRequest request) {
        if (Util.isEmpty((String)request.getName())) {
            throw new AdempiereException("@Name@ @IsMandatory@");
        }
        if (Util.isEmpty((String)request.getPosUuid())) {
            throw new AdempiereException("@C_POS_ID@ @IsMandatory@");
        }
        MBPartner businessPartner = MBPartner.getTemplate((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)RecordUtil.getIdFromUuid("C_POS", request.getPosUuid(), null));
        Trx.run(transactionName -> {
            int businessPartnerGroupId;
            businessPartner.setAD_Org_ID(0);
            businessPartner.setIsCustomer(true);
            businessPartner.setIsVendor(false);
            businessPartner.set_TrxName(transactionName);
            String value = request.getValue();
            if (Util.isEmpty((String)value)) {
                value = DB.getDocumentNo((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (String)"C_BPartner", (String)transactionName, (PO)businessPartner);
            }
            businessPartner.setValue(value);
            if (!Util.isEmpty((String)request.getTaxId())) {
                businessPartner.setTaxID(request.getTaxId());
            }
            if (!Util.isEmpty((String)request.getDuns())) {
                businessPartner.setDUNS(request.getDuns());
            }
            if (!Util.isEmpty((String)request.getNaics())) {
                businessPartner.setNAICS(request.getNaics());
            }
            businessPartner.setName(request.getName());
            if (!Util.isEmpty((String)request.getLastName())) {
                businessPartner.setName2(request.getLastName());
            }
            if (!Util.isEmpty((String)request.getDescription())) {
                businessPartner.setDescription(request.getDescription());
            }
            if (!Util.isEmpty((String)request.getBusinessPartnerGroupUuid()) && (businessPartnerGroupId = RecordUtil.getIdFromUuid("C_BP_Group", request.getBusinessPartnerGroupUuid(), transactionName)) != 0) {
                businessPartner.setC_BP_Group_ID(businessPartnerGroupId);
            }
            businessPartner.saveEx(transactionName);
            MUser contact = null;
            if (!(Util.isEmpty((String)request.getContactName()) && Util.isEmpty((String)request.getEmail()) && Util.isEmpty((String)request.getPhone()))) {
                contact = new MUser((X_C_BPartner)businessPartner);
                if (!Util.isEmpty((String)request.getContactName())) {
                    contact.setName(request.getContactName());
                }
                if (!Util.isEmpty((String)request.getEmail())) {
                    contact.setEMail(request.getEmail());
                }
                if (!Util.isEmpty((String)request.getPhone())) {
                    contact.setPhone(request.getPhone());
                }
                if (!Util.isEmpty((String)request.getDescription())) {
                    contact.setDescription(request.getDescription());
                }
                contact.saveEx(transactionName);
            }
            int countryId = 0;
            if (!Util.isEmpty((String)request.getCountryUuid())) {
                countryId = RecordUtil.getIdFromUuid("C_Country", request.getCountryUuid(), transactionName);
            }
            if (countryId <= 0) {
                countryId = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#C_Country_ID");
            }
            int regionId = 0;
            if (!Util.isEmpty((String)request.getRegionUuid())) {
                regionId = RecordUtil.getIdFromUuid("C_Region", request.getRegionUuid(), transactionName);
            }
            String cityName = null;
            int cityId = 0;
            if (!Util.isEmpty((String)request.getCityName())) {
                cityName = request.getCityName();
            }
            if (!Util.isEmpty((String)request.getCityUuid())) {
                cityId = RecordUtil.getIdFromUuid("C_Region", request.getRegionUuid(), transactionName);
            }
            MLocation location = new MLocation(Env.getCtx(), countryId, regionId, cityName, transactionName);
            if (cityId > 0) {
                location.setC_City_ID(cityId);
            }
            if (!Util.isEmpty((String)request.getPostalCode())) {
                location.setPostal(request.getPostalCode());
            }
            Optional.ofNullable(request.getAddress1()).ifPresent(address -> location.setAddress1(address));
            Optional.ofNullable(request.getAddress2()).ifPresent(address -> location.setAddress2(address));
            Optional.ofNullable(request.getAddress3()).ifPresent(address -> location.setAddress3(address));
            Optional.ofNullable(request.getAddress4()).ifPresent(address -> location.setAddress4(address));
            location.saveEx(transactionName);
            MBPartnerLocation businessPartnerLocation = new MBPartnerLocation(businessPartner);
            businessPartnerLocation.setC_Location_ID(location.getC_Location_ID());
            if (!Util.isEmpty((String)request.getPhone())) {
                businessPartnerLocation.setPhone(request.getPhone());
            }
            if (!Util.isEmpty((String)request.getContactName())) {
                businessPartnerLocation.setContactPerson(request.getContactName());
            }
            businessPartnerLocation.saveEx(transactionName);
            Optional.ofNullable(contact).ifPresent(contactToSave -> {
                contactToSave.setC_BPartner_Location_ID(businessPartnerLocation.getC_BPartner_Location_ID());
                contactToSave.saveEx(transactionName);
            });
        });
        return ConvertUtil.convertBusinessPartner(businessPartner);
    }

    private BusinessPartner.Builder getBusinessPartner(GetBusinessPartnerRequest request) {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (!Util.isEmpty((String)request.getSearchValue())) {
            whereClause.append("(UPPER(Value) = UPPER(?) OR UPPER(Name) = UPPER(?))");
            parameters.add(request.getSearchValue());
            parameters.add(request.getSearchValue());
        }
        if (!Util.isEmpty((String)request.getValue())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(UPPER(Value) = UPPER(?))");
            parameters.add(request.getValue());
        }
        if (!Util.isEmpty((String)request.getName())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(UPPER(Name) = UPPER(?))");
            parameters.add(request.getName());
        }
        if (!Util.isEmpty((String)request.getContactName())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM AD_User u WHERE u.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(u.Name) = UPPER(?)))");
            parameters.add(request.getContactName());
        }
        if (!Util.isEmpty((String)request.getEmail())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM AD_User u WHERE u.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(u.EMail) = UPPER(?)))");
            parameters.add(request.getEmail());
        }
        if (!Util.isEmpty((String)request.getPhone())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM AD_User u WHERE u.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(u.Phone) = UPPER(?)) OR EXISTS(SELECT 1 FROM C_BPartner_Location bpl WHERE bpl.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(bpl.Phone) = UPPER(?)))");
            parameters.add(request.getPhone());
            parameters.add(request.getPhone());
        }
        if (!Util.isEmpty((String)request.getPostalCode())) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(EXISTS(SELECT 1 FROM C_BPartner_Location bpl INNER JOIN C_Location l ON(l.C_Location_ID = bpl.C_Location_ID) WHERE bpl.C_BPartner_ID = C_BPartner.C_BPartner_ID AND UPPER(l.Postal) = UPPER(?)))");
            parameters.add(request.getPostalCode());
        }
        String criteriaWhereClause = ValueUtil.getWhereClauseFromCriteria(request.getCriteria(), parameters);
        if (whereClause.length() > 0 && !Util.isEmpty((String)criteriaWhereClause)) {
            whereClause.append(" AND (").append(criteriaWhereClause).append(")");
        }
        MBPartner businessPartner = (MBPartner)new Query(Env.getCtx(), "C_BPartner", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true).first();
        return ConvertUtil.convertBusinessPartner(businessPartner);
    }

    private Country.Builder getCountry(GetCountryRequest request) {
        int id;
        String key = null;
        MCountry country = null;
        if (Util.isEmpty((String)request.getUuid()) && request.getId() == 0) {
            country = ContextManager.getDefaultCountry();
        }
        if ((id = request.getId()) <= 0) {
            id = RecordUtil.getIdFromUuid("C_Country", request.getUuid(), null);
        }
        if (id > 0 && country == null && (country = (MCountry)countryCache.put((Object)(key = "ID:|" + request.getId()), (Object)country)) == null) {
            country = MCountry.get((Properties)Env.getCtx(), (int)request.getId());
        }
        if (!Util.isEmpty(key) && country != null) {
            countryCache.put(key, (Object)country);
        }
        return ConvertUtil.convertCountry(Env.getCtx(), country);
    }

    private ListLanguagesResponse.Builder convertLanguagesList(ListLanguagesRequest request) {
        ListLanguagesResponse.Builder builder = ListLanguagesResponse.newBuilder();
        new Query(Env.getCtx(), "AD_Language", "(IsSystemLanguage=? OR IsBaseLanguage=?)", null).setParameters(new Object[]{true, true}).setOnlyActiveRecords(true).list().forEach(language -> builder.addLanguages(ConvertUtil.convertLanguage(language)));
        return builder;
    }

    private ListOrganizationsResponse.Builder convertOrganizationsList(ListOrganizationsRequest request) {
        ListOrganizationsResponse.Builder builder = ListOrganizationsResponse.newBuilder();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        String whereClause = "AD_Client_ID = " + Env.getAD_Client_ID((Properties)Env.getCtx());
        MRole role = null;
        if (request.getRoleId() != 0) {
            role = MRole.get((Properties)Env.getCtx(), (int)request.getRoleId());
        } else if (!Util.isEmpty((String)request.getRoleUuid())) {
            role = (MRole)new Query(Env.getCtx(), "AD_Role", "UUID = ?", null).setParameters(new Object[]{request.getRoleUuid()}).setOnlyActiveRecords(true).first();
        }
        if (role != null) {
            if (role.isUseUserOrgAccess()) {
                whereClause = "EXISTS(SELECT 1 FROM AD_User_OrgAccess ua WHERE ua.AD_Org_ID = AD_Org.AD_Org_ID AND ua.AD_User_ID = ? AND ua.IsActive = 'Y')";
                parameters.add(Env.getAD_User_ID((Properties)Env.getCtx()));
            } else {
                whereClause = "EXISTS(SELECT 1 FROM AD_Role_OrgAccess ra WHERE ra.AD_Org_ID = AD_Org.AD_Org_ID AND ra.AD_Role_ID = ? AND ra.IsActive = 'Y')";
                parameters.add(role.getAD_Role_ID());
            }
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int offset = pageNumber * 50;
        int limit = (pageNumber + 1) * 50;
        Query query = new Query(Env.getCtx(), "AD_Org", whereClause, null).setParameters(parameters).setOnlyActiveRecords(true).setLimit(limit, offset);
        int count = query.count();
        query.list().forEach(organization -> builder.addOrganizations(ConvertUtil.convertOrganization(organization)));
        builder.setRecordCount(count);
        if (count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private ListWarehousesResponse.Builder convertWarehousesList(ListWarehousesRequest request) {
        ListWarehousesResponse.Builder builder = ListWarehousesResponse.newBuilder();
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int offset = pageNumber * 50;
        int limit = (pageNumber + 1) * 50;
        int id = request.getOrganizationId();
        if (id <= 0) {
            id = RecordUtil.getIdFromUuid("AD_Org", request.getOrganizationUuid(), null);
        }
        Query query = new Query(Env.getCtx(), "M_Warehouse", "AD_Org_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{id}).setLimit(limit, offset);
        int count = query.count();
        query.list().forEach(warehouse -> builder.addWarehouses(ConvertUtil.convertWarehouse(warehouse)));
        builder.setRecordCount(count);
        if (count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }
}

