/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MRecentItem;
import org.compiere.model.MReportView;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.MimeType;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.base.util.ContextManager;
import org.spin.base.util.ConvertUtil;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.BusinessDataGrpc;
import org.spin.grpc.util.CreateEntityRequest;
import org.spin.grpc.util.Criteria;
import org.spin.grpc.util.DeleteEntityRequest;
import org.spin.grpc.util.Empty;
import org.spin.grpc.util.Entity;
import org.spin.grpc.util.GetEntityRequest;
import org.spin.grpc.util.KeyValue;
import org.spin.grpc.util.KeyValueSelection;
import org.spin.grpc.util.ListEntitiesRequest;
import org.spin.grpc.util.ListEntitiesResponse;
import org.spin.grpc.util.ProcessInfoLog;
import org.spin.grpc.util.ProcessLog;
import org.spin.grpc.util.ReportOutput;
import org.spin.grpc.util.RunBusinessProcessRequest;
import org.spin.grpc.util.UpdateEntityRequest;
import org.spin.grpc.util.Value;

public class BusinessDataServiceImplementation
extends BusinessDataGrpc.BusinessDataImplBase {
    private CLogger log = CLogger.getCLogger(BusinessDataServiceImplementation.class);
    private static CCache<String, String> referenceWhereClauseCache = new CCache("Reference_WhereClause", 30, 0);

    @Override
    public void getEntity(GetEntityRequest request, StreamObserver<Entity> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getUuid());
            ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Entity.Builder entityValue = this.getEntity(request);
            responseObserver.onNext((Object)entityValue.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void createEntity(CreateEntityRequest request, StreamObserver<Entity> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Entity.Builder entityValue = this.createEntity(context, request);
            responseObserver.onNext((Object)entityValue.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void updateEntity(UpdateEntityRequest request, StreamObserver<Entity> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Entity.Builder entityValue = this.updateEntity(context, request);
            responseObserver.onNext((Object)entityValue.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void deleteEntity(DeleteEntityRequest request, StreamObserver<Empty> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Object Requested = " + request.getUuid());
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            Empty.Builder entityValue = this.deleteEntity(context, request);
            responseObserver.onNext((Object)entityValue.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listEntities(ListEntitiesRequest request, StreamObserver<ListEntitiesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ListEntitiesResponse.Builder entityValueList = this.convertEntitiesList(context, request);
            responseObserver.onNext((Object)entityValueList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void runBusinessProcess(RunBusinessProcessRequest request, StreamObserver<ProcessLog> responseObserver) {
        try {
            if (request == null || Util.isEmpty((String)request.getProcessUuid())) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Lookup List Requested = " + request.getUuid());
            Properties context = ContextManager.getContext(request.getClientRequest().getSessionUuid(), request.getClientRequest().getLanguage(), request.getClientRequest().getOrganizationUuid(), request.getClientRequest().getWarehouseUuid());
            ProcessLog.Builder processReponse = this.runProcess(context, request);
            responseObserver.onNext((Object)processReponse.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private ProcessLog.Builder runProcess(Properties context, RunBusinessProcessRequest request) throws FileNotFoundException, IOException {
        File reportFile;
        ProcessInfo result;
        MProcess process;
        ProcessLog.Builder response;
        block37: {
            MTable table;
            response = ProcessLog.newBuilder();
            process = MProcess.get((Properties)context, (int)RecordUtil.getIdFromUuid("AD_Process", request.getProcessUuid(), null));
            if (process == null || process.getAD_Process_ID() <= 0) {
                throw new AdempiereException("@AD_Process_ID@ @NotFound@");
            }
            int tableId = 0;
            int recordId = request.getId();
            if (!Util.isEmpty((String)request.getTableName()) && (table = MTable.get((Properties)context, (String)request.getTableName())) != null && table.getAD_Table_ID() != 0) {
                tableId = table.getAD_Table_ID();
            }
            PO entity = null;
            if (!(recordId == 0 && Util.isEmpty((String)request.getUuid()) || Util.isEmpty((String)request.getTableName()))) {
                String uuid = request.getUuid();
                if (recordId != 0) {
                    uuid = null;
                }
                if ((entity = RecordUtil.getEntity(context, request.getTableName(), uuid, recordId, null)) != null) {
                    recordId = entity.get_ID();
                }
            }
            this.addToRecentItem("P", process.getAD_Process_ID());
            ProcessBuilder builder = ProcessBuilder.create((Properties)context).process(Integer.valueOf(process.getAD_Process_ID())).withRecordId(Integer.valueOf(tableId), Integer.valueOf(recordId)).withoutPrintPreview().withoutBatchMode().withWindowNo(Integer.valueOf(0)).withTitle(process.getName());
            if (process.isReport()) {
                builder.withReportExportFormat(request.getReportType());
            }
            if (request.getSelectionsCount() > 0) {
                ArrayList<Integer> selectionKeys = new ArrayList<Integer>();
                LinkedHashMap selection = new LinkedHashMap();
                for (KeyValueSelection selectionKey : request.getSelectionsList()) {
                    selectionKeys.add(selectionKey.getSelectionId());
                    if (selectionKey.getValuesCount() <= 0) continue;
                    selection.put(selectionKey.getSelectionId(), new LinkedHashMap<String, Object>(ValueUtil.convertValuesToObjects(selectionKey.getValuesList())));
                }
                builder.withSelectedRecordsIds(request.getTableSelectedId(), selectionKeys, selection);
            }
            String documentAction = null;
            if (request.getParametersCount() > 0) {
                for (KeyValue parameter : request.getParametersList()) {
                    Object value = ValueUtil.getObjectFromValue(parameter.getValue());
                    if (value == null) continue;
                    builder.withParameter(parameter.getKey(), value);
                    if (!parameter.getKey().equals("DocAction")) continue;
                    documentAction = (String)value;
                }
            }
            if (!Util.isEmpty(documentAction) && process.getAD_Workflow_ID() != 0 && entity != null && DocAction.class.isAssignableFrom(entity.getClass())) {
                entity.set_ValueOfColumn("DocAction", documentAction);
                entity.saveEx();
                builder.withoutTransactionClose();
            }
            result = null;
            try {
                result = builder.execute();
            }
            catch (Exception e) {
                result = builder.getProcessInfo();
                if (!Util.isEmpty((String)result.getSummary())) break block37;
                result.setSummary(e.getLocalizedMessage());
            }
        }
        String reportViewUuid = null;
        String printFormatUuid = request.getPrintFormatUuid();
        String tableName = null;
        if (result.getAD_PInstance_ID() != 0) {
            MPInstance instance = (MPInstance)new Query(context, "AD_PInstance", "AD_PInstance_ID = ?", null).setParameters(new Object[]{result.getAD_PInstance_ID()}).first();
            response.setInstanceUuid(ValueUtil.validateNull(instance.getUUID()));
            response.setLastRun(instance.getUpdated().getTime());
            if (process.isReport()) {
                MReportView reportView;
                int printFormatId = 0;
                int reportViewId = 0;
                if (instance.getAD_PrintFormat_ID() != 0) {
                    printFormatId = instance.getAD_PrintFormat_ID();
                } else if (process.getAD_PrintFormat_ID() != 0) {
                    printFormatId = process.getAD_PrintFormat_ID();
                } else if (process.getAD_ReportView_ID() != 0) {
                    reportViewId = process.getAD_ReportView_ID();
                }
                MPrintFormat printFormat = null;
                if (!Util.isEmpty((String)printFormatUuid)) {
                    printFormat = (MPrintFormat)new Query(context, "AD_PrintFormat", "UUID = ?", null).setParameters(new Object[]{printFormatUuid}).first();
                    tableName = printFormat.getAD_Table().getTableName();
                    if (printFormat.getAD_ReportView_ID() != 0) {
                        reportView = MReportView.get((Properties)context, (int)printFormat.getAD_ReportView_ID());
                        reportViewUuid = reportView.getUUID();
                    }
                } else if (printFormatId != 0) {
                    printFormat = MPrintFormat.get((Properties)context, (int)printFormatId, (boolean)false);
                    printFormatUuid = printFormat.getUUID();
                    tableName = printFormat.getAD_Table().getTableName();
                    if (printFormat.getAD_ReportView_ID() != 0) {
                        reportView = MReportView.get((Properties)context, (int)printFormat.getAD_ReportView_ID());
                        reportViewUuid = reportView.getUUID();
                    }
                } else if (reportViewId != 0) {
                    reportView = MReportView.get((Properties)context, (int)reportViewId);
                    reportViewUuid = reportView.getUUID();
                    tableName = reportView.getAD_Table().getTableName();
                    printFormat = MPrintFormat.get((Properties)context, (int)reportViewId, (int)0);
                    if (printFormat != null) {
                        printFormatUuid = printFormat.getUUID();
                    }
                }
            }
        }
        if (Util.isEmpty((String)printFormatUuid)) {
            printFormatUuid = request.getPrintFormatUuid();
        }
        if (Util.isEmpty(reportViewUuid)) {
            reportViewUuid = request.getReportViewUuid();
        }
        response.setIsError(result.isError());
        if (!Util.isEmpty((String)result.getSummary())) {
            response.setSummary(Msg.parseTranslation((Properties)context, (String)result.getSummary()));
        }
        response.setResultTableName(ValueUtil.validateNull(result.getResultTableName()));
        if (result.getLogList() != null) {
            for (ProcessInfoLog log : result.getLogList()) {
                response.addLogs(this.convertProcessInfoLog(log).build());
            }
        }
        if (process.isReport() && (reportFile = Optional.ofNullable(result.getReportAsFile()).orElse(result.getPDFReport())) != null && reportFile.exists()) {
            String validFileName = this.getValidName(reportFile.getName());
            ReportOutput.Builder output = ReportOutput.newBuilder();
            output.setFileName(ValueUtil.validateNull(validFileName));
            output.setName(result.getTitle());
            output.setMimeType(ValueUtil.validateNull(MimeType.getMimeType((String)validFileName)));
            output.setDescription(ValueUtil.validateNull(process.getDescription()));
            String reportType = result.getReportType();
            if (Util.isEmpty((String)result.getReportType())) {
                reportType = result.getReportType();
            }
            if (!Util.isEmpty((String)this.getExtension(validFileName)) && !this.getExtension(validFileName).equals(reportType)) {
                reportType = this.getExtension(validFileName);
            }
            output.setReportType(request.getReportType());
            ByteString resultFile = ByteString.readFrom((InputStream)new FileInputStream(reportFile));
            if (reportType.endsWith("html") || reportType.endsWith("txt")) {
                output.setOutputBytes(resultFile);
            }
            output.setReportType(reportType);
            output.setOutputStream(resultFile);
            output.setReportViewUuid(ValueUtil.validateNull(reportViewUuid));
            output.setPrintFormatUuid(ValueUtil.validateNull(printFormatUuid));
            output.setTableName(ValueUtil.validateNull(tableName));
            response.setOutput(output.build());
        }
        return response;
    }

    private void addToRecentItem(String action, int optionId) {
        if (Util.isEmpty((String)action)) {
            return;
        }
        String whereClause = null;
        if (action.equals("W")) {
            whereClause = "AD_Window_ID = ?";
        } else if (action.equals("X")) {
            whereClause = "AD_Form_ID = ?";
        } else if (action.equals("P") || action.equals("R")) {
            whereClause = "AD_Process_ID = ?";
        } else if (action.equals("F")) {
            whereClause = "AD_Workflow_ID = ?";
        } else if (action.equals("S")) {
            whereClause = "AD_Browse_ID = ?";
        }
        int menuId = new Query(Env.getCtx(), "AD_Menu", whereClause, null).setParameters(new Object[]{optionId}).firstId();
        MRecentItem.addMenuOption((Properties)Env.getCtx(), (int)menuId, (int)0);
    }

    private String getValidName(String fileName) {
        if (Util.isEmpty((String)fileName)) {
            return "";
        }
        return fileName.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()*#/><]", "").replaceAll(" ", "-");
    }

    private String getExtension(String fileName) {
        if (Util.isEmpty((String)fileName)) {
            return "";
        }
        int index = fileName.lastIndexOf(".");
        if (index <= -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    private ProcessInfoLog.Builder convertProcessInfoLog(ProcessInfoLog log) {
        ProcessInfoLog.Builder processLog = org.spin.grpc.util.ProcessInfoLog.newBuilder();
        processLog.setRecordId(log.getP_ID());
        processLog.setLog(ValueUtil.validateNull(Msg.parseTranslation((Properties)Env.getCtx(), (String)log.getP_Msg())));
        return processLog;
    }

    private Entity.Builder getEntity(GetEntityRequest request) {
        String tableName = request.getTableName();
        if (Util.isEmpty((String)request.getTableName()) && request.getCriteria() != null) {
            tableName = request.getCriteria().getTableName();
        }
        PO entity = null;
        if (!Util.isEmpty((String)request.getUuid()) || request.getId() != 0) {
            entity = RecordUtil.getEntity(Env.getCtx(), tableName, request.getUuid(), request.getId(), null);
        } else if (request.getCriteria() != null) {
            ArrayList<Object> parameters = new ArrayList<Object>();
            String whereClause = ValueUtil.getWhereClauseFromCriteria(request.getCriteria(), parameters);
            entity = RecordUtil.getEntity(Env.getCtx(), tableName, whereClause, parameters, null);
        }
        return ConvertUtil.convertEntity(entity);
    }

    private Empty.Builder deleteEntity(Properties context, DeleteEntityRequest request) {
        Trx.run(transactionName -> {
            PO entity = RecordUtil.getEntity(context, request.getTableName(), request.getUuid(), request.getId(), transactionName);
            if (entity != null && entity.get_ID() >= 0) {
                entity.deleteEx(true);
            }
        });
        return Empty.newBuilder();
    }

    private Entity.Builder createEntity(Properties context, CreateEntityRequest request) {
        if (Util.isEmpty((String)request.getTableName())) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        String tableName = request.getTableName();
        MTable table = MTable.get((Properties)context, (String)tableName);
        PO entity = table.getPO(0, null);
        if (entity == null) {
            throw new AdempiereException("@Error@ PO is null");
        }
        request.getAttributesList().forEach(attribute -> {
            int referenceId = this.getReferenceId(entity.get_Table_ID(), attribute.getKey());
            Object value = null;
            if (referenceId > 0) {
                value = ValueUtil.getObjectFromReference(attribute.getValue(), referenceId);
            }
            if (value == null) {
                value = ValueUtil.getObjectFromValue(attribute.getValue());
            }
            entity.set_ValueOfColumn(attribute.getKey(), value);
        });
        entity.saveEx();
        return ConvertUtil.convertEntity(entity);
    }

    private Entity.Builder updateEntity(Properties context, UpdateEntityRequest request) {
        PO entity = RecordUtil.getEntity(context, request.getTableName(), request.getUuid(), request.getId(), null);
        if (entity != null && entity.get_ID() >= 0) {
            request.getAttributesList().forEach(attribute -> {
                int referenceId = this.getReferenceId(entity.get_Table_ID(), attribute.getKey());
                Object value = null;
                if (referenceId > 0) {
                    value = ValueUtil.getObjectFromReference(attribute.getValue(), referenceId);
                }
                if (value == null) {
                    value = ValueUtil.getObjectFromValue(attribute.getValue());
                }
                entity.set_ValueOfColumn(attribute.getKey(), value);
            });
            entity.saveEx();
        }
        return ConvertUtil.convertEntity(entity);
    }

    private int getReferenceId(int tableId, String columnName) {
        MColumn column = MTable.get((Properties)Env.getCtx(), (int)tableId).getColumn(columnName);
        if (column == null) {
            return -1;
        }
        return column.getAD_Reference_ID();
    }

    private ListEntitiesResponse.Builder convertEntitiesList(Properties context, ListEntitiesRequest request) {
        String referenceWhereClause;
        Criteria criteria = request.getCriteria();
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        String dynamicWhere = ValueUtil.getWhereClauseFromCriteria(criteria, params);
        if (!Util.isEmpty((String)dynamicWhere)) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append(dynamicWhere);
        }
        if (!Util.isEmpty((String)criteria.getReferenceUuid()) && !Util.isEmpty((String)(referenceWhereClause = (String)referenceWhereClauseCache.get((Object)criteria.getReferenceUuid())))) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(").append(referenceWhereClause).append(")");
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getClientRequest().getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        int count = 0;
        ListEntitiesResponse.Builder builder = ListEntitiesResponse.newBuilder();
        if (Util.isEmpty((String)criteria.getQuery())) {
            Query query = new Query(context, criteria.getTableName(), whereClause.toString(), null).setParameters(params);
            count = query.count();
            if (!Util.isEmpty((String)criteria.getOrderByClause())) {
                query.setOrderBy(criteria.getOrderByClause());
            }
            List entityList = query.setLimit(limit, offset).list();
            for (PO entity : entityList) {
                Entity.Builder valueObject = ConvertUtil.convertEntity(entity);
                builder.addRecords(valueObject.build());
            }
        } else {
            StringBuilder sql = new StringBuilder(criteria.getQuery());
            if (whereClause.length() > 0) {
                sql.append(" WHERE ").append(whereClause);
            }
            String parsedSQL = MRole.getDefault().addAccessSQL(sql.toString(), null, true, false);
            String orderByClause = criteria.getOrderByClause();
            orderByClause = Util.isEmpty((String)orderByClause) ? "" : " ORDER BY " + orderByClause;
            count = RecordUtil.countRecords(parsedSQL, criteria.getTableName(), params);
            parsedSQL = parsedSQL + " AND ROWNUM >= " + offset + " AND ROWNUM <= " + limit;
            parsedSQL = parsedSQL + orderByClause;
            builder = this.convertListEntitiesResult(MTable.get((Properties)context, (String)criteria.getTableName()), parsedSQL, params);
        }
        builder.setRecordCount(count);
        if (RecordUtil.isValidNextPageToken(count, offset, limit)) {
            nexPageToken = RecordUtil.getPagePrefix(request.getClientRequest().getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListEntitiesResponse.Builder convertListEntitiesResult(MTable table, String sql, List<Object> params) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ListEntitiesResponse.Builder builder = ListEntitiesResponse.newBuilder();
        long recordCount = 0L;
        try {
            LinkedHashMap<String, MColumn> columnsMap = new LinkedHashMap<String, MColumn>();
            for (Object column : table.getColumnsAsList()) {
                columnsMap.put(column.getColumnName().toUpperCase(), (MColumn)column);
            }
            pstmt = DB.prepareStatement((String)sql, null);
            AtomicInteger parameterIndex = new AtomicInteger(1);
            for (Object e : params) {
                ValueUtil.setParameterFromObject((PreparedStatement)pstmt, e, parameterIndex.getAndIncrement());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Entity.Builder valueObjectBuilder = Entity.newBuilder();
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                for (int index = 1; index <= resultSetMetaData.getColumnCount(); ++index) {
                    try {
                        String columnName = resultSetMetaData.getColumnName(index);
                        MColumn field = (MColumn)columnsMap.get(columnName.toUpperCase());
                        Value.Builder valueBuilder = Value.newBuilder();
                        if (field == null) {
                            String value = rs.getString(index);
                            if (Util.isEmpty((String)value)) continue;
                            valueBuilder = ValueUtil.getValueFromString(value);
                            valueObjectBuilder.putValues(columnName, valueBuilder.build());
                            continue;
                        }
                        String fieldColumnName = field.getColumnName();
                        valueBuilder = ValueUtil.getValueFromReference(rs.getObject(index), field.getAD_Reference_ID());
                        if (valueBuilder.getValueType().equals((Object)Value.ValueType.UNRECOGNIZED)) continue;
                        valueObjectBuilder.putValues(fieldColumnName, valueBuilder.build());
                        continue;
                    }
                    catch (Exception e) {
                        this.log.severe(e.getLocalizedMessage());
                    }
                }
                builder.addRecords(valueObjectBuilder.build());
                ++recordCount;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
        finally {
            DB.close(rs, pstmt);
        }
        builder.setRecordCount(recordCount);
        return builder;
    }
}

