/*
 * Decompiled with CFR 0.152.
 */
package org.spin.grpc.service;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.compiere.model.I_AD_Menu;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MUser;
import org.compiere.model.MWindow;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.base.util.ContextManager;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.SessionManager;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.ChangeRoleRequest;
import org.spin.grpc.util.ContextValue;
import org.spin.grpc.util.ListRolesRequest;
import org.spin.grpc.util.ListRolesResponse;
import org.spin.grpc.util.LoginRequest;
import org.spin.grpc.util.LogoutRequest;
import org.spin.grpc.util.Menu;
import org.spin.grpc.util.MenuRequest;
import org.spin.grpc.util.Role;
import org.spin.grpc.util.SecurityGrpc;
import org.spin.grpc.util.Session;
import org.spin.grpc.util.SessionRequest;
import org.spin.grpc.util.UserInfo;
import org.spin.grpc.util.UserInfoRequest;
import org.spin.model.MADAttachmentReference;
import org.spin.model.MADToken;
import org.spin.util.AttachmentUtil;

public class AccessServiceImplementation
extends SecurityGrpc.SecurityImplBase {
    private CLogger log = CLogger.getCLogger(AccessServiceImplementation.class);
    private static CCache<String, Menu.Builder> menuCache = new CCache("Menu_for_User", 30, 0);

    public AccessServiceImplementation() {
        DB.validateSupportedUUIDFromDB();
        MCountry.getCountries((Properties)Env.getCtx());
    }

    @Override
    public void runLogin(LoginRequest request, StreamObserver<Session> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Session Requested = " + request.getUserName());
            Session.Builder sessionBuilder = this.createSession(request, true);
            responseObserver.onNext((Object)sessionBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void runLogout(LogoutRequest request, StreamObserver<Session> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            ContextManager.getContext(request.getSessionUuid(), request.getLanguage());
            this.log.fine("Session Requested = " + request.getSessionUuid());
            Session.Builder sessionBuilder = this.logoutSession(request);
            responseObserver.onNext((Object)sessionBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getSession(SessionRequest request, StreamObserver<Session> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Session Requested = " + request.getSessionUuid());
            ContextManager.getContext(request.getSessionUuid(), request.getLanguage());
            Session.Builder sessionBuilder = this.getSessionInfo(request);
            responseObserver.onNext((Object)sessionBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getUserInfo(UserInfoRequest request, StreamObserver<UserInfo> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("User Info Requested = " + request.getClientVersion());
            ContextManager.getContext(request.getSessionUuid(), request.getLanguage());
            UserInfo.Builder UserInfo2 = this.convertUserInfo(request);
            responseObserver.onNext((Object)UserInfo2.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void getMenu(MenuRequest request, StreamObserver<Menu> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Menu Requested = " + request.getClientVersion());
            ContextManager.getContext(request.getSessionUuid(), request.getLanguage());
            Menu.Builder menuBuilder = this.convertMenu();
            responseObserver.onNext((Object)menuBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void runChangeRole(ChangeRoleRequest request, StreamObserver<Session> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Object Request Null");
            }
            this.log.fine("Change Role Requested = " + request.getRoleUuid());
            ContextManager.getContext(request.getSessionUuid(), request.getLanguage(), request.getOrganizationUuid(), request.getWarehouseUuid());
            Session.Builder sessionBuilder = this.changeRole(request);
            responseObserver.onNext((Object)sessionBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    @Override
    public void listRoles(ListRolesRequest request, StreamObserver<ListRolesResponse> responseObserver) {
        try {
            if (request == null) {
                throw new AdempiereException("Lookup Request Null");
            }
            ContextManager.getContext(request.getSessionUuid(), request.getLanguage());
            ListRolesResponse.Builder rolesList = this.convertRolesList(request);
            responseObserver.onNext((Object)rolesList.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(e.getLocalizedMessage()).augmentDescription(e.getLocalizedMessage()).withCause((Throwable)e).asRuntimeException());
        }
    }

    private ListRolesResponse.Builder convertRolesList(ListRolesRequest request) {
        ListRolesResponse.Builder builder = ListRolesResponse.newBuilder();
        MSession session = MSession.get((Properties)Env.getCtx(), (boolean)false, (boolean)false);
        if (session == null) {
            throw new AdempiereException("@AD_Session_ID@ @IsMandatory@");
        }
        String nexPageToken = null;
        int pageNumber = RecordUtil.getPageNumber(request.getSessionUuid(), request.getPageToken());
        int limit = 50;
        int offset = pageNumber * 50;
        Query query = new Query(Env.getCtx(), "AD_Role", "EXISTS(SELECT 1 FROM AD_User_Roles ur WHERE ur.AD_Role_ID = AD_Role.AD_Role_ID AND ur.AD_User_ID = ?)", null).setParameters(new Object[]{session.getCreatedBy()});
        int count = query.count();
        query.setLimit(limit, offset).list().forEach(role -> builder.addRoles(this.convertRole((MRole)role, false)));
        builder.setRecordCount(count);
        if (count > offset && count > limit) {
            nexPageToken = RecordUtil.getPagePrefix(request.getSessionUuid()) + (pageNumber + 1);
        }
        builder.setNextPageToken(ValueUtil.validateNull(nexPageToken));
        return builder;
    }

    private int getUserId(String userName, String userPass) {
        Login login = new Login(Env.getCtx());
        return login.getAuthenticatedUserId(userName, userPass);
    }

    private Session.Builder createSession(LoginRequest request, boolean isDefaultRole) {
        MRole role;
        Session.Builder builder = Session.newBuilder();
        Properties context = Env.getCtx();
        int userId = -1;
        int roleId = -1;
        int organizationId = -1;
        int warehouseId = -1;
        if (!Util.isEmpty((String)request.getToken())) {
            MADToken token = SessionManager.getSessionFromToken(request.getToken());
            if (Optional.ofNullable(token).isPresent()) {
                userId = token.getAD_User_ID();
                roleId = token.getAD_Role_ID();
                organizationId = token.getAD_Org_ID();
            }
        } else {
            userId = this.getUserId(request.getUserName(), request.getUserPass());
            if (userId < 0) {
                throw new AdempiereException("@AD_User_ID@ / @AD_Role_ID@ / @AD_Org_ID@ @NotFound@");
            }
        }
        if (isDefaultRole && Util.isEmpty((String)request.getRoleUuid())) {
            if (roleId <= 0) {
                roleId = DB.getSQLValue(null, (String)"SELECT ur.AD_Role_ID FROM AD_User_Roles ur WHERE ur.AD_User_ID = ? AND ur.IsActive = 'Y' ORDER BY COALESCE(ur.IsDefault,'N') DESC", (int)userId);
            }
            if (organizationId < 0 && (organizationId = SessionManager.getDefaultOrganizationId(roleId, userId)) < 0) {
                organizationId = 0;
            }
            warehouseId = DB.getSQLValue(null, (String)"SELECT M_Warehouse_ID FROM M_Warehouse WHERE IsActive = 'Y' AND AD_Org_ID = ?", (int)organizationId);
        } else {
            if (roleId <= 0 && (role = MRole.get((Properties)context, (int)(roleId = RecordUtil.getIdFromUuid("AD_Role", request.getRoleUuid(), null)))) != null && !Optional.ofNullable(role.getUUID()).orElse("").equals(Optional.ofNullable(request.getRoleUuid()).orElse(""))) {
                roleId = DB.getSQLValue(null, (String)"SELECT ur.AD_Role_ID FROM AD_User_Roles ur WHERE ur.AD_User_ID = ? AND ur.IsActive = 'Y' ORDER BY COALESCE(ur.IsDefault,'N') DESC", (int)userId);
                if (organizationId < 0) {
                    organizationId = SessionManager.getDefaultOrganizationId(roleId, userId);
                }
            }
            if (organizationId < 0) {
                organizationId = RecordUtil.getIdFromUuid("AD_Org", request.getOrganizationUuid(), null);
            }
            warehouseId = RecordUtil.getIdFromUuid("M_Warehouse", request.getWarehouseUuid(), null);
        }
        if (organizationId < 0) {
            throw new AdempiereException("@AD_User_ID@: @AD_Org_ID@ @NotFound@");
        }
        if (warehouseId < 0) {
            warehouseId = 0;
        }
        if (roleId < 0) {
            throw new AdempiereException("@AD_User_ID@ / @AD_Role_ID@ / @AD_Org_ID@ @NotFound@");
        }
        role = MRole.get((Properties)context, (int)roleId);
        Env.setContext((Properties)context, (String)"#M_Warehouse_ID", (int)warehouseId);
        Env.setContext((Properties)context, (String)"#AD_Session_ID", (int)0);
        MClient client = MClient.get((Properties)context, (int)role.getAD_Client_ID());
        Env.setContext((Properties)context, (String)"#AD_Client_ID", (int)client.getAD_Client_ID());
        Env.setContext((Properties)context, (String)"#AD_Org_ID", (int)organizationId);
        Env.setContext((Properties)context, (String)"#AD_Role_ID", (int)roleId);
        Env.setContext((Properties)context, (String)"#AD_User_ID", (int)userId);
        MSession session = MSession.get((Properties)context, (boolean)true);
        if (!Util.isEmpty((String)request.getClientVersion())) {
            session.setWebSession(request.getClientVersion());
        }
        Env.setContext((Properties)context, (String)"#AD_Session_ID", (int)session.getAD_Session_ID());
        Env.setContext((Properties)context, (String)"#Session_UUID", (String)session.getUUID());
        SessionManager.loadDefaultSessionValues(context, request.getLanguage());
        builder.setId(session.getAD_Session_ID());
        builder.setUuid(ValueUtil.validateNull(session.getUUID()));
        builder.setName(ValueUtil.validateNull(session.getDescription()));
        builder.setUserInfo(this.convertUserInfo(MUser.get((Properties)Env.getCtx(), (int)userId)).build());
        Role.Builder roleBuilder = this.convertRole(role, false);
        builder.setRole(roleBuilder.build());
        this.populateDefaultPreferences(builder);
        return builder;
    }

    private ContextValue.Builder convertObjectFromContext(String value) {
        ContextValue.Builder builder = ContextValue.newBuilder();
        if (Util.isEmpty((String)value)) {
            return builder;
        }
        if (ValueUtil.isNumeric(value)) {
            builder.setValueType(ContextValue.ValueType.INTEGER);
            builder.setIntValue(ValueUtil.getIntegerFromString(value));
        } else if (ValueUtil.isBoolean(value)) {
            builder.setValueType(ContextValue.ValueType.BOOLEAN);
            builder.setBooleanValue(value.trim().equals("Y") || value.trim().equals("true"));
        } else if (ValueUtil.isDate(value)) {
            builder.setValueType(ContextValue.ValueType.DATE);
            builder.setLongValue(ValueUtil.getDateFromString(value).getTime());
        } else {
            builder.setValueType(ContextValue.ValueType.STRING);
            builder.setStringValue(ValueUtil.validateNull(value));
        }
        return builder;
    }

    private Session.Builder changeRole(ChangeRoleRequest request) {
        int warehouseId;
        Session.Builder builder = Session.newBuilder();
        DB.validateSupportedUUIDFromDB();
        MSession currentSession = MSession.get((Properties)Env.getCtx(), (boolean)false, (boolean)false);
        int userId = currentSession.getCreatedBy();
        int roleId = DB.getSQLValue(null, (String)"SELECT AD_Role_ID FROM AD_Role WHERE UUID = ?", (String)request.getRoleUuid());
        int organizationId = DB.getSQLValue(null, (String)"SELECT AD_Org_ID FROM AD_Org WHERE UUID = ?", (String)request.getOrganizationUuid());
        if (organizationId < 0) {
            organizationId = SessionManager.getDefaultOrganizationId(roleId, userId);
        }
        if (organizationId < 0) {
            organizationId = 0;
        }
        if ((warehouseId = DB.getSQLValue(null, (String)"SELECT M_Warehouse_ID FROM M_Warehouse WHERE UUID = ? AND AD_Org_ID = ?", (Object[])new Object[]{request.getWarehouseUuid(), organizationId})) < 0) {
            warehouseId = 0;
        }
        if (roleId < 0) {
            throw new AdempiereException("@AD_User_ID@ / @AD_Role_ID@ / @AD_Org_ID@ @NotFound@");
        }
        MRole role = MRole.get((Properties)Env.getCtx(), (int)roleId);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Session_ID", (int)0);
        Env.setContext((Properties)Env.getCtx(), (String)"#Session_UUID", (String)"");
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_User_ID", (int)userId);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)roleId);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)role.getAD_Client_ID());
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Org_ID", (int)organizationId);
        MSession session = MSession.get((Properties)Env.getCtx(), (boolean)true);
        if (!Util.isEmpty((String)request.getClientVersion())) {
            session.setWebSession(request.getClientVersion());
        }
        Env.setContext((Properties)Env.getCtx(), (String)"#M_Warehouse_ID", (int)warehouseId);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Session_ID", (int)session.getAD_Session_ID());
        SessionManager.loadDefaultSessionValues(Env.getCtx(), request.getLanguage());
        builder.setId(session.getAD_Session_ID());
        builder.setUuid(ValueUtil.validateNull(session.getUUID()));
        builder.setName(ValueUtil.validateNull(session.getDescription()));
        builder.setUserInfo(this.convertUserInfo(MUser.get((Properties)Env.getCtx(), (int)userId)).build());
        this.populateDefaultPreferences(builder);
        Role.Builder roleBuilder = this.convertRole(role, false);
        builder.setRole(roleBuilder.build());
        LogoutRequest logoutRequest = LogoutRequest.newBuilder().setSessionUuid(request.getSessionUuid()).setClientVersion(request.getClientVersion()).setLanguage(request.getLanguage()).build();
        this.logoutSession(logoutRequest);
        return builder;
    }

    private void populateDefaultPreferences(Session.Builder session) {
        MCountry country = MCountry.get((Properties)Env.getCtx(), (int)Env.getContextAsInt((Properties)Env.getCtx(), (String)"#C_Country_ID"));
        MCurrency currency = MCurrency.get((Properties)Env.getCtx(), (int)country.getC_Currency_ID());
        session.setCountryId(country.getC_Country_ID());
        session.setCountryCode(ValueUtil.validateNull(country.getCountryCode()));
        session.setCountryName(ValueUtil.validateNull(country.getName()));
        session.setDisplaySequence(ValueUtil.validateNull(country.getDisplaySequence()));
        session.setCurrencyIsoCode(ValueUtil.validateNull(currency.getISO_Code()));
        session.setCurrencyName(ValueUtil.validateNull(currency.getDescription()));
        session.setCurrencySymbol(ValueUtil.validateNull(currency.getCurSymbol()));
        session.setStandardPrecision(currency.getStdPrecision());
        session.setCostingPrecision(currency.getCostingPrecision());
        session.setLanguage(ValueUtil.validateNull(ContextManager.getDefaultLanguage(Env.getAD_Language((Properties)Env.getCtx()))));
        Env.getCtx().entrySet().stream().filter(keyValue -> String.valueOf(keyValue.getKey()).startsWith("#") || String.valueOf(keyValue.getKey()).startsWith("$")).forEach(contextKeyValue -> session.putDefaultContext(contextKeyValue.getKey().toString(), this.convertObjectFromContext((String)contextKeyValue.getValue()).build()));
    }

    private Session.Builder logoutSession(LogoutRequest request) {
        Session.Builder builder = Session.newBuilder();
        if (Util.isEmpty((String)request.getSessionUuid())) {
            throw new AdempiereException("@AD_Session_ID@ @NotFound@");
        }
        Properties context = Env.getCtx();
        MSession session = this.getSessionFromUUid(request.getSessionUuid());
        session.logout();
        builder.setId(session.getAD_Session_ID());
        builder.setUuid(ValueUtil.validateNull(session.getUUID()));
        builder.setName(ValueUtil.validateNull(session.getDescription()));
        builder.setUserInfo(this.convertUserInfo(MUser.get((Properties)context, (int)session.getCreatedBy())).build());
        return builder;
    }

    private Session.Builder getSessionInfo(SessionRequest request) {
        Session.Builder builder = Session.newBuilder();
        if (Util.isEmpty((String)request.getSessionUuid())) {
            throw new AdempiereException("@AD_Session_ID@ @NotFound@");
        }
        Properties context = Env.getCtx();
        MSession session = this.getSessionFromUUid(request.getSessionUuid());
        SessionManager.loadDefaultSessionValues(context, null);
        builder.setId(session.getAD_Session_ID());
        builder.setUuid(ValueUtil.validateNull(session.getUUID()));
        builder.setName(ValueUtil.validateNull(session.getDescription()));
        builder.setUserInfo(this.convertUserInfo(MUser.get((Properties)context, (int)session.getCreatedBy())).build());
        Role.Builder roleBuilder = this.convertRole(MRole.get((Properties)context, (int)session.getAD_Role_ID()), false);
        builder.setRole(roleBuilder.build());
        this.populateDefaultPreferences(builder);
        return builder;
    }

    private UserInfo.Builder convertUserInfo(MUser user) {
        UserInfo.Builder userInfo = UserInfo.newBuilder();
        userInfo.setId(user.getAD_User_ID());
        userInfo.setUuid(ValueUtil.validateNull(user.getUUID()));
        userInfo.setName(ValueUtil.validateNull(user.getName()));
        userInfo.setDescription(ValueUtil.validateNull(user.getDescription()));
        userInfo.setComments(ValueUtil.validateNull(user.getComments()));
        if (user.getLogo_ID() > 0 && AttachmentUtil.getInstance().isValidForClient(user.getAD_Client_ID())) {
            MClientInfo clientInfo = MClientInfo.get((Properties)Env.getCtx(), (int)user.getAD_Client_ID());
            MADAttachmentReference attachmentReference = MADAttachmentReference.getByImageId((Properties)user.getCtx(), (int)clientInfo.getFileHandler_ID(), (int)user.getLogo_ID(), null);
            if (attachmentReference != null && attachmentReference.getAD_AttachmentReference_ID() > 0) {
                userInfo.setImage(ValueUtil.validateNull(attachmentReference.getValidFileName()));
            }
        }
        Object value = user.get_Value("ConnectionTimeout");
        long sessionTimeout = 0L;
        if (value == null) {
            String sessionTimeoutAsString = MSysConfig.getValue((String)"WEBUI_DEFAULT_TIMEOUT", (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)0);
            try {
                sessionTimeout = Long.parseLong(sessionTimeoutAsString);
            }
            catch (Exception e) {
                this.log.severe(e.getLocalizedMessage());
            }
        } else {
            try {
                sessionTimeout = Long.parseLong(String.valueOf(value));
            }
            catch (Exception e) {
                this.log.severe(e.getLocalizedMessage());
            }
        }
        userInfo.setConnectionTimeout(sessionTimeout);
        return userInfo;
    }

    private MSession getSessionFromUUid(String sessionUuid) {
        MSession session = (MSession)new Query(Env.getCtx(), "AD_Session", "UUID = ?", null).setParameters(new Object[]{sessionUuid}).first();
        if (session == null || session.getAD_Session_ID() <= 0) {
            throw new AdempiereException("@AD_Session_ID@ @NotFound@");
        }
        if (session.isProcessed()) {
            throw new AdempiereException("@AD_Session_ID@ @Expired@");
        }
        return session;
    }

    private UserInfo.Builder convertUserInfo(UserInfoRequest request) {
        if (Util.isEmpty((String)request.getSessionUuid())) {
            throw new AdempiereException("@AD_Session_ID@ @NotFound@");
        }
        MSession session = this.getSessionFromUUid(request.getSessionUuid());
        List roleList = new Query(Env.getCtx(), "AD_Role", "EXISTS(SELECT 1 FROM AD_User_Roles ur WHERE ur.AD_Role_ID = AD_Role.AD_Role_ID AND ur.AD_User_ID = ?)", null).setParameters(new Object[]{session.getCreatedBy()}).setOnlyActiveRecords(true).list();
        if (roleList == null || roleList.size() == 0) {
            return null;
        }
        MUser user = MUser.get((Properties)Env.getCtx(), (int)session.getCreatedBy());
        if (user == null || user.getAD_User_ID() <= 0) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        return this.convertUserInfo(user);
    }

    private Role.Builder convertRole(MRole role, boolean withAccess) {
        Role.Builder builder = null;
        if (role != null) {
            MClient client = MClient.get((Properties)Env.getCtx(), (int)role.getAD_Client_ID());
            builder = Role.newBuilder().setId(role.getAD_Role_ID()).setUuid(ValueUtil.validateNull(role.getUUID())).setName(ValueUtil.validateNull(role.getName())).setDescription(ValueUtil.validateNull(role.getDescription())).setClientName(ValueUtil.validateNull(client.getName())).setClientId(role.getAD_Client_ID()).setIsCanExport(role.isCanExport()).setIsCanReport(role.isCanReport()).setIsPersonalAccess(role.isPersonalAccess()).setIsPersonalLock(role.isPersonalLock()).setIsAllowHtmlView(role.isAllow_HTML_View()).setIsAllowInfoAccount(role.isAllow_Info_Account()).setIsAllowInfoAsset(role.isAllow_Info_Asset()).setIsAllowInfoBusinessPartner(role.isAllow_Info_BPartner()).setIsAllowInfoCashJournal(role.isAllow_Info_CashJournal()).setIsAllowInfoCrp(role.isAllow_Info_CRP()).setIsAllowInfoInOut(role.isAllow_Info_InOut()).setIsAllowInfoInvoice(role.isAllow_Info_Invoice()).setIsAllowInfoMrp(role.isAllow_Info_MRP()).setIsAllowInfoOrder(role.isAllow_Info_Order()).setIsAllowInfoPayment(role.isAllow_Info_Payment()).setIsAllowInfoProduct(role.isAllow_Info_Product()).setIsAllowInfoResource(role.isAllow_Info_Resource()).setIsAllowInfoSchedule(role.isAllow_Info_Schedule()).setIsAllowXlsView(role.isAllow_XLS_View());
            if (withAccess) {
                // empty if block
            }
        }
        return builder;
    }

    private Menu.Builder convertMenu() {
        int roleId = Env.getAD_Role_ID((Properties)Env.getCtx());
        int userId = Env.getAD_User_ID((Properties)Env.getCtx());
        String menuKey = roleId + "|" + userId + "|" + Env.getAD_Language((Properties)Env.getCtx());
        Menu.Builder builder = (Menu.Builder)menuCache.get((Object)menuKey);
        if (builder != null) {
            return builder;
        }
        builder = Menu.newBuilder();
        MMenu menu = new MMenu(Env.getCtx(), 0, null);
        menu.setName(Msg.getMsg((Properties)Env.getCtx(), (String)"Menu"));
        int treeId = DB.getSQLValue(null, (String)"SELECT COALESCE(r.AD_Tree_Menu_ID, ci.AD_Tree_Menu_ID)FROM AD_ClientInfo ci INNER JOIN AD_Role r ON (ci.AD_Client_ID=r.AD_Client_ID) WHERE AD_Role_ID=?", (int)roleId);
        if (treeId <= 0) {
            treeId = MTree.getDefaultTreeIdFromTableId((int)menu.getAD_Client_ID(), (int)I_AD_Menu.Table_ID);
        }
        if (treeId != 0) {
            MTree tree = new MTree(Env.getCtx(), treeId, false, false, null, null);
            builder = this.convertMenu(Env.getCtx(), menu, 0, Env.getAD_Language((Properties)Env.getCtx()));
            MTreeNode rootNode = tree.getRoot();
            Enumeration childrens = rootNode.children();
            while (childrens.hasMoreElements()) {
                MTreeNode child = (MTreeNode)childrens.nextElement();
                Menu.Builder childBuilder = this.convertMenu(Env.getCtx(), MMenu.getFromId((Properties)Env.getCtx(), (int)child.getNode_ID()), child.getParent_ID(), Env.getAD_Language((Properties)Env.getCtx()));
                this.addChildren(Env.getCtx(), childBuilder, child, Env.getAD_Language((Properties)Env.getCtx()));
                builder.addChilds(childBuilder.build());
            }
        }
        menuCache.put((Object)menuKey, (Object)builder);
        return builder;
    }

    private Menu.Builder convertMenu(Properties context, MMenu menu, int parentId, String language) {
        String name = null;
        String description = null;
        if (!Util.isEmpty((String)language)) {
            name = menu.get_Translation("Name", language);
            description = menu.get_Translation("Description", language);
        }
        if (Util.isEmpty(name)) {
            name = menu.getName();
        }
        if (Util.isEmpty(description)) {
            description = menu.getDescription();
        }
        String parentUuid = null;
        if (parentId > 0) {
            parentUuid = MMenu.getFromId((Properties)context, (int)parentId).getUUID();
        }
        Menu.Builder builder = Menu.newBuilder().setId(menu.getAD_Menu_ID()).setUuid(ValueUtil.validateNull(menu.getUUID())).setName(ValueUtil.validateNull(name)).setDescription(ValueUtil.validateNull(description)).setAction(ValueUtil.validateNull(menu.getAction())).setIsSOTrx(menu.isSOTrx()).setIsSummary(menu.isSummary()).setIsReadOnly(menu.isReadOnly()).setIsActive(menu.isActive()).setParentUuid(ValueUtil.validateNull(parentUuid));
        if (!Util.isEmpty((String)menu.getAction())) {
            String referenceUuid = null;
            if (menu.getAction().equals("X")) {
                if (menu.getAD_Form_ID() > 0) {
                    MForm form = new MForm(context, menu.getAD_Form_ID(), null);
                    referenceUuid = form.getUUID();
                }
            } else if (menu.getAction().equals("W")) {
                if (menu.getAD_Window_ID() > 0) {
                    MWindow window = new MWindow(context, menu.getAD_Window_ID(), null);
                    referenceUuid = window.getUUID();
                }
            } else if (menu.getAction().equals("P") || menu.getAction().equals("R")) {
                if (menu.getAD_Process_ID() > 0) {
                    MProcess process = MProcess.get((Properties)context, (int)menu.getAD_Process_ID());
                    referenceUuid = process.getUUID();
                }
            } else if (menu.getAction().equals("S") && menu.getAD_Browse_ID() > 0) {
                MBrowse smartBrowser = MBrowse.get((Properties)context, (int)menu.getAD_Browse_ID());
                referenceUuid = smartBrowser.getUUID();
            }
            builder.setReferenceUuid(ValueUtil.validateNull(referenceUuid));
        }
        return builder;
    }

    private void addChildren(Properties context, Menu.Builder builder, MTreeNode node, String language) {
        Enumeration childrens = node.children();
        while (childrens.hasMoreElements()) {
            MTreeNode child = (MTreeNode)childrens.nextElement();
            Menu.Builder childBuilder = this.convertMenu(context, MMenu.getFromId((Properties)context, (int)child.getNode_ID()), child.getParent_ID(), language);
            this.addChildren(context, childBuilder, child, language);
            builder.addChilds(childBuilder.build());
        }
    }
}

