/*
 * Decompiled with CFR 0.152.
 */
package org.spin.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.spin.grpc.util.ClientRequest;
import org.spin.grpc.util.Condition;
import org.spin.grpc.util.Criteria;
import org.spin.grpc.util.ListTabEntitiesRequest;
import org.spin.grpc.util.ListTabEntitiesResponse;
import org.spin.grpc.util.UserInterfaceGrpc;
import org.spin.grpc.util.Value;

public class UserInterface {
    private static final Logger logger = Logger.getLogger(UserInterface.class.getName());
    private final ManagedChannel channel;
    private final UserInterfaceGrpc.UserInterfaceBlockingStub blockingStub;

    public UserInterface(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build());
    }

    UserInterface(ManagedChannel channel) {
        this.channel = channel;
        this.blockingStub = UserInterfaceGrpc.newBlockingStub((Channel)channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void requestProcess() {
        ClientRequest clientRequest = ClientRequest.newBuilder().setSessionUuid("c8a1c844-35eb-472e-a461-9f06cd2680b8").build();
        ListTabEntitiesRequest request = ListTabEntitiesRequest.newBuilder().setClientRequest(clientRequest).setTabUuid("a4a1007a-fb40-11e8-a479-7a0060f0aa01").setFilters(Criteria.newBuilder().addConditions(Condition.newBuilder().setColumnName("Value").setOperatorValue(11).addValues(Value.newBuilder().setStringValue("Test").setValueTypeValue(4)))).build();
        try {
            ListTabEntitiesResponse response = this.blockingStub.listTabEntities(request);
            logger.info("Cache Reset: " + response);
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        UserInterface client = new UserInterface("localhost", 50059);
        try {
            logger.info("####################### List Entities from tab #####################");
            client.requestProcess();
            client.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

