/*
 * Decompiled with CFR 0.152.
 */
package org.spin.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.spin.grpc.enrollment.EnrollUserRequest;
import org.spin.grpc.enrollment.RegisterGrpc;
import org.spin.grpc.enrollment.ResetPasswordRequest;
import org.spin.grpc.enrollment.ResetPasswordResponse;
import org.spin.grpc.enrollment.User;

public class EnrollmentClient {
    private static final Logger logger = Logger.getLogger(EnrollmentClient.class.getName());
    private final ManagedChannel channel;
    private final RegisterGrpc.RegisterBlockingStub blockingStub;

    public EnrollmentClient(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build());
    }

    EnrollmentClient(ManagedChannel channel) {
        this.channel = channel;
        this.blockingStub = RegisterGrpc.newBlockingStub((Channel)channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void enrollUser() {
        EnrollUserRequest userRequest = EnrollUserRequest.newBuilder().setUserName("yamelsenih").setName("Yamel Senih").setEmail("ysenih@erpya.com").build();
        try {
            User response = this.blockingStub.enrollUser(userRequest);
            logger.info("User Enrolled: " + response);
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
    }

    public void resetPassword() {
        ResetPasswordRequest resetRequest = ResetPasswordRequest.newBuilder().setUserName("yamelsenih").setEmail("ysenih@erpya.com").build();
        try {
            ResetPasswordResponse response = this.blockingStub.resetPassword(resetRequest);
            logger.info("Reset Password Status: " + response.getResponseTypeValue());
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        EnrollmentClient client = new EnrollmentClient("localhost", 50053);
        try {
            logger.info("####################### Enroll User #####################");
            client.enrollUser();
            logger.info("####################### Reset Password #####################");
            client.resetPassword();
        }
        finally {
            client.shutdown();
        }
    }
}

