/*
 * Decompiled with CFR 0.152.
 */
package org.spin.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.spin.grpc.util.ApplicationRequest;
import org.spin.grpc.util.DictionaryGrpc;
import org.spin.grpc.util.EntityRequest;
import org.spin.grpc.util.Tab;
import org.spin.grpc.util.Window;

public class DictionaryClient {
    private static final Logger logger = Logger.getLogger(DictionaryClient.class.getName());
    private final ManagedChannel channel;
    private final DictionaryGrpc.DictionaryBlockingStub blockingStub;

    public DictionaryClient(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build());
    }

    DictionaryClient(ManagedChannel channel) {
        this.channel = channel;
        this.blockingStub = DictionaryGrpc.newBlockingStub((Channel)channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void requestWindow(boolean withTabs) {
        ApplicationRequest applicationRequest = ApplicationRequest.newBuilder().setLanguage("es_MX").build();
        EntityRequest request = EntityRequest.newBuilder().setUuid("a520de12-fb40-11e8-a479-7a0060f0aa01").setApplicationRequest(applicationRequest).build();
        try {
            Window response;
            if (withTabs) {
                response = this.blockingStub.getWindow(request);
                for (Tab tab : response.getTabsList()) {
                    logger.info("Tab: " + tab);
                }
            } else {
                response = this.blockingStub.getWindow(request);
            }
            logger.info("Window: " + response);
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        DictionaryClient client = new DictionaryClient("localhost", 50051);
        try {
            logger.info("####################### Window + Tabs #####################");
            client.requestWindow(true);
        }
        finally {
            client.shutdown();
        }
    }
}

