/*
 * Decompiled with CFR 0.152.
 */
package org.spin.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.spin.grpc.util.BusinessDataGrpc;
import org.spin.grpc.util.ClientRequest;
import org.spin.grpc.util.ProcessLog;
import org.spin.grpc.util.RunBusinessProcessRequest;

public class BusinessDataClient {
    private static final Logger logger = Logger.getLogger(BusinessDataClient.class.getName());
    private final ManagedChannel channel;
    private final BusinessDataGrpc.BusinessDataBlockingStub blockingStub;

    public BusinessDataClient(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build());
    }

    BusinessDataClient(ManagedChannel channel) {
        this.channel = channel;
        this.blockingStub = BusinessDataGrpc.newBlockingStub((Channel)channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void requestProcess() {
        ClientRequest clientRequest = ClientRequest.newBuilder().setSessionUuid("53c1c836-6e47-11e9-8160-3709b250e4e1").build();
        RunBusinessProcessRequest request = RunBusinessProcessRequest.newBuilder().setClientRequest(clientRequest).setUuid("a42acf86-fb40-11e8-a479-7a0060f0aa01").build();
        try {
            ProcessLog response = this.blockingStub.runBusinessProcess(request);
            logger.info("Cache Reset: " + response);
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        BusinessDataClient client = new BusinessDataClient("localhost", 50052);
        try {
            logger.info("####################### Report Output #####################");
            client.requestProcess();
            client.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

