/*
 * Decompiled with CFR 0.152.
 */
package org.spin.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.spin.grpc.util.LoginRequest;
import org.spin.grpc.util.LogoutRequest;
import org.spin.grpc.util.SecurityGrpc;
import org.spin.grpc.util.Session;

public class AccessClient {
    private static final Logger logger = Logger.getLogger(AccessClient.class.getName());
    private final ManagedChannel channel;
    private final SecurityGrpc.SecurityBlockingStub blockingStub;

    public AccessClient(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build());
    }

    AccessClient(ManagedChannel channel) {
        this.channel = channel;
        this.blockingStub = SecurityGrpc.newBlockingStub((Channel)channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void requestLogin() {
        LoginRequest request = LoginRequest.newBuilder().setClientVersion("Version Epale (" + System.currentTimeMillis() + ")").setUserName("SuperUser").setUserPass("System").setOrganizationUuid("a3e5c878-fb40-11e8-a479-7a0060f0aa01").setRoleUuid("a48d2596-fb40-11e8-a479-7a0060f0aa01").setLanguage("es_MX").build();
        try {
            Session response = this.blockingStub.runLogin(request);
            logger.info("User Session: " + response);
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
    }

    public void requestLogout() {
        LogoutRequest request = LogoutRequest.newBuilder().setClientVersion("Version Epale (" + System.currentTimeMillis() + ")").setSessionUuid("25f773a4-6a48-11e9-9537-070abd038317").build();
        try {
            Session response = this.blockingStub.runLogout(request);
            logger.info("User Session Logout: " + response);
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        AccessClient client = new AccessClient("localhost", 50050);
        try {
            logger.info("####################### Request Login #####################");
            client.requestLogin();
            logger.info("####################### Request Logout #####################");
            client.requestLogout();
        }
        finally {
            client.shutdown();
        }
    }
}

