/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.util;

import java.util.List;
import java.util.Properties;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFEventAudit;
import org.compiere.wf.MWFNextCondition;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWFResponsible;
import org.compiere.wf.MWorkflow;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.WorkflowActivity;
import org.spin.grpc.util.WorkflowCondition;
import org.spin.grpc.util.WorkflowDefinition;
import org.spin.grpc.util.WorkflowEvent;
import org.spin.grpc.util.WorkflowNode;
import org.spin.grpc.util.WorkflowProcess;
import org.spin.grpc.util.WorkflowTransition;

public class WorkflowUtil {
    public static WorkflowProcess.Builder convertWorkflowProcess(MWFProcess workflowProcess) {
        String translation;
        MTable table = MTable.get((Properties)workflowProcess.getCtx(), (int)workflowProcess.getAD_Table_ID());
        WorkflowProcess.Builder builder = WorkflowProcess.newBuilder();
        builder.setProcessUuid(ValueUtil.validateNull(workflowProcess.getUUID()));
        MWorkflow workflow = MWorkflow.get((Properties)workflowProcess.getCtx(), (int)workflowProcess.getAD_Workflow_ID());
        builder.setWorkflowUuid(ValueUtil.validateNull(workflow.getUUID()));
        String workflowName = workflow.getName();
        if (!Env.isBaseLanguage((Properties)workflowProcess.getCtx(), (String)"") && !Util.isEmpty((String)(translation = workflow.get_Translation("Name")))) {
            workflowName = translation;
        }
        if (workflowProcess.getAD_WF_Responsible_ID() != 0) {
            MWFResponsible responsible = MWFResponsible.get((Properties)workflowProcess.getCtx(), (int)workflowProcess.getAD_WF_Responsible_ID());
            builder.setResponsibleUuid(ValueUtil.validateNull(responsible.getUUID()));
            builder.setResponsibleName(ValueUtil.validateNull(responsible.getName()));
        }
        if (workflowProcess.getAD_User_ID() != 0) {
            MUser user = MUser.get((Properties)workflowProcess.getCtx(), (int)workflowProcess.getAD_User_ID());
            builder.setUserUuid(ValueUtil.validateNull(user.getUUID()));
            builder.setUserName(ValueUtil.validateNull(user.getName()));
        }
        builder.setWorkflowName(ValueUtil.validateNull(workflowName));
        builder.setId(workflowProcess.getRecord_ID());
        builder.setUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId(table.getTableName(), workflowProcess.getRecord_ID())));
        builder.setTableName(ValueUtil.validateNull(table.getTableName()));
        builder.setTextMessage(ValueUtil.validateNull(Msg.parseTranslation((Properties)workflowProcess.getCtx(), (String)workflowProcess.getTextMsg())));
        builder.setProcessed(workflowProcess.isProcessed());
        builder.setLogDate(workflowProcess.getCreated().getTime());
        if (!Util.isEmpty((String)workflowProcess.getWFState())) {
            if (workflowProcess.getWFState().equals("OR")) {
                builder.setWorkflowState(WorkflowProcess.WorkflowState.RUNNING);
            } else if (workflowProcess.getWFState().equals("CC")) {
                builder.setWorkflowState(WorkflowProcess.WorkflowState.COMPLETED);
            } else if (workflowProcess.getWFState().equals("CA")) {
                builder.setWorkflowState(WorkflowProcess.WorkflowState.ABORTED);
            } else if (workflowProcess.getWFState().equals("CT")) {
                builder.setWorkflowState(WorkflowProcess.WorkflowState.TERMINATED);
            } else if (workflowProcess.getWFState().equals("OS")) {
                builder.setWorkflowState(WorkflowProcess.WorkflowState.SUSPENDED);
            } else if (workflowProcess.getWFState().equals("ON")) {
                builder.setWorkflowState(WorkflowProcess.WorkflowState.NOT_STARTED);
            }
        }
        builder.setPriorityValue(workflowProcess.getPriority());
        List workflowEventsList = new Query(workflowProcess.getCtx(), "AD_WF_EventAudit", "AD_WF_Process_ID = ?", null).setParameters(new Object[]{workflowProcess.getAD_WF_Process_ID()}).list();
        for (MWFEventAudit eventAudit : workflowEventsList) {
            WorkflowEvent.Builder valueObject = WorkflowUtil.convertWorkflowEventAudit(eventAudit);
            builder.addWorkflowEvents(valueObject.build());
        }
        return builder;
    }

    public static WorkflowDefinition.Builder convertWorkflowDefinition(MWorkflow workflow) {
        MTable table = MTable.get((Properties)workflow.getCtx(), (int)workflow.getAD_Table_ID());
        WorkflowDefinition.Builder builder = WorkflowDefinition.newBuilder();
        builder.setWorkflowUuid(ValueUtil.validateNull(workflow.getUUID()));
        builder.setValue(ValueUtil.validateNull(workflow.getValue()));
        String name = workflow.getName();
        String description = workflow.getDescription();
        String help = workflow.getHelp();
        if (!Env.isBaseLanguage((Properties)workflow.getCtx(), (String)"")) {
            String translation = workflow.get_Translation("Name");
            if (!Util.isEmpty((String)translation)) {
                name = translation;
            }
            if (!Util.isEmpty((String)(translation = workflow.get_Translation("Description")))) {
                description = translation;
            }
            if (!Util.isEmpty((String)(translation = workflow.get_Translation("Help")))) {
                help = translation;
            }
        }
        builder.setName(ValueUtil.validateNull(name));
        builder.setDescription(ValueUtil.validateNull(description));
        builder.setHelp(ValueUtil.validateNull(help));
        if (workflow.getAD_WF_Responsible_ID() != 0) {
            MWFResponsible responsible = MWFResponsible.get((Properties)workflow.getCtx(), (int)workflow.getAD_WF_Responsible_ID());
            builder.setResponsibleUuid(ValueUtil.validateNull(responsible.getUUID()));
            builder.setResponsibleName(ValueUtil.validateNull(responsible.getName()));
        }
        builder.setPriority(workflow.getPriority());
        builder.setTableName(ValueUtil.validateNull(table.getTableName()));
        builder.setIsDefault(workflow.isDefault());
        builder.setIsValid(workflow.isValid());
        if (workflow.getValidFrom() != null) {
            builder.setValidFrom(workflow.getValidFrom().getTime());
        }
        if (!Util.isEmpty((String)workflow.getDurationUnit())) {
            if (workflow.getDurationUnit().equals("D")) {
                builder.setDurationUnitValue(1);
            } else if (workflow.getDurationUnit().equals("m")) {
                builder.setDurationUnitValue(2);
            } else if (workflow.getDurationUnit().equals("M")) {
                builder.setDurationUnitValue(3);
            } else if (workflow.getDurationUnit().equals("s")) {
                builder.setDurationUnitValue(4);
            } else if (workflow.getDurationUnit().equals("Y")) {
                builder.setDurationUnitValue(5);
            }
        }
        if (!Util.isEmpty((String)workflow.getPublishStatus())) {
            if (workflow.getPublishStatus().equals("R")) {
                builder.setPublishStatusValue(0);
            } else if (workflow.getPublishStatus().equals("T")) {
                builder.setDurationUnitValue(1);
            } else if (workflow.getPublishStatus().equals("U")) {
                builder.setDurationUnitValue(2);
            } else if (workflow.getPublishStatus().equals("V")) {
                builder.setDurationUnitValue(3);
            }
        }
        if (workflow.getAD_WF_Node_ID() != 0) {
            MWFNode startNode = MWFNode.get((Properties)workflow.getCtx(), (int)workflow.getAD_WF_Node_ID());
            builder.setStartNode(WorkflowUtil.convertWorkflowNode(startNode));
        }
        List workflowNodeList = new Query(workflow.getCtx(), "AD_WF_Node", "AD_Workflow_ID = ?", null).setParameters(new Object[]{workflow.getAD_Workflow_ID()}).list();
        for (MWFNode node : workflowNodeList) {
            WorkflowNode.Builder valueObject = WorkflowUtil.convertWorkflowNode(node);
            builder.addWorkflowNodes(valueObject.build());
        }
        return builder;
    }

    public static WorkflowNode.Builder convertWorkflowNode(MWFNode node) {
        WorkflowNode.Builder builder = WorkflowNode.newBuilder();
        builder.setNodeUuid(ValueUtil.validateNull(node.getUUID()));
        builder.setValue(ValueUtil.validateNull(node.getValue()));
        String name = node.getName();
        String description = node.getDescription();
        String help = node.getHelp();
        if (!Env.isBaseLanguage((Properties)node.getCtx(), (String)"")) {
            String translation = node.get_Translation("Name");
            if (!Util.isEmpty((String)translation)) {
                name = translation;
            }
            if (!Util.isEmpty((String)(translation = node.get_Translation("Description")))) {
                description = translation;
            }
            if (!Util.isEmpty((String)(translation = node.get_Translation("Help")))) {
                help = translation;
            }
        }
        builder.setName(ValueUtil.validateNull(name));
        builder.setDescription(ValueUtil.validateNull(description));
        builder.setHelp(ValueUtil.validateNull(help));
        if (node.getAD_WF_Responsible_ID() != 0) {
            MWFResponsible responsible = MWFResponsible.get((Properties)node.getCtx(), (int)node.getAD_WF_Responsible_ID());
            builder.setResponsibleUuid(ValueUtil.validateNull(responsible.getUUID()));
            builder.setResponsibleName(ValueUtil.validateNull(responsible.getName()));
        }
        builder.setPriority(node.getPriority());
        List workflowNodeTransitionList = new Query(node.getCtx(), "AD_WF_NodeNext", "AD_WF_Node_ID = ?", null).setParameters(new Object[]{node.getAD_WF_Node_ID()}).list();
        for (MWFNodeNext nodeNext : workflowNodeTransitionList) {
            WorkflowTransition.Builder valueObject = WorkflowUtil.convertTransition(nodeNext);
            builder.addTransitions(valueObject.build());
        }
        return builder;
    }

    public static WorkflowTransition.Builder convertTransition(MWFNodeNext transition) {
        WorkflowTransition.Builder builder = WorkflowTransition.newBuilder();
        MWFNode nodeNext = MWFNode.get((Properties)transition.getCtx(), (int)transition.getAD_WF_NodeNext_ID());
        builder.setNodeNextUuid(ValueUtil.validateNull(nodeNext.getUUID()));
        builder.setDescription(ValueUtil.validateNull(transition.getDescription()));
        builder.setSequence(transition.getSeqNo());
        builder.setIsStdUserWorkflow(transition.isStdUserWorkflow());
        List workflowNodeTransitionList = new Query(transition.getCtx(), "AD_WF_NextCondition", "AD_WF_NodeNext_ID = ?", null).setParameters(new Object[]{transition.getAD_WF_Node_ID()}).list();
        for (MWFNextCondition nextCondition : workflowNodeTransitionList) {
            WorkflowCondition.Builder valueObject = WorkflowUtil.convertWorkflowCondition(nextCondition);
            builder.addWorkflowConditions(valueObject.build());
        }
        return builder;
    }

    public static WorkflowCondition.Builder convertWorkflowCondition(MWFNextCondition condition) {
        WorkflowCondition.Builder builder = WorkflowCondition.newBuilder();
        builder.setSequence(condition.getSeqNo());
        MColumn column = MColumn.get((Properties)condition.getCtx(), (int)condition.getAD_Column_ID());
        builder.setColumnName(ValueUtil.validateNull(column.getColumnName()));
        builder.setValue(ValueUtil.validateNull(condition.getValue()));
        if (!Util.isEmpty((String)condition.getAndOr())) {
            if (condition.getAndOr().equals("A")) {
                builder.setConditionTypeValue(0);
            } else if (condition.getAndOr().equals("O")) {
                builder.setConditionTypeValue(1);
            }
        }
        if (!Util.isEmpty((String)condition.getOperation())) {
            if (condition.getOperation().equals("==")) {
                builder.setOperation(WorkflowCondition.Operation.EQUAL);
            } else if (condition.getOperation().equals("!=")) {
                builder.setOperation(WorkflowCondition.Operation.NOT_EQUAL);
            } else if (condition.getOperation().equals("~~")) {
                builder.setOperation(WorkflowCondition.Operation.LIKE);
            } else if (condition.getOperation().equals(">>")) {
                builder.setOperation(WorkflowCondition.Operation.GREATER);
            } else if (condition.getOperation().equals(">=")) {
                builder.setOperation(WorkflowCondition.Operation.GREATER_EQUAL);
            } else if (condition.getOperation().equals("<<")) {
                builder.setOperation(WorkflowCondition.Operation.LESS);
            } else if (condition.getOperation().equals("<=")) {
                builder.setOperation(WorkflowCondition.Operation.LESS_EQUAL);
            } else if (condition.getOperation().equals("AB")) {
                builder.setOperation(WorkflowCondition.Operation.BETWEEN);
            } else if (condition.getOperation().equals("SQ")) {
                builder.setOperation(WorkflowCondition.Operation.SQL);
            }
        }
        return builder;
    }

    public static WorkflowEvent.Builder convertWorkflowEventAudit(MWFEventAudit workflowEventAudit) {
        String translation;
        MTable table = MTable.get((Properties)workflowEventAudit.getCtx(), (int)workflowEventAudit.getAD_Table_ID());
        WorkflowEvent.Builder builder = WorkflowEvent.newBuilder();
        MWFNode node = MWFNode.get((Properties)workflowEventAudit.getCtx(), (int)workflowEventAudit.getAD_WF_Node_ID());
        builder.setNodeUuid(ValueUtil.validateNull(node.getUUID()));
        String nodeName = node.getName();
        if (!Env.isBaseLanguage((Properties)workflowEventAudit.getCtx(), (String)"") && !Util.isEmpty((String)(translation = node.get_Translation("Name")))) {
            nodeName = translation;
        }
        builder.setNodeName(ValueUtil.validateNull(nodeName));
        if (workflowEventAudit.getAD_WF_Responsible_ID() != 0) {
            MWFResponsible responsible = MWFResponsible.get((Properties)workflowEventAudit.getCtx(), (int)workflowEventAudit.getAD_WF_Responsible_ID());
            builder.setResponsibleUuid(ValueUtil.validateNull(responsible.getUUID()));
            builder.setResponsibleName(ValueUtil.validateNull(responsible.getName()));
        }
        if (workflowEventAudit.getAD_User_ID() != 0) {
            MUser user = MUser.get((Properties)workflowEventAudit.getCtx(), (int)workflowEventAudit.getAD_User_ID());
            builder.setUserUuid(ValueUtil.validateNull(user.getUUID()));
            builder.setUserName(ValueUtil.validateNull(user.getName()));
        }
        builder.setId(workflowEventAudit.getRecord_ID());
        builder.setUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId(table.getTableName(), workflowEventAudit.getRecord_ID())));
        builder.setTableName(ValueUtil.validateNull(table.getTableName()));
        builder.setTextMessage(ValueUtil.validateNull(Msg.parseTranslation((Properties)workflowEventAudit.getCtx(), (String)workflowEventAudit.getTextMsg())));
        builder.setLogDate(workflowEventAudit.getCreated().getTime());
        if (workflowEventAudit.getElapsedTimeMS() != null) {
            builder.setTimeElapsed(workflowEventAudit.getElapsedTimeMS().longValue());
        }
        if (!Util.isEmpty((String)workflowEventAudit.getWFState())) {
            if (workflowEventAudit.getWFState().equals("OR")) {
                builder.setWorkflowState(WorkflowEvent.WorkflowState.RUNNING);
            } else if (workflowEventAudit.getWFState().equals("CC")) {
                builder.setWorkflowState(WorkflowEvent.WorkflowState.COMPLETED);
            } else if (workflowEventAudit.getWFState().equals("CA")) {
                builder.setWorkflowState(WorkflowEvent.WorkflowState.ABORTED);
            } else if (workflowEventAudit.getWFState().equals("CT")) {
                builder.setWorkflowState(WorkflowEvent.WorkflowState.TERMINATED);
            } else if (workflowEventAudit.getWFState().equals("OS")) {
                builder.setWorkflowState(WorkflowEvent.WorkflowState.SUSPENDED);
            } else if (workflowEventAudit.getWFState().equals("ON")) {
                builder.setWorkflowState(WorkflowEvent.WorkflowState.NOT_STARTED);
            }
        }
        builder.setAttributeName(ValueUtil.validateNull(workflowEventAudit.getAttributeName()));
        builder.setOldValue(ValueUtil.validateNull(workflowEventAudit.getOldValue()));
        builder.setNewValue(ValueUtil.validateNull(workflowEventAudit.getNewValue()));
        return builder;
    }

    public static WorkflowActivity.Builder convertWorkflowActivity(MWFActivity workflowActivity) {
        MTable table = MTable.get((Properties)workflowActivity.getCtx(), (int)workflowActivity.getAD_Table_ID());
        WorkflowActivity.Builder builder = WorkflowActivity.newBuilder();
        MWorkflow workflow = MWorkflow.get((Properties)workflowActivity.getCtx(), (int)workflowActivity.getAD_Workflow_ID());
        MWFProcess workflowProcess = (MWFProcess)workflowActivity.getAD_WF_Process();
        MWFNode workflowNode = MWFNode.get((Properties)Env.getCtx(), (int)workflowActivity.getAD_WF_Node_ID());
        builder.setWorkflowProcess(WorkflowUtil.convertWorkflowProcess(workflowProcess));
        builder.setWorkflow(WorkflowUtil.convertWorkflowDefinition(workflow));
        builder.setNode(WorkflowUtil.convertWorkflowNode(workflowNode));
        if (workflowActivity.getAD_WF_Responsible_ID() != 0) {
            MWFResponsible responsible = MWFResponsible.get((Properties)workflowActivity.getCtx(), (int)workflowActivity.getAD_WF_Responsible_ID());
            builder.setResponsibleUuid(ValueUtil.validateNull(responsible.getUUID()));
            builder.setResponsibleName(ValueUtil.validateNull(responsible.getName()));
        }
        if (workflowActivity.getAD_User_ID() != 0) {
            MUser user = MUser.get((Properties)workflowActivity.getCtx(), (int)workflowActivity.getAD_User_ID());
            builder.setUserUuid(ValueUtil.validateNull(user.getUUID()));
            builder.setUserName(ValueUtil.validateNull(user.getName()));
        }
        builder.setId(workflowActivity.getAD_WF_Activity_ID());
        builder.setUuid(ValueUtil.validateNull(workflowActivity.getUUID()));
        builder.setRecordUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId(table.getTableName(), workflowActivity.getRecord_ID())));
        builder.setTableName(ValueUtil.validateNull(table.getTableName()));
        builder.setTextMessage(ValueUtil.validateNull(Msg.parseTranslation((Properties)workflowActivity.getCtx(), (String)workflowActivity.getTextMsg())));
        builder.setProcessed(workflowActivity.isProcessed());
        builder.setCreated(workflowActivity.getCreated().getTime());
        if (workflowActivity.getDateLastAlert() != null) {
            builder.setLastAlert(workflowActivity.getDateLastAlert().getTime());
        }
        return builder;
    }
}

