/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.util;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.spin.grpc.util.Criteria;
import org.spin.grpc.util.Decimal;
import org.spin.grpc.util.KeyValue;
import org.spin.grpc.util.Value;

public class ValueUtil {
    private static final String TIME_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    public static Value.Builder getValueFromObject(Object value) {
        Value.Builder builderValue = Value.newBuilder();
        if (value == null) {
            return builderValue;
        }
        if (value instanceof BigDecimal) {
            return ValueUtil.getValueFromDecimal((BigDecimal)value);
        }
        if (value instanceof Integer) {
            return ValueUtil.getValueFromInteger((Integer)value);
        }
        if (value instanceof String) {
            return ValueUtil.getValueFromString((String)value);
        }
        if (value instanceof Boolean) {
            return ValueUtil.getValueFromBoolean((Boolean)value);
        }
        if (value instanceof Timestamp) {
            return ValueUtil.getValueFromDate((Timestamp)value);
        }
        return builderValue;
    }

    public static Value.Builder getValueFromInteger(Integer value) {
        Value.Builder convertedValue = Value.newBuilder().setValueType(Value.ValueType.INTEGER);
        if (value != null) {
            convertedValue.setIntValue(value);
        }
        return convertedValue;
    }

    public static Value.Builder getValueFromString(String value) {
        return Value.newBuilder().setStringValue(ValueUtil.validateNull(value)).setValueType(Value.ValueType.STRING);
    }

    public static Value.Builder getValueFromBoolean(boolean value) {
        return Value.newBuilder().setBooleanValue(value).setValueType(Value.ValueType.BOOLEAN);
    }

    public static Value.Builder getValueFromDate(Timestamp value) {
        return Value.newBuilder().setLongValue(value.getTime()).setValueType(Value.ValueType.DATE);
    }

    public static Value.Builder getValueFromDecimal(BigDecimal value) {
        return Value.newBuilder().setDecimalValue(Decimal.newBuilder().setDecimalValue(value.toPlainString()).setScale(value.scale())).setValueType(Value.ValueType.DECIMAL);
    }

    public static Decimal.Builder getDecimalFromBigDecimal(BigDecimal value) {
        if (value == null) {
            return Decimal.newBuilder();
        }
        return Decimal.newBuilder().setDecimalValue(value.toPlainString()).setScale(value.scale());
    }

    public static BigDecimal getDecimalFromValue(Value value) {
        if (Util.isEmpty((String)value.getDecimalValue().getDecimalValue())) {
            return null;
        }
        return new BigDecimal(value.getDecimalValue().getDecimalValue());
    }

    public static BigDecimal getBigDecimalFromDecimal(Decimal decimalValue) {
        if (decimalValue == null || Util.isEmpty((String)decimalValue.getDecimalValue())) {
            return null;
        }
        return new BigDecimal(decimalValue.getDecimalValue());
    }

    public static Timestamp getDateFromValue(Value value) {
        if (value.getLongValue() > 0L) {
            return new Timestamp(value.getLongValue());
        }
        return null;
    }

    public static String getStringFromValue(Value value, boolean uppercase) {
        String stringValue = value.getStringValue();
        if (Util.isEmpty((String)stringValue)) {
            stringValue = null;
        }
        if (uppercase) {
            stringValue = stringValue.toUpperCase();
        }
        return stringValue;
    }

    public static String getStringFromValue(Value value) {
        return ValueUtil.getStringFromValue(value, false);
    }

    public static int getIntegerFromValue(Value value) {
        return value.getIntValue();
    }

    public static boolean getBooleanFromValue(Value value) {
        return value.getBooleanValue();
    }

    public static Value.Builder getValueFromReference(Object value, int referenceId) {
        Value.Builder builderValue = Value.newBuilder();
        if (value == null) {
            return builderValue;
        }
        if (ValueUtil.isLookup(referenceId) || DisplayType.isID((int)referenceId)) {
            return ValueUtil.getValueFromObject(value);
        }
        if (11 == referenceId) {
            if (value instanceof Integer) {
                return ValueUtil.getValueFromInteger((Integer)value);
            }
            if (value instanceof BigDecimal) {
                return ValueUtil.getValueFromInteger(((BigDecimal)value).intValue());
            }
            return ValueUtil.getValueFromInteger(null);
        }
        if (DisplayType.isNumeric((int)referenceId)) {
            return ValueUtil.getValueFromDecimal((BigDecimal)value);
        }
        if (20 == referenceId) {
            if (value instanceof String) {
                String stringValue = (String)value;
                value = !Util.isEmpty((String)stringValue) && stringValue.equals("Y");
            }
            return ValueUtil.getValueFromBoolean((Boolean)value);
        }
        if (DisplayType.isDate((int)referenceId)) {
            return ValueUtil.getValueFromDate((Timestamp)value);
        }
        if (DisplayType.isText((int)referenceId)) {
            return ValueUtil.getValueFromString((String)value);
        }
        return builderValue;
    }

    public static Map<String, Object> convertValuesToObjects(List<KeyValue> values) {
        HashMap<String, Object> convertedValues = new HashMap<String, Object>();
        for (KeyValue value : values) {
            convertedValues.put(value.getKey(), ValueUtil.getObjectFromValue(value.getValue()));
        }
        return convertedValues;
    }

    public static Object getObjectFromValue(Value valueToConvert) {
        return ValueUtil.getObjectFromValue(valueToConvert, false);
    }

    public static Object getObjectFromValue(Value value, boolean uppercase) {
        if (value.getValueType().equals((Object)Value.ValueType.BOOLEAN)) {
            return value.getBooleanValue();
        }
        if (value.getValueType().equals((Object)Value.ValueType.DECIMAL)) {
            return ValueUtil.getDecimalFromValue(value);
        }
        if (value.getValueType().equals((Object)Value.ValueType.INTEGER)) {
            return value.getIntValue();
        }
        if (value.getValueType().equals((Object)Value.ValueType.STRING)) {
            return ValueUtil.getStringFromValue(value, uppercase);
        }
        if (value.getValueType().equals((Object)Value.ValueType.DATE)) {
            return ValueUtil.getDateFromValue(value);
        }
        return null;
    }

    public static Object getObjectFromReference(Value value, int referenceId) {
        if (value == null || value.getValueType().equals((Object)Value.ValueType.UNKNOWN)) {
            return null;
        }
        if (ValueUtil.isLookup(referenceId) || DisplayType.isID((int)referenceId)) {
            return ValueUtil.getObjectFromValue(value);
        }
        if (11 == referenceId) {
            return ValueUtil.getIntegerFromValue(value);
        }
        if (DisplayType.isNumeric((int)referenceId)) {
            return ValueUtil.getDecimalFromValue(value);
        }
        if (20 == referenceId) {
            return ValueUtil.getBooleanFromValue(value);
        }
        if (DisplayType.isDate((int)referenceId)) {
            return ValueUtil.getDateFromValue(value);
        }
        if (DisplayType.isText((int)referenceId)) {
            return ValueUtil.getStringFromValue(value);
        }
        return null;
    }

    public static boolean isLookup(int displayType) {
        return DisplayType.isLookup((int)displayType) || 25 == displayType || 21 == displayType || 31 == displayType || 35 == displayType;
    }

    public static String validateNull(String value) {
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static String getTranslation(PO object, String columnName) {
        if (object == null) {
            return null;
        }
        if (Language.isBaseLanguage((String)Env.getAD_Language((Properties)Env.getCtx()))) {
            return object.get_ValueAsString(columnName);
        }
        return object.get_Translation(columnName);
    }

    public static boolean isNumeric(String value) {
        if (Util.isEmpty((String)value)) {
            return false;
        }
        return value.matches("[+-]?\\d*(\\.\\d+)?");
    }

    public static int getIntegerFromString(String value) {
        Integer integerValue = null;
        try {
            integerValue = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (integerValue == null) {
            return 0;
        }
        return integerValue;
    }

    public static boolean isBoolean(String value) {
        if (Util.isEmpty((String)value)) {
            return false;
        }
        return value.equals("Y") || value.equals("N") || value.equals("true") || value.equals("false");
    }

    public static boolean isDate(String value) {
        return ValueUtil.getDateFromString(value) != null;
    }

    public static boolean isBigDecimal(String value) {
        return ValueUtil.getBigDecimalFromString(value) != null;
    }

    public static BigDecimal getBigDecimalFromString(String value) {
        BigDecimal numberValue = null;
        if (Util.isEmpty((String)value)) {
            return null;
        }
        try {
            numberValue = new BigDecimal(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return numberValue;
    }

    public static Timestamp getDateFromString(String value) {
        if (Util.isEmpty((String)value)) {
            return null;
        }
        Date date = null;
        try {
            date = DisplayType.getTimestampFormat_Default().parse(value);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public static String convertOperator(int gRpcOperator) {
        String operator = "=";
        switch (gRpcOperator) {
            case 8: {
                operator = " BETWEEN ";
                break;
            }
            case 0: {
                operator = "=";
                break;
            }
            case 5: {
                operator = ">=";
                break;
            }
            case 4: {
                operator = ">";
                break;
            }
            case 11: {
                operator = " IN ";
                break;
            }
            case 7: {
                operator = "<=";
                break;
            }
            case 6: {
                operator = "<";
                break;
            }
            case 2: {
                operator = " LIKE ";
                break;
            }
            case 1: {
                operator = "!=";
                break;
            }
            case 12: {
                operator = " NOT IN ";
                break;
            }
            case 3: {
                operator = " NOT LIKE ";
                break;
            }
            case 9: {
                operator = " IS NOT NULL ";
                break;
            }
            case 10: {
                operator = " IS NULL ";
                break;
            }
        }
        return operator;
    }

    public static void setParameterFromObject(PreparedStatement pstmt, Object value, int index) throws SQLException {
        if (value instanceof Integer) {
            pstmt.setInt(index, (Integer)value);
        } else if (value instanceof Double) {
            pstmt.setDouble(index, (Double)value);
        } else if (value instanceof Long) {
            pstmt.setLong(index, (Long)value);
        } else if (value instanceof BigDecimal) {
            pstmt.setBigDecimal(index, (BigDecimal)value);
        } else if (value instanceof String) {
            pstmt.setString(index, (String)value);
        } else if (value instanceof Timestamp) {
            pstmt.setTimestamp(index, (Timestamp)value);
        } else if (value instanceof Boolean) {
            pstmt.setString(index, (Boolean)value != false ? "Y" : "N");
        }
    }

    public static void setParameterFromValue(PreparedStatement pstmt, Value value, int index) throws SQLException {
        if (value.getValueType().equals((Object)Value.ValueType.INTEGER)) {
            pstmt.setInt(index, ValueUtil.getIntegerFromValue(value));
        } else if (value.getValueType().equals((Object)Value.ValueType.DECIMAL)) {
            pstmt.setBigDecimal(index, ValueUtil.getDecimalFromValue(value));
        } else if (value.getValueType().equals((Object)Value.ValueType.STRING)) {
            pstmt.setString(index, ValueUtil.getStringFromValue(value));
        } else if (value.getValueType().equals((Object)Value.ValueType.DATE)) {
            pstmt.setTimestamp(index, ValueUtil.getDateFromValue(value));
        }
    }

    public static String getWhereClauseFromCriteria(Criteria criteria, List<Object> params) {
        return ValueUtil.getWhereClauseFromCriteria(criteria, null, params);
    }

    public static String getWhereClauseFromCriteria(Criteria criteria, String tableName, List<Object> params) {
        AtomicReference<String> tableNameFromReference;
        StringBuffer whereClause = new StringBuffer();
        if (!Util.isEmpty((String)criteria.getWhereClause())) {
            whereClause.append("(").append(criteria.getWhereClause()).append(")");
        }
        if (Util.isEmpty((String)(tableNameFromReference = new AtomicReference<String>(tableName)).get())) {
            tableNameFromReference.set(criteria.getTableName());
        }
        if (Util.isEmpty((String)tableNameFromReference.get())) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        criteria.getConditionsList().stream().filter(condition -> !Util.isEmpty((String)condition.getColumnName())).forEach(condition -> {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            String colummName = (String)tableNameFromReference.get() + "." + condition.getColumnName();
            whereClause.append("(");
            if (condition.getOperatorValue() == 2 || condition.getOperatorValue() == 3) {
                colummName = "UPPER(" + colummName + ")";
            }
            whereClause.append(colummName).append(ValueUtil.convertOperator(condition.getOperatorValue()));
            if (condition.getOperatorValue() == 11 || condition.getOperatorValue() == 12) {
                StringBuffer parameter = new StringBuffer();
                condition.getValuesList().forEach(value -> {
                    if (parameter.length() > 0) {
                        parameter.append(", ");
                    }
                    parameter.append("?");
                    params.add(ValueUtil.getObjectFromValue(value));
                });
                whereClause.append("(").append(parameter).append(")");
            } else if (condition.getOperatorValue() == 8) {
                whereClause.append(" ? ").append(" AND ").append(" ?");
                params.add(ValueUtil.getObjectFromValue(condition.getValue()));
                params.add(ValueUtil.getObjectFromValue(condition.getValueTo()));
            } else if (condition.getOperatorValue() == 2 || condition.getOperatorValue() == 3) {
                whereClause.append("?");
                params.add(ValueUtil.getObjectFromValue(condition.getValue(), true));
            } else if (condition.getOperatorValue() != 10 && condition.getOperatorValue() != 9) {
                whereClause.append("?");
                params.add(ValueUtil.getObjectFromValue(condition.getValue()));
            }
            whereClause.append(")");
        });
        return whereClause.toString();
    }

    public static Timestamp convertStringToDate(String date) {
        if (Util.isEmpty((String)date)) {
            return null;
        }
        String format = DATE_FORMAT;
        if (date.length() == TIME_FORMAT.length()) {
            format = TIME_FORMAT;
        } else if (date.length() != DATE_FORMAT.length()) {
            throw new AdempiereException("Invalid date format, please use some like this: \"yyyy-MM-dd\" or \"yyyy-MM-dd hh:mm:ss\"");
        }
        SimpleDateFormat dateConverter = new SimpleDateFormat(format);
        try {
            Date validFromParameter = dateConverter.parse(date);
            return new Timestamp(validFromParameter.getTime());
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public static String convertDateToString(Timestamp date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(TIME_FORMAT).format(date);
    }
}

