/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.util;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.ListPackagesRequest;
import org.spin.grpc.util.ListPackagesResponse;
import org.spin.grpc.util.ListStepsRequest;
import org.spin.grpc.util.ListStepsResponse;
import org.spin.grpc.util.ListUpdatesRequest;
import org.spin.grpc.util.ListUpdatesResponse;
import org.spin.grpc.util.UpdateCenterGrpc;

public class UpdateManager {
    private static final Logger logger = Logger.getLogger(UpdateManager.class.getName());
    private int port;
    private String host;
    private String token;
    private ManagedChannel channel;
    private UpdateCenterGrpc.UpdateCenterBlockingStub blockingStub;

    public static UpdateManager newInstance() {
        return new UpdateManager();
    }

    public final int getPort() {
        return this.port;
    }

    public final UpdateManager withPort(int port) {
        this.port = port;
        return this;
    }

    public final String getHost() {
        return this.host;
    }

    public final UpdateManager withHost(String host) {
        this.host = host;
        return this;
    }

    public final String getToken() {
        return this.token;
    }

    public final UpdateManager withToken(String token) {
        this.token = token;
        return this;
    }

    private void buildConnection() {
        this.channel = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext().build();
        this.blockingStub = UpdateCenterGrpc.newBlockingStub((Channel)this.channel);
    }

    private void shutdown() {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    public ListPackagesResponse listAvailablePackages(String version, String releaseNo, String pageToken) {
        try {
            this.buildConnection();
            ListPackagesResponse listPackagesResponse = this.blockingStub.listPackages(ListPackagesRequest.newBuilder().setToken(this.getToken()).setPageToken(ValueUtil.validateNull(pageToken)).setVersion(version).setReleaseNo(releaseNo).build());
            return listPackagesResponse;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shutdown();
        }
    }

    public ListUpdatesResponse listUpdates(String entityType, String releaseNo, String pageToken) {
        try {
            this.buildConnection();
            ListUpdatesResponse listUpdatesResponse = this.blockingStub.listUpdates(ListUpdatesRequest.newBuilder().setToken(this.getToken()).setPageToken(ValueUtil.validateNull(pageToken)).setEntityType(entityType).setReleaseNo(ValueUtil.validateNull(releaseNo)).build());
            return listUpdatesResponse;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shutdown();
        }
    }

    public ListStepsResponse listSteps(String updateUuid, String pageToken, int fromStep) {
        try {
            this.buildConnection();
            ListStepsResponse listStepsResponse = this.blockingStub.listSteps(ListStepsRequest.newBuilder().setToken(this.getToken()).setPageToken(ValueUtil.validateNull(pageToken)).setUpdateUuid(updateUuid).setFromStep(fromStep).build());
            return listStepsResponse;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shutdown();
        }
    }
}

