/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCountry;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Util;
import org.spin.base.util.ContextManager;
import org.spin.model.MADToken;
import org.spin.util.IThirdPartyAccessGenerator;
import org.spin.util.ITokenGenerator;
import org.spin.util.TokenGeneratorHandler;

public class SessionManager {
    private static CLogger log = CLogger.getCLogger(SessionManager.class);

    public static void createSessionFromToken(String tokenValue) {
        Properties context = Env.getCtx();
        int userId = -1;
        int roleId = -1;
        int organizationId = -1;
        int warehouseId = -1;
        MADToken token = SessionManager.getSessionFromToken(tokenValue);
        if (Optional.ofNullable(token).isPresent()) {
            userId = token.getAD_User_ID();
            roleId = token.getAD_Role_ID();
            organizationId = token.getAD_Org_ID();
        }
        if (organizationId < 0) {
            organizationId = 0;
        }
        if (warehouseId < 0) {
            warehouseId = 0;
        }
        if (roleId < 0) {
            throw new AdempiereException("@AD_User_ID@ / @AD_Role_ID@ / @AD_Org_ID@ @NotFound@");
        }
        MRole role = MRole.get((Properties)context, (int)roleId);
        Env.setContext((Properties)context, (String)"#M_Warehouse_ID", (int)warehouseId);
        Env.setContext((Properties)context, (String)"#AD_Session_ID", (int)0);
        MClient client = MClient.get((Properties)context, (int)role.getAD_Client_ID());
        Env.setContext((Properties)context, (String)"#AD_Client_ID", (int)client.getAD_Client_ID());
        Env.setContext((Properties)context, (String)"#AD_Org_ID", (int)organizationId);
        Env.setContext((Properties)context, (String)"#AD_Role_ID", (int)roleId);
        Env.setContext((Properties)context, (String)"#AD_User_ID", (int)userId);
        MSession session = MSession.get((Properties)context, (boolean)true);
        Env.setContext((Properties)context, (String)"#AD_Session_ID", (int)session.getAD_Session_ID());
        Env.setContext((Properties)context, (String)"#Session_UUID", (String)session.getUUID());
        SessionManager.loadDefaultSessionValues(context, null);
    }

    public static int getSessionId() {
        return Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Session_ID");
    }

    public static String getSessionUuid() {
        return Env.getContext((Properties)Env.getCtx(), (String)"#Session_UUID");
    }

    public static MADToken getSessionFromToken(String tokenValue) {
        if (Util.isEmpty((String)tokenValue)) {
            throw new AdempiereException("@AD_Token_ID@ @NotFound@");
        }
        try {
            ITokenGenerator generator = TokenGeneratorHandler.getInstance().getTokenGenerator("TPA");
            if (generator == null) {
                throw new AdempiereException("@AD_TokenDefinition_ID@ @NotFound@");
            }
            if (!IThirdPartyAccessGenerator.class.isAssignableFrom(generator.getClass())) {
                throw new AdempiereException("@AD_TokenDefinition_ID@ @Invalid@");
            }
            IThirdPartyAccessGenerator thirdPartyAccessGenerator = (IThirdPartyAccessGenerator)generator;
            if (!thirdPartyAccessGenerator.validateToken(tokenValue)) {
                throw new AdempiereException("@Invalid@ @AD_Token_ID@");
            }
            MADToken token = thirdPartyAccessGenerator.getToken();
            return token;
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public static void loadDefaultSessionValues(Properties context, String language) {
        MClient client = MClient.get((Properties)context, (int)Env.getContextAsInt((Properties)context, (String)"#AD_Client_ID"));
        Env.setContext((Properties)context, (String)"#AD_Client_Name", (String)client.getName());
        Env.setContext((Properties)context, (String)"#Date", (Timestamp)new Timestamp(System.currentTimeMillis()));
        Env.setContext((Properties)context, (String)"#AD_Language", (String)ContextManager.getDefaultLanguage(language));
        MRole role = MRole.get((Properties)context, (int)Env.getContextAsInt((Properties)context, (String)"#AD_Role_ID"));
        Env.setContext((Properties)context, (String)"#AD_Role_Name", (String)role.getName());
        MUser user = MUser.get((Properties)context, (int)Env.getContextAsInt((Properties)context, (String)"#AD_User_ID"));
        Env.setContext((Properties)context, (String)"#AD_User_Name", (String)user.getName());
        Env.setContext((Properties)context, (String)"#AD_User_Description", (String)user.getDescription());
        SessionManager.loadPreferences(context);
    }

    public static int getDefaultOrganizationId(int roleId, int userId) {
        String organizationSQL = "SELECT o.AD_Org_ID FROM AD_Role r INNER JOIN AD_Client c ON(c.AD_Client_ID = r.AD_Client_ID) INNER JOIN AD_Org o ON(c.AD_Client_ID=o.AD_Client_ID OR o.AD_Org_ID=0) WHERE r.AD_Role_ID=?  AND o.IsActive='Y' AND o.IsSummary='N' AND (r.IsAccessAllOrgs='Y' OR (r.IsUseUserOrgAccess='N' AND EXISTS(SELECT 1 FROM AD_Role_OrgAccess ra WHERE ra.AD_Org_ID = o.AD_Org_ID AND ra.AD_Role_ID = r.AD_Role_ID AND ra.IsActive='Y')) OR (r.IsUseUserOrgAccess='Y' AND EXISTS(SELECT 1 FROM AD_User_OrgAccess ua WHERE ua.AD_Org_ID = o.AD_Org_ID AND ua.AD_User_ID = ? AND ua.IsActive='Y'))) ORDER BY o.AD_Org_ID DESC, o.Name";
        return DB.getSQLValue(null, (String)organizationSQL, (int)roleId, (int)userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPreferences(Properties context) {
        if (context == null) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        if (Env.getContext((Properties)context, (String)"#AD_Client_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context #AD_Client_ID");
        }
        if (Env.getContext((Properties)context, (String)"#AD_User_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context #AD_User_ID");
        }
        if (Env.getContext((Properties)context, (String)"#AD_Role_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context #AD_Role_ID");
        }
        MRole.getDefault((Properties)context, (boolean)true);
        Env.setAutoCommit((Properties)context, (boolean)Ini.isPropertyBool((String)"AutoCommit"));
        Env.setAutoNew((Properties)context, (boolean)Ini.isPropertyBool((String)"AutoNew"));
        if (MRole.getDefault((Properties)context, (boolean)false).isShowAcct()) {
            Env.setContext((Properties)context, (String)"#ShowAcct", (String)Ini.getProperty((String)"ShowAcct"));
        } else {
            Env.setContext((Properties)context, (String)"#ShowAcct", (String)"N");
        }
        Env.setContext((Properties)context, (String)"#ShowTrl", (String)Ini.getProperty((String)"ShowTrl"));
        Env.setContext((Properties)context, (String)"#ShowAdvanced", (String)Ini.getProperty((String)"ShowAdvanced"));
        Env.setContext((Properties)context, (String)"#YYYY", (String)"Y");
        Env.setContext((Properties)context, (String)"#StdPrecision", (int)2);
        int clientId = Env.getAD_Client_ID((Properties)context);
        int orgId = Env.getAD_Org_ID((Properties)context);
        String sql = "SELECT * FROM C_AcctSchema a, AD_ClientInfo c WHERE a.C_AcctSchema_ID=c.C_AcctSchema1_ID AND c.AD_Client_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int acctSchemaId = 0;
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, clientId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                acctSchemaId = rs.getInt("C_AcctSchema_ID");
                Env.setContext((Properties)context, (String)"$C_AcctSchema_ID", (int)acctSchemaId);
                Env.setContext((Properties)context, (String)"$C_Currency_ID", (int)rs.getInt("C_Currency_ID"));
                Env.setContext((Properties)context, (String)"$HasAlias", (String)rs.getString("HasAlias"));
            }
            rs.close();
            pstmt.close();
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)clientId);
            if (ass != null && ass.length > 1) {
                for (MAcctSchema as : ass) {
                    acctSchemaId = MClientInfo.get((Properties)Env.getCtx(), (int)clientId).getC_AcctSchema1_ID();
                    if (as.getAD_OrgOnly_ID() == 0 || as.isSkipOrg(orgId)) continue;
                    acctSchemaId = as.getC_AcctSchema_ID();
                    Env.setContext((Properties)context, (String)"$C_AcctSchema_ID", (int)acctSchemaId);
                    Env.setContext((Properties)context, (String)"$C_Currency_ID", (int)as.getC_Currency_ID());
                    Env.setContext((Properties)context, (String)"$HasAlias", (boolean)as.isHasAlias());
                    break;
                }
            }
            sql = "SELECT ElementType FROM C_AcctSchema_Element WHERE C_AcctSchema_ID=? AND IsActive='Y'";
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, acctSchemaId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Env.setContext((Properties)context, (String)("$Element_" + rs.getString("ElementType")), (String)"Y");
            }
            rs.close();
            pstmt.close();
            sql = "SELECT Attribute, Value, AD_Window_ID FROM AD_Preference WHERE AD_Client_ID IN (0, @#AD_Client_ID@) AND AD_Org_ID IN (0, @#AD_Org_ID@) AND (AD_User_ID IS NULL OR AD_User_ID=0 OR AD_User_ID=@#AD_User_ID@) AND IsActive='Y' ORDER BY Attribute, AD_Client_ID, AD_User_ID DESC, AD_Org_ID";
            sql = Env.parseContext((Properties)context, (int)0, (String)sql, (boolean)false);
            if (sql.length() == 0) {
                log.log(Level.SEVERE, "loadPreferences - Missing Environment");
            } else {
                pstmt = DB.prepareStatement((String)sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int AD_Window_ID = rs.getInt(3);
                    String at = "";
                    at = rs.wasNull() ? "P|" + rs.getString(1) : "P" + AD_Window_ID + "|" + rs.getString(1);
                    String va = rs.getString(2);
                    Env.setContext((Properties)context, (String)at, (String)va);
                }
                rs.close();
                pstmt.close();
            }
            log.info("Default Values ...");
            sql = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE c.IsKey='Y' AND t.IsActive='Y' AND EXISTS (SELECT * FROM AD_Column cc  WHERE ColumnName = 'IsDefault' AND t.AD_Table_ID=cc.AD_Table_ID AND cc.IsActive='Y')";
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                SessionManager.loadDefault(context, rs.getString(1), rs.getString(2));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, "loadPreferences", (Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, (Statement)pstmt);
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        MCountry country = ContextManager.getDefaultCountry();
        if (country != null) {
            Env.setContext((Properties)context, (String)"#C_Country_ID", (int)country.getC_Country_ID());
        }
        ModelValidationEngine.get().afterLoadPreferences(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDefault(Properties context, String tableName, String columnName) {
        if (tableName.startsWith("AD_Window") || tableName.startsWith("AD_PrintFormat") || tableName.startsWith("AD_Workflow")) {
            return;
        }
        String value = null;
        String sql = "SELECT " + columnName + " FROM " + tableName + " WHERE IsDefault='Y' AND IsActive='Y' ORDER BY AD_Client_ID DESC, AD_Org_ID DESC";
        sql = MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(sql, tableName, false, false);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                value = rs.getString(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, tableName + " (" + sql + ")", (Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            return;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (value != null && value.length() != 0) {
            if (tableName.equals("C_DocType")) {
                Env.setContext((Properties)context, (String)"#C_DocTypeTarget_ID", (String)value);
            } else {
                Env.setContext((Properties)context, (String)("#" + columnName), (String)value);
            }
        }
    }
}

